/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model.service;

import ch.elexis.core.common.ElexisEvent;
import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.entities.Kontakt;
import ch.elexis.core.jpa.model.adapter.AbstractIdModelAdapter;
import ch.elexis.core.jpa.model.adapter.AbstractModelService;
import ch.elexis.core.model.ILaboratory;
import ch.elexis.core.model.IOrganization;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IPerson;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.service.CoreModelAdapterFactory;
import ch.elexis.core.model.service.CoreQuery;
import ch.elexis.core.model.service.ElexisTypeMap;
import ch.elexis.core.services.IElexisEntityManager;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.IStoreToStringContribution;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.EventAdmin;
import org.slf4j.LoggerFactory;

@Component(property={"service.model.name=ch.elexis.core.model"})
public class CoreModelService
extends AbstractModelService
implements IModelService,
IStoreToStringContribution {
    @Reference(target="(id=default)")
    private IElexisEntityManager entityManager;
    @Reference
    private EventAdmin eventAdmin;

    protected EntityManager getEntityManager(boolean managed) {
        return (EntityManager)this.entityManager.getEntityManager(managed);
    }

    protected void closeEntityManager(EntityManager entityManager) {
        this.entityManager.closeEntityManager((Object)entityManager);
    }

    protected EventAdmin getEventAdmin() {
        return this.eventAdmin;
    }

    @Activate
    public void activate() {
        this.adapterFactory = CoreModelAdapterFactory.getInstance();
    }

    public Optional<String> storeToString(Identifiable identifiable) {
        String classKey = null;
        Optional dbObject = this.getDbObject(identifiable);
        if (dbObject.isPresent() && (classKey = ElexisTypeMap.getKeyForObject((EntityWithId)dbObject.get())) != null) {
            return Optional.of(String.valueOf(classKey) + "::" + identifiable.getId());
        }
        return Optional.empty();
    }

    public Optional<Identifiable> loadFromString(String storeToString) {
        if (storeToString == null) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("StoreToString is null");
            return Optional.empty();
        }
        String[] split = this.splitIntoTypeAndId(storeToString);
        if (split != null && split.length == 2) {
            EntityManager em;
            EntityWithId dbObject;
            String className = split[0];
            String id = split[1];
            Class<? extends EntityWithId> clazz = ElexisTypeMap.get(className);
            Class<? extends Identifiable> interfaceClass = ElexisTypeMap.getInterfaceClass(className);
            if (clazz != null && (dbObject = (EntityWithId)(em = (EntityManager)this.entityManager.getEntityManager()).find(clazz, (Object)id)) != null) {
                return Optional.ofNullable(this.adapterFactory.getModelAdapter(dbObject, interfaceClass, false).orElse(null));
            }
        }
        return Optional.empty();
    }

    public List<Identifiable> loadFromStringWithIdPart(String partialStoreToString) {
        if (partialStoreToString == null) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("StoreToString is null");
            return Collections.emptyList();
        }
        String[] split = this.splitIntoTypeAndId(partialStoreToString);
        if (split != null && split.length == 2) {
            String className = split[0];
            String id = split[1];
            Class<? extends EntityWithId> clazz = ElexisTypeMap.get(className);
            if (clazz != null) {
                EntityManager em = (EntityManager)this.entityManager.getEntityManager();
                TypedQuery query = em.createQuery("SELECT entity FROM " + clazz.getSimpleName() + " entity WHERE entity.id LIKE :idpart", clazz);
                query.setParameter("idpart", (Object)(String.valueOf(id) + "%"));
                List found = query.getResultList();
                if (!found.isEmpty()) {
                    return found.parallelStream().map(e -> this.adapterFactory.getModelAdapter(e, null, false).orElse(null)).collect(Collectors.toList());
                }
            }
        }
        return Collections.emptyList();
    }

    protected ElexisEvent getCreateEvent(Identifiable identifiable) {
        ElexisEvent ee = new ElexisEvent();
        ee.setTopic("info/elexis/po/create");
        if (identifiable instanceof AbstractIdModelAdapter) {
            EntityWithId dbObject = ((AbstractIdModelAdapter)identifiable).getEntity();
            ee.getProperties().put("id", dbObject.getId());
            ee.getProperties().put("class", ElexisTypeMap.getKeyForObject(dbObject));
        }
        return ee;
    }

    public <T> IQuery<T> getQuery(Class<T> clazz, boolean refreshCache, boolean includeDeleted) {
        return new CoreQuery<T>(clazz, refreshCache, (EntityManager)this.entityManager.getEntityManager(), includeDeleted);
    }

    public void clearCache() {
        this.entityManager.clearCache();
    }

    public Class<?> getEntityForType(String type) {
        return ElexisTypeMap.get(type);
    }

    public String getTypeForEntity(Object entityInstance) {
        return ElexisTypeMap.getKeyForObject((EntityWithId)entityInstance);
    }

    public String getTypeForModel(Class<?> interfaze) {
        Class entityClass = this.adapterFactory.getEntityClass(interfaze);
        if (entityClass != null) {
            try {
                EntityWithId instance = (EntityWithId)entityClass.newInstance();
                if (instance instanceof Kontakt) {
                    if (IPatient.class.isAssignableFrom(interfaze)) {
                        ((Kontakt)instance).setPatient(true);
                    }
                    if (IPerson.class.isAssignableFrom(interfaze)) {
                        ((Kontakt)instance).setPerson(true);
                    }
                    if (IOrganization.class.isAssignableFrom(interfaze)) {
                        ((Kontakt)instance).setOrganisation(true);
                    }
                    if (ILaboratory.class.isAssignableFrom(interfaze)) {
                        ((Kontakt)instance).setLaboratory(true);
                    }
                }
                return this.getTypeForEntity(instance);
            }
            catch (IllegalAccessException | InstantiationException e) {
                LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Error getting type for model [" + interfaze + "]", (Throwable)e);
            }
        }
        return null;
    }
}

