/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.contacts.views.comparator;

import ch.elexis.core.model.IContact;
import ch.elexis.core.ui.contacts.views.filter.KontaktAnzeigeTypViewerFilter;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;

public class ContactSelectorViewerComparator
extends ViewerComparator {
    private static sorter selectedSorter = sorter.SORT_BY_FAMILYNAME;

    public ContactSelectorViewerComparator(Viewer viewer) {
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        IContact c1 = (IContact)e1;
        IContact c2 = (IContact)e2;
        switch (selectedSorter) {
            case SORT_BY_FIRSTNAME: {
                if (c1.getDescription1() == null || c2.getDescription1() == null) {
                    return 0;
                }
                return c1.getDescription1().compareToIgnoreCase(c2.getDescription1());
            }
            case SORT_BY_FAMILYNAME: {
                if (c1.getDescription2() == null || c2.getDescription2() == null) {
                    return 0;
                }
                return c1.getDescription2().compareToIgnoreCase(c2.getDescription2());
            }
        }
        if (c1.getDescription2() == null || c2.getDescription2() == null) {
            return 0;
        }
        return c1.getDescription2().compareToIgnoreCase(c2.getDescription2());
    }

    public static void setSelectedSorter(sorter selectedSorter) {
        ContactSelectorViewerComparator.selectedSorter = selectedSorter;
        KontaktAnzeigeTypViewerFilter.refreshViewer();
    }

    public static sorter getSelectedSorter() {
        return selectedSorter;
    }

    public static enum sorter {
        SORT_BY_FIRSTNAME("Vorname"),
        SORT_BY_FAMILYNAME("Nachname");

        public String label;

        private sorter(String label) {
            this.label = label;
        }
    }
}

