/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.contacts.preferences;

import ch.elexis.admin.AccessControlDefaults;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.l10n.Messages;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.types.LocalizeUtil;
import ch.elexis.core.types.RelationshipType;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.contacts.dialogs.BezugsKontaktAuswahl;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.preferences.ConfigServicePreferenceStore;
import ch.elexis.data.BezugsKontaktRelation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class BezugsKontaktSettings
extends PreferencePage
implements IWorkbenchPreferencePage {
    private TableViewer tableViewer;
    private Table tableBezugsKontaktRelations;
    private Set<String> updateExistingEntriesIds = new HashSet<String>();
    private List<BezugsKontaktRelation> initalValues = new ArrayList<BezugsKontaktRelation>();
    private final boolean allowEditing;

    public BezugsKontaktSettings() {
        this.noDefaultAndApplyButton();
        this.setTitle(Messages.Core_Reference_Definition);
        this.allowEditing = CoreHub.acl.request(AccessControlDefaults.ADMIN);
    }

    protected Control createContents(Composite parent) {
        this.updateExistingEntriesIds.clear();
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        Group group = new Group(container, 0);
        group.setLayout((Layout)new GridLayout(1, false));
        group.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        group.setText(Messages.Core_Reference_Definition);
        Composite composite = new Composite((Composite)group, 0);
        GridData gd_composite = new GridData(4, 4, true, true, 1, 1);
        gd_composite.heightHint = 300;
        composite.setLayoutData((Object)gd_composite);
        TableColumnLayout tcl_composite = new TableColumnLayout();
        composite.setLayout((Layout)tcl_composite);
        this.tableViewer = new TableViewer(composite, 67584);
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tableBezugsKontaktRelations = this.tableViewer.getTable();
        this.tableBezugsKontaktRelations.setHeaderVisible(true);
        this.tableBezugsKontaktRelations.setLinesVisible(true);
        if (this.allowEditing) {
            Menu menu = new Menu((Control)this.tableBezugsKontaktRelations);
            this.tableBezugsKontaktRelations.setMenu(menu);
            MenuItem mntmAddBezugsKontaktRelation = new MenuItem(menu, 0);
            mntmAddBezugsKontaktRelation.setText(Messages.Core_Add);
            mntmAddBezugsKontaktRelation.setImage(Images.IMG_NEW.getImage());
            mntmAddBezugsKontaktRelation.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BezugsKontaktRelation bezugsKontaktRelation = new BezugsKontaktRelation("", RelationshipType.AGENERIC, RelationshipType.AGENERIC);
                    BezugsKontaktSettings.this.tableViewer.add((Object)bezugsKontaktRelation);
                    BezugsKontaktSettings.this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)bezugsKontaktRelation));
                }
            });
            MenuItem mntmRemoveBezugsKontaktRelation = new MenuItem(menu, 0);
            mntmRemoveBezugsKontaktRelation.setText(Messages.Core_Remove);
            mntmRemoveBezugsKontaktRelation.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean ret;
                    int selectionsIdx = BezugsKontaktSettings.this.tableViewer.getTable().getSelectionIndex();
                    if (selectionsIdx != -1 && (ret = MessageDialog.openQuestion((Shell)UiDesk.getTopShell(), (String)Messages.Bezugskontakt_ConfirmDelete, (String)Messages.Bezugskontakt_ConfirmDeleteText))) {
                        BezugsKontaktSettings.this.tableViewer.getTable().remove(selectionsIdx);
                    }
                }
            });
        }
        TableViewerColumn viewCol = new TableViewerColumn(this.tableViewer, 0);
        TableColumn col = viewCol.getColumn();
        tcl_composite.setColumnData((Widget)col, (ColumnLayoutData)new ColumnWeightData(1, 140));
        col.setText(Messages.Core_Reference);
        col.setToolTipText(Messages.Bezugskontakt_ReferenceTooltip);
        viewCol.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                BezugsKontaktRelation s = (BezugsKontaktRelation)cell.getElement();
                if (s == null) {
                    return;
                }
                cell.setText(s.getName());
            }
        });
        viewCol.setEditingSupport(new EditingSupport((ColumnViewer)this.tableViewer){

            protected void setValue(Object element, Object value) {
                if (element instanceof BezugsKontaktRelation) {
                    String newName = String.valueOf(value);
                    BezugsKontaktRelation tableData = null;
                    TableItem[] tableItemArray = BezugsKontaktSettings.this.tableViewer.getTable().getItems();
                    int n = tableItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableItem tableItem = tableItemArray[n2];
                        tableData = (BezugsKontaktRelation)tableItem.getData();
                        if (tableData != null && !tableData.equals(element) && !tableData.getName().isEmpty() && newName.equalsIgnoreCase(tableData.getName())) {
                            MessageDialog.openError((Shell)UiDesk.getTopShell(), (String)"", (String)Messages.Bezugskontakt_NameMustBeUnique);
                            return;
                        }
                        ++n2;
                    }
                    BezugsKontaktRelation bezugsKontaktRelation = (BezugsKontaktRelation)element;
                    if (!bezugsKontaktRelation.getName().equals(newName)) {
                        bezugsKontaktRelation.setName(newName);
                        this.getViewer().update((Object)bezugsKontaktRelation, null);
                        BezugsKontaktSettings.this.openConfirmUpdateExistingData(bezugsKontaktRelation);
                    }
                }
            }

            protected Object getValue(Object element) {
                if (element instanceof BezugsKontaktRelation) {
                    return ((BezugsKontaktRelation)element).getName();
                }
                return null;
            }

            protected CellEditor getCellEditor(Object element) {
                return new TextCellEditor((Composite)BezugsKontaktSettings.this.tableViewer.getTable());
            }

            protected boolean canEdit(Object element) {
                return BezugsKontaktSettings.this.allowEditing;
            }
        });
        viewCol = new TableViewerColumn(this.tableViewer, 0);
        col = viewCol.getColumn();
        tcl_composite.setColumnData((Widget)col, (ColumnLayoutData)new ColumnWeightData(0, 140));
        col.setText(Messages.Bezugskontakt_RelationFrom);
        viewCol.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                BezugsKontaktRelation s = (BezugsKontaktRelation)cell.getElement();
                if (s == null) {
                    return;
                }
                cell.setText(LocalizeUtil.getLocaleText((Enumerator)s.getDestRelationType()));
            }
        });
        viewCol.setEditingSupport(new EditingSupport((ColumnViewer)this.tableViewer){

            protected void setValue(Object element, Object value) {
                if (element instanceof BezugsKontaktRelation && value instanceof Integer) {
                    BezugsKontaktRelation bezugsKontaktRelation = (BezugsKontaktRelation)element;
                    RelationshipType[] allRelationshipTypes = RelationshipType.values();
                    if ((Integer)value != -1 && !bezugsKontaktRelation.getDestRelationType().equals((Object)allRelationshipTypes[(Integer)value])) {
                        bezugsKontaktRelation.setDestRelationType(allRelationshipTypes[(Integer)value]);
                        this.getViewer().update((Object)bezugsKontaktRelation, null);
                        BezugsKontaktSettings.this.openConfirmUpdateExistingData(bezugsKontaktRelation);
                    }
                }
            }

            protected Object getValue(Object element) {
                BezugsKontaktRelation bezugsKontaktRelation;
                RelationshipType relationshipType;
                if (element instanceof BezugsKontaktRelation && (relationshipType = (bezugsKontaktRelation = (BezugsKontaktRelation)element).getDestRelationType()) != null) {
                    return relationshipType.getValue();
                }
                return 0;
            }

            protected CellEditor getCellEditor(Object element) {
                return new ComboBoxCellEditor((Composite)BezugsKontaktSettings.this.tableViewer.getTable(), BezugsKontaktAuswahl.getBezugKontaktTypes(), 0);
            }

            protected boolean canEdit(Object element) {
                return BezugsKontaktSettings.this.allowEditing;
            }
        });
        viewCol = new TableViewerColumn(this.tableViewer, 0);
        col = viewCol.getColumn();
        tcl_composite.setColumnData((Widget)col, (ColumnLayoutData)new ColumnWeightData(0, 140));
        col.setText(Messages.Bezugskontakt_RelationTo);
        viewCol.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                BezugsKontaktRelation s = (BezugsKontaktRelation)cell.getElement();
                if (s == null) {
                    return;
                }
                cell.setText(LocalizeUtil.getLocaleText((Enumerator)s.getSrcRelationType()));
            }
        });
        viewCol.setEditingSupport(new EditingSupport((ColumnViewer)this.tableViewer){

            protected void setValue(Object element, Object value) {
                if (element instanceof BezugsKontaktRelation && value instanceof Integer) {
                    BezugsKontaktRelation bezugsKontaktRelation = (BezugsKontaktRelation)element;
                    RelationshipType[] allRelationshipTypes = RelationshipType.values();
                    if ((Integer)value != -1 && !bezugsKontaktRelation.getSrcRelationType().equals((Object)allRelationshipTypes[(Integer)value])) {
                        bezugsKontaktRelation.setSrcRelationType(allRelationshipTypes[(Integer)value]);
                        this.getViewer().update((Object)bezugsKontaktRelation, null);
                        BezugsKontaktSettings.this.openConfirmUpdateExistingData(bezugsKontaktRelation);
                    }
                }
            }

            protected Object getValue(Object element) {
                BezugsKontaktRelation bezugsKontaktRelation;
                RelationshipType relationshipType;
                if (element instanceof BezugsKontaktRelation && (relationshipType = (bezugsKontaktRelation = (BezugsKontaktRelation)element).getSrcRelationType()) != null) {
                    return relationshipType.getValue();
                }
                return 0;
            }

            protected CellEditor getCellEditor(Object element) {
                return new ComboBoxCellEditor((Composite)BezugsKontaktSettings.this.tableViewer.getTable(), BezugsKontaktAuswahl.getBezugKontaktTypes(), 0);
            }

            protected boolean canEdit(Object element) {
                return BezugsKontaktSettings.this.allowEditing;
            }
        });
        this.tableViewer.setInput(this.loadBezugKonkaktTypes(ConfigServiceHolder.getGlobal((String)"views/patientenblatt/Bezugskontakttypen", (String)"")));
        return container;
    }

    private List<BezugsKontaktRelation> loadBezugKonkaktTypes(String cfgBezugKonktaks) {
        ArrayList<BezugsKontaktRelation> bezugsKontaktRelations = new ArrayList<BezugsKontaktRelation>();
        this.initalValues.clear();
        String[] stringArray = cfgBezugKonktaks.split("#!>");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String cfgPart = stringArray[n2];
            BezugsKontaktRelation bezugsKontaktRelation = new BezugsKontaktRelation();
            bezugsKontaktRelation.loadValuesByCfg(cfgPart);
            this.initalValues.add(bezugsKontaktRelation);
            bezugsKontaktRelations.add(new BezugsKontaktRelation(bezugsKontaktRelation));
            ++n2;
        }
        return bezugsKontaktRelations;
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore((IPreferenceStore)new ConfigServicePreferenceStore(ConfigServicePreferenceStore.Scope.GLOBAL));
    }

    protected void performApply() {
        this.setErrorMessage(null);
        super.performApply();
    }

    public boolean performOk() {
        if (this.allowEditing) {
            StringBuffer cfg = new StringBuffer();
            BezugsKontaktRelation bezugsKontaktRelation = null;
            boolean firstElement = true;
            TableItem[] tableItemArray = this.tableViewer.getTable().getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem tableItem = tableItemArray[n2];
                bezugsKontaktRelation = (BezugsKontaktRelation)tableItem.getData();
                if (bezugsKontaktRelation != null) {
                    if (firstElement) {
                        firstElement = false;
                    } else {
                        cfg.append("#!>");
                    }
                    cfg.append(bezugsKontaktRelation.getCfgString());
                    if (this.updateExistingEntriesIds.contains(bezugsKontaktRelation.getId())) {
                        this.updateExistingEntries(bezugsKontaktRelation);
                    }
                }
                ++n2;
            }
            ConfigServiceHolder.setGlobal((String)"views/patientenblatt/Bezugskontakttypen", (String)cfg.toString());
        }
        return super.performOk();
    }

    private void updateExistingEntries(BezugsKontaktRelation newBezugsKontaktRelation) {
        BezugsKontaktRelation initalBezugKonktaktRelation = this.getInitalBezugKontakt(newBezugsKontaktRelation.getId());
        if (initalBezugKonktaktRelation != null) {
            initalBezugKonktaktRelation.updateToNewBezugKontakt(newBezugsKontaktRelation);
        }
    }

    private BezugsKontaktRelation getInitalBezugKontakt(String id) {
        for (BezugsKontaktRelation initalBezugKonktaktRelation : this.initalValues) {
            if (!initalBezugKonktaktRelation.getId().equals(id)) continue;
            return initalBezugKonktaktRelation;
        }
        return null;
    }

    private void openConfirmUpdateExistingData(BezugsKontaktRelation bezugsKontaktRelation) {
        boolean ret;
        BezugsKontaktRelation initalBezugKonktaktRelation;
        if (!this.updateExistingEntriesIds.contains(bezugsKontaktRelation.getId()) && (initalBezugKonktaktRelation = this.getInitalBezugKontakt(bezugsKontaktRelation.getId())) != null && (ret = MessageDialog.openQuestion((Shell)UiDesk.getTopShell(), (String)"", (String)Messages.Bezugskontakt_ConfirmUpdateExisting))) {
            this.updateExistingEntriesIds.add(bezugsKontaktRelation.getId());
        }
    }
}

