/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views.rechnung;

import ch.elexis.admin.AccessControlDefaults;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.util.Log;
import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.core.ui.util.viewers.ViewerConfigurer;
import ch.elexis.core.ui.views.rechnung.Messages;
import ch.elexis.core.ui.views.rechnung.RechnungsListeView;
import ch.elexis.core.ui.views.rechnung.invoice.InvoiceListBottomComposite;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Patient;
import ch.elexis.data.Query;
import ch.elexis.data.Rechnung;
import ch.elexis.data.Zahlung;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.IFilter;
import ch.rgw.tools.Money;
import ch.rgw.tools.TimeTool;
import ch.rgw.tools.Tree;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

class RnContentProvider
implements ViewerConfigurer.ICommonViewerContentProvider,
ITreeContentProvider,
ViewerConfigurer.ControlFieldListener {
    private static final float PREVAL = 50000.0f;
    CommonViewer cv;
    Tree[] result;
    int iPat;
    int iRn;
    Money mAmount;
    Money mOpen;
    TreeComparator treeComparator = new TreeComparator();
    PatientComparator patientComparator = new PatientComparator();
    RechnungsListeView rlv;
    String[] constraints;
    String[] val;
    private final Log log = Log.get("Rechnungenlader");

    RnContentProvider(RechnungsListeView l, CommonViewer cv) {
        this.cv = cv;
        this.rlv = l;
    }

    @Override
    public void startListening() {
        this.cv.getConfigurer().getControlFieldProvider().addChangeListener(this);
    }

    @Override
    public void stopListening() {
        this.cv.getConfigurer().getControlFieldProvider().removeChangeListener(this);
    }

    public Object[] getElements(Object inputElement) {
        IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
        try {
            progressService.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    RnContentProvider.this.reload(monitor);
                    if (monitor.isCanceled()) {
                        monitor.done();
                    }
                    RnContentProvider.this.rlv.getSite().getShell().getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            InvoiceListBottomComposite invoiceListeBottomComposite = (this).RnContentProvider.this.rlv.getInvoiceListeBottomComposite();
                            if (invoiceListeBottomComposite != null) {
                                invoiceListeBottomComposite.update(Integer.toString((this).RnContentProvider.this.iPat), Integer.toString((this).RnContentProvider.this.iRn), (this).RnContentProvider.this.mAmount.getAmountAsString(), (this).RnContentProvider.this.mOpen.getAmountAsString());
                            }
                        }
                    });
                }
            });
        }
        catch (Throwable ex) {
            ExHandler.handle((Throwable)ex);
        }
        return this.result == null ? new Tree[]{} : this.result;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    @Override
    public void changed(HashMap<String, String> values) {
        this.cv.notify(CommonViewer.Message.update);
    }

    @Override
    public void reorder(String field) {
        this.cv.getViewerWidget().setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                TimeTool t1 = RnContentProvider.this.getLatest((Tree)e1);
                TimeTool t2 = RnContentProvider.this.getLatest((Tree)e2);
                return t1.compareTo((Calendar)t2);
            }
        });
    }

    @Override
    public void selected() {
    }

    private TimeTool getLatest(Tree t) {
        if (t.contents instanceof Rechnung) {
            return new TimeTool(((Rechnung)t.contents).getDatumRn());
        }
        if (t.contents instanceof Fall) {
            return this.getLatestFromCase(t);
        }
        if (t.contents instanceof Patient) {
            Tree runner = t.getFirstChild();
            TimeTool latest = new TimeTool();
            while (runner != null) {
                TimeTool lff = this.getLatestFromCase(runner);
                if (lff.isBefore(latest)) {
                    latest.set(lff);
                }
                runner = runner.getNextSibling();
            }
            return latest;
        }
        return null;
    }

    private TimeTool getLatestFromCase(Tree c) {
        List tRn = (List)c.getChildren();
        TimeTool tL = new TimeTool();
        for (Tree t : tRn) {
            Rechnung rn = (Rechnung)t.contents;
            TimeTool ttR = new TimeTool(rn.getDatumRn());
            if (!ttR.isBefore(tL)) continue;
            tL.set(ttR);
        }
        return tL;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof Tree) {
            Object[] ret = ((Tree)parentElement).getChildren().toArray(new Tree[0]);
            Arrays.sort(ret, this.treeComparator);
            return ret;
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        if (element instanceof Tree) {
            return ((Tree)element).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return !(element instanceof Tree) || !(((Tree)element).contents instanceof Rechnung);
    }

    public void setConstraints(String[] constraints) {
        this.constraints = constraints;
    }

    public Query<Rechnung> prepareQuery() {
        this.cv.getParent().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                RnContentProvider.this.val = null;
                RnContentProvider.this.val = RnContentProvider.this.cv.getConfigurer().getControlFieldProvider().getValues();
            }
        });
        Query q1 = new Query(Rechnung.class);
        if (!CoreHub.acl.request(AccessControlDefaults.ACCOUNTING_GLOBAL)) {
            if (CoreHub.actMandant == null) {
                return null;
            }
            q1.add("MandantID", "=", CoreHub.actMandant.getId());
        }
        if (this.val[2] != null) {
            q1.add("RnNummer", "=", this.val[2]);
        } else if (this.val[3] != null) {
            q1.add("Betragx100", "=", this.val[3]);
        } else {
            Fall[] faelle;
            Patient act;
            if (Integer.parseInt(this.val[0]) == 23) {
                q1.startGroup();
                q1.add("RnStatus", "=", Integer.toString(4));
                q1.or();
                q1.add("RnStatus", "=", Integer.toString(6));
                q1.add("RnStatus", "=", Integer.toString(8));
                q1.add("RnStatus", "=", Integer.toString(10));
                q1.endGroup();
                q1.and();
            } else if (Integer.parseInt(this.val[0]) == 24) {
                q1.startGroup();
                q1.add("RnStatus", "=", Integer.toString(5));
                q1.or();
                q1.add("RnStatus", "=", Integer.toString(7));
                q1.add("RnStatus", "=", Integer.toString(9));
                q1.add("RnStatus", "=", Integer.toString(11));
                q1.endGroup();
                q1.and();
            } else if (!this.val[0].equals("0")) {
                q1.add("RnStatus", "=", this.val[0]);
            }
            if (this.val[1] != null && (act = Patient.load((String)this.val[1])).exists() && (faelle = act.getFaelle()) != null && faelle.length > 0) {
                q1.startGroup();
                q1.insertFalse();
                q1.or();
                Fall[] fallArray = faelle;
                int n = faelle.length;
                int n2 = 0;
                while (n2 < n) {
                    Fall fall = fallArray[n2];
                    q1.add("FallID", "=", fall.getId());
                    ++n2;
                }
                q1.endGroup();
            }
            if (this.constraints != null) {
                String[] stringArray = this.constraints;
                int n = this.constraints.length;
                int n3 = 0;
                while (n3 < n) {
                    String line = stringArray[n3];
                    q1.addToken(line);
                    ++n3;
                }
            }
        }
        if (this.val[4] != null) {
            q1.addPostQueryFilter(new IFilter(){

                public boolean select(Object toTest) {
                    String abr;
                    Rechnung rn;
                    Fall fall;
                    return toTest instanceof Rechnung && (fall = (rn = (Rechnung)toTest).getFall()) != null && (abr = fall.getAbrechnungsSystem()) != null && abr.equals(RnContentProvider.this.val[4]);
                }
            });
        }
        return q1;
    }

    public void reload(IProgressMonitor monitor) {
        monitor.beginTask(Messages.RnContentProvider_collectInvoices, Math.round(50000.0f));
        monitor.subTask(Messages.Core_Database_Query);
        Tree root = new Tree(null, null);
        Hashtable<String, Tree> hPats = new Hashtable<String, Tree>(367, 0.75f);
        Hashtable<String, Tree> hFaelle = new Hashtable<String, Tree>(719, 0.75f);
        Query<Rechnung> q1 = this.prepareQuery();
        if (q1 == null) {
            return;
        }
        q1.orderBy(false, new String[]{"RnDatum"});
        List rechnungen = q1.execute();
        if (rechnungen == null) {
            this.log.log(Messages.RnContentProvider_errorRetriveingBillds, 2);
            return;
        }
        monitor.worked(100);
        monitor.subTask(Messages.Core_Database_Query);
        int multiplyer = Math.round(50000.0f / (float)rechnungen.size());
        monitor.subTask(Messages.RnContentProvider_load);
        this.iPat = 0;
        this.iRn = rechnungen.size();
        this.mAmount = new Money();
        this.mOpen = new Money();
        for (Rechnung rn : rechnungen) {
            if (monitor.isCanceled()) {
                monitor.worked(1);
                monitor.done();
                return;
            }
            if (rn == null || !rn.exists()) {
                this.log.log("Fehlerhafte Rechnung", 2);
                continue;
            }
            this.mAmount.addMoney(rn.getOffenerBetrag());
            this.mOpen.addMoney(this.sumZahlungen(rn));
            Fall fall = rn.getFall();
            if (fall == null) {
                this.log.log("Rechnung " + rn.getId() + " hat keinen Fall", 3);
                continue;
            }
            Tree tFall = (Tree)hFaelle.get(fall.getId());
            if (tFall == null) {
                Patient pat = fall.getPatient();
                if (pat == null) {
                    this.log.log("Fall " + fall.getId() + " hat keinen Patienten", 3);
                    continue;
                }
                Tree tPat = (Tree)hPats.get(pat.getId());
                if (tPat == null) {
                    tPat = new Tree(root, (Object)pat, (Comparator)this.patientComparator);
                    hPats.put(pat.getId(), tPat);
                    ++this.iPat;
                }
                tFall = new Tree(tPat, (Object)fall);
                hFaelle.put(fall.getId(), tFall);
            }
            Tree tRn = new Tree(tFall, (Object)rn);
            monitor.worked(multiplyer);
        }
        monitor.worked(1);
        monitor.subTask(Messages.RnContentProvider_prepareSort);
        this.result = root.getChildren().toArray(new Tree[0]);
        monitor.worked(100);
        monitor.done();
    }

    public Money sumZahlungen(Rechnung rn) {
        List lz = rn.getZahlungen();
        Money total = new Money();
        for (Zahlung z : lz) {
            Money abzahlung = z.getBetrag();
            if (z.getBemerkung().equalsIgnoreCase("storno")) continue;
            total.addMoney(abzahlung);
        }
        return total;
    }

    @Override
    public void init() {
    }

    private static class PatientComparator
    implements Comparator {
        private PatientComparator() {
        }

        public int compare(Object o1, Object o2) {
            Patient p1 = (Patient)o1;
            Patient p2 = (Patient)o2;
            return p1.getLabel().compareTo(p2.getLabel());
        }
    }

    private static class TreeComparator
    implements Comparator {
        TimeTool tt0 = new TimeTool();
        TimeTool tt1 = new TimeTool();

        private TreeComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            Tree t0 = (Tree)arg0;
            Tree t1 = (Tree)arg1;
            if (t0.contents instanceof Patient) {
                Patient p0 = (Patient)t0.contents;
                Patient p1 = (Patient)t1.contents;
                String s0 = p0.getLabel();
                String s1 = p1.getLabel();
                return s0.compareTo(s1);
            }
            if (t0.contents instanceof Fall) {
                Fall f0 = (Fall)t0.contents;
                Fall f1 = (Fall)t1.contents;
                this.tt0.set(f0.getBeginnDatum());
                this.tt1.set(f1.getBeginnDatum());
                return this.tt0.secondsTo(this.tt1);
            }
            if (t0.contents instanceof Konsultation) {
                Konsultation b0 = (Konsultation)t0.contents;
                Konsultation b1 = (Konsultation)t1.contents;
                this.tt0.set(b0.getDatum());
                this.tt1.set(b1.getDatum());
                return this.tt0.secondsTo(this.tt1);
            }
            return 0;
        }
    }
}

