/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views.rechnung;

import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.util.BillingUtil;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.Money;
import ch.rgw.tools.Result;
import ch.rgw.tools.TimeTool;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.part.ViewPart;

public class BillingProposalView
extends ViewPart {
    public static final String ID = "ch.elexis.core.ui.views.rechnung.BillingProposalView";
    private TableViewer viewer;
    private BillingProposalViewerComparator comparator;
    private Color lightRed = UiDesk.getColorFromRGB("ff8d8d");
    private Color lightGreen = UiDesk.getColorFromRGB("a6ffaa");

    public void createPartControl(Composite parent) {
        this.viewer = new TableViewer(parent, 0x10010002);
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.setContentProvider((IContentProvider)new BillingInformationContentProvider((StructuredViewer)this.viewer));
        this.comparator = new BillingProposalViewerComparator();
        this.viewer.setComparator((ViewerComparator)this.comparator);
        TableViewerColumn patNameColumn = new TableViewerColumn(this.viewer, 0);
        patNameColumn.getColumn().setWidth(175);
        patNameColumn.getColumn().setText("Patient");
        patNameColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof BillingInformation) {
                    return ((BillingInformation)element).getPatientName();
                }
                return super.getText(element);
            }
        });
        patNameColumn.getColumn().addSelectionListener((SelectionListener)this.getSelectionAdapter(0));
        TableViewerColumn patNrColumn = new TableViewerColumn(this.viewer, 0);
        patNrColumn.getColumn().setWidth(50);
        patNrColumn.getColumn().setText("PatNr");
        patNrColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof BillingInformation) {
                    return Integer.toString(((BillingInformation)element).getPatientNr());
                }
                return super.getText(element);
            }
        });
        patNrColumn.getColumn().addSelectionListener((SelectionListener)this.getSelectionAdapter(1));
        TableViewerColumn dateColumn = new TableViewerColumn(this.viewer, 0);
        dateColumn.getColumn().setWidth(75);
        dateColumn.getColumn().setText("Datum");
        dateColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof BillingInformation) {
                    return ((BillingInformation)element).getDate().format(DateTimeFormatter.ofPattern("dd.MM.yyyy"));
                }
                return super.getText(element);
            }
        });
        dateColumn.getColumn().addSelectionListener((SelectionListener)this.getSelectionAdapter(2));
        TableViewerColumn accountingSystemColumn = new TableViewerColumn(this.viewer, 0);
        accountingSystemColumn.getColumn().setWidth(75);
        accountingSystemColumn.getColumn().setText("Fall");
        accountingSystemColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof BillingInformation) {
                    return ((BillingInformation)element).getAccountingSystem();
                }
                return super.getText(element);
            }
        });
        TableViewerColumn insurerColumn = new TableViewerColumn(this.viewer, 0);
        insurerColumn.getColumn().setWidth(175);
        insurerColumn.getColumn().setText("Versicherer");
        insurerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof BillingInformation) {
                    return ((BillingInformation)element).getInsurer();
                }
                return super.getText(element);
            }
        });
        TableViewerColumn totalColumn = new TableViewerColumn(this.viewer, 0);
        totalColumn.getColumn().setWidth(75);
        totalColumn.getColumn().setText("Total");
        totalColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof BillingInformation) {
                    return ((BillingInformation)element).getTotal();
                }
                return super.getText(element);
            }
        });
        TableViewerColumn checkResultColumn = new TableViewerColumn(this.viewer, 0);
        checkResultColumn.getColumn().setWidth(200);
        checkResultColumn.getColumn().setText("Pr\u00fcfergebnis");
        checkResultColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof BillingInformation) {
                    return ((BillingInformation)element).getCheckResultMessage();
                }
                return super.getText(element);
            }

            public Color getBackground(Object element) {
                if (element instanceof BillingInformation) {
                    return ((BillingInformation)element).isOk() != false ? BillingProposalView.this.lightGreen : BillingProposalView.this.lightRed;
                }
                return super.getForeground(element);
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection != null && !selection.isEmpty() && selection.getFirstElement() instanceof BillingInformation) {
                    Konsultation kons = ((BillingInformation)selection.getFirstElement()).getKonsultation();
                    Patient pat = kons.getFall().getPatient();
                    ElexisEventDispatcher.getInstance().fire(new ElexisEvent[]{new ElexisEvent((Object)pat, pat.getClass(), 16, 1)});
                    ElexisEventDispatcher.fireSelectionEvent((PersistentObject)kons);
                }
            }
        });
        this.viewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 0x100000E) {
                    BillingProposalView.this.refresh();
                }
            }
        });
        MenuManager menuManager = new MenuManager();
        Menu menu = menuManager.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.viewer);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
    }

    private SelectionAdapter getSelectionAdapter(final int index) {
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BillingProposalView.this.comparator.setColumn(index);
                int dir = BillingProposalView.this.comparator.getDirection();
                BillingProposalView.this.viewer.getTable().setSortDirection(dir);
                BillingProposalView.this.viewer.refresh();
            }
        };
        return selectionAdapter;
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void setInput(List<Konsultation> proposal) {
        this.viewer.setInput(proposal);
    }

    public void refresh() {
        ((BillingInformationContentProvider)this.viewer.getContentProvider()).refresh();
        this.viewer.refresh();
    }

    public List<Konsultation> getToBill() {
        List<BillingInformation> content = ((BillingInformationContentProvider)this.viewer.getContentProvider()).getCurrentContent();
        if (content != null && !content.isEmpty()) {
            return content.parallelStream().map(bi -> bi.getKonsultation()).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public void removeToBill(List<BillingInformation> list) {
        ((BillingInformationContentProvider)this.viewer.getContentProvider()).removeContent(list);
        this.viewer.refresh();
    }

    public ProposalLetter getToPrint() {
        BillingInformationContentProvider contentProvider = (BillingInformationContentProvider)this.viewer.getContentProvider();
        contentProvider.resolveAll();
        List<BillingInformation> content = contentProvider.getCurrentContent();
        BillingProposalViewerComparator comparator = (BillingProposalViewerComparator)this.viewer.getComparator();
        content.sort(comparator);
        ProposalLetter ret = new ProposalLetter();
        if (content != null && !content.isEmpty()) {
            ret.setProposal(content);
        } else {
            ret.setProposal(Collections.emptyList());
        }
        return ret;
    }

    @Optional
    @Inject
    public void setFixLayout(MPart part, @Named(value="perspectives/fix_layout") @Named(value="perspectives/fix_layout") boolean currentState) {
        CoreUiUtil.updateFixLayout((MPart)part, (boolean)currentState);
    }

    @XmlRootElement(name="proposal")
    public static class BillingInformation {
        @XmlTransient
        private static ExecutorService executorService = Executors.newFixedThreadPool(8);
        @XmlTransient
        private volatile boolean resolved;
        @XmlTransient
        private volatile boolean resolving;
        @XmlTransient
        private StructuredViewer viewer;
        @XmlTransient
        private Fall fall;
        @XmlTransient
        private Konsultation konsultation;
        @XmlElement
        @XmlJavaTypeAdapter(value=LocalDateAdapter.class)
        private LocalDate date;
        @XmlElement
        private int patientNr = -1;
        @XmlElement
        private String patientName;
        @XmlElement
        private String insurerName;
        @XmlElement
        private String accountingSystem;
        @XmlElement
        private String amountTotal;
        @XmlElement
        private String checkResultMessage;
        @XmlElement
        private boolean checkResult;

        public BillingInformation() {
        }

        public BillingInformation(StructuredViewer viewer, Fall fall, Konsultation konsultation) {
            this.viewer = viewer;
            this.fall = fall;
            this.konsultation = konsultation;
            this.resolved = false;
            this.resolving = false;
            this.date = new TimeTool(konsultation.getDatum()).toLocalDate();
        }

        public String getPatientName() {
            if (this.patientName == null && this.fall != null) {
                this.patientName = this.fall.getPatient().getPersonalia();
            }
            return this.patientName;
        }

        public Konsultation getKonsultation() {
            return this.konsultation;
        }

        public Integer getPatientNr() {
            if (this.patientNr == -1) {
                try {
                    this.patientNr = Integer.parseInt(this.fall.getPatient().getPatCode());
                }
                catch (NumberFormatException e) {
                    this.patientNr = -1;
                }
            }
            return this.patientNr;
        }

        public LocalDate getDate() {
            return this.date;
        }

        public synchronized boolean isResolved() {
            if (!this.resolved && !this.resolving) {
                this.resolving = true;
                executorService.execute(new ResolveLazyFieldsRunnable(this.viewer, this));
            }
            return this.resolved;
        }

        public void resolve() {
            executorService.execute(new ResolveLazyFieldsRunnable(null, this));
            while (!this.isResolved()) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        public synchronized void refresh() {
            this.resolved = false;
        }

        public String getCheckResultMessage() {
            if (!this.isResolved()) {
                return "...";
            }
            return this.checkResultMessage;
        }

        public Boolean isOk() {
            if (!this.isResolved()) {
                return false;
            }
            return this.checkResult;
        }

        public String getTotal() {
            if (!this.isResolved()) {
                return "...";
            }
            return this.amountTotal;
        }

        public String getAccountingSystem() {
            if (!this.isResolved()) {
                return "...";
            }
            return this.accountingSystem;
        }

        public String getInsurer() {
            if (!this.isResolved()) {
                return "...";
            }
            return this.insurerName;
        }

        private static class ResolveLazyFieldsRunnable
        implements Runnable {
            private BillingInformation item;
            private StructuredViewer viewer;

            public ResolveLazyFieldsRunnable(StructuredViewer viewer, BillingInformation item) {
                this.item = item;
                this.viewer = viewer;
            }

            @Override
            public void run() {
                this.resolveInsurer();
                this.resolveAccountingSystem();
                this.resolveTotal();
                this.resolveCheckResult();
                this.item.resolved = true;
                this.item.resolving = false;
                if (this.viewer != null) {
                    this.updateViewer();
                }
            }

            private void resolveCheckResult() {
                Result result = BillingUtil.getBillableResult((Konsultation)this.item.konsultation);
                if (result.isOK()) {
                    this.item.checkResultMessage = "Ok";
                    this.item.checkResult = true;
                } else {
                    StringBuilder sb = new StringBuilder();
                    for (Result.msg message : result.getMessages()) {
                        if (message.getSeverity() == Result.SEVERITY.OK) continue;
                        if (sb.length() > 0) {
                            sb.append(" / ");
                        }
                        sb.append(message.getText());
                    }
                    this.item.checkResultMessage = sb.toString();
                    this.item.checkResult = false;
                }
            }

            private void resolveTotal() {
                Money total = BillingUtil.getTotal((Konsultation)this.item.konsultation);
                this.item.amountTotal = total.getAmountAsString();
            }

            private void resolveInsurer() {
                Kontakt costBearer = this.item.fall.getCostBearer();
                this.item.insurerName = costBearer != null ? costBearer.getLabel(true) : "";
            }

            private void resolveAccountingSystem() {
                this.item.accountingSystem = this.item.fall.getAbrechnungsSystem();
            }

            private void updateViewer() {
                final Control control = this.viewer.getControl();
                if (control != null && !control.isDisposed()) {
                    control.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!control.isDisposed() && control.isVisible()) {
                                viewer.refresh((Object)item, true);
                            }
                        }
                    });
                }
            }
        }
    }

    private class BillingInformationContentProvider
    implements IStructuredContentProvider {
        private StructuredViewer viewer;
        private List<BillingInformation> currentContent;

        public BillingInformationContentProvider(StructuredViewer viewer) {
            this.viewer = viewer;
        }

        public void removeContent(List<BillingInformation> list) {
            this.currentContent.removeAll(list);
        }

        public void resolveAll() {
            this.currentContent.parallelStream().forEach(bi -> {
                bi.getPatientNr();
                if (!bi.isResolved()) {
                    bi.resolve();
                }
            });
        }

        public void refresh() {
            if (this.currentContent != null) {
                this.currentContent = this.currentContent.parallelStream().filter(bi -> bi.getKonsultation().getRechnung() == null).collect(Collectors.toList());
                this.currentContent.parallelStream().forEach(bi -> bi.refresh());
            }
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                return this.currentContent.toArray();
            }
            return Collections.emptyList().toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput instanceof List) {
                this.currentContent = ((List)newInput).parallelStream().map(k -> new BillingInformation(this.viewer, k.getFall(), (Konsultation)k)).collect(Collectors.toList());
            }
        }

        public List<BillingInformation> getCurrentContent() {
            if (this.currentContent != null) {
                return this.currentContent;
            }
            return Collections.emptyList();
        }

        public void dispose() {
            this.viewer = null;
            this.currentContent = null;
        }
    }

    private class BillingProposalViewerComparator
    extends ViewerComparator
    implements Comparator<BillingInformation> {
        private int propertyIndex = 0;
        private static final int DESCENDING = 1;
        private int direction = 1;

        public int getDirection() {
            return this.direction == 1 ? 1024 : 128;
        }

        public void setColumn(int column) {
            if (column == this.propertyIndex) {
                this.direction = 1 - this.direction;
            } else {
                this.propertyIndex = column;
                this.direction = 1;
            }
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            BillingInformation left = (BillingInformation)e1;
            BillingInformation right = (BillingInformation)e2;
            return this.compare(left, right);
        }

        @Override
        public int compare(BillingInformation left, BillingInformation right) {
            int rc = 0;
            switch (this.propertyIndex) {
                case 0: {
                    rc = right.getPatientName().compareTo(left.getPatientName());
                    break;
                }
                case 1: {
                    rc = right.getPatientNr().compareTo(left.getPatientNr());
                    break;
                }
                case 2: {
                    rc = right.getDate().compareTo(left.getDate());
                    break;
                }
                default: {
                    rc = 0;
                }
            }
            if (this.direction == 1) {
                rc = -rc;
            }
            if (this.propertyIndex != 2 && rc == 0) {
                rc = left.getDate().compareTo(right.getDate());
            }
            return rc;
        }
    }

    public static class LocalDateAdapter
    extends XmlAdapter<String, LocalDate> {
        private DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd.MM.yyyy");

        public String marshal(LocalDate date) throws Exception {
            return this.formatter.format(date);
        }

        public LocalDate unmarshal(String string) throws Exception {
            return LocalDate.parse(string, this.formatter);
        }
    }

    @XmlRootElement
    public static class ProposalLetter {
        private List<BillingInformation> proposal;

        public void setProposal(List<BillingInformation> proposal) {
            this.proposal = proposal;
        }

        public List<BillingInformation> getProposal() {
            return this.proposal;
        }
    }
}

