/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.perspective.service.internal;

import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.ui.perspective.service.IPerspectiveImportService;
import ch.elexis.core.ui.perspective.service.IStateCallback;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.eclipse.e4.ui.internal.workbench.E4XMIResourceFactory;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MSnippetContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimmedWindow;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.basic.MWindowElement;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.internal.PerspectiveExtensionReader;
import org.eclipse.ui.internal.PerspectiveTagger;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.e4.compatibility.ModeledPageLayout;
import org.eclipse.ui.internal.menus.MenuHelper;
import org.eclipse.ui.internal.registry.PerspectiveDescriptor;
import org.eclipse.ui.internal.registry.PerspectiveRegistry;
import org.osgi.service.component.annotations.Component;
import org.slf4j.LoggerFactory;

@Component
public class PerspectiveImportService
implements IPerspectiveImportService {
    @Override
    public IPerspectiveDescriptor importPerspective(String uri, IStateCallback iStateHandle, boolean openPerspectiveIfAdded) {
        try {
            if (uri != null) {
                File f;
                if (uri.toLowerCase().startsWith("http")) {
                    InputStream in = new URL(uri).openStream();
                    return this.importPerspectiveFromStream(in, iStateHandle, openPerspectiveIfAdded);
                }
                if (uri.toLowerCase().endsWith("xmi") && (f = new File(uri)) != null && f.exists()) {
                    FileInputStream in = FileUtils.openInputStream((File)f);
                    return this.importPerspectiveFromStream(in, iStateHandle, openPerspectiveIfAdded);
                }
            }
        }
        catch (IOException e) {
            LoggerFactory.getLogger(PerspectiveImportService.class).error("cannot import perspective at: " + uri, (Throwable)e);
        }
        return null;
    }

    private IPerspectiveDescriptor importPerspectiveFromStream(InputStream in, IStateCallback iStateHandle, boolean openPerspectiveIfAdded) throws IOException {
        MPerspective mPerspective = this.loadPerspectiveFromStream(in);
        if (mPerspective != null) {
            IPerspectiveRegistry iPerspectiveRegistry = PlatformUI.getWorkbench().getPerspectiveRegistry();
            String id = mPerspective.getElementId();
            IPerspectiveDescriptor existingPerspectiveDescriptor = iPerspectiveRegistry.findPerspectiveWithId(id);
            String activePerspectiveId = this.getActivePerspectiveId();
            if (existingPerspectiveDescriptor == null || iStateHandle == null || iStateHandle.state(IStateCallback.State.OVERRIDE)) {
                IPerspectiveDescriptor activePd = iPerspectiveRegistry.findPerspectiveWithId(activePerspectiveId);
                int idx = this.deletePerspective(id);
                ((PerspectiveRegistry)iPerspectiveRegistry).addPerspective(mPerspective);
                IPerspectiveDescriptor createdPd = iPerspectiveRegistry.findPerspectiveWithId(id);
                if (createdPd != null) {
                    ((PerspectiveDescriptor)createdPd).setHasCustomDefinition(false);
                }
                if (idx > -1 || openPerspectiveIfAdded) {
                    this.openPerspective(createdPd);
                    this.openPerspective(activePd);
                }
                return createdPd;
            }
        }
        return null;
    }

    @Override
    public void openPerspective(IPerspectiveDescriptor iPerspectiveDescriptor) {
        try {
            IWorkbenchWindow win = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            PlatformUI.getWorkbench().showPerspective(iPerspectiveDescriptor.getId(), win);
            boolean value = ConfigServiceHolder.getUser((String)"perspectives/fix_layout", (boolean)false);
            ContextServiceHolder.get().getRootContext().setNamed("perspectives/fix_layout", (Object)(!value ? 1 : 0));
            ContextServiceHolder.get().getRootContext().setNamed("perspectives/fix_layout", (Object)value);
        }
        catch (WorkbenchException e) {
            LoggerFactory.getLogger(PerspectiveImportService.class).error("cannot open perspective [{}]", (Object)iPerspectiveDescriptor.getId(), (Object)e);
        }
    }

    @Override
    public int closePerspective(IPerspectiveDescriptor iPerspectiveDescriptor) {
        int idx = this.isPerspectiveInsideStack(iPerspectiveDescriptor);
        if (idx > -1) {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closePerspective(iPerspectiveDescriptor, true, false);
        }
        return idx;
    }

    @Override
    public int deletePerspective(String perspectiveId) {
        IPerspectiveRegistry iPerspectiveRegistry = PlatformUI.getWorkbench().getPerspectiveRegistry();
        MApplication mApplication = PerspectiveImportService.getService(MApplication.class);
        IPerspectiveDescriptor existingPerspectiveDescriptor = iPerspectiveRegistry.findPerspectiveWithId(perspectiveId);
        int idx = -1;
        if (existingPerspectiveDescriptor != null) {
            idx = this.closePerspective(existingPerspectiveDescriptor);
            iPerspectiveRegistry.deletePerspective(existingPerspectiveDescriptor);
            PerspectiveImportService.genericInvokMethod(iPerspectiveRegistry, "removeSnippet", MSnippetContainer.class, String.class, mApplication, existingPerspectiveDescriptor.getId());
        }
        return idx;
    }

    @Override
    public int isPerspectiveInStack(String perspectiveId) {
        IPerspectiveRegistry iPerspectiveRegistry = PlatformUI.getWorkbench().getPerspectiveRegistry();
        return this.isPerspectiveInsideStack(iPerspectiveRegistry.findPerspectiveWithId(perspectiveId));
    }

    private int isPerspectiveInsideStack(IPerspectiveDescriptor pd) {
        int idx = -1;
        if (pd != null) {
            MPerspectiveStack mPerspectiveStack = this.getPerspectiveStack();
            List perspectivesInStack = mPerspectiveStack.getChildren();
            for (MPerspective perspectiveInStack : perspectivesInStack) {
                if (!pd.getId().equals(perspectiveInStack.getElementId())) continue;
                ++idx;
                break;
            }
        }
        return idx;
    }

    @Override
    public MPerspective loadPerspectiveFromStream(InputStream in) throws IOException {
        try {
            Resource resource = new E4XMIResourceFactory().createResource(null);
            resource.load(in, null);
            if (!resource.getContents().isEmpty()) {
                MPerspective loadedPerspective;
                MPerspective mPerspective = loadedPerspective = (MPerspective)resource.getContents().get(0);
                return mPerspective;
            }
            return null;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    private MPerspective getActivePerspective() {
        EModelService modelService = PerspectiveImportService.getService(EModelService.class);
        MTrimmedWindow mWindow = this.getActiveWindow();
        if (mWindow != null) {
            return modelService.getActivePerspective((MWindow)mWindow);
        }
        return null;
    }

    @Override
    public MTrimmedWindow getActiveWindow() {
        List windows;
        MApplication mApplication;
        EModelService modelService = PerspectiveImportService.getService(EModelService.class);
        MTrimmedWindow mWindow = (MTrimmedWindow)modelService.find("IDEWindow", (MUIElement)(mApplication = PerspectiveImportService.getService(MApplication.class)));
        if (mWindow == null && !(windows = mApplication.getChildren()).isEmpty() && windows.get(0) instanceof MTrimmedWindow) {
            mWindow = (MTrimmedWindow)windows.get(0);
        }
        return mWindow;
    }

    private String getActivePerspectiveId() {
        MPerspective mPerspective = this.getActivePerspective();
        if (mPerspective != null) {
            return mPerspective.getElementId();
        }
        return null;
    }

    private MPerspectiveStack getPerspectiveStack() {
        MTrimmedWindow window;
        EModelService modelService = PerspectiveImportService.getService(EModelService.class);
        List theStack = modelService.findElements((MUIElement)(window = this.getActiveWindow()), null, MPerspectiveStack.class, null);
        if (theStack.size() > 0) {
            return (MPerspectiveStack)theStack.get(0);
        }
        for (MWindowElement child : window.getChildren()) {
            if (!(child instanceof MPerspectiveStack)) continue;
            return (MPerspectiveStack)child;
        }
        return null;
    }

    @Override
    public List<String> createPerspectiveFromLegacy(String path, MPerspective mPerspective) throws IOException {
        ArrayList<String> fastViewIds = new ArrayList<String>();
        IPerspectiveRegistry iPerspectiveRegistry = PlatformUI.getWorkbench().getPerspectiveRegistry();
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (FileReader reader = new FileReader(new File(path));){
                ModeledPageLayout modelLayout;
                List windows;
                IPerspectiveDescriptor orgPd;
                XMLMemento memento = XMLMemento.createReadRoot((Reader)reader);
                String label = memento.getChild("descriptor").getString("label");
                String id = memento.getChild("descriptor").getString("id");
                String descriptorId = memento.getChild("descriptor").getString("descriptor");
                PerspectiveDescriptor pd = new PerspectiveDescriptor(id, label, null);
                if (descriptorId != null && (orgPd = iPerspectiveRegistry.findPerspectiveWithId(descriptorId)) != null) {
                    pd.setImageDescriptor(orgPd.getImageDescriptor());
                    mPerspective.setIconURI(MenuHelper.getImageUrl((ImageDescriptor)orgPd.getImageDescriptor()));
                }
                mPerspective.setLabel(label);
                mPerspective.setElementId(id);
                IMemento layout = memento.getChild("layout");
                EPartService partService = PerspectiveImportService.getService(EPartService.class);
                EModelService modelService = PerspectiveImportService.getService(EModelService.class);
                MApplication mApplication = PerspectiveImportService.getService(MApplication.class);
                MWindow window = (MWindow)modelService.find("IDEWindow", (MUIElement)mApplication);
                if (window == null && !(windows = mApplication.getChildren()).isEmpty() && windows.get(0) instanceof MTrimmedWindow) {
                    window = (MWindow)windows.get(0);
                }
                WorkbenchPage workbenchPage = (WorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                ModeledPageLayout pLayout = modelLayout = new ModeledPageLayout(window, modelService, partService, mPerspective, (IPerspectiveDescriptor)pd, workbenchPage, true);
                pLayout.setEditorAreaVisible(false);
                pLayout.setFixed(false);
                IMemento fastViews = memento.getChild("fastViews");
                if (fastViews != null) {
                    IMemento[] iMementoArray = fastViews.getChildren("view");
                    int n = iMementoArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMemento fastViewTags = iMementoArray[n2];
                        fastViewIds.add(fastViewTags.getString("id"));
                        ++n2;
                    }
                }
                IMemento mainWindow = layout.getChild("mainWindow");
                IMemento[] children = mainWindow.getChildren("info");
                int i = 0;
                while (i < children.length) {
                    IMemento childMem = children[i];
                    String partID = childMem.getString("part");
                    String refId = childMem.getString("relative");
                    Float ratio1 = childMem.getFloat("ratio");
                    Integer relationShip = childMem.getInteger("relationship");
                    IFolderLayout folder1 = pLayout.createFolder(partID, relationShip != null ? relationShip : 1, ratio1 != null ? ratio1.floatValue() : 1.0f, refId != null ? refId : "org.eclipse.ui.editorss");
                    IMemento folderData = childMem.getChild("folder");
                    if (folderData != null) {
                        IMemento[] tabs = folderData.getChildren("page");
                        int j = 0;
                        while (j < tabs.length) {
                            IMemento tab = tabs[j];
                            String tagId = tab.getString("content");
                            if (!fastViewIds.contains(tagId)) {
                                folder1.addView(tagId);
                            }
                            tab.getString("label");
                            ++j;
                        }
                    }
                    ++i;
                }
                PerspectiveTagger.tagPerspective((MPerspective)mPerspective, (EModelService)modelService);
                PerspectiveExtensionReader extReader = new PerspectiveExtensionReader();
                extReader.extendLayout(workbenchPage.getExtensionTracker(), id, modelLayout);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (WorkbenchException e) {
            throw new IOException(e);
        }
        return fastViewIds;
    }

    private static Object genericInvokMethod(Object obj, String methodName, Class<?> clazz1, Class<?> clazz2, Object param1, Object param2) {
        Object requiredObj = null;
        Object[] parameters = new Object[]{param1, param2};
        Class[] classArray = new Class[]{clazz1, clazz2};
        try {
            Method method = obj.getClass().getDeclaredMethod(methodName, classArray);
            method.setAccessible(true);
            requiredObj = method.invoke(obj, parameters);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(PerspectiveImportService.class).error("generic error", (Throwable)e);
        }
        return requiredObj;
    }

    private static <T> T getService(Class<T> clazz) {
        return (T)PlatformUI.getWorkbench().getService(clazz);
    }

    @Override
    public void savePerspectiveAs(String perspectiveId, String newName) {
        EModelService modelService = PerspectiveImportService.getService(EModelService.class);
        MApplication mApplication = PerspectiveImportService.getService(MApplication.class);
        PerspectiveRegistry perspectiveRegistry = (PerspectiveRegistry)PlatformUI.getWorkbench().getPerspectiveRegistry();
        PerspectiveDescriptor existingPerspectiveDescriptor = (PerspectiveDescriptor)perspectiveRegistry.findPerspectiveWithId(perspectiveId);
        if (existingPerspectiveDescriptor != null) {
            int idx = this.isPerspectiveInsideStack((IPerspectiveDescriptor)existingPerspectiveDescriptor);
            this.openPerspective((IPerspectiveDescriptor)existingPerspectiveDescriptor);
            List modelPerspective = modelService.findElements((MUIElement)mApplication, existingPerspectiveDescriptor.getId(), MPerspective.class, null);
            if (!modelPerspective.isEmpty()) {
                PerspectiveDescriptor newPd = perspectiveRegistry.createPerspective(newName, existingPerspectiveDescriptor);
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().savePerspectiveAs((IPerspectiveDescriptor)newPd);
                this.closePerspective((IPerspectiveDescriptor)newPd);
                if (idx > -1) {
                    this.openPerspective((IPerspectiveDescriptor)existingPerspectiveDescriptor);
                }
            }
        }
    }
}

