/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir.transformer;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ch.elexis.core.findings.util.fhir.IFhirTransformer;
import ch.elexis.core.findings.util.fhir.transformer.helper.IContactHelper;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IPerson;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IUserService;
import ch.elexis.core.services.IXidService;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.Address;
import org.hl7.fhir.r4.model.ContactPoint;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Person;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class PersonIPersonTransformer
implements IFhirTransformer<Person, IPerson> {
    @Reference(target="(service.model.name=ch.elexis.core.model)")
    private IModelService modelService;
    @Reference
    private IXidService xidService;
    @Reference
    private IUserService userService;
    private IContactHelper contactHelper;

    @Activate
    public void activate() {
        this.contactHelper = new IContactHelper(this.modelService, this.xidService, this.userService);
    }

    @Override
    public Optional<Person> getFhirObject(IPerson localObject, SummaryEnum summaryEnum, Set<Include> includes) {
        Person person = new Person();
        person.setId((IIdType)new IdDt("Person", localObject.getId()));
        List<Identifier> identifiers = this.contactHelper.getIdentifiers((IContact)localObject);
        identifiers.add(this.getElexisObjectIdentifier((Identifiable)localObject));
        person.setIdentifier(identifiers);
        person.setName(this.contactHelper.getHumanNames(localObject));
        List<Address> addresses = this.contactHelper.getAddresses((IContact)localObject);
        for (Address address : addresses) {
            person.addAddress(address);
        }
        List<ContactPoint> contactPoints = this.contactHelper.getContactPoints((IContact)localObject);
        for (ContactPoint contactPoint : contactPoints) {
            person.addTelecom(contactPoint);
        }
        return Optional.of(person);
    }

    @Override
    public Optional<IPerson> getLocalObject(Person fhirObject) {
        return null;
    }

    @Override
    public Optional<IPerson> updateLocalObject(Person fhirObject, IPerson localObject) {
        return null;
    }

    @Override
    public Optional<IPerson> createLocalObject(Person fhirObject) {
        return null;
    }

    @Override
    public boolean matchesTypes(Class<?> fhirClazz, Class<?> localClazz) {
        return Person.class.equals(fhirClazz) && IPerson.class.equals(localClazz);
    }
}

