/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.mail;

import ch.elexis.core.model.IMandator;
import java.util.Base64;
import javax.mail.Address;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;

public class MailAccount {
    private static final String SEPARATOR = ",";
    private String id;
    private TYPE type;
    private String username;
    private String password;
    private String from;
    private String host;
    private String port;
    private String mandants;
    private boolean starttls;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public TYPE getType() {
        return this.type;
    }

    public void setType(TYPE type) {
        this.type = type;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public boolean isStarttls() {
        return this.starttls;
    }

    public void setStarttls(boolean starttls) {
        this.starttls = starttls;
    }

    public String getMandants() {
        return this.mandants;
    }

    public void setMandants(String mandants) {
        this.mandants = mandants;
    }

    public static MailAccount from(String csv) {
        MailAccount ret = null;
        String[] parts = csv.split(SEPARATOR);
        if (parts != null && parts.length > 2) {
            ret = new MailAccount();
            String[] stringArray = parts;
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                String[] subParts = string.split("=");
                if (subParts != null && subParts.length == 2) {
                    MailAccount.setField(subParts[0], subParts[1], ret);
                }
                ++n2;
            }
        }
        return ret;
    }

    private static void setField(String field, String value, MailAccount account) {
        switch (field) {
            case "id": {
                account.id = value;
                return;
            }
            case "type": {
                account.type = TYPE.valueOf(value);
                return;
            }
            case "username": {
                account.username = value;
                return;
            }
            case "password": {
                account.password = new String(Base64.getDecoder().decode(value));
                return;
            }
            case "from": {
                account.from = value;
                return;
            }
            case "host": {
                account.host = value;
                return;
            }
            case "port": {
                account.port = value;
                return;
            }
            case "mandants": {
                account.mandants = value;
                return;
            }
            case "starttls": {
                account.starttls = Boolean.parseBoolean(value);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.id != null) {
            sb.append("id=").append(this.id);
            sb.append(SEPARATOR);
        }
        if (this.type != null) {
            sb.append("type=").append(this.type.name());
            sb.append(SEPARATOR);
        }
        if (this.username != null) {
            sb.append("username=").append(this.username);
            sb.append(SEPARATOR);
        }
        if (this.password != null) {
            sb.append("password=").append(Base64.getEncoder().encodeToString(this.password.getBytes()));
            sb.append(SEPARATOR);
        }
        if (this.from != null) {
            sb.append("from=").append(this.from);
            sb.append(SEPARATOR);
        }
        if (this.host != null) {
            sb.append("host=").append(this.host);
            sb.append(SEPARATOR);
        }
        if (this.port != null) {
            sb.append("port=").append(this.port);
            sb.append(SEPARATOR);
        }
        if (this.mandants != null) {
            sb.append("mandants=").append(this.mandants);
            sb.append(SEPARATOR);
        }
        sb.append("starttls=").append(this.starttls);
        return sb.toString();
    }

    public Address getFromAddress() throws AddressException {
        InternetAddress[] fromAdresses;
        if (this.from != null && this.from.contains("@") && (fromAdresses = InternetAddress.parse((String)this.from)) != null && fromAdresses.length > 0) {
            return fromAdresses[0];
        }
        if (this.username != null && this.username.contains("@") && (fromAdresses = InternetAddress.parse((String)this.username)) != null && fromAdresses.length > 0) {
            return fromAdresses[0];
        }
        throw new AddressException("From [" + this.from + "] Username [" + this.username + "] are no mail addresses.");
    }

    public boolean isForMandant(String mandantId) {
        if (this.mandants != null && !this.mandants.isEmpty()) {
            String[] ids;
            String[] stringArray = ids = this.mandants.split("\\|\\|");
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                if (string.equals(mandantId)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public void addMandant(IMandator mandant) {
        String newId = mandant.getId();
        if (this.mandants == null) {
            this.mandants = new String(newId);
        } else if (!this.mandants.contains(newId)) {
            this.mandants = String.valueOf(this.mandants) + "||" + newId;
        }
    }

    public void removeMandant(IMandator mandant) {
        if (this.mandants != null) {
            String[] ids;
            StringBuilder sb = new StringBuilder();
            String[] stringArray = ids = this.mandants.split("\\|\\|");
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                if (!string.equals(mandant.getId())) {
                    if (sb.length() == 0) {
                        sb.append(string);
                    } else {
                        sb.append("||").append(string);
                    }
                }
                ++n2;
            }
            this.mandants = sb.toString();
        }
    }

    public MailAccount copy() {
        return MailAccount.from(this.toString());
    }

    public static enum TYPE {
        SMTP,
        IMAP,
        IMAPS;

    }
}

