/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.tasks.internal.model.service;

import ch.elexis.core.common.ElexisEvent;
import ch.elexis.core.jpa.model.adapter.AbstractModelService;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IElexisEntityManager;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.IStoreToStringContribution;
import ch.elexis.core.tasks.internal.model.service.TaskModelAdapterFactory;
import ch.elexis.core.tasks.internal.model.service.TaskModelQuery;
import java.util.Optional;
import javax.persistence.EntityManager;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.EventAdmin;
import org.slf4j.LoggerFactory;

@Component(property={"service.model.name=ch.elexis.core.tasks.model"})
public class TaskModelService
extends AbstractModelService
implements IModelService,
IStoreToStringContribution {
    @Reference
    private IElexisEntityManager entityManager;
    @Reference
    private EventAdmin eventAdmin;

    @Activate
    public void activate() {
        this.adapterFactory = TaskModelAdapterFactory.getInstance();
    }

    public <T> IQuery<T> getQuery(Class<T> clazz, boolean refreshCache, boolean includeDeleted) {
        return new TaskModelQuery<T>(clazz, refreshCache, (EntityManager)this.entityManager.getEntityManager(), includeDeleted);
    }

    protected EntityManager getEntityManager(boolean managed) {
        return (EntityManager)this.entityManager.getEntityManager(managed);
    }

    protected void closeEntityManager(EntityManager entityManager) {
        this.entityManager.closeEntityManager((Object)entityManager);
    }

    protected EventAdmin getEventAdmin() {
        return this.eventAdmin;
    }

    protected ElexisEvent getCreateEvent(Identifiable identifiable) {
        return null;
    }

    public void clearCache() {
        this.entityManager.clearCache();
    }

    public Optional<String> storeToString(Identifiable identifiable) {
        Class<?>[] classArray = identifiable.getClass().getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> clazz = classArray[n2];
            if (clazz.getName().startsWith("ch.elexis.core.tasks.model")) {
                return Optional.of(String.valueOf(clazz.getName()) + "::" + identifiable.getId());
            }
            ++n2;
        }
        return Optional.empty();
    }

    public Optional<Identifiable> loadFromString(String storeToString) {
        if (storeToString == null) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("StoreToString is null");
            return Optional.empty();
        }
        if (storeToString.startsWith("ch.elexis.core.tasks.model")) {
            try {
                String[] split = this.splitIntoTypeAndId(storeToString);
                String className = split[0];
                String id = split[1];
                Class<?> clazz = TaskModelService.class.getClassLoader().loadClass(className);
                if (clazz != null) {
                    return this.load(id, clazz);
                }
            }
            catch (ClassNotFoundException e) {
                LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("Could not load class of [" + storeToString + "]");
            }
        }
        return Optional.empty();
    }

    public Class<?> getEntityForType(String type) {
        if (type.startsWith("ch.elexis.core.tasks.model")) {
            try {
                Class<?> clazz = TaskModelService.class.getClassLoader().loadClass(type);
                if (clazz != null) {
                    return this.adapterFactory.getEntityClass(clazz);
                }
            }
            catch (ClassNotFoundException e) {
                LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("Could not load class for type [" + type + "]");
            }
        }
        return null;
    }

    public String getTypeForEntity(Object entityInstance) {
        return null;
    }

    public String getTypeForModel(Class<?> interfaze) {
        return null;
    }
}

