/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.xml;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.item.NonTransientResourceException;
import org.springframework.batch.item.file.ResourceAwareItemReaderItemStream;
import org.springframework.batch.item.support.AbstractItemCountingItemStreamItemReader;
import org.springframework.batch.item.xml.stax.DefaultFragmentEventReader;
import org.springframework.batch.item.xml.stax.FragmentEventReader;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.lang.Nullable;
import org.springframework.oxm.Unmarshaller;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.StaxUtils;

public class StaxEventItemReader<T>
extends AbstractItemCountingItemStreamItemReader<T>
implements ResourceAwareItemReaderItemStream<T>,
InitializingBean {
    private static final Log logger = LogFactory.getLog(StaxEventItemReader.class);
    public static final String DEFAULT_ENCODING = Charset.defaultCharset().name();
    private FragmentEventReader fragmentReader;
    private XMLEventReader eventReader;
    private Unmarshaller unmarshaller;
    private Resource resource;
    private InputStream inputStream;
    private List<QName> fragmentRootElementNames;
    private boolean noInput;
    private boolean strict = true;
    private XMLInputFactory xmlInputFactory = StaxUtils.createDefensiveInputFactory();
    private String encoding = DEFAULT_ENCODING;

    public StaxEventItemReader() {
        this.setName(ClassUtils.getShortName(StaxEventItemReader.class));
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    @Override
    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public void setUnmarshaller(Unmarshaller unmarshaller) {
        this.unmarshaller = unmarshaller;
    }

    public void setFragmentRootElementName(String fragmentRootElementName) {
        this.setFragmentRootElementNames(new String[]{fragmentRootElementName});
    }

    public void setFragmentRootElementNames(String[] fragmentRootElementNames) {
        this.fragmentRootElementNames = new ArrayList<QName>();
        for (String fragmentRootElementName : fragmentRootElementNames) {
            this.fragmentRootElementNames.add(this.parseFragmentRootElementName(fragmentRootElementName));
        }
    }

    public void setXmlInputFactory(XMLInputFactory xmlInputFactory) {
        Assert.notNull((Object)xmlInputFactory, "XMLInputFactory must not be null");
        this.xmlInputFactory = xmlInputFactory;
    }

    public void setEncoding(String encoding) {
        Assert.notNull((Object)encoding, "The encoding must not be null");
        this.encoding = encoding;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.unmarshaller, "The Unmarshaller must not be null.");
        Assert.notEmpty(this.fragmentRootElementNames, "The FragmentRootElementNames must not be empty");
        for (QName fragmentRootElementName : this.fragmentRootElementNames) {
            Assert.hasText(fragmentRootElementName.getLocalPart(), "The FragmentRootElementNames must not contain empty elements");
        }
    }

    protected boolean moveCursorToNextFragment(XMLEventReader reader) throws NonTransientResourceException {
        try {
            while (true) {
                if (reader.peek() != null && !reader.peek().isStartElement()) {
                    reader.nextEvent();
                    continue;
                }
                if (reader.peek() == null) {
                    return false;
                }
                QName startElementName = ((StartElement)reader.peek()).getName();
                if (this.isFragmentRootElementName(startElementName)) {
                    return true;
                }
                reader.nextEvent();
            }
        }
        catch (XMLStreamException e) {
            throw new NonTransientResourceException("Error while reading from event reader", e);
        }
    }

    @Override
    protected void doClose() throws Exception {
        try {
            if (this.fragmentReader != null) {
                this.fragmentReader.close();
            }
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
        finally {
            this.fragmentReader = null;
            this.inputStream = null;
        }
    }

    @Override
    protected void doOpen() throws Exception {
        Assert.notNull((Object)this.resource, "The Resource must not be null.");
        this.noInput = true;
        if (!this.resource.exists()) {
            if (this.strict) {
                throw new IllegalStateException("Input resource must exist (reader is in 'strict' mode)");
            }
            logger.warn("Input resource does not exist " + this.resource.getDescription());
            return;
        }
        if (!this.resource.isReadable()) {
            if (this.strict) {
                throw new IllegalStateException("Input resource must be readable (reader is in 'strict' mode)");
            }
            logger.warn("Input resource is not readable " + this.resource.getDescription());
            return;
        }
        this.inputStream = this.resource.getInputStream();
        this.eventReader = this.xmlInputFactory.createXMLEventReader(this.inputStream, this.encoding);
        this.fragmentReader = new DefaultFragmentEventReader(this.eventReader);
        this.noInput = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    protected T doRead() throws IOException, XMLStreamException {
        if (this.noInput) {
            return null;
        }
        Object item = null;
        boolean success = false;
        try {
            success = this.moveCursorToNextFragment(this.fragmentReader);
        }
        catch (NonTransientResourceException e) {
            this.noInput = true;
            throw e;
        }
        if (success) {
            this.fragmentReader.markStartFragment();
            try {
                Object mappedFragment;
                item = mappedFragment = this.unmarshaller.unmarshal(StaxUtils.createStaxSource(this.fragmentReader));
            }
            finally {
                this.fragmentReader.markFragmentProcessed();
            }
        }
        return (T)item;
    }

    @Override
    protected void jumpToItem(int itemIndex) throws Exception {
        for (int i2 = 0; i2 < itemIndex; ++i2) {
            try {
                QName fragmentName = this.readToStartFragment();
                this.readToEndFragment(fragmentName);
                continue;
            }
            catch (NoSuchElementException e) {
                if (itemIndex == i2 + 1) {
                    return;
                }
                throw e;
            }
        }
    }

    private QName readToStartFragment() throws XMLStreamException {
        XMLEvent nextEvent;
        while (!(nextEvent = this.eventReader.nextEvent()).isStartElement() || !this.isFragmentRootElementName(((StartElement)nextEvent).getName())) {
        }
        return ((StartElement)nextEvent).getName();
    }

    private void readToEndFragment(QName fragmentRootElementName) throws XMLStreamException {
        XMLEvent nextEvent;
        while (!(nextEvent = this.eventReader.nextEvent()).isEndElement() || !fragmentRootElementName.equals(((EndElement)nextEvent).getName())) {
        }
    }

    protected boolean isFragmentRootElementName(QName name) {
        for (QName fragmentRootElementName : this.fragmentRootElementNames) {
            if (!fragmentRootElementName.getLocalPart().equals(name.getLocalPart()) || StringUtils.hasText(fragmentRootElementName.getNamespaceURI()) && !fragmentRootElementName.getNamespaceURI().equals(name.getNamespaceURI())) continue;
            return true;
        }
        return false;
    }

    private QName parseFragmentRootElementName(String fragmentRootElementName) {
        String name = fragmentRootElementName;
        String nameSpace = null;
        if (fragmentRootElementName.contains("{")) {
            nameSpace = fragmentRootElementName.replaceAll("\\{(.*)\\}.*", "$1");
            name = fragmentRootElementName.replaceAll("\\{.*\\}(.*)", "$1");
        }
        return new QName(nameSpace, name, "");
    }
}

