/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.jms;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jms.JmsException;
import org.springframework.jms.core.JmsOperations;
import org.springframework.lang.Nullable;
import org.springframework.retry.interceptor.MethodInvocationRecoverer;

public class JmsMethodInvocationRecoverer<T>
implements MethodInvocationRecoverer<T> {
    protected Log logger = LogFactory.getLog(this.getClass());
    private JmsOperations jmsTemplate;

    public void setJmsTemplate(JmsOperations jmsTemplate) {
        this.jmsTemplate = jmsTemplate;
    }

    @Override
    @Nullable
    public T recover(Object[] items, Throwable cause) {
        try {
            for (Object item : items) {
                this.jmsTemplate.convertAndSend(item);
            }
            return null;
        }
        catch (JmsException e) {
            this.logger.error("Could not recover because of JmsException.", e);
            throw e;
        }
    }
}

