/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.file.mapping;

import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import org.springframework.beans.BeanUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

final class PropertyMatches {
    public static final int DEFAULT_MAX_DISTANCE = 2;
    private final String propertyName;
    private String[] possibleMatches;

    public static PropertyMatches forProperty(String propertyName, Class<?> beanClass) {
        return PropertyMatches.forProperty(propertyName, beanClass, 2);
    }

    public static PropertyMatches forProperty(String propertyName, Class<?> beanClass, int maxDistance) {
        return new PropertyMatches(propertyName, beanClass, maxDistance);
    }

    private PropertyMatches(String propertyName, Class<?> beanClass, int maxDistance) {
        this.propertyName = propertyName;
        this.possibleMatches = this.calculateMatches(BeanUtils.getPropertyDescriptors(beanClass), maxDistance);
    }

    public String[] getPossibleMatches() {
        return this.possibleMatches;
    }

    public String buildErrorMessage() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("Bean property '");
        buf.append(this.propertyName);
        buf.append("' is not writable or has an invalid setter method. ");
        if (ObjectUtils.isEmpty(this.possibleMatches)) {
            buf.append("Does the parameter type of the setter match the return type of the getter?");
        } else {
            buf.append("Did you mean ");
            for (int i2 = 0; i2 < this.possibleMatches.length; ++i2) {
                buf.append('\'');
                buf.append(this.possibleMatches[i2]);
                if (i2 < this.possibleMatches.length - 2) {
                    buf.append("', ");
                    continue;
                }
                if (i2 != this.possibleMatches.length - 2) continue;
                buf.append("', or ");
            }
            buf.append("'?");
        }
        return buf.toString();
    }

    private String[] calculateMatches(PropertyDescriptor[] propertyDescriptors, int maxDistance) {
        ArrayList<String> candidates = new ArrayList<String>();
        for (int i2 = 0; i2 < propertyDescriptors.length; ++i2) {
            String possibleAlternative;
            int distance;
            if (propertyDescriptors[i2].getWriteMethod() == null || (distance = this.calculateStringDistance(this.propertyName, possibleAlternative = propertyDescriptors[i2].getName())) > maxDistance) continue;
            candidates.add(possibleAlternative);
        }
        Collections.sort(candidates);
        return StringUtils.toStringArray(candidates);
    }

    private int calculateStringDistance(String s1, String s2) {
        int i2;
        if (s1.length() == 0) {
            return s2.length();
        }
        if (s2.length() == 0) {
            return s1.length();
        }
        int[][] d = new int[s1.length() + 1][s2.length() + 1];
        for (i2 = 0; i2 <= s1.length(); ++i2) {
            d[i2][0] = i2;
        }
        for (int j = 0; j <= s2.length(); ++j) {
            d[0][j] = j;
        }
        for (i2 = 1; i2 <= s1.length(); ++i2) {
            char s_i = s1.charAt(i2 - 1);
            for (int j = 1; j <= s2.length(); ++j) {
                char t_j = s2.charAt(j - 1);
                int cost = Character.toLowerCase(s_i) == Character.toLowerCase(t_j) ? 0 : 1;
                d[i2][j] = Math.min(Math.min(d[i2 - 1][j] + 1, d[i2][j - 1] + 1), d[i2 - 1][j - 1] + cost);
            }
        }
        return d[s1.length()][s2.length()];
    }
}

