/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.database.support;

import org.springframework.batch.item.database.support.SqlPagingQueryUtils;
import org.springframework.batch.item.database.support.SqlWindowingPagingQueryProvider;
import org.springframework.util.StringUtils;

public class Db2PagingQueryProvider
extends SqlWindowingPagingQueryProvider {
    @Override
    public String generateFirstPageQuery(int pageSize) {
        return SqlPagingQueryUtils.generateLimitSqlQuery(this, false, this.buildLimitClause(pageSize));
    }

    @Override
    public String generateRemainingPagesQuery(int pageSize) {
        if (StringUtils.hasText(this.getGroupClause())) {
            return SqlPagingQueryUtils.generateLimitGroupedSqlQuery(this, true, this.buildLimitClause(pageSize));
        }
        return SqlPagingQueryUtils.generateLimitSqlQuery(this, true, this.buildLimitClause(pageSize));
    }

    @Override
    protected Object getSubQueryAlias() {
        return "AS TMP_SUB ";
    }

    private String buildLimitClause(int pageSize) {
        return "FETCH FIRST " + pageSize + " ROWS ONLY";
    }
}

