/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step.item;

import io.micrometer.core.instrument.Timer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.listener.StepListenerFailedException;
import org.springframework.batch.core.metrics.BatchMetrics;
import org.springframework.batch.core.step.item.BatchRetryTemplate;
import org.springframework.batch.core.step.item.Chunk;
import org.springframework.batch.core.step.item.ChunkMonitor;
import org.springframework.batch.core.step.item.ForceRollbackForWriteSkipException;
import org.springframework.batch.core.step.item.KeyGenerator;
import org.springframework.batch.core.step.item.SimpleChunkProcessor;
import org.springframework.batch.core.step.item.SkipWrapper;
import org.springframework.batch.core.step.skip.LimitCheckingItemSkipPolicy;
import org.springframework.batch.core.step.skip.NonSkippableProcessException;
import org.springframework.batch.core.step.skip.SkipLimitExceededException;
import org.springframework.batch.core.step.skip.SkipListenerFailedException;
import org.springframework.batch.core.step.skip.SkipPolicy;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemWriter;
import org.springframework.classify.BinaryExceptionClassifier;
import org.springframework.classify.Classifier;
import org.springframework.retry.ExhaustedRetryException;
import org.springframework.retry.RecoveryCallback;
import org.springframework.retry.RetryCallback;
import org.springframework.retry.RetryContext;
import org.springframework.retry.RetryException;
import org.springframework.retry.support.DefaultRetryState;

public class FaultTolerantChunkProcessor<I, O>
extends SimpleChunkProcessor<I, O> {
    private SkipPolicy itemProcessSkipPolicy = new LimitCheckingItemSkipPolicy();
    private SkipPolicy itemWriteSkipPolicy = new LimitCheckingItemSkipPolicy();
    private final BatchRetryTemplate batchRetryTemplate;
    private Classifier<Throwable, Boolean> rollbackClassifier = new BinaryExceptionClassifier(true);
    private Log logger = LogFactory.getLog(this.getClass());
    private boolean buffering = true;
    private KeyGenerator keyGenerator;
    private ChunkMonitor chunkMonitor = new ChunkMonitor();
    private boolean processorTransactional = true;

    public void setKeyGenerator(KeyGenerator keyGenerator) {
        this.keyGenerator = keyGenerator;
    }

    public void setProcessSkipPolicy(SkipPolicy SkipPolicy2) {
        this.itemProcessSkipPolicy = SkipPolicy2;
    }

    public void setWriteSkipPolicy(SkipPolicy SkipPolicy2) {
        this.itemWriteSkipPolicy = SkipPolicy2;
    }

    public void setRollbackClassifier(Classifier<Throwable, Boolean> rollbackClassifier) {
        this.rollbackClassifier = rollbackClassifier;
    }

    public void setChunkMonitor(ChunkMonitor chunkMonitor) {
        this.chunkMonitor = chunkMonitor;
    }

    public void setBuffering(boolean buffering) {
        this.buffering = buffering;
    }

    public void setProcessorTransactional(boolean processorTransactional) {
        this.processorTransactional = processorTransactional;
    }

    public FaultTolerantChunkProcessor(ItemProcessor<? super I, ? extends O> itemProcessor, ItemWriter<? super O> itemWriter, BatchRetryTemplate batchRetryTemplate) {
        super(itemProcessor, itemWriter);
        this.batchRetryTemplate = batchRetryTemplate;
    }

    @Override
    protected void initializeUserData(Chunk<I> inputs) {
        UserData data = (UserData)inputs.getUserData();
        if (data == null) {
            data = new UserData();
            inputs.setUserData(data);
            data.setOutputs(new Chunk());
        } else if (data.scanning()) {
            data.filterCount = 0;
        }
    }

    @Override
    protected int getFilterCount(Chunk<I> inputs, Chunk<O> outputs) {
        UserData data = (UserData)inputs.getUserData();
        return data.filterCount;
    }

    @Override
    protected boolean isComplete(Chunk<I> inputs) {
        UserData data = (UserData)inputs.getUserData();
        Chunk previous = data.getOutputs();
        return inputs.isEmpty() && previous.getSkips().isEmpty();
    }

    @Override
    protected Chunk<O> getAdjustedOutputs(Chunk<I> inputs, Chunk<O> outputs) {
        UserData data = (UserData)inputs.getUserData();
        Chunk previous = data.getOutputs();
        Chunk<O> next = new Chunk<O>(outputs.getItems(), previous.getSkips());
        next.setBusy(previous.isBusy());
        data.setOutputs(next);
        return next;
    }

    @Override
    protected Chunk<O> transform(final StepContribution contribution, Chunk<I> inputs) throws Exception {
        Chunk<Object> outputs = new Chunk<Object>();
        final UserData data = (UserData)inputs.getUserData();
        final Chunk cache = data.getOutputs();
        final Iterator cacheIterator = cache.isEmpty() ? null : new ArrayList(cache.getItems()).iterator();
        final AtomicInteger count = new AtomicInteger(0);
        final Chunk.ChunkIterator iterator2 = inputs.iterator();
        while (iterator2.hasNext()) {
            RecoveryCallback recoveryCallback;
            final Object item = iterator2.next();
            RetryCallback retryCallback = new RetryCallback<O, Exception>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public O doWithRetry(RetryContext context) throws Exception {
                    Object output;
                    block13: {
                        Timer.Sample sample = BatchMetrics.createTimerSample();
                        String status = "SUCCESS";
                        output = null;
                        try {
                            Object cached;
                            count.incrementAndGet();
                            Object o = cached = cacheIterator != null && cacheIterator.hasNext() ? (Object)cacheIterator.next() : null;
                            if (cached != null && !FaultTolerantChunkProcessor.this.processorTransactional) {
                                output = cached;
                            } else {
                                output = FaultTolerantChunkProcessor.this.doProcess(item);
                                if (output == null) {
                                    data.incrementFilterCount();
                                } else if (!FaultTolerantChunkProcessor.this.processorTransactional && !data.scanning()) {
                                    cache.add(output);
                                }
                            }
                        }
                        catch (Exception e) {
                            status = "FAILURE";
                            if (((Boolean)FaultTolerantChunkProcessor.this.rollbackClassifier.classify(e)).booleanValue()) {
                                throw e;
                            }
                            if (FaultTolerantChunkProcessor.this.shouldSkip(FaultTolerantChunkProcessor.this.itemProcessSkipPolicy, e, contribution.getStepSkipCount())) {
                                contribution.incrementProcessSkipCount();
                                FaultTolerantChunkProcessor.this.logger.debug("Skipping after failed process with no rollback", e);
                                FaultTolerantChunkProcessor.this.callProcessSkipListener(item, e);
                                break block13;
                            }
                            throw new NonSkippableProcessException("Non-skippable exception in processor.  Make sure any exceptions that do not cause a rollback are skippable.", e);
                        }
                        finally {
                            FaultTolerantChunkProcessor.this.stopTimer(sample, contribution.getStepExecution(), "item.process", status, "Item processing");
                        }
                    }
                    if (output == null) {
                        iterator2.remove();
                    }
                    return output;
                }
            };
            Object output = this.batchRetryTemplate.execute(retryCallback, recoveryCallback = new RecoveryCallback<O>(){

                @Override
                public O recover(RetryContext context) throws Exception {
                    Throwable e = context.getLastThrowable();
                    if (FaultTolerantChunkProcessor.this.shouldSkip(FaultTolerantChunkProcessor.this.itemProcessSkipPolicy, e, contribution.getStepSkipCount())) {
                        iterator2.remove(e);
                        contribution.incrementProcessSkipCount();
                        FaultTolerantChunkProcessor.this.logger.debug("Skipping after failed process", e);
                        return null;
                    }
                    if (((Boolean)FaultTolerantChunkProcessor.this.rollbackClassifier.classify(e)).booleanValue()) {
                        throw new RetryException("Non-skippable exception in recoverer while processing", e);
                    }
                    iterator2.remove(e);
                    return null;
                }
            }, new DefaultRetryState(this.getInputKey(item), this.rollbackClassifier));
            if (output != null) {
                outputs.add(output);
            }
            if (!data.scanning()) continue;
            while (cacheIterator != null && cacheIterator.hasNext()) {
                outputs.add(cacheIterator.next());
            }
            break block0;
        }
        return outputs;
    }

    @Override
    protected void write(final StepContribution contribution, final Chunk<I> inputs, final Chunk<O> outputs) throws Exception {
        final UserData data = (UserData)inputs.getUserData();
        final AtomicReference contextHolder = new AtomicReference();
        RetryCallback<Object, Exception> retryCallback = new RetryCallback<Object, Exception>(){

            @Override
            public Object doWithRetry(RetryContext context) throws Exception {
                contextHolder.set(context);
                if (!data.scanning()) {
                    FaultTolerantChunkProcessor.this.chunkMonitor.setChunkSize(inputs.size());
                    Timer.Sample sample = BatchMetrics.createTimerSample();
                    String status = "SUCCESS";
                    try {
                        FaultTolerantChunkProcessor.this.doWrite(outputs.getItems());
                    }
                    catch (Exception e) {
                        status = "FAILURE";
                        if (((Boolean)FaultTolerantChunkProcessor.this.rollbackClassifier.classify(e)).booleanValue()) {
                            throw e;
                        }
                        throw new ForceRollbackForWriteSkipException("Force rollback on skippable exception so that skipped item can be located.", e);
                    }
                    finally {
                        FaultTolerantChunkProcessor.this.stopTimer(sample, contribution.getStepExecution(), "chunk.write", status, "Chunk writing");
                    }
                    contribution.incrementWriteCount(outputs.size());
                } else {
                    FaultTolerantChunkProcessor.this.scan(contribution, inputs, outputs, FaultTolerantChunkProcessor.this.chunkMonitor, false);
                }
                return null;
            }
        };
        if (!this.buffering) {
            RecoveryCallback<Object> batchRecoveryCallback = new RecoveryCallback<Object>(){

                @Override
                public Object recover(RetryContext context) throws Exception {
                    Throwable e = context.getLastThrowable();
                    if (outputs.size() > 1 && !((Boolean)FaultTolerantChunkProcessor.this.rollbackClassifier.classify(e)).booleanValue()) {
                        throw new RetryException("Invalid retry state during write caused by exception that does not classify for rollback: ", e);
                    }
                    Chunk.ChunkIterator inputIterator = inputs.iterator();
                    Chunk.ChunkIterator outputIterator = outputs.iterator();
                    while (outputIterator.hasNext()) {
                        inputIterator.next();
                        outputIterator.next();
                        FaultTolerantChunkProcessor.this.checkSkipPolicy(inputIterator, outputIterator, e, contribution, true);
                        if (((Boolean)FaultTolerantChunkProcessor.this.rollbackClassifier.classify(e)).booleanValue()) continue;
                        throw new RetryException("Invalid retry state during recovery caused by exception that does not classify for rollback: ", e);
                    }
                    return null;
                }
            };
            this.batchRetryTemplate.execute(retryCallback, batchRecoveryCallback, BatchRetryTemplate.createState(this.getInputKeys(inputs), this.rollbackClassifier));
        } else {
            RecoveryCallback<Object> recoveryCallback = new RecoveryCallback<Object>(){

                @Override
                public Object recover(RetryContext context) throws Exception {
                    if (!FaultTolerantChunkProcessor.this.shouldSkip(FaultTolerantChunkProcessor.this.itemWriteSkipPolicy, context.getLastThrowable(), -1)) {
                        throw new ExhaustedRetryException("Retry exhausted after last attempt in recovery path, but exception is not skippable.", context.getLastThrowable());
                    }
                    inputs.setBusy(true);
                    data.scanning(true);
                    FaultTolerantChunkProcessor.this.scan(contribution, inputs, outputs, FaultTolerantChunkProcessor.this.chunkMonitor, true);
                    return null;
                }
            };
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Attempting to write: " + inputs);
            }
            try {
                this.batchRetryTemplate.execute(retryCallback, recoveryCallback, new DefaultRetryState(inputs, this.rollbackClassifier));
            }
            catch (Exception e) {
                RetryContext context = (RetryContext)contextHolder.get();
                if (!this.batchRetryTemplate.canRetry(context)) {
                    data.scanning(true);
                }
                throw e;
            }
        }
        this.callSkipListeners(inputs, outputs);
    }

    private void callSkipListeners(Chunk<I> inputs, Chunk<O> outputs) {
        for (SkipWrapper<I> skipWrapper : inputs.getSkips()) {
            I item = skipWrapper.getItem();
            if (item == null) continue;
            Throwable e = skipWrapper.getException();
            this.callProcessSkipListener(item, e);
        }
        for (SkipWrapper<Object> skipWrapper : outputs.getSkips()) {
            Throwable e = skipWrapper.getException();
            try {
                this.getListener().onSkipInWrite(skipWrapper.getItem(), e);
            }
            catch (RuntimeException ex) {
                throw new SkipListenerFailedException("Fatal exception in SkipListener.", ex, e);
            }
        }
        outputs.clearSkips();
        inputs.clearSkips();
    }

    private void callProcessSkipListener(I item, Throwable e) {
        try {
            this.getListener().onSkipInProcess(item, e);
        }
        catch (RuntimeException ex) {
            throw new SkipListenerFailedException("Fatal exception in SkipListener.", ex, e);
        }
    }

    private boolean shouldSkip(SkipPolicy policy, Throwable e, int skipCount) {
        try {
            return policy.shouldSkip(e, skipCount);
        }
        catch (SkipLimitExceededException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw new SkipListenerFailedException("Fatal exception in SkipPolicy.", ex, e);
        }
    }

    private Object getInputKey(I item) {
        if (this.keyGenerator == null) {
            return item;
        }
        return this.keyGenerator.getKey(item);
    }

    private List<?> getInputKeys(Chunk<I> inputs) {
        if (this.keyGenerator == null) {
            return inputs.getItems();
        }
        ArrayList<Object> keys2 = new ArrayList<Object>();
        for (I item : inputs.getItems()) {
            keys2.add(this.keyGenerator.getKey(item));
        }
        return keys2;
    }

    private void checkSkipPolicy(Chunk.ChunkIterator inputIterator, Chunk.ChunkIterator outputIterator, Throwable e, StepContribution contribution, boolean recovery) throws Exception {
        this.logger.debug("Checking skip policy after failed write");
        if (!this.shouldSkip(this.itemWriteSkipPolicy, e, contribution.getStepSkipCount())) {
            if (recovery) {
                throw new RetryException("Non-skippable exception in recoverer", e);
            }
            if (e instanceof Exception) {
                throw (Exception)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw new RetryException("Non-skippable throwable in recoverer", e);
        }
        contribution.incrementWriteSkipCount();
        inputIterator.remove();
        outputIterator.remove(e);
        this.logger.debug("Skipping after failed write", e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scan(StepContribution contribution, Chunk<I> inputs, Chunk<O> outputs, ChunkMonitor chunkMonitor, boolean recovery) throws Exception {
        UserData data;
        block14: {
            data = (UserData)inputs.getUserData();
            if (this.logger.isDebugEnabled()) {
                if (recovery) {
                    this.logger.debug("Scanning for failed item on recovery from write: " + inputs);
                } else {
                    this.logger.debug("Scanning for failed item on write: " + inputs);
                }
            }
            if (outputs.isEmpty() || inputs.isEmpty()) {
                data.scanning(false);
                inputs.setBusy(false);
                chunkMonitor.resetOffset();
                return;
            }
            Chunk.ChunkIterator inputIterator = inputs.iterator();
            Chunk.ChunkIterator outputIterator = outputs.iterator();
            if (!inputs.getSkips().isEmpty() && inputs.getItems().size() != outputs.getItems().size() && outputIterator.hasNext()) {
                outputIterator.remove();
                return;
            }
            List items = Collections.singletonList(outputIterator.next());
            inputIterator.next();
            try {
                this.writeItems(items);
                this.doAfterWrite(items);
                contribution.incrementWriteCount(1);
                inputIterator.remove();
                outputIterator.remove();
            }
            catch (Exception e) {
                try {
                    this.doOnWriteError(e, items);
                }
                finally {
                    Throwable cause = e;
                    if (e instanceof StepListenerFailedException) {
                        cause = e.getCause();
                    }
                    if (!this.shouldSkip(this.itemWriteSkipPolicy, cause, -1) && !this.rollbackClassifier.classify(cause).booleanValue()) {
                        inputIterator.remove();
                        outputIterator.remove();
                    } else {
                        this.checkSkipPolicy(inputIterator, outputIterator, cause, contribution, recovery);
                    }
                    if (!this.rollbackClassifier.classify(cause).booleanValue()) break block14;
                    throw cause;
                }
            }
        }
        chunkMonitor.incrementOffset();
        if (outputs.isEmpty()) {
            data.scanning(false);
            inputs.setBusy(false);
            chunkMonitor.resetOffset();
        }
    }

    private static class UserData<O> {
        private Chunk<O> outputs;
        private int filterCount = 0;
        private boolean scanning;

        private UserData() {
        }

        public boolean scanning() {
            return this.scanning;
        }

        public void scanning(boolean scanning) {
            this.scanning = scanning;
        }

        public void incrementFilterCount() {
            ++this.filterCount;
        }

        public Chunk<O> getOutputs() {
            return this.outputs;
        }

        public void setOutputs(Chunk<O> outputs) {
            this.outputs = outputs;
        }
    }
}

