/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.listener;

import java.util.Iterator;
import java.util.List;
import org.springframework.batch.core.ItemReadListener;
import org.springframework.batch.core.listener.OrderedComposite;

public class CompositeItemReadListener<T>
implements ItemReadListener<T> {
    private OrderedComposite<ItemReadListener<? super T>> listeners = new OrderedComposite();

    public void setListeners(List<? extends ItemReadListener<? super T>> itemReadListeners) {
        this.listeners.setItems(itemReadListeners);
    }

    public void register(ItemReadListener<? super T> itemReaderListener) {
        this.listeners.add(itemReaderListener);
    }

    @Override
    public void afterRead(T item) {
        Iterator<ItemReadListener<T>> iterator2 = this.listeners.reverse();
        while (iterator2.hasNext()) {
            ItemReadListener<T> listener = iterator2.next();
            listener.afterRead(item);
        }
    }

    @Override
    public void beforeRead() {
        Iterator<ItemReadListener<T>> iterator2 = this.listeners.iterator();
        while (iterator2.hasNext()) {
            ItemReadListener<T> listener = iterator2.next();
            listener.beforeRead();
        }
    }

    @Override
    public void onReadError(Exception ex) {
        Iterator<ItemReadListener<T>> iterator2 = this.listeners.reverse();
        while (iterator2.hasNext()) {
            ItemReadListener<T> listener = iterator2.next();
            listener.onReadError(ex);
        }
    }
}

