/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.jsr.configuration.xml;

import java.util.List;
import org.springframework.batch.core.configuration.xml.ExceptionElementParser;
import org.springframework.batch.core.jsr.configuration.support.BatchArtifactType;
import org.springframework.batch.core.jsr.configuration.xml.PropertyParser;
import org.springframework.batch.core.jsr.configuration.xml.StepFactoryBean;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ChunkParser {
    private static final String TIME_LIMIT_ATTRIBUTE = "time-limit";
    private static final String ITEM_COUNT_ATTRIBUTE = "item-count";
    private static final String CHECKPOINT_ALGORITHM_ELEMENT = "checkpoint-algorithm";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String INCLUDE_ELEMENT = "include";
    private static final String NO_ROLLBACK_EXCEPTION_CLASSES_ELEMENT = "no-rollback-exception-classes";
    private static final String RETRYABLE_EXCEPTION_CLASSES_ELEMENT = "retryable-exception-classes";
    private static final String SKIPPABLE_EXCEPTION_CLASSES_ELEMENT = "skippable-exception-classes";
    private static final String WRITER_ELEMENT = "writer";
    private static final String PROCESSOR_ELEMENT = "processor";
    private static final String READER_ELEMENT = "reader";
    private static final String REF_ATTRIBUTE = "ref";
    private static final String RETRY_LIMIT_ATTRIBUTE = "retry-limit";
    private static final String SKIP_LIMIT_ATTRIBUTE = "skip-limit";
    private static final String CUSTOM_CHECKPOINT_POLICY = "custom";
    private static final String ITEM_CHECKPOINT_POLICY = "item";
    private static final String CHECKPOINT_POLICY_ATTRIBUTE = "checkpoint-policy";

    public void parse(Element element, AbstractBeanDefinition bd, ParserContext parserContext, String stepName) {
        String itemCount;
        MutablePropertyValues propertyValues = bd.getPropertyValues();
        bd.setBeanClass(StepFactoryBean.class);
        bd.setAttribute("isNamespaceStep", false);
        propertyValues.addPropertyValue("hasChunkElement", Boolean.TRUE);
        String checkpointPolicy = element.getAttribute(CHECKPOINT_POLICY_ATTRIBUTE);
        if (StringUtils.hasText(checkpointPolicy)) {
            if (checkpointPolicy.equals(ITEM_CHECKPOINT_POLICY)) {
                itemCount = element.getAttribute(ITEM_COUNT_ATTRIBUTE);
                if (StringUtils.hasText(itemCount)) {
                    propertyValues.addPropertyValue("commitInterval", itemCount);
                } else {
                    propertyValues.addPropertyValue("commitInterval", "10");
                }
                this.parseSimpleAttribute(element, propertyValues, TIME_LIMIT_ATTRIBUTE, "timeout");
            } else if (checkpointPolicy.equals(CUSTOM_CHECKPOINT_POLICY)) {
                this.parseCustomCheckpointAlgorithm(element, parserContext, propertyValues, stepName);
            }
        } else {
            itemCount = element.getAttribute(ITEM_COUNT_ATTRIBUTE);
            if (StringUtils.hasText(itemCount)) {
                propertyValues.addPropertyValue("commitInterval", itemCount);
            } else {
                propertyValues.addPropertyValue("commitInterval", "10");
            }
            this.parseSimpleAttribute(element, propertyValues, TIME_LIMIT_ATTRIBUTE, "timeout");
        }
        this.parseSimpleAttribute(element, propertyValues, SKIP_LIMIT_ATTRIBUTE, "skipLimit");
        this.parseSimpleAttribute(element, propertyValues, RETRY_LIMIT_ATTRIBUTE, "retryLimit");
        NodeList children = element.getChildNodes();
        for (int i2 = 0; i2 < children.getLength(); ++i2) {
            Node nd = children.item(i2);
            this.parseChildElement(element, parserContext, propertyValues, nd, stepName);
        }
    }

    private void parseSimpleAttribute(Element element, MutablePropertyValues propertyValues, String attributeName, String propertyName) {
        String propertyValue = element.getAttribute(attributeName);
        if (StringUtils.hasText(propertyValue)) {
            propertyValues.addPropertyValue(propertyName, propertyValue);
        }
    }

    private void parseChildElement(Element element, ParserContext parserContext, MutablePropertyValues propertyValues, Node nd, String stepName) {
        if (nd instanceof Element) {
            Element nestedElement = (Element)nd;
            String name = nestedElement.getLocalName();
            String artifactName = nestedElement.getAttribute(REF_ATTRIBUTE);
            if (name.equals(READER_ELEMENT)) {
                if (StringUtils.hasText(artifactName)) {
                    propertyValues.addPropertyValue("stepItemReader", new RuntimeBeanReference(artifactName));
                }
                new PropertyParser(artifactName, parserContext, BatchArtifactType.STEP_ARTIFACT, stepName).parseProperties(nestedElement);
            } else if (name.equals(PROCESSOR_ELEMENT)) {
                if (StringUtils.hasText(artifactName)) {
                    propertyValues.addPropertyValue("stepItemProcessor", new RuntimeBeanReference(artifactName));
                }
                new PropertyParser(artifactName, parserContext, BatchArtifactType.STEP_ARTIFACT, stepName).parseProperties(nestedElement);
            } else if (name.equals(WRITER_ELEMENT)) {
                if (StringUtils.hasText(artifactName)) {
                    propertyValues.addPropertyValue("stepItemWriter", new RuntimeBeanReference(artifactName));
                }
                new PropertyParser(artifactName, parserContext, BatchArtifactType.STEP_ARTIFACT, stepName).parseProperties(nestedElement);
            } else if (name.equals(SKIPPABLE_EXCEPTION_CLASSES_ELEMENT)) {
                ManagedMap<TypedStringValue, Boolean> exceptionClasses = new ExceptionElementParser().parse(element, parserContext, SKIPPABLE_EXCEPTION_CLASSES_ELEMENT);
                if (exceptionClasses != null) {
                    propertyValues.addPropertyValue("skippableExceptionClasses", exceptionClasses);
                }
            } else if (name.equals(RETRYABLE_EXCEPTION_CLASSES_ELEMENT)) {
                ManagedMap<TypedStringValue, Boolean> exceptionClasses = new ExceptionElementParser().parse(element, parserContext, RETRYABLE_EXCEPTION_CLASSES_ELEMENT);
                if (exceptionClasses != null) {
                    propertyValues.addPropertyValue("retryableExceptionClasses", exceptionClasses);
                }
            } else if (name.equals(NO_ROLLBACK_EXCEPTION_CLASSES_ELEMENT)) {
                ManagedList<TypedStringValue> list = new ManagedList<TypedStringValue>();
                for (Element child : DomUtils.getChildElementsByTagName(nestedElement, INCLUDE_ELEMENT)) {
                    String className = child.getAttribute(CLASS_ATTRIBUTE);
                    list.add(new TypedStringValue(className, Class.class));
                }
                propertyValues.addPropertyValue("noRollbackExceptionClasses", list);
            }
        }
    }

    private void parseCustomCheckpointAlgorithm(Element element, ParserContext parserContext, MutablePropertyValues propertyValues, String stepName) {
        List<Element> elements = DomUtils.getChildElementsByTagName(element, CHECKPOINT_ALGORITHM_ELEMENT);
        if (elements.size() == 1) {
            Element checkpointAlgorithmElement = elements.get(0);
            String name = checkpointAlgorithmElement.getAttribute(REF_ATTRIBUTE);
            if (StringUtils.hasText(name)) {
                propertyValues.addPropertyValue("stepChunkCompletionPolicy", new RuntimeBeanReference(name));
            }
            new PropertyParser(name, parserContext, BatchArtifactType.STEP_ARTIFACT, stepName).parseProperties(checkpointAlgorithmElement);
        } else if (elements.size() > 1) {
            parserContext.getReaderContext().error("The <checkpoint-algorithm/> element may not appear more than once in a single <" + element.getNodeName() + "/>.", element);
        }
    }
}

