/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.xml;

import org.springframework.batch.core.configuration.xml.CoreNamespaceUtils;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class JobRepositoryParser
extends AbstractSingleBeanDefinitionParser {
    @Override
    protected String getBeanClassName(Element element) {
        return "org.springframework.batch.core.repository.support.JobRepositoryFactoryBean";
    }

    @Override
    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
        String id = element.getAttribute("id");
        if (!StringUtils.hasText(id)) {
            id = "jobRepository";
        }
        return id;
    }

    @Override
    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        CoreNamespaceUtils.autoregisterBeansForNamespace(parserContext, element);
        String dataSource = element.getAttribute("data-source");
        String jdbcOperations = element.getAttribute("jdbc-operations");
        String transactionManager = element.getAttribute("transaction-manager");
        String isolationLevelForCreate = element.getAttribute("isolation-level-for-create");
        String tablePrefix = element.getAttribute("table-prefix");
        String maxVarCharLength = element.getAttribute("max-varchar-length");
        String lobHandler = element.getAttribute("lob-handler");
        String serializer = element.getAttribute("serializer");
        RuntimeBeanReference ds = new RuntimeBeanReference(dataSource);
        builder.addPropertyValue("dataSource", ds);
        RuntimeBeanReference tx = new RuntimeBeanReference(transactionManager);
        builder.addPropertyValue("transactionManager", tx);
        if (StringUtils.hasText(jdbcOperations)) {
            builder.addPropertyReference("jdbcOperations", jdbcOperations);
        }
        if (StringUtils.hasText(isolationLevelForCreate)) {
            builder.addPropertyValue("isolationLevelForCreate", "ISOLATION_" + isolationLevelForCreate);
        }
        if (StringUtils.hasText(tablePrefix)) {
            builder.addPropertyValue("tablePrefix", tablePrefix);
        }
        if (StringUtils.hasText(lobHandler)) {
            builder.addPropertyReference("lobHandler", lobHandler);
        }
        if (StringUtils.hasText(maxVarCharLength)) {
            builder.addPropertyValue("maxVarCharLength", maxVarCharLength);
        }
        if (StringUtils.hasText(serializer)) {
            builder.addPropertyReference("serializer", serializer);
        }
        builder.setRole(1);
    }
}

