/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.configuration.support.ApplicationContextFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.CustomEditorConfigurer;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.beans.factory.support.AbstractBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public abstract class AbstractApplicationContextFactory
implements ApplicationContextFactory,
ApplicationContextAware {
    private static final Log logger = LogFactory.getLog(AbstractApplicationContextFactory.class);
    private Object[] resources;
    private ConfigurableApplicationContext parent;
    private boolean copyConfiguration = true;
    private Collection<Class<? extends BeanFactoryPostProcessor>> beanFactoryPostProcessorClasses;
    private Collection<Class<?>> beanPostProcessorExcludeClasses;

    public AbstractApplicationContextFactory(Object ... resource) {
        this.resources = resource;
        this.beanFactoryPostProcessorClasses = new ArrayList<Class<? extends BeanFactoryPostProcessor>>();
        this.beanFactoryPostProcessorClasses.add(PropertyPlaceholderConfigurer.class);
        this.beanFactoryPostProcessorClasses.add(PropertySourcesPlaceholderConfigurer.class);
        this.beanFactoryPostProcessorClasses.add(CustomEditorConfigurer.class);
        this.beanPostProcessorExcludeClasses = new ArrayList();
        this.beanPostProcessorExcludeClasses.add(BeanFactoryAware.class);
    }

    public void setCopyConfiguration(boolean copyConfiguration) {
        this.copyConfiguration = copyConfiguration;
    }

    protected final boolean isCopyConfiguration() {
        return this.copyConfiguration;
    }

    public void setBeanFactoryPostProcessorClasses(Class<? extends BeanFactoryPostProcessor>[] beanFactoryPostProcessorClasses) {
        this.beanFactoryPostProcessorClasses = new ArrayList<Class<? extends BeanFactoryPostProcessor>>();
        for (int i2 = 0; i2 < beanFactoryPostProcessorClasses.length; ++i2) {
            this.beanFactoryPostProcessorClasses.add(beanFactoryPostProcessorClasses[i2]);
        }
    }

    public void setBeanPostProcessorExcludeClasses(Class<?>[] beanPostProcessorExcludeClasses) {
        this.beanPostProcessorExcludeClasses = new ArrayList();
        for (int i2 = 0; i2 < beanPostProcessorExcludeClasses.length; ++i2) {
            this.beanPostProcessorExcludeClasses.add(beanPostProcessorExcludeClasses[i2]);
        }
    }

    protected final Collection<Class<? extends BeanFactoryPostProcessor>> getBeanFactoryPostProcessorClasses() {
        return this.beanFactoryPostProcessorClasses;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (applicationContext == null) {
            return;
        }
        Assert.isInstanceOf(ConfigurableApplicationContext.class, applicationContext);
        this.parent = (ConfigurableApplicationContext)applicationContext;
    }

    @Override
    public ConfigurableApplicationContext createApplicationContext() {
        if (this.resources == null || this.resources.length == 0) {
            return this.parent;
        }
        return this.createApplicationContext(this.parent, this.resources);
    }

    protected abstract ConfigurableApplicationContext createApplicationContext(ConfigurableApplicationContext var1, Object ... var2);

    protected void prepareContext(ConfigurableApplicationContext parent, ConfigurableApplicationContext context) {
    }

    protected void prepareBeanFactory(ConfigurableListableBeanFactory parent, ConfigurableListableBeanFactory beanFactory) {
        if (this.copyConfiguration && parent != null) {
            ArrayList parentPostProcessors = new ArrayList();
            ArrayList childPostProcessors = new ArrayList();
            childPostProcessors.addAll(beanFactory instanceof AbstractBeanFactory ? ((AbstractBeanFactory)((Object)beanFactory)).getBeanPostProcessors() : new ArrayList());
            parentPostProcessors.addAll(parent instanceof AbstractBeanFactory ? ((AbstractBeanFactory)((Object)parent)).getBeanPostProcessors() : new ArrayList());
            try {
                Class<?> applicationContextAwareProcessorClass = ClassUtils.forName("org.springframework.context.support.ApplicationContextAwareProcessor", parent.getBeanClassLoader());
                for (BeanPostProcessor beanPostProcessor : new ArrayList(parentPostProcessors)) {
                    if (!applicationContextAwareProcessorClass.isAssignableFrom(beanPostProcessor.getClass())) continue;
                    logger.debug("Removing parent ApplicationContextAwareProcessor");
                    parentPostProcessors.remove(beanPostProcessor);
                }
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
            ArrayList aggregatedPostProcessors = new ArrayList();
            aggregatedPostProcessors.addAll(childPostProcessors);
            aggregatedPostProcessors.addAll(parentPostProcessors);
            for (BeanPostProcessor beanPostProcessor : new ArrayList(aggregatedPostProcessors)) {
                for (Class<?> cls : this.beanPostProcessorExcludeClasses) {
                    if (!cls.isAssignableFrom(beanPostProcessor.getClass())) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug("Removing bean post processor: " + beanPostProcessor + " of type " + cls);
                    }
                    aggregatedPostProcessors.remove(beanPostProcessor);
                }
            }
            beanFactory.copyConfigurationFrom(parent);
            List<Object> beanPostProcessors = beanFactory instanceof AbstractBeanFactory ? ((AbstractBeanFactory)((Object)beanFactory)).getBeanPostProcessors() : new ArrayList();
            beanPostProcessors.clear();
            beanPostProcessors.addAll(aggregatedPostProcessors);
        }
    }

    public String toString() {
        return "ApplicationContextFactory [resources=" + Arrays.toString(this.resources) + "]";
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }
}

