/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.springframework.batch.core.JobKeyGenerator;
import org.springframework.batch.core.JobParameter;
import org.springframework.batch.core.JobParameters;
import org.springframework.util.Assert;

public class DefaultJobKeyGenerator
implements JobKeyGenerator<JobParameters> {
    @Override
    public String generateKey(JobParameters source) {
        MessageDigest digest;
        Assert.notNull((Object)source, "source must not be null");
        Map<String, JobParameter> props = source.getParameters();
        StringBuilder stringBuffer = new StringBuilder();
        ArrayList<String> keys2 = new ArrayList<String>(props.keySet());
        Collections.sort(keys2);
        for (String key : keys2) {
            JobParameter jobParameter = props.get(key);
            if (!jobParameter.isIdentifying()) continue;
            String value = jobParameter.getValue() == null ? "" : jobParameter.toString();
            stringBuffer.append(key).append("=").append(value).append(";");
        }
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("MD5 algorithm not available.  Fatal (should be in the JDK).");
        }
        try {
            byte[] bytes = digest.digest(stringBuffer.toString().getBytes("UTF-8"));
            return String.format("%032x", new BigInteger(1, bytes));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("UTF-8 encoding not available.  Fatal (should be in the JDK).");
        }
    }
}

