/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.utils.structuremap;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.r5.elementmodel.Property;
import org.hl7.fhir.r5.model.TypeDetails;
import org.hl7.fhir.r5.utils.structuremap.PropertyWithType;
import org.hl7.fhir.r5.utils.structuremap.StructureMapUtilities;
import org.hl7.fhir.r5.utils.structuremap.VariableForProfiling;
import org.hl7.fhir.r5.utils.structuremap.VariableMode;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;

public class VariablesForProfiling {
    private final StructureMapUtilities structureMapUtilities;
    private List<VariableForProfiling> list = new ArrayList<VariableForProfiling>();
    private boolean optional;
    private boolean repeating;

    public VariablesForProfiling(StructureMapUtilities structureMapUtilities, boolean optional, boolean repeating) {
        this.structureMapUtilities = structureMapUtilities;
        this.optional = optional;
        this.repeating = repeating;
    }

    public void add(VariableMode mode, String name, String path, Property property, TypeDetails types) {
        this.add(mode, name, new PropertyWithType(path, property, null, types));
    }

    public void add(VariableMode mode, String name, String path, Property baseProperty, Property profileProperty, TypeDetails types) {
        this.add(mode, name, new PropertyWithType(path, baseProperty, profileProperty, types));
    }

    public void add(VariableMode mode, String name, PropertyWithType property) {
        VariableForProfiling vv = null;
        for (VariableForProfiling v : this.list) {
            if (v.getMode() != mode || !v.getName().equals(name)) continue;
            vv = v;
        }
        if (vv != null) {
            this.list.remove(vv);
        }
        this.list.add(new VariableForProfiling(mode, name, property));
    }

    public VariablesForProfiling copy(boolean optional, boolean repeating) {
        VariablesForProfiling result = new VariablesForProfiling(this.structureMapUtilities, optional, repeating);
        result.list.addAll(this.list);
        return result;
    }

    public VariablesForProfiling copy() {
        VariablesForProfiling result = new VariablesForProfiling(this.structureMapUtilities, this.optional, this.repeating);
        result.list.addAll(this.list);
        return result;
    }

    public VariableForProfiling get(VariableMode mode, String name) {
        if (mode == null) {
            for (VariableForProfiling v : this.list) {
                if (v.getMode() != VariableMode.OUTPUT || !v.getName().equals(name)) continue;
                return v;
            }
            for (VariableForProfiling v : this.list) {
                if (v.getMode() != VariableMode.INPUT || !v.getName().equals(name)) continue;
                return v;
            }
        }
        for (VariableForProfiling v : this.list) {
            if (v.getMode() != mode || !v.getName().equals(name)) continue;
            return v;
        }
        return null;
    }

    public String summary() {
        CommaSeparatedStringBuilder s2 = new CommaSeparatedStringBuilder();
        CommaSeparatedStringBuilder t = new CommaSeparatedStringBuilder();
        for (VariableForProfiling v : this.list) {
            if (v.getMode() == VariableMode.INPUT) {
                s2.append(v.summary());
                continue;
            }
            t.append(v.summary());
        }
        return "source variables [" + s2.toString() + "], target variables [" + t.toString() + "]";
    }
}

