/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.utils;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.formats.JsonParser;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.utilities.Utilities;

public class Unbundler {
    public static void main(String[] args2) throws Exception {
        Unbundler.unbundle(args2[0]);
    }

    private static void unbundle(String src) throws FHIRFormatError, FileNotFoundException, IOException {
        String folder = Utilities.getDirectoryForFile(src);
        Bundle bnd = (Bundle)new JsonParser().parse(new FileInputStream(src));
        for (Bundle.BundleEntryComponent be : bnd.getEntry()) {
            Resource r = be.getResource();
            if (r == null) continue;
            String tgt = Utilities.path(folder, r.fhirType() + "-" + r.getId() + ".json");
            new JsonParser().compose(new FileOutputStream(tgt), r);
        }
    }
}

