/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Expression;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.Questionnaire;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.renderers.RendererFactory;
import org.hl7.fhir.r5.renderers.TerminologyRenderer;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.r5.terminologies.ValueSetExpander;
import org.hl7.fhir.r5.utils.ToolingExtensions;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.HierarchicalTableGenerator;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class QuestionnaireRenderer
extends TerminologyRenderer {
    public QuestionnaireRenderer(RenderingContext context) {
        super(context);
    }

    @Override
    public boolean render(XhtmlNode x, Resource q) throws UnsupportedEncodingException, IOException {
        return this.render(x, (Questionnaire)q);
    }

    public boolean render(XhtmlNode x, Questionnaire q) throws UnsupportedEncodingException, IOException {
        switch (this.context.getQuestionnaireMode()) {
            case FORM: {
                return this.renderForm(x, q);
            }
            case LINKS: {
                return this.renderLinks(x, q);
            }
            case LOGIC: {
                return this.renderLogic(x, q);
            }
            case DEFNS: {
                return this.renderDefns(x, q);
            }
            case TREE: {
                return this.renderTree(x, q);
            }
        }
        throw new Error("Unknown Questionnaire Renderer Mode");
    }

    public boolean renderTree(XhtmlNode x, Questionnaire q) throws UnsupportedEncodingException, IOException {
        HierarchicalTableGenerator gen;
        boolean hasFlags = this.checkForFlags(q.getItem());
        HierarchicalTableGenerator hierarchicalTableGenerator = gen = new HierarchicalTableGenerator(this.context.getDestDir(), this.context.isInlineGraphics(), true);
        hierarchicalTableGenerator.getClass();
        HierarchicalTableGenerator.TableModel model = new HierarchicalTableGenerator.TableModel(hierarchicalTableGenerator, "qtree=" + q.getId(), !this.forResource);
        model.setAlternating(true);
        model.setDocoImg(this.context.getSpecificationLink() + "help16.png");
        model.setDocoRef(this.context.getSpecificationLink() + "formats.html#table");
        List<HierarchicalTableGenerator.Title> list = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
        hierarchicalTableGenerator2.getClass();
        list.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator2, null, model.getDocoRef(), this.translate("sd.head", "LinkId"), this.translate("sd.hint", "The linkId for the item"), null, 0));
        List<HierarchicalTableGenerator.Title> list2 = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
        hierarchicalTableGenerator3.getClass();
        list2.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator3, null, model.getDocoRef(), this.translate("sd.head", "Text"), this.translate("sd.hint", "Text for the item"), null, 0));
        List<HierarchicalTableGenerator.Title> list3 = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
        hierarchicalTableGenerator4.getClass();
        list3.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator4, null, model.getDocoRef(), this.translate("sd.head", "Cardinality"), this.translate("sd.hint", "Minimum and Maximum # of times the the itemcan appear in the instance"), null, 0));
        List<HierarchicalTableGenerator.Title> list4 = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator5 = gen;
        hierarchicalTableGenerator5.getClass();
        list4.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator5, null, model.getDocoRef(), this.translate("sd.head", "Type"), this.translate("sd.hint", "The type of the item"), null, 0));
        if (hasFlags) {
            List<HierarchicalTableGenerator.Title> list5 = model.getTitles();
            HierarchicalTableGenerator hierarchicalTableGenerator6 = gen;
            hierarchicalTableGenerator6.getClass();
            list5.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator6, null, model.getDocoRef(), this.translate("sd.head", "Flags"), this.translate("sd.hint", "Other attributes of the item"), null, 0));
        }
        List<HierarchicalTableGenerator.Title> list6 = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator7 = gen;
        hierarchicalTableGenerator7.getClass();
        list6.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator7, null, model.getDocoRef(), this.translate("sd.head", "Description & Constraints"), this.translate("sd.hint", "Additional information about the item"), null, 0));
        boolean hasExt = false;
        HierarchicalTableGenerator.Row row = this.addTreeRoot(gen, model.getRows(), q, hasFlags);
        for (Questionnaire.QuestionnaireItemComponent i2 : q.getItem()) {
            hasExt = this.renderTreeItem(gen, row.getSubRows(), q, i2, hasFlags) || hasExt;
        }
        XhtmlNode xn = gen.generate(model, this.context.getLocalPrefix(), 1, null);
        x.getChildNodes().add(xn);
        return hasExt;
    }

    private boolean checkForFlags(List<Questionnaire.QuestionnaireItemComponent> items) {
        for (Questionnaire.QuestionnaireItemComponent i2 : items) {
            if (!this.checkForFlags(i2)) continue;
            return true;
        }
        return false;
    }

    private boolean checkForFlags(Questionnaire.QuestionnaireItemComponent i2) {
        if (i2.getReadOnly()) {
            return true;
        }
        if (ToolingExtensions.readBoolExtension(i2, "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-isSubject")) {
            return true;
        }
        if (ToolingExtensions.readBoolExtension(i2, "http://hl7.org/fhir/StructureDefinition/questionnaire-hidden")) {
            return true;
        }
        if (ToolingExtensions.readBoolExtension(i2, "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-optionalDisplay")) {
            return true;
        }
        if (i2.hasExtension("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-observationLinkPeriod")) {
            return true;
        }
        if (i2.hasExtension("http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation")) {
            return true;
        }
        if (i2.hasExtension("http://hl7.org/fhir/StructureDefinition/questionnaire-displayCategory")) {
            return true;
        }
        return this.checkForFlags(i2.getItem());
    }

    private HierarchicalTableGenerator.Row addTreeRoot(HierarchicalTableGenerator gen, List<HierarchicalTableGenerator.Row> rows, Questionnaire q, boolean hasFlags) throws IOException {
        HierarchicalTableGenerator.Row r = new HierarchicalTableGenerator.Row(gen);
        rows.add(r);
        r.setIcon("icon_q_root.gif", "QuestionnaireRoot");
        List<HierarchicalTableGenerator.Cell> list = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        hierarchicalTableGenerator.getClass();
        list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, q.getName(), null, null));
        List<HierarchicalTableGenerator.Cell> list2 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
        hierarchicalTableGenerator2.getClass();
        list2.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator2, null, null, "", null, null));
        List<HierarchicalTableGenerator.Cell> list3 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
        hierarchicalTableGenerator3.getClass();
        list3.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator3, null, null, "", null, null));
        List<HierarchicalTableGenerator.Cell> list4 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
        hierarchicalTableGenerator4.getClass();
        list4.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator4, null, null, "Questionnaire", null, null));
        if (hasFlags) {
            List<HierarchicalTableGenerator.Cell> list5 = r.getCells();
            HierarchicalTableGenerator hierarchicalTableGenerator5 = gen;
            hierarchicalTableGenerator5.getClass();
            list5.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator5, null, null, "", null, null));
        }
        List<HierarchicalTableGenerator.Cell> list6 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator6 = gen;
        hierarchicalTableGenerator6.getClass();
        list6.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator6, null, null, q.getDescription(), null, null));
        return r;
    }

    private boolean renderTreeItem(HierarchicalTableGenerator gen, List<HierarchicalTableGenerator.Row> rows, Questionnaire q, Questionnaire.QuestionnaireItemComponent i2, boolean hasFlags) throws IOException {
        HierarchicalTableGenerator.Piece p;
        HierarchicalTableGenerator.Row r = new HierarchicalTableGenerator.Row(gen);
        rows.add(r);
        boolean hasExt = false;
        r.setIcon("icon-q-" + i2.getType().toCode().toLowerCase() + ".png", i2.getType().getDisplay());
        List<HierarchicalTableGenerator.Cell> list = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        hierarchicalTableGenerator.getClass();
        list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, this.context.getDefinitionsTarget() == null ? "" : this.context.getDefinitionsTarget() + "#item." + i2.getLinkId(), i2.getLinkId(), null, null));
        String txt = (i2.hasPrefix() ? i2.getPrefix() + ". " : "") + i2.getText();
        List<HierarchicalTableGenerator.Cell> list2 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
        hierarchicalTableGenerator2.getClass();
        list2.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator2, null, null, txt, null, null));
        List<HierarchicalTableGenerator.Cell> list3 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
        hierarchicalTableGenerator3.getClass();
        list3.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator3, null, null, (i2.getRequired() ? "1" : "0") + ".." + (i2.getRepeats() ? "*" : "1"), null, null));
        List<HierarchicalTableGenerator.Cell> list4 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
        hierarchicalTableGenerator4.getClass();
        list4.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator4, null, this.context.getSpecificationLink() + "codesystem-item-type.html#" + i2.getType().toCode(), i2.getType().toCode(), null, null));
        if (hasFlags) {
            HierarchicalTableGenerator.Cell flags = new HierarchicalTableGenerator.Cell(gen);
            r.getCells().add(flags);
            if (i2.getReadOnly()) {
                HierarchicalTableGenerator hierarchicalTableGenerator5 = gen;
                hierarchicalTableGenerator5.getClass();
                flags.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator5, Utilities.pathURL(this.context.getSpecificationLink(), "questionnaire-definitions.html#Questionnaire.item.readOnly"), null, "Is Readonly").addHtml(new XhtmlNode(NodeType.Element, "img").attribute("src", Utilities.path(this.context.getLocalPrefix(), "icon-qi-readonly.png"))));
            }
            if (ToolingExtensions.readBoolExtension(i2, "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-isSubject")) {
                HierarchicalTableGenerator hierarchicalTableGenerator6 = gen;
                hierarchicalTableGenerator6.getClass();
                flags.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator6, "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-isSubject", null, "Can change the subject of the questionnaire").addHtml(new XhtmlNode(NodeType.Element, "img").attribute("src", Utilities.path(this.context.getLocalPrefix(), "icon-qi-subject.png"))));
            }
            if (ToolingExtensions.readBoolExtension(i2, "http://hl7.org/fhir/StructureDefinition/questionnaire-hidden")) {
                HierarchicalTableGenerator hierarchicalTableGenerator7 = gen;
                hierarchicalTableGenerator7.getClass();
                flags.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator7, Utilities.pathURL(this.context.getSpecificationLink(), "extension-questionnaire-hidden.html"), null, "Is a hidden item").addHtml(new XhtmlNode(NodeType.Element, "img").attribute("src", Utilities.path(this.context.getLocalPrefix(), "icon-qi-hidden.png"))));
            }
            if (ToolingExtensions.readBoolExtension(i2, "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-optionalDisplay")) {
                HierarchicalTableGenerator hierarchicalTableGenerator8 = gen;
                hierarchicalTableGenerator8.getClass();
                flags.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator8, "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-optionalDisplay", null, "Is optional to display").addHtml(new XhtmlNode(NodeType.Element, "img").attribute("src", Utilities.path(this.context.getLocalPrefix(), "icon-qi-optional.png"))));
            }
            if (i2.hasExtension("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-observationLinkPeriod")) {
                HierarchicalTableGenerator hierarchicalTableGenerator9 = gen;
                hierarchicalTableGenerator9.getClass();
                flags.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator9, "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-observationLinkPeriod", null, "Is linked to an observation").addHtml(new XhtmlNode(NodeType.Element, "img").attribute("src", Utilities.path(this.context.getLocalPrefix(), "icon-qi-observation.png"))));
            }
            if (i2.hasExtension("http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation")) {
                String code = ToolingExtensions.readStringExtension(i2, "http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation");
                HierarchicalTableGenerator hierarchicalTableGenerator10 = gen;
                hierarchicalTableGenerator10.getClass();
                flags.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator10, "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-observationLinkPeriod", null, "Orientation: " + code).addHtml(new XhtmlNode(NodeType.Element, "img").attribute("src", Utilities.path(this.context.getLocalPrefix(), "icon-qi-" + code + ".png"))));
            }
            if (i2.hasExtension("http://hl7.org/fhir/StructureDefinition/questionnaire-displayCategory")) {
                CodeableConcept cc = i2.getExtensionByUrl("http://hl7.org/fhir/StructureDefinition/questionnaire-displayCategory").getValueCodeableConcept();
                String string = cc.getCode("http://hl7.org/fhir/questionnaire-display-category");
                HierarchicalTableGenerator hierarchicalTableGenerator11 = gen;
                hierarchicalTableGenerator11.getClass();
                flags.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator11, "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-displayCategory", null, "Category: " + string).addHtml(new XhtmlNode(NodeType.Element, "img").attribute("src", Utilities.path(this.context.getLocalPrefix(), "icon-qi-" + string + ".png"))));
            }
        }
        HierarchicalTableGenerator.Cell defn = new HierarchicalTableGenerator.Cell(gen);
        r.getCells().add(defn);
        if (i2.hasMaxLength()) {
            List<HierarchicalTableGenerator.Piece> list5 = defn.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator12 = gen;
            hierarchicalTableGenerator12.getClass();
            list5.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator12, null, "Max Length: ", null));
            List<HierarchicalTableGenerator.Piece> list6 = defn.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator13 = gen;
            hierarchicalTableGenerator13.getClass();
            list6.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator13, null, Integer.toString(i2.getMaxLength()), null));
        }
        if (i2.hasDefinition()) {
            if (!defn.getPieces().isEmpty()) {
                HierarchicalTableGenerator hierarchicalTableGenerator14 = gen;
                hierarchicalTableGenerator14.getClass();
                defn.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator14, "br"));
            }
            List<HierarchicalTableGenerator.Piece> list7 = defn.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator15 = gen;
            hierarchicalTableGenerator15.getClass();
            list7.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator15, null, "Definition: ", null));
            this.genDefinitionLink(gen, i2, defn);
        }
        if (i2.hasEnableWhen()) {
            if (!defn.getPieces().isEmpty()) {
                HierarchicalTableGenerator hierarchicalTableGenerator16 = gen;
                hierarchicalTableGenerator16.getClass();
                defn.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator16, "br"));
            }
            HierarchicalTableGenerator hierarchicalTableGenerator17 = gen;
            hierarchicalTableGenerator17.getClass();
            p = new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator17, null, "Enable When: ", null);
            defn.getPieces().add(p);
            if (i2.getEnableWhen().size() == 0) {
                XhtmlNode xhtmlNode = new XhtmlNode(NodeType.Element, "span");
                p.getChildren().add(xhtmlNode);
                this.renderEnableWhen(xhtmlNode, i2.getEnableWhenFirstRep());
            } else {
                XhtmlNode xhtmlNode = new XhtmlNode(NodeType.Element, "ul");
                p.getChildren().add(xhtmlNode);
                for (Questionnaire.QuestionnaireItemEnableWhenComponent qi : i2.getEnableWhen()) {
                    this.renderEnableWhen(xhtmlNode.li(), qi);
                }
            }
        }
        if (i2.hasAnswerValueSet()) {
            Object vs;
            if (!defn.getPieces().isEmpty()) {
                HierarchicalTableGenerator hierarchicalTableGenerator18 = gen;
                hierarchicalTableGenerator18.getClass();
                defn.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator18, "br"));
            }
            List<HierarchicalTableGenerator.Piece> list8 = defn.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator19 = gen;
            hierarchicalTableGenerator19.getClass();
            list8.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator19, null, "Value Set: ", null));
            if (i2.getAnswerValueSet().startsWith("#")) {
                vs = (ValueSet)q.getContained(i2.getAnswerValueSet().substring(1));
                if (vs == null) {
                    List<HierarchicalTableGenerator.Piece> list9 = defn.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator20 = gen;
                    hierarchicalTableGenerator20.getClass();
                    list9.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator20, null, i2.getAnswerValueSet(), null));
                } else {
                    List<HierarchicalTableGenerator.Piece> list10 = defn.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator21 = gen;
                    hierarchicalTableGenerator21.getClass();
                    list10.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator21, ((Base)vs).getUserString("path"), ((CanonicalResource)vs).present(), null));
                }
            } else {
                vs = this.context.getWorker().fetchResource(ValueSet.class, i2.getAnswerValueSet());
                if (vs == null || !((Base)vs).hasUserData("path")) {
                    List<HierarchicalTableGenerator.Piece> list11 = defn.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator22 = gen;
                    hierarchicalTableGenerator22.getClass();
                    list11.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator22, null, i2.getAnswerValueSet(), null));
                } else {
                    List<HierarchicalTableGenerator.Piece> list12 = defn.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator23 = gen;
                    hierarchicalTableGenerator23.getClass();
                    list12.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator23, ((Base)vs).getUserString("path"), ((CanonicalResource)vs).present(), null));
                }
            }
        }
        if (i2.hasAnswerOption()) {
            if (!defn.getPieces().isEmpty()) {
                HierarchicalTableGenerator hierarchicalTableGenerator24 = gen;
                hierarchicalTableGenerator24.getClass();
                defn.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator24, "br"));
            }
            List<HierarchicalTableGenerator.Piece> list13 = defn.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator25 = gen;
            hierarchicalTableGenerator25.getClass();
            list13.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator25, null, "Options: ", null));
            List<HierarchicalTableGenerator.Piece> list14 = defn.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator26 = gen;
            hierarchicalTableGenerator26.getClass();
            list14.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator26, this.context.getDefinitionsTarget() + "#item." + i2.getLinkId(), Integer.toString(i2.getAnswerOption().size()) + " " + Utilities.pluralize("option", i2.getAnswerOption().size()), null));
        }
        if (i2.hasInitial()) {
            for (Questionnaire.QuestionnaireItemInitialComponent questionnaireItemInitialComponent : i2.getInitial()) {
                if (!defn.getPieces().isEmpty()) {
                    HierarchicalTableGenerator hierarchicalTableGenerator27 = gen;
                    hierarchicalTableGenerator27.getClass();
                    defn.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator27, "br"));
                }
                List<HierarchicalTableGenerator.Piece> list15 = defn.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator28 = gen;
                hierarchicalTableGenerator28.getClass();
                list15.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator28, null, "Initial Value: ", null));
                List<HierarchicalTableGenerator.Piece> list16 = defn.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator29 = gen;
                hierarchicalTableGenerator29.getClass();
                list16.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator29, null, questionnaireItemInitialComponent.getValue().fhirType(), null));
                List<HierarchicalTableGenerator.Piece> list17 = defn.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator30 = gen;
                hierarchicalTableGenerator30.getClass();
                list17.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator30, null, " = ", null));
                if (questionnaireItemInitialComponent.getValue().isPrimitive()) {
                    List<HierarchicalTableGenerator.Piece> list18 = defn.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator31 = gen;
                    hierarchicalTableGenerator31.getClass();
                    list18.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator31, null, questionnaireItemInitialComponent.getValue().primitiveValue(), null));
                    continue;
                }
                List<HierarchicalTableGenerator.Piece> list19 = defn.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator32 = gen;
                hierarchicalTableGenerator32.getClass();
                list19.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator32, null, "{todo}", null));
            }
        }
        if (i2.hasExtension("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression") || i2.hasExtension("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-itemContext") || i2.hasExtension("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression") || i2.hasExtension("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-contextExpression") || i2.hasExtension("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-candidateExpression") || i2.hasExtension("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression")) {
            if (!defn.getPieces().isEmpty()) {
                HierarchicalTableGenerator hierarchicalTableGenerator33 = gen;
                hierarchicalTableGenerator33.getClass();
                defn.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator33, "br"));
            }
            List<HierarchicalTableGenerator.Piece> list20 = defn.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator34 = gen;
            hierarchicalTableGenerator34.getClass();
            list20.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator34, null, "Expressions: ", null));
            HierarchicalTableGenerator hierarchicalTableGenerator35 = gen;
            hierarchicalTableGenerator35.getClass();
            p = new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator35, "ul");
            defn.getPieces().add(p);
            for (Extension e : i2.getExtensionsByUrl("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression")) {
                this.addExpression(p, e.getValueExpression(), "Initial Value", "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression");
            }
            for (Extension e : i2.getExtensionsByUrl("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-contextExpression")) {
                this.addExpression(p, e.getValueExpression(), "Context", "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-contextExpression");
            }
            for (Extension e : i2.getExtensionsByUrl("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-itemContext")) {
                this.addExpression(p, e.getValueExpression(), "Item Context", "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-itemContext");
            }
            for (Extension e : i2.getExtensionsByUrl("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression")) {
                this.addExpression(p, e.getValueExpression(), "Enable When", "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression");
            }
            for (Extension e : i2.getExtensionsByUrl("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression")) {
                this.addExpression(p, e.getValueExpression(), "Calculated Value", "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression");
            }
            for (Extension e : i2.getExtensionsByUrl("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-candidateExpression")) {
                this.addExpression(p, e.getValueExpression(), "Candidates", "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-candidateExpression");
            }
        }
        for (Questionnaire.QuestionnaireItemComponent questionnaireItemComponent : i2.getItem()) {
            hasExt = this.renderTreeItem(gen, r.getSubRows(), q, questionnaireItemComponent, hasFlags) || hasExt;
        }
        return hasExt;
    }

    public void genDefinitionLink(HierarchicalTableGenerator gen, Questionnaire.QuestionnaireItemComponent i2, HierarchicalTableGenerator.Cell defn) {
        StructureDefinition sd;
        String path = null;
        String d = i2.getDefinition();
        if (d.contains("#")) {
            path = d.substring(d.indexOf("#") + 1);
            d = d.substring(0, d.indexOf("#"));
        }
        if ((sd = this.context.getWorker().fetchResource(StructureDefinition.class, d)) != null) {
            String url = sd.getUserString("path");
            if (url != null) {
                List<HierarchicalTableGenerator.Piece> list = defn.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                hierarchicalTableGenerator.getClass();
                list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, url + "#" + path, path, null));
            } else {
                List<HierarchicalTableGenerator.Piece> list = defn.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                hierarchicalTableGenerator.getClass();
                list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, i2.getDefinition(), null));
            }
        } else {
            List<HierarchicalTableGenerator.Piece> list = defn.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
            hierarchicalTableGenerator.getClass();
            list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, i2.getDefinition(), null));
        }
    }

    public void genDefinitionLink(XhtmlNode x, Questionnaire.QuestionnaireItemComponent i2) {
        StructureDefinition sd;
        String path = null;
        String d = i2.getDefinition();
        if (d.contains("#")) {
            path = d.substring(d.indexOf("#") + 1);
            d = d.substring(0, d.indexOf("#"));
        }
        if ((sd = this.context.getWorker().fetchResource(StructureDefinition.class, d)) != null) {
            String url = sd.getUserString("path");
            if (url != null) {
                x.ah(url + "#" + path).tx(path);
            } else {
                x.tx(i2.getDefinition());
            }
        } else {
            x.tx(i2.getDefinition());
        }
    }

    private void addExpression(HierarchicalTableGenerator.Piece p, Expression exp, String label, String url) {
        XhtmlNode x = new XhtmlNode(NodeType.Element, "li").style("font-size: 11px");
        p.addHtml(x);
        x.ah(url).tx(label);
        x.tx(": ");
        x.code(exp.getExpression());
    }

    private boolean renderLogic(XhtmlNode x, Questionnaire q) throws FHIRException, IOException {
        HierarchicalTableGenerator gen;
        HierarchicalTableGenerator hierarchicalTableGenerator = gen = new HierarchicalTableGenerator(this.context.getDestDir(), this.context.isInlineGraphics(), true);
        hierarchicalTableGenerator.getClass();
        HierarchicalTableGenerator.TableModel model = new HierarchicalTableGenerator.TableModel(hierarchicalTableGenerator, "qtree=" + q.getId(), true);
        model.setAlternating(true);
        model.setDocoImg(this.context.getSpecificationLink() + "help16.png");
        model.setDocoRef(this.context.getSpecificationLink() + "formats.html#table");
        List<HierarchicalTableGenerator.Title> list = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
        hierarchicalTableGenerator2.getClass();
        list.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator2, null, model.getDocoRef(), this.translate("sd.head", "LinkId"), this.translate("sd.hint", "The linkId for the item"), null, 0));
        List<HierarchicalTableGenerator.Title> list2 = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
        hierarchicalTableGenerator3.getClass();
        list2.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator3, null, model.getDocoRef(), this.translate("sd.head", "Description & Constraints"), this.translate("sd.hint", "Additional information about the item"), null, 0));
        boolean hasExt = false;
        if (!q.hasItem()) {
            gen.emptyRow(model, 2);
        } else {
            for (Questionnaire.QuestionnaireItemComponent i2 : q.getItem()) {
                hasExt = this.renderLogicItem(gen, model.getRows(), q, i2) || hasExt;
            }
        }
        XhtmlNode xn = gen.generate(model, this.context.getLocalPrefix(), 1, null);
        x.getChildNodes().add(xn);
        return hasExt;
    }

    private boolean renderLogicItem(HierarchicalTableGenerator gen, List<HierarchicalTableGenerator.Row> rows, Questionnaire q, Questionnaire.QuestionnaireItemComponent i2) throws IOException {
        HierarchicalTableGenerator.Row r = new HierarchicalTableGenerator.Row(gen);
        rows.add(r);
        boolean hasExt = false;
        r.setIcon("icon-q-" + i2.getType().toCode().toLowerCase() + ".png", i2.getType().getDisplay());
        List<HierarchicalTableGenerator.Cell> list = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        hierarchicalTableGenerator.getClass();
        list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, this.context.getDefinitionsTarget() == null ? "" : this.context.getDefinitionsTarget() + "#item." + i2.getLinkId(), i2.getLinkId(), null, null));
        HierarchicalTableGenerator.Cell defn = new HierarchicalTableGenerator.Cell(gen);
        r.getCells().add(defn);
        if (i2.hasMaxLength()) {
            List<HierarchicalTableGenerator.Piece> list2 = defn.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
            hierarchicalTableGenerator2.getClass();
            list2.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator2, null, "Max Length: ", null));
            List<HierarchicalTableGenerator.Piece> list3 = defn.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
            hierarchicalTableGenerator3.getClass();
            list3.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator3, null, Integer.toString(i2.getMaxLength()), null));
        }
        if (i2.hasDefinition()) {
            if (!defn.getPieces().isEmpty()) {
                HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
                hierarchicalTableGenerator4.getClass();
                defn.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator4, "br"));
            }
            List<HierarchicalTableGenerator.Piece> list4 = defn.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator5 = gen;
            hierarchicalTableGenerator5.getClass();
            list4.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator5, null, "Definition: ", null));
            this.genDefinitionLink(gen, i2, defn);
        }
        if (i2.hasEnableWhen()) {
            if (!defn.getPieces().isEmpty()) {
                HierarchicalTableGenerator hierarchicalTableGenerator6 = gen;
                hierarchicalTableGenerator6.getClass();
                defn.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator6, "br"));
            }
            List<HierarchicalTableGenerator.Piece> list5 = defn.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator7 = gen;
            hierarchicalTableGenerator7.getClass();
            list5.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator7, null, "Enable When: ", null));
            List<HierarchicalTableGenerator.Piece> list6 = defn.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator8 = gen;
            hierarchicalTableGenerator8.getClass();
            list6.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator8, null, "todo", null));
        }
        if (i2.hasAnswerValueSet()) {
            Object vs;
            if (!defn.getPieces().isEmpty()) {
                HierarchicalTableGenerator hierarchicalTableGenerator9 = gen;
                hierarchicalTableGenerator9.getClass();
                defn.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator9, "br"));
            }
            List<HierarchicalTableGenerator.Piece> list7 = defn.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator10 = gen;
            hierarchicalTableGenerator10.getClass();
            list7.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator10, null, "Value Set: ", null));
            if (i2.getAnswerValueSet().startsWith("#")) {
                vs = (ValueSet)q.getContained(i2.getAnswerValueSet().substring(1));
                if (vs == null) {
                    List<HierarchicalTableGenerator.Piece> list8 = defn.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator11 = gen;
                    hierarchicalTableGenerator11.getClass();
                    list8.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator11, null, i2.getAnswerValueSet(), null));
                } else {
                    List<HierarchicalTableGenerator.Piece> list9 = defn.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator12 = gen;
                    hierarchicalTableGenerator12.getClass();
                    list9.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator12, ((Base)vs).getUserString("path"), ((CanonicalResource)vs).present(), null));
                }
            } else {
                vs = this.context.getWorker().fetchResource(ValueSet.class, i2.getAnswerValueSet());
                if (vs == null || !((Base)vs).hasUserData("path")) {
                    List<HierarchicalTableGenerator.Piece> list10 = defn.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator13 = gen;
                    hierarchicalTableGenerator13.getClass();
                    list10.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator13, null, i2.getAnswerValueSet(), null));
                } else {
                    List<HierarchicalTableGenerator.Piece> list11 = defn.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator14 = gen;
                    hierarchicalTableGenerator14.getClass();
                    list11.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator14, ((Base)vs).getUserString("path"), ((CanonicalResource)vs).present(), null));
                }
            }
        }
        if (i2.hasAnswerOption()) {
            if (!defn.getPieces().isEmpty()) {
                HierarchicalTableGenerator hierarchicalTableGenerator15 = gen;
                hierarchicalTableGenerator15.getClass();
                defn.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator15, "br"));
            }
            List<HierarchicalTableGenerator.Piece> list12 = defn.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator16 = gen;
            hierarchicalTableGenerator16.getClass();
            list12.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator16, null, "Options: ", null));
            List<HierarchicalTableGenerator.Piece> list13 = defn.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator17 = gen;
            hierarchicalTableGenerator17.getClass();
            list13.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator17, this.context.getDefinitionsTarget() + "#item." + i2.getLinkId(), Integer.toString(i2.getAnswerOption().size()) + " " + Utilities.pluralize("option", i2.getAnswerOption().size()), null));
        }
        if (i2.hasInitial()) {
            for (Questionnaire.QuestionnaireItemInitialComponent questionnaireItemInitialComponent : i2.getInitial()) {
                if (!defn.getPieces().isEmpty()) {
                    HierarchicalTableGenerator hierarchicalTableGenerator18 = gen;
                    hierarchicalTableGenerator18.getClass();
                    defn.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator18, "br"));
                }
                List<HierarchicalTableGenerator.Piece> list14 = defn.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator19 = gen;
                hierarchicalTableGenerator19.getClass();
                list14.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator19, null, "Initial Value: ", null));
                List<HierarchicalTableGenerator.Piece> list15 = defn.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator20 = gen;
                hierarchicalTableGenerator20.getClass();
                list15.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator20, null, questionnaireItemInitialComponent.getValue().fhirType(), null));
                List<HierarchicalTableGenerator.Piece> list16 = defn.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator21 = gen;
                hierarchicalTableGenerator21.getClass();
                list16.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator21, null, " = ", null));
                if (questionnaireItemInitialComponent.getValue().isPrimitive()) {
                    List<HierarchicalTableGenerator.Piece> list17 = defn.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator22 = gen;
                    hierarchicalTableGenerator22.getClass();
                    list17.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator22, null, questionnaireItemInitialComponent.getValue().primitiveValue(), null));
                    continue;
                }
                List<HierarchicalTableGenerator.Piece> list18 = defn.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator23 = gen;
                hierarchicalTableGenerator23.getClass();
                list18.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator23, null, "{todo}", null));
            }
        }
        if (i2.hasExtension("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression") || i2.hasExtension("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-itemContext") || i2.hasExtension("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression") || i2.hasExtension("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-contextExpression") || i2.hasExtension("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-candidateExpression") || i2.hasExtension("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression")) {
            if (!defn.getPieces().isEmpty()) {
                HierarchicalTableGenerator hierarchicalTableGenerator24 = gen;
                hierarchicalTableGenerator24.getClass();
                defn.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator24, "br"));
            }
            List<HierarchicalTableGenerator.Piece> list19 = defn.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator25 = gen;
            hierarchicalTableGenerator25.getClass();
            list19.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator25, null, "Expressions: ", null));
            HierarchicalTableGenerator hierarchicalTableGenerator26 = gen;
            hierarchicalTableGenerator26.getClass();
            HierarchicalTableGenerator.Piece p = new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator26, "ul");
            defn.getPieces().add(p);
            for (Extension e : i2.getExtensionsByUrl("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression")) {
                this.addExpression(p, e.getValueExpression(), "Initial Value", "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression");
            }
            for (Extension e : i2.getExtensionsByUrl("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-contextExpression")) {
                this.addExpression(p, e.getValueExpression(), "Context", "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-contextExpression");
            }
            for (Extension e : i2.getExtensionsByUrl("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-itemContext")) {
                this.addExpression(p, e.getValueExpression(), "Item Context", "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-itemContext");
            }
            for (Extension e : i2.getExtensionsByUrl("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression")) {
                this.addExpression(p, e.getValueExpression(), "Enable When", "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression");
            }
            for (Extension e : i2.getExtensionsByUrl("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression")) {
                this.addExpression(p, e.getValueExpression(), "Calculated Value", "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression");
            }
            for (Extension e : i2.getExtensionsByUrl("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-candidateExpression")) {
                this.addExpression(p, e.getValueExpression(), "Candidates", "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-candidateExpression");
            }
        }
        for (Questionnaire.QuestionnaireItemComponent questionnaireItemComponent : i2.getItem()) {
            hasExt = this.renderLogicItem(gen, r.getSubRows(), q, questionnaireItemComponent) || hasExt;
        }
        return hasExt;
    }

    public boolean renderForm(XhtmlNode x, Questionnaire q) throws UnsupportedEncodingException, IOException {
        boolean hasExt = false;
        XhtmlNode d = x.div();
        boolean hasPrefix = false;
        for (Questionnaire.QuestionnaireItemComponent c : q.getItem()) {
            hasPrefix = hasPrefix || this.doesItemHavePrefix(c);
        }
        int i2 = 1;
        for (Questionnaire.QuestionnaireItemComponent c : q.getItem()) {
            hasExt = this.renderFormItem(d, q, c, hasPrefix ? null : Integer.toString(i2), 0) || hasExt;
            ++i2;
        }
        return hasExt;
    }

    private boolean doesItemHavePrefix(Questionnaire.QuestionnaireItemComponent i2) {
        if (i2.hasPrefix()) {
            return true;
        }
        for (Questionnaire.QuestionnaireItemComponent c : i2.getItem()) {
            if (!this.doesItemHavePrefix(c)) continue;
            return true;
        }
        return false;
    }

    private boolean renderFormItem(XhtmlNode x, Questionnaire q, Questionnaire.QuestionnaireItemComponent i2, String pfx, int indent) throws IOException {
        boolean hasExt = false;
        XhtmlNode d = x.div().style("width: " + Integer.toString(900 - indent * 10) + "px; border-top: 1px #eeeeee solid");
        if (indent > 0) {
            d.style("margin-left: " + Integer.toString(10 * indent) + "px");
        }
        XhtmlNode display = d.div().style("display: inline-block; width: " + Integer.toString(500 - indent * 10) + "px");
        XhtmlNode details = d.div().style("border: 1px #ccccff solid; padding: 2px; display: inline-block; background-color: #fefce7; width: 380px");
        XhtmlNode p = display.para();
        if (i2.getType() == Questionnaire.QuestionnaireItemType.GROUP) {
            p = p.b();
        }
        if (i2.hasPrefix()) {
            p.tx(i2.getPrefix());
            p.tx(": ");
        }
        p.span(null, "linkId: " + i2.getLinkId()).tx(i2.getText());
        if (i2.getRequired()) {
            p.span("color: red", "Mandatory").tx("*");
        }
        XhtmlNode input = null;
        switch (i2.getType()) {
            case STRING: {
                p.tx(" ");
                input = p.input(i2.getLinkId(), "text", i2.getType().getDisplay(), 60);
                break;
            }
            case ATTACHMENT: {
                break;
            }
            case BOOLEAN: {
                p.tx(" ");
                input = p.input(i2.getLinkId(), "checkbox", i2.getType().getDisplay(), 1);
                break;
            }
            case CODING: {
                input = p.select(i2.getLinkId());
                this.listOptions(q, i2, input);
                break;
            }
            case DATE: {
                p.tx(" ");
                input = p.input(i2.getLinkId(), "date", i2.getType().getDisplay(), 10);
                break;
            }
            case DATETIME: {
                p.tx(" ");
                input = p.input(i2.getLinkId(), "datetime-local", i2.getType().getDisplay(), 25);
                break;
            }
            case DECIMAL: {
                p.tx(" ");
                input = p.input(i2.getLinkId(), "number", i2.getType().getDisplay(), 15);
                break;
            }
            case DISPLAY: {
                break;
            }
            case GROUP: {
                break;
            }
            case INTEGER: {
                p.tx(" ");
                input = p.input(i2.getLinkId(), "number", i2.getType().getDisplay(), 10);
                break;
            }
            case QUANTITY: {
                p.tx(" ");
                input = p.input(i2.getLinkId(), "number", "value", 15);
                p.tx(" ");
                input = p.input(i2.getLinkId(), "unit", "unit", 10);
                break;
            }
            case QUESTION: {
                break;
            }
            case REFERENCE: {
                break;
            }
            case TEXT: {
                break;
            }
            case TIME: {
                break;
            }
            case URL: {
                break;
            }
        }
        if (input != null && i2.getReadOnly()) {
            input.attribute("readonly", "1");
            input.style("background-color: #eeeeee");
        }
        XhtmlNode ul = details.ul();
        boolean hasFlag = false;
        XhtmlNode flags = this.item(ul, "Flags");
        this.item(ul, "linkId", i2.getLinkId());
        if (ToolingExtensions.readBoolExtension(i2, "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-isSubject")) {
            hasFlag = true;
            flags.ah("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-isSubject", "Can change the subject of the questionnaire").img(Utilities.path(this.context.getLocalPrefix(), "icon-qi-subject.png"));
        }
        if (ToolingExtensions.readBoolExtension(i2, "http://hl7.org/fhir/StructureDefinition/questionnaire-hidden")) {
            hasFlag = true;
            flags.ah(Utilities.pathURL(this.context.getSpecificationLink(), "extension-questionnaire-hidden.html"), "Is a hidden item").img(Utilities.path(this.context.getLocalPrefix(), "icon-qi-hidden.png"));
            d.style("background-color: #eeeeee");
        }
        if (ToolingExtensions.readBoolExtension(i2, "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-optionalDisplay")) {
            hasFlag = true;
            flags.ah("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-optionalDisplay", "Is optional to display").img(Utilities.path(this.context.getLocalPrefix(), "icon-qi-optional.png"));
        }
        if (i2.hasExtension("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-observationLinkPeriod")) {
            hasFlag = true;
            flags.ah("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-observationLinkPeriod", "Is linked to an observation").img(Utilities.path(this.context.getLocalPrefix(), "icon-qi-observation.png"));
        }
        if (i2.hasExtension("http://hl7.org/fhir/StructureDefinition/questionnaire-displayCategory")) {
            CodeableConcept cc = i2.getExtensionByUrl("http://hl7.org/fhir/StructureDefinition/questionnaire-displayCategory").getValueCodeableConcept();
            String code = cc.getCode("http://hl7.org/fhir/questionnaire-display-category");
            hasFlag = true;
            flags.ah("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-displayCategory", "Category: " + code).img(Utilities.path(this.context.getLocalPrefix(), "icon-qi-" + code + ".png"));
        }
        if (i2.hasMaxLength()) {
            this.item(ul, "Max Length", Integer.toString(i2.getMaxLength()));
        }
        if (i2.hasDefinition()) {
            this.genDefinitionLink(this.item(ul, "Definition"), i2);
        }
        if (i2.hasEnableWhen()) {
            this.item(ul, "Enable When", "todo");
        }
        if (i2.hasAnswerValueSet()) {
            ValueSet vs;
            XhtmlNode ans = this.item(ul, "Answers");
            if (i2.getAnswerValueSet().startsWith("#")) {
                vs = (ValueSet)q.getContained(i2.getAnswerValueSet().substring(1));
                if (vs == null) {
                    ans.tx(i2.getAnswerValueSet());
                } else {
                    ans.ah(vs.getUserString("path")).tx(vs.present());
                }
            } else {
                vs = this.context.getWorker().fetchResource(ValueSet.class, i2.getAnswerValueSet());
                if (vs == null || !vs.hasUserData("path")) {
                    ans.tx(i2.getAnswerValueSet());
                } else {
                    ans.ah(vs.getUserString("path")).tx(vs.present());
                }
            }
        }
        if (i2.hasAnswerOption()) {
            this.item(ul, "Answers", Integer.toString(i2.getAnswerOption().size()) + " " + Utilities.pluralize("option", i2.getAnswerOption().size()), this.context.getDefinitionsTarget() + "#item." + i2.getLinkId());
        }
        if (i2.hasInitial()) {
            XhtmlNode vi = this.item(ul, "Initial Values");
            boolean first = true;
            for (Questionnaire.QuestionnaireItemInitialComponent v : i2.getInitial()) {
                if (first) {
                    first = false;
                } else {
                    vi.tx(", ");
                }
                if (v.getValue().isPrimitive()) {
                    vi.tx(v.getValue().primitiveValue());
                    continue;
                }
                vi.tx("{todo}");
            }
        }
        if (!hasFlag) {
            ul.remove(flags);
        }
        int t = 1;
        for (Questionnaire.QuestionnaireItemComponent c : i2.getItem()) {
            hasExt = this.renderFormItem(x, q, c, pfx == null ? null : pfx + "." + Integer.toString(t), indent + 1) || hasExt;
            ++t;
        }
        return hasExt;
    }

    private void item(XhtmlNode ul, String name, String value, String valueLink) {
        if (!Utilities.noString(value)) {
            ul.li().style("font-size: 10px").ah(valueLink).tx(name + ": " + value);
        }
    }

    private void item(XhtmlNode ul, String name, String value) {
        if (!Utilities.noString(value)) {
            ul.li().style("font-size: 10px").tx(name + ": " + value);
        }
    }

    private XhtmlNode item(XhtmlNode ul, String name) {
        XhtmlNode li = ul.li();
        li.style("font-size: 10px").tx(name + ": ");
        return li;
    }

    private void listOptions(Questionnaire q, Questionnaire.QuestionnaireItemComponent i2, XhtmlNode select) {
        if (i2.hasAnswerValueSet()) {
            ValueSetExpander.ValueSetExpansionOutcome exp;
            ValueSet vs = null;
            if (i2.getAnswerValueSet().startsWith("#")) {
                vs = (ValueSet)q.getContained(i2.getAnswerValueSet().substring(1));
                if (vs != null && !vs.hasUrl()) {
                    vs = vs.copy();
                    vs.setUrl("urn:uuid:" + UUID.randomUUID().toString().toLowerCase());
                }
            } else {
                vs = this.context.getContext().fetchResource(ValueSet.class, i2.getAnswerValueSet());
            }
            if (vs != null && (exp = this.context.getContext().expandVS(vs, true, false)).getValueset() != null) {
                for (ValueSet.ValueSetExpansionContainsComponent cc : exp.getValueset().getExpansion().getContains()) {
                    select.option(cc.getCode(), cc.hasDisplay() ? cc.getDisplay() : cc.getCode(), false);
                }
                return;
            }
        } else if (i2.hasAnswerOption()) {
            // empty if block
        }
        select.option("a", "??", false);
    }

    @Override
    public String display(Resource dr) throws UnsupportedEncodingException, IOException {
        return this.display((Questionnaire)dr);
    }

    public String display(Questionnaire q) throws UnsupportedEncodingException, IOException {
        return "Questionnaire " + q.present();
    }

    private boolean renderLinks(XhtmlNode x, Questionnaire q) {
        x.para().tx("Try this questionnaire out:");
        XhtmlNode ul = x.ul();
        ul.li().ah("http://todo.nlm.gov/path?mode=ig&src=" + Utilities.pathURL(this.context.getSelfLink(), "package.tgz") + "&q=" + q.getId() + ".json").tx("NLM Forms Library");
        return false;
    }

    private boolean renderDefns(XhtmlNode x, Questionnaire q) throws IOException {
        XhtmlNode tbl = x.table("dict");
        boolean ext = false;
        ext = this.renderRootDefinition(tbl, q, new ArrayList<Questionnaire.QuestionnaireItemComponent>()) || ext;
        for (Questionnaire.QuestionnaireItemComponent qi : q.getItem()) {
            ext = this.renderDefinition(tbl, q, qi, new ArrayList<Questionnaire.QuestionnaireItemComponent>()) || ext;
        }
        return ext;
    }

    private boolean renderRootDefinition(XhtmlNode tbl, Questionnaire q, List<Questionnaire.QuestionnaireItemComponent> parents) throws IOException {
        boolean first;
        boolean ext = false;
        XhtmlNode td = tbl.tr().td("structure").colspan("2").span(null, null).attribute("class", "self-link-parent");
        td.an(q.getId());
        td.img(Utilities.path(this.context.getLocalPrefix(), "icon_q_root.gif"));
        td.tx(" Questionnaire ");
        td.b().tx(q.getId());
        this.defn(tbl, "URL", q.getUrl());
        this.defn(tbl, "Version", q.getVersion());
        this.defn(tbl, "Name", q.getName());
        this.defn(tbl, "Title", q.getTitle());
        if (q.hasDerivedFrom()) {
            td = this.defn(tbl, "Derived From");
            first = true;
            for (CanonicalType canonicalType : q.getDerivedFrom()) {
                if (first) {
                    first = false;
                } else {
                    td.tx(", ");
                }
                td.tx(canonicalType.asStringValue());
            }
        }
        this.defn(tbl, "Status", q.getStatus().getDisplay());
        this.defn(tbl, "Experimental", q.getExperimental());
        this.defn(tbl, "Publication Date", q.getDateElement().primitiveValue());
        this.defn(tbl, "Approval Date", q.getApprovalDateElement().primitiveValue());
        this.defn(tbl, "Last Review Date", q.getLastReviewDateElement().primitiveValue());
        if (q.hasEffectivePeriod()) {
            this.renderPeriod(this.defn(tbl, "Effective Period"), q.getEffectivePeriod());
        }
        if (q.hasSubjectType()) {
            td = this.defn(tbl, "Subject Type");
            first = true;
            for (CodeType codeType : q.getSubjectType()) {
                if (first) {
                    first = false;
                } else {
                    td.tx(", ");
                }
                td.tx(codeType.asStringValue());
            }
        }
        this.defn(tbl, "Description", q.getDescription());
        this.defn(tbl, "Purpose", q.getPurpose());
        this.defn(tbl, "Copyright", q.getCopyright());
        if (q.hasCode()) {
            td = this.defn(tbl, Utilities.pluralize("Code", q.getCode().size()));
            first = true;
            for (Coding coding : q.getCode()) {
                if (first) {
                    first = false;
                } else {
                    td.tx(", ");
                }
                this.renderCodingWithDetails(td, coding);
            }
        }
        return false;
    }

    private boolean renderDefinition(XhtmlNode tbl, Questionnaire q, Questionnaire.QuestionnaireItemComponent qi, List<Questionnaire.QuestionnaireItemComponent> parents) throws IOException {
        XhtmlNode li;
        XhtmlNode ul;
        XhtmlNode tr;
        boolean ext = false;
        XhtmlNode td = tbl.tr().td("structure").colspan("2").span(null, null).attribute("class", "self-link-parent");
        td.an("item." + qi.getLinkId());
        for (Questionnaire.QuestionnaireItemComponent p : parents) {
            td.ah("#item." + p.getLinkId()).img(Utilities.path(this.context.getLocalPrefix(), "icon_q_item.png"));
            td.tx(" > ");
        }
        td.img(Utilities.path(this.context.getLocalPrefix(), "icon_q_item.png"));
        td.tx(" Item ");
        td.b().tx(qi.getLinkId());
        this.defn(tbl, "Link Id", qi.getLinkId());
        this.defn(tbl, "Prefix", qi.getPrefix());
        this.defn(tbl, "Text", qi.getText());
        this.defn(tbl, "Type", qi.getType().getDisplay());
        this.defn(tbl, "Required", qi.getRequired(), true);
        this.defn(tbl, "Repeats", qi.getRepeats(), true);
        this.defn(tbl, "Read Only", qi.getReadOnly(), false);
        if (ToolingExtensions.readBoolExtension(qi, "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-isSubject")) {
            this.defn(tbl, "Subject", "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-isSubject", "This element changes who the subject of the question is", null);
        }
        this.defn(tbl, "Max Length", qi.getMaxLength());
        if (qi.hasAnswerValueSet()) {
            this.defn(tbl, "Value Set", qi.getDefinition(), this.context.getWorker().fetchResource(ValueSet.class, qi.getAnswerValueSet()));
        }
        if (qi.hasAnswerOption()) {
            tr = tbl.tr();
            tr.td().tx("Allowed Answers");
            ul = tr.td().ul();
            for (Questionnaire.QuestionnaireItemAnswerOptionComponent questionnaireItemAnswerOptionComponent : qi.getAnswerOption()) {
                li = ul.li();
                this.render(li, questionnaireItemAnswerOptionComponent.getValue());
                if (!questionnaireItemAnswerOptionComponent.getInitialSelected()) continue;
                li.tx(" (initially selected)");
            }
        }
        if (qi.hasInitial()) {
            tr = tbl.tr();
            tr.td().tx(Utilities.pluralize("Initial Answer", qi.getInitial().size()));
            if (qi.getInitial().size() == 1) {
                this.render(tr.td(), qi.getInitialFirstRep().getValue());
            } else {
                ul = tr.td().ul();
                for (Questionnaire.QuestionnaireItemInitialComponent questionnaireItemInitialComponent : qi.getInitial()) {
                    li = ul.li();
                    this.render(li, questionnaireItemInitialComponent.getValue());
                }
            }
        }
        if (qi.hasExtension("http://hl7.org/fhir/StructureDefinition/questionnaire-displayCategory")) {
            tr = tbl.tr();
            tr.td().ah("http://hl7.org/fhir/StructureDefinition/questionnaire-displayCategory").tx("Display Category");
            this.render(tr.td(), qi.getExtensionByUrl("http://hl7.org/fhir/StructureDefinition/questionnaire-displayCategory").getValue());
        }
        if (ToolingExtensions.readBoolExtension(qi, "http://hl7.org/fhir/StructureDefinition/questionnaire-hidden")) {
            this.defn(tbl, "Hidden Item", "http://hl7.org/fhir/StructureDefinition/questionnaire-displayCategory", "This item is a hidden question", null);
        }
        if (ToolingExtensions.readBoolExtension(qi, "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-optionalDisplay")) {
            this.defn(tbl, "Hidden Item", "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-optionalDisplay", "This item is optional to display", null);
        }
        if (qi.hasDefinition()) {
            this.genDefinitionLink(this.defn(tbl, "Definition"), qi);
        }
        if (qi.hasCode()) {
            tr = tbl.tr();
            tr.td().tx(Utilities.pluralize("Code", qi.getCode().size()));
            ul = tr.td().ul();
            for (Coding coding : qi.getCode()) {
                this.renderCodingWithDetails(ul.li(), coding);
            }
        }
        if (qi.hasExtension("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-observationLinkPeriod")) {
            tr = tbl.tr();
            tr.td().ah("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-observationLinkPeriod").tx("Observation Link Period");
            this.render(tr.td(), qi.getExtensionByUrl("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-observationLinkPeriod").getValue());
        }
        if (qi.hasEnableWhen()) {
            tr = tbl.tr();
            tr.td().tx("Enable When");
            td = tr.td();
            if (qi.getEnableWhen().size() == 1) {
                this.renderEnableWhen(td, qi.getEnableWhen().get(0));
            } else {
                td.tx(qi.getEnableBehavior().getDisplay() + " are true:");
                ul = td.ul();
                for (Questionnaire.QuestionnaireItemEnableWhenComponent questionnaireItemEnableWhenComponent : qi.getEnableWhen()) {
                    this.renderEnableWhen(ul.li(), questionnaireItemEnableWhenComponent);
                }
            }
        }
        ArrayList<Questionnaire.QuestionnaireItemComponent> curr = new ArrayList<Questionnaire.QuestionnaireItemComponent>();
        curr.addAll(parents);
        curr.add(qi);
        for (Questionnaire.QuestionnaireItemComponent qic : qi.getItem()) {
            ext = this.renderDefinition(tbl, q, qic, curr) || ext;
        }
        return ext;
    }

    private void defn(XhtmlNode tbl, String name, String url, Resource res) throws UnsupportedEncodingException, IOException {
        if (res != null && res.hasUserData("path")) {
            this.defn(tbl, "Definition", RendererFactory.factory(res, this.context).display(res), res.getUserString("path"));
        } else if (Utilities.isAbsoluteUrl(url)) {
            this.defn(tbl, "Definition", url, url);
        }
        this.defn(tbl, "Definition", url);
    }

    private void renderEnableWhen(XhtmlNode x, Questionnaire.QuestionnaireItemEnableWhenComponent ew) {
        x.ah("#item." + ew.getQuestion()).tx(ew.getQuestion());
        x.tx(" ");
        x.tx(ew.getOperator().toCode());
        x.tx(" ");
        x.tx(this.display(ew.getAnswer()));
    }

    private XhtmlNode defn(XhtmlNode tbl, String name) {
        XhtmlNode tr = tbl.tr();
        tr.td().tx(name);
        return tr.td();
    }

    private void defn(XhtmlNode tbl, String name, int value) {
        if (value > 0) {
            XhtmlNode tr = tbl.tr();
            tr.td().tx(name);
            tr.td().tx(value);
        }
    }

    private void defn(XhtmlNode tbl, String name, boolean value) {
        XhtmlNode tr = tbl.tr();
        tr.td().tx(name);
        tr.td().tx(Boolean.toString(value));
    }

    private void defn(XhtmlNode tbl, String name, String value) {
        if (!Utilities.noString(value)) {
            XhtmlNode tr = tbl.tr();
            tr.td().tx(name);
            tr.td().tx(value);
        }
    }

    private void defn(XhtmlNode tbl, String name, String value, String url) {
        if (!Utilities.noString(value)) {
            XhtmlNode tr = tbl.tr();
            tr.td().tx(name);
            tr.td().ah(url).tx(value);
        }
    }

    private void defn(XhtmlNode tbl, String name, String nurl, String value, String url) {
        if (!Utilities.noString(value)) {
            XhtmlNode tr = tbl.tr();
            tr.td().ah(nurl).tx(name);
            if (url != null) {
                tr.td().ah(url).tx(value);
            } else {
                tr.td().tx(value);
            }
        }
    }

    private void defn(XhtmlNode tbl, String name, boolean value, boolean ifFalse) {
        if (ifFalse || value) {
            XhtmlNode tr = tbl.tr();
            tr.td().tx(name);
            tr.td().tx(Boolean.toString(value));
        }
    }
}

