/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Attachment;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.DocumentReference;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.MarketingStatus;
import org.hl7.fhir.r5.model.MedicinalProductDefinition;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.ProductShelfLife;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RegulatedAuthorization;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="PackagedProductDefinition", profile="http://hl7.org/fhir/StructureDefinition/PackagedProductDefinition")
public class PackagedProductDefinition
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Unique identifier", formalDefinition="Unique identifier.")
    protected List<Identifier> identifier;
    @Child(name="name", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="A name for this package. Typically what it would be listed as in a drug formulary or catalogue, inventory etc", formalDefinition="A name for this package. Typically what it would be listed as in a drug formulary or catalogue, inventory etc.")
    protected StringType name;
    @Child(name="type", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="A high level category e.g. medicinal product, raw material, shipping/transport container, etc", formalDefinition="A high level category e.g. medicinal product, raw material, shipping/transport container, etc.")
    protected CodeableConcept type;
    @Child(name="subject", type={MedicinalProductDefinition.class}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The product that this is a pack for", formalDefinition="The product that this is a pack for.")
    protected List<Reference> subject;
    @Child(name="status", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The status within the lifecycle of this item. A high level status, this is not intended to duplicate details carried elsewhere such as legal status, or authorization or marketing status", formalDefinition="The status within the lifecycle of this item. A high level status, this is not intended to duplicate details carried elsewhere such as legal status, or authorization or marketing status.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/publication-status")
    protected CodeableConcept status;
    @Child(name="statusDate", type={DateTimeType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The date at which the given status became applicable", formalDefinition="The date at which the given status became applicable.")
    protected DateTimeType statusDate;
    @Child(name="containedItemQuantity", type={Quantity.class}, order=6, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="A total of the amount of items in the package, per item type. This can be considered as the pack size. This attribite is repeatable so that the different item types in one pack type can be counted (e.g. a count of vials and count of syringes). Repeats are not to be used to represent differerent pack sizes (e.g. 20 pack vs 50 pack) - which would be different resource instances. This attribute differs from  containedItem.amount in that it can give a single count of all tablet types in a pack, even when these are different manufactured items", formalDefinition="A total of the amount of items in the package, per item type. This can be considered as the pack size. This attribite is repeatable so that the different item types in one pack type can be counted (e.g. a count of vials and count of syringes). Repeats are not to be used to represent differerent pack sizes (e.g. 20 pack vs 50 pack) - which would be different resource instances. This attribute differs from  containedItem.amount in that it can give a single count of all tablet types in a pack, even when these are different manufactured items.")
    protected List<Quantity> containedItemQuantity;
    @Child(name="description", type={MarkdownType.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Textual description. Note that this is not the name of the package or product", formalDefinition="Textual description. Note that this is not the name of the package or product.")
    protected MarkdownType description;
    @Child(name="legalStatusOfSupply", type={CodeableConcept.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The legal status of supply of the packaged item as classified by the regulator", formalDefinition="The legal status of supply of the packaged item as classified by the regulator.")
    protected CodeableConcept legalStatusOfSupply;
    @Child(name="marketingStatus", type={MarketingStatus.class}, order=9, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Marketing information", formalDefinition="Marketing information.")
    protected List<MarketingStatus> marketingStatus;
    @Child(name="characteristic", type={CodeableConcept.class}, order=10, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Allows the key features to be recorded, such as \"hospital pack\", \"nurse prescribable\", \"calendar pack\"", formalDefinition="Allows the key features to be recorded, such as \"hospital pack\", \"nurse prescribable\", \"calendar pack\".")
    protected List<CodeableConcept> characteristic;
    @Child(name="copackagedIndicator", type={BooleanType.class}, order=11, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="States whether a drug product is supplied with another item such as a diluent or adjuvant", formalDefinition="States whether a drug product is supplied with another item such as a diluent or adjuvant.")
    protected BooleanType copackagedIndicator;
    @Child(name="marketingAuthorization", type={RegulatedAuthorization.class}, order=12, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="An authorization for this package type", formalDefinition="An authorization for this package type.")
    protected Reference marketingAuthorization;
    @Child(name="manufacturer", type={Organization.class}, order=13, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Manufacturer of this package type. When there are multiple it means these are all possible manufacturers", formalDefinition="Manufacturer of this package type. When there are multiple it means these are all possible manufacturers.")
    protected List<Reference> manufacturer;
    @Child(name="attachedDocument", type={DocumentReference.class}, order=14, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Additional information or supporting documentation about the packaged product", formalDefinition="Additional information or supporting documentation about the packaged product.")
    protected List<Reference> attachedDocument;
    @Child(name="package", type={}, order=15, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="A packaging item, as a container for medically related items, possibly with other packaging items within, or a packaging component, such as bottle cap (which is not a device or a medication manufactured item)", formalDefinition="A packaging item, as a container for medically related items, possibly with other packaging items within, or a packaging component, such as bottle cap (which is not a device or a medication manufactured item).")
    protected PackagedProductDefinitionPackageComponent package_;
    private static final long serialVersionUID = 1564403582L;
    @SearchParamDefinition(name="biological", path="PackagedProductDefinition.package.containedItem.item.reference", description="A biologically derived product within this packaged product", type="reference")
    public static final String SP_BIOLOGICAL = "biological";
    public static final ReferenceClientParam BIOLOGICAL = new ReferenceClientParam("biological");
    public static final Include INCLUDE_BIOLOGICAL = new Include("PackagedProductDefinition:biological").toLocked();
    @SearchParamDefinition(name="contained-item", path="PackagedProductDefinition.package.containedItem.item.reference", description="Any of the contained items within this packaged product", type="reference")
    public static final String SP_CONTAINED_ITEM = "contained-item";
    public static final ReferenceClientParam CONTAINED_ITEM = new ReferenceClientParam("contained-item");
    public static final Include INCLUDE_CONTAINED_ITEM = new Include("PackagedProductDefinition:contained-item").toLocked();
    @SearchParamDefinition(name="device", path="PackagedProductDefinition.package.containedItem.item.reference", description="A device within this packaged product", type="reference")
    public static final String SP_DEVICE = "device";
    public static final ReferenceClientParam DEVICE = new ReferenceClientParam("device");
    public static final Include INCLUDE_DEVICE = new Include("PackagedProductDefinition:device").toLocked();
    @SearchParamDefinition(name="identifier", path="PackagedProductDefinition.identifier", description="Unique identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="manufactured-item", path="PackagedProductDefinition.package.containedItem.item.reference", description="A manufactured item of medication within this packaged product", type="reference")
    public static final String SP_MANUFACTURED_ITEM = "manufactured-item";
    public static final ReferenceClientParam MANUFACTURED_ITEM = new ReferenceClientParam("manufactured-item");
    public static final Include INCLUDE_MANUFACTURED_ITEM = new Include("PackagedProductDefinition:manufactured-item").toLocked();
    @SearchParamDefinition(name="medication", path="PackagedProductDefinition.package.containedItem.item.reference", description="A manufactured item of medication within this packaged product", type="reference")
    public static final String SP_MEDICATION = "medication";
    public static final ReferenceClientParam MEDICATION = new ReferenceClientParam("medication");
    public static final Include INCLUDE_MEDICATION = new Include("PackagedProductDefinition:medication").toLocked();
    @SearchParamDefinition(name="name", path="PackagedProductDefinition.name", description="A name for this package. Typically what it would be listed as in a drug formulary or catalogue, inventory etc", type="token")
    public static final String SP_NAME = "name";
    public static final TokenClientParam NAME = new TokenClientParam("name");
    @SearchParamDefinition(name="nutrition", path="PackagedProductDefinition.package.containedItem.item.reference", description="A nutrition product within this packaged product", type="reference")
    public static final String SP_NUTRITION = "nutrition";
    public static final ReferenceClientParam NUTRITION = new ReferenceClientParam("nutrition");
    public static final Include INCLUDE_NUTRITION = new Include("PackagedProductDefinition:nutrition").toLocked();
    @SearchParamDefinition(name="package", path="PackagedProductDefinition.package.containedItem.item.reference", description="A complete packaged product within this packaged product", type="reference")
    public static final String SP_PACKAGE = "package";
    public static final ReferenceClientParam PACKAGE = new ReferenceClientParam("package");
    public static final Include INCLUDE_PACKAGE = new Include("PackagedProductDefinition:package").toLocked();
    @SearchParamDefinition(name="status", path="PackagedProductDefinition.status", description="The status within the lifecycle of this item. A high level status, this is not intended to duplicate details carried elsewhere such as legal status, or authorization or marketing status", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="subject", path="PackagedProductDefinition.subject", description="The product that this is a pack for", type="reference", target={MedicinalProductDefinition.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("PackagedProductDefinition:subject").toLocked();

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public PackagedProductDefinition setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public PackagedProductDefinition addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PackagedProductDefinition.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    public PackagedProductDefinition setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    public PackagedProductDefinition setName(String value) {
        if (Utilities.noString(value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    public CodeableConcept getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PackagedProductDefinition.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeableConcept();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public PackagedProductDefinition setType(CodeableConcept value) {
        this.type = value;
        return this;
    }

    public List<Reference> getSubject() {
        if (this.subject == null) {
            this.subject = new ArrayList<Reference>();
        }
        return this.subject;
    }

    public PackagedProductDefinition setSubject(List<Reference> theSubject) {
        this.subject = theSubject;
        return this;
    }

    public boolean hasSubject() {
        if (this.subject == null) {
            return false;
        }
        for (Reference item : this.subject) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addSubject() {
        Reference t = new Reference();
        if (this.subject == null) {
            this.subject = new ArrayList<Reference>();
        }
        this.subject.add(t);
        return t;
    }

    public PackagedProductDefinition addSubject(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.subject == null) {
            this.subject = new ArrayList<Reference>();
        }
        this.subject.add(t);
        return this;
    }

    public Reference getSubjectFirstRep() {
        if (this.getSubject().isEmpty()) {
            this.addSubject();
        }
        return this.getSubject().get(0);
    }

    public CodeableConcept getStatus() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PackagedProductDefinition.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new CodeableConcept();
            }
        }
        return this.status;
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public PackagedProductDefinition setStatus(CodeableConcept value) {
        this.status = value;
        return this;
    }

    public DateTimeType getStatusDateElement() {
        if (this.statusDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PackagedProductDefinition.statusDate");
            }
            if (Configuration.doAutoCreate()) {
                this.statusDate = new DateTimeType();
            }
        }
        return this.statusDate;
    }

    public boolean hasStatusDateElement() {
        return this.statusDate != null && !this.statusDate.isEmpty();
    }

    public boolean hasStatusDate() {
        return this.statusDate != null && !this.statusDate.isEmpty();
    }

    public PackagedProductDefinition setStatusDateElement(DateTimeType value) {
        this.statusDate = value;
        return this;
    }

    public Date getStatusDate() {
        return this.statusDate == null ? null : (Date)this.statusDate.getValue();
    }

    public PackagedProductDefinition setStatusDate(Date value) {
        if (value == null) {
            this.statusDate = null;
        } else {
            if (this.statusDate == null) {
                this.statusDate = new DateTimeType();
            }
            this.statusDate.setValue(value);
        }
        return this;
    }

    public List<Quantity> getContainedItemQuantity() {
        if (this.containedItemQuantity == null) {
            this.containedItemQuantity = new ArrayList<Quantity>();
        }
        return this.containedItemQuantity;
    }

    public PackagedProductDefinition setContainedItemQuantity(List<Quantity> theContainedItemQuantity) {
        this.containedItemQuantity = theContainedItemQuantity;
        return this;
    }

    public boolean hasContainedItemQuantity() {
        if (this.containedItemQuantity == null) {
            return false;
        }
        for (Quantity item : this.containedItemQuantity) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Quantity addContainedItemQuantity() {
        Quantity t = new Quantity();
        if (this.containedItemQuantity == null) {
            this.containedItemQuantity = new ArrayList<Quantity>();
        }
        this.containedItemQuantity.add(t);
        return t;
    }

    public PackagedProductDefinition addContainedItemQuantity(Quantity t) {
        if (t == null) {
            return this;
        }
        if (this.containedItemQuantity == null) {
            this.containedItemQuantity = new ArrayList<Quantity>();
        }
        this.containedItemQuantity.add(t);
        return this;
    }

    public Quantity getContainedItemQuantityFirstRep() {
        if (this.getContainedItemQuantity().isEmpty()) {
            this.addContainedItemQuantity();
        }
        return this.getContainedItemQuantity().get(0);
    }

    public MarkdownType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PackagedProductDefinition.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new MarkdownType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public PackagedProductDefinition setDescriptionElement(MarkdownType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public PackagedProductDefinition setDescription(String value) {
        if (value == null) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new MarkdownType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public CodeableConcept getLegalStatusOfSupply() {
        if (this.legalStatusOfSupply == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PackagedProductDefinition.legalStatusOfSupply");
            }
            if (Configuration.doAutoCreate()) {
                this.legalStatusOfSupply = new CodeableConcept();
            }
        }
        return this.legalStatusOfSupply;
    }

    public boolean hasLegalStatusOfSupply() {
        return this.legalStatusOfSupply != null && !this.legalStatusOfSupply.isEmpty();
    }

    public PackagedProductDefinition setLegalStatusOfSupply(CodeableConcept value) {
        this.legalStatusOfSupply = value;
        return this;
    }

    public List<MarketingStatus> getMarketingStatus() {
        if (this.marketingStatus == null) {
            this.marketingStatus = new ArrayList<MarketingStatus>();
        }
        return this.marketingStatus;
    }

    public PackagedProductDefinition setMarketingStatus(List<MarketingStatus> theMarketingStatus) {
        this.marketingStatus = theMarketingStatus;
        return this;
    }

    public boolean hasMarketingStatus() {
        if (this.marketingStatus == null) {
            return false;
        }
        for (MarketingStatus item : this.marketingStatus) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MarketingStatus addMarketingStatus() {
        MarketingStatus t = new MarketingStatus();
        if (this.marketingStatus == null) {
            this.marketingStatus = new ArrayList<MarketingStatus>();
        }
        this.marketingStatus.add(t);
        return t;
    }

    public PackagedProductDefinition addMarketingStatus(MarketingStatus t) {
        if (t == null) {
            return this;
        }
        if (this.marketingStatus == null) {
            this.marketingStatus = new ArrayList<MarketingStatus>();
        }
        this.marketingStatus.add(t);
        return this;
    }

    public MarketingStatus getMarketingStatusFirstRep() {
        if (this.getMarketingStatus().isEmpty()) {
            this.addMarketingStatus();
        }
        return this.getMarketingStatus().get(0);
    }

    public List<CodeableConcept> getCharacteristic() {
        if (this.characteristic == null) {
            this.characteristic = new ArrayList<CodeableConcept>();
        }
        return this.characteristic;
    }

    public PackagedProductDefinition setCharacteristic(List<CodeableConcept> theCharacteristic) {
        this.characteristic = theCharacteristic;
        return this;
    }

    public boolean hasCharacteristic() {
        if (this.characteristic == null) {
            return false;
        }
        for (CodeableConcept item : this.characteristic) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addCharacteristic() {
        CodeableConcept t = new CodeableConcept();
        if (this.characteristic == null) {
            this.characteristic = new ArrayList<CodeableConcept>();
        }
        this.characteristic.add(t);
        return t;
    }

    public PackagedProductDefinition addCharacteristic(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.characteristic == null) {
            this.characteristic = new ArrayList<CodeableConcept>();
        }
        this.characteristic.add(t);
        return this;
    }

    public CodeableConcept getCharacteristicFirstRep() {
        if (this.getCharacteristic().isEmpty()) {
            this.addCharacteristic();
        }
        return this.getCharacteristic().get(0);
    }

    public BooleanType getCopackagedIndicatorElement() {
        if (this.copackagedIndicator == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PackagedProductDefinition.copackagedIndicator");
            }
            if (Configuration.doAutoCreate()) {
                this.copackagedIndicator = new BooleanType();
            }
        }
        return this.copackagedIndicator;
    }

    public boolean hasCopackagedIndicatorElement() {
        return this.copackagedIndicator != null && !this.copackagedIndicator.isEmpty();
    }

    public boolean hasCopackagedIndicator() {
        return this.copackagedIndicator != null && !this.copackagedIndicator.isEmpty();
    }

    public PackagedProductDefinition setCopackagedIndicatorElement(BooleanType value) {
        this.copackagedIndicator = value;
        return this;
    }

    public boolean getCopackagedIndicator() {
        return this.copackagedIndicator == null || this.copackagedIndicator.isEmpty() ? false : (Boolean)this.copackagedIndicator.getValue();
    }

    public PackagedProductDefinition setCopackagedIndicator(boolean value) {
        if (this.copackagedIndicator == null) {
            this.copackagedIndicator = new BooleanType();
        }
        this.copackagedIndicator.setValue((Object)value);
        return this;
    }

    public Reference getMarketingAuthorization() {
        if (this.marketingAuthorization == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PackagedProductDefinition.marketingAuthorization");
            }
            if (Configuration.doAutoCreate()) {
                this.marketingAuthorization = new Reference();
            }
        }
        return this.marketingAuthorization;
    }

    public boolean hasMarketingAuthorization() {
        return this.marketingAuthorization != null && !this.marketingAuthorization.isEmpty();
    }

    public PackagedProductDefinition setMarketingAuthorization(Reference value) {
        this.marketingAuthorization = value;
        return this;
    }

    public List<Reference> getManufacturer() {
        if (this.manufacturer == null) {
            this.manufacturer = new ArrayList<Reference>();
        }
        return this.manufacturer;
    }

    public PackagedProductDefinition setManufacturer(List<Reference> theManufacturer) {
        this.manufacturer = theManufacturer;
        return this;
    }

    public boolean hasManufacturer() {
        if (this.manufacturer == null) {
            return false;
        }
        for (Reference item : this.manufacturer) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addManufacturer() {
        Reference t = new Reference();
        if (this.manufacturer == null) {
            this.manufacturer = new ArrayList<Reference>();
        }
        this.manufacturer.add(t);
        return t;
    }

    public PackagedProductDefinition addManufacturer(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.manufacturer == null) {
            this.manufacturer = new ArrayList<Reference>();
        }
        this.manufacturer.add(t);
        return this;
    }

    public Reference getManufacturerFirstRep() {
        if (this.getManufacturer().isEmpty()) {
            this.addManufacturer();
        }
        return this.getManufacturer().get(0);
    }

    public List<Reference> getAttachedDocument() {
        if (this.attachedDocument == null) {
            this.attachedDocument = new ArrayList<Reference>();
        }
        return this.attachedDocument;
    }

    public PackagedProductDefinition setAttachedDocument(List<Reference> theAttachedDocument) {
        this.attachedDocument = theAttachedDocument;
        return this;
    }

    public boolean hasAttachedDocument() {
        if (this.attachedDocument == null) {
            return false;
        }
        for (Reference item : this.attachedDocument) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addAttachedDocument() {
        Reference t = new Reference();
        if (this.attachedDocument == null) {
            this.attachedDocument = new ArrayList<Reference>();
        }
        this.attachedDocument.add(t);
        return t;
    }

    public PackagedProductDefinition addAttachedDocument(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.attachedDocument == null) {
            this.attachedDocument = new ArrayList<Reference>();
        }
        this.attachedDocument.add(t);
        return this;
    }

    public Reference getAttachedDocumentFirstRep() {
        if (this.getAttachedDocument().isEmpty()) {
            this.addAttachedDocument();
        }
        return this.getAttachedDocument().get(0);
    }

    public PackagedProductDefinitionPackageComponent getPackage() {
        if (this.package_ == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PackagedProductDefinition.package_");
            }
            if (Configuration.doAutoCreate()) {
                this.package_ = new PackagedProductDefinitionPackageComponent();
            }
        }
        return this.package_;
    }

    public boolean hasPackage() {
        return this.package_ != null && !this.package_.isEmpty();
    }

    public PackagedProductDefinition setPackage(PackagedProductDefinitionPackageComponent value) {
        this.package_ = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Unique identifier.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_NAME, "string", "A name for this package. Typically what it would be listed as in a drug formulary or catalogue, inventory etc.", 0, 1, this.name));
        children.add(new Property("type", "CodeableConcept", "A high level category e.g. medicinal product, raw material, shipping/transport container, etc.", 0, 1, this.type));
        children.add(new Property(SP_SUBJECT, "Reference(MedicinalProductDefinition)", "The product that this is a pack for.", 0, Integer.MAX_VALUE, this.subject));
        children.add(new Property(SP_STATUS, "CodeableConcept", "The status within the lifecycle of this item. A high level status, this is not intended to duplicate details carried elsewhere such as legal status, or authorization or marketing status.", 0, 1, this.status));
        children.add(new Property("statusDate", "dateTime", "The date at which the given status became applicable.", 0, 1, this.statusDate));
        children.add(new Property("containedItemQuantity", "Quantity", "A total of the amount of items in the package, per item type. This can be considered as the pack size. This attribite is repeatable so that the different item types in one pack type can be counted (e.g. a count of vials and count of syringes). Repeats are not to be used to represent differerent pack sizes (e.g. 20 pack vs 50 pack) - which would be different resource instances. This attribute differs from  containedItem.amount in that it can give a single count of all tablet types in a pack, even when these are different manufactured items.", 0, Integer.MAX_VALUE, this.containedItemQuantity));
        children.add(new Property("description", "markdown", "Textual description. Note that this is not the name of the package or product.", 0, 1, this.description));
        children.add(new Property("legalStatusOfSupply", "CodeableConcept", "The legal status of supply of the packaged item as classified by the regulator.", 0, 1, this.legalStatusOfSupply));
        children.add(new Property("marketingStatus", "MarketingStatus", "Marketing information.", 0, Integer.MAX_VALUE, this.marketingStatus));
        children.add(new Property("characteristic", "CodeableConcept", "Allows the key features to be recorded, such as \"hospital pack\", \"nurse prescribable\", \"calendar pack\".", 0, Integer.MAX_VALUE, this.characteristic));
        children.add(new Property("copackagedIndicator", "boolean", "States whether a drug product is supplied with another item such as a diluent or adjuvant.", 0, 1, this.copackagedIndicator));
        children.add(new Property("marketingAuthorization", "Reference(RegulatedAuthorization)", "An authorization for this package type.", 0, 1, this.marketingAuthorization));
        children.add(new Property("manufacturer", "Reference(Organization)", "Manufacturer of this package type. When there are multiple it means these are all possible manufacturers.", 0, Integer.MAX_VALUE, this.manufacturer));
        children.add(new Property("attachedDocument", "Reference(DocumentReference)", "Additional information or supporting documentation about the packaged product.", 0, Integer.MAX_VALUE, this.attachedDocument));
        children.add(new Property(SP_PACKAGE, "", "A packaging item, as a container for medically related items, possibly with other packaging items within, or a packaging component, such as bottle cap (which is not a device or a medication manufactured item).", 0, 1, this.package_));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Unique identifier.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 3373707: {
                return new Property(SP_NAME, "string", "A name for this package. Typically what it would be listed as in a drug formulary or catalogue, inventory etc.", 0, 1, this.name);
            }
            case 3575610: {
                return new Property("type", "CodeableConcept", "A high level category e.g. medicinal product, raw material, shipping/transport container, etc.", 0, 1, this.type);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(MedicinalProductDefinition)", "The product that this is a pack for.", 0, Integer.MAX_VALUE, this.subject);
            }
            case -892481550: {
                return new Property(SP_STATUS, "CodeableConcept", "The status within the lifecycle of this item. A high level status, this is not intended to duplicate details carried elsewhere such as legal status, or authorization or marketing status.", 0, 1, this.status);
            }
            case 247524032: {
                return new Property("statusDate", "dateTime", "The date at which the given status became applicable.", 0, 1, this.statusDate);
            }
            case -1686893359: {
                return new Property("containedItemQuantity", "Quantity", "A total of the amount of items in the package, per item type. This can be considered as the pack size. This attribite is repeatable so that the different item types in one pack type can be counted (e.g. a count of vials and count of syringes). Repeats are not to be used to represent differerent pack sizes (e.g. 20 pack vs 50 pack) - which would be different resource instances. This attribute differs from  containedItem.amount in that it can give a single count of all tablet types in a pack, even when these are different manufactured items.", 0, Integer.MAX_VALUE, this.containedItemQuantity);
            }
            case -1724546052: {
                return new Property("description", "markdown", "Textual description. Note that this is not the name of the package or product.", 0, 1, this.description);
            }
            case -844874031: {
                return new Property("legalStatusOfSupply", "CodeableConcept", "The legal status of supply of the packaged item as classified by the regulator.", 0, 1, this.legalStatusOfSupply);
            }
            case 70767032: {
                return new Property("marketingStatus", "MarketingStatus", "Marketing information.", 0, Integer.MAX_VALUE, this.marketingStatus);
            }
            case 366313883: {
                return new Property("characteristic", "CodeableConcept", "Allows the key features to be recorded, such as \"hospital pack\", \"nurse prescribable\", \"calendar pack\".", 0, Integer.MAX_VALUE, this.characteristic);
            }
            case -1638663195: {
                return new Property("copackagedIndicator", "boolean", "States whether a drug product is supplied with another item such as a diluent or adjuvant.", 0, 1, this.copackagedIndicator);
            }
            case 571831283: {
                return new Property("marketingAuthorization", "Reference(RegulatedAuthorization)", "An authorization for this package type.", 0, 1, this.marketingAuthorization);
            }
            case -1969347631: {
                return new Property("manufacturer", "Reference(Organization)", "Manufacturer of this package type. When there are multiple it means these are all possible manufacturers.", 0, Integer.MAX_VALUE, this.manufacturer);
            }
            case -513945889: {
                return new Property("attachedDocument", "Reference(DocumentReference)", "Additional information or supporting documentation about the packaged product.", 0, Integer.MAX_VALUE, this.attachedDocument);
            }
            case -807062458: {
                return new Property(SP_PACKAGE, "", "A packaging item, as a container for medically related items, possibly with other packaging items within, or a packaging component, such as bottle cap (which is not a device or a medication manufactured item).", 0, 1, this.package_);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.name;
                }
                return baseArray;
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.type;
                }
                return baseArray;
            }
            case -1867885268: {
                return this.subject == null ? new Base[]{} : this.subject.toArray(new Base[this.subject.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.status;
                }
                return baseArray;
            }
            case 247524032: {
                Base[] baseArray;
                if (this.statusDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.statusDate;
                }
                return baseArray;
            }
            case -1686893359: {
                return this.containedItemQuantity == null ? new Base[]{} : this.containedItemQuantity.toArray(new Base[this.containedItemQuantity.size()]);
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.description;
                }
                return baseArray;
            }
            case -844874031: {
                Base[] baseArray;
                if (this.legalStatusOfSupply == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.legalStatusOfSupply;
                }
                return baseArray;
            }
            case 70767032: {
                return this.marketingStatus == null ? new Base[]{} : this.marketingStatus.toArray(new Base[this.marketingStatus.size()]);
            }
            case 366313883: {
                return this.characteristic == null ? new Base[]{} : this.characteristic.toArray(new Base[this.characteristic.size()]);
            }
            case -1638663195: {
                Base[] baseArray;
                if (this.copackagedIndicator == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.copackagedIndicator;
                }
                return baseArray;
            }
            case 571831283: {
                Base[] baseArray;
                if (this.marketingAuthorization == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.marketingAuthorization;
                }
                return baseArray;
            }
            case -1969347631: {
                return this.manufacturer == null ? new Base[]{} : this.manufacturer.toArray(new Base[this.manufacturer.size()]);
            }
            case -513945889: {
                return this.attachedDocument == null ? new Base[]{} : this.attachedDocument.toArray(new Base[this.attachedDocument.size()]);
            }
            case -807062458: {
                Base[] baseArray;
                if (this.package_ == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.package_;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case 3373707: {
                this.name = TypeConvertor.castToString(value);
                return value;
            }
            case 3575610: {
                this.type = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -1867885268: {
                this.getSubject().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -892481550: {
                this.status = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 247524032: {
                this.statusDate = TypeConvertor.castToDateTime(value);
                return value;
            }
            case -1686893359: {
                this.getContainedItemQuantity().add(TypeConvertor.castToQuantity(value));
                return value;
            }
            case -1724546052: {
                this.description = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case -844874031: {
                this.legalStatusOfSupply = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 70767032: {
                this.getMarketingStatus().add(TypeConvertor.castToMarketingStatus(value));
                return value;
            }
            case 366313883: {
                this.getCharacteristic().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -1638663195: {
                this.copackagedIndicator = TypeConvertor.castToBoolean(value);
                return value;
            }
            case 571831283: {
                this.marketingAuthorization = TypeConvertor.castToReference(value);
                return value;
            }
            case -1969347631: {
                this.getManufacturer().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -513945889: {
                this.getAttachedDocument().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -807062458: {
                this.package_ = (PackagedProductDefinitionPackageComponent)value;
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_NAME)) {
            this.name = TypeConvertor.castToString(value);
        } else if (name.equals("type")) {
            this.type = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals(SP_SUBJECT)) {
            this.getSubject().add(TypeConvertor.castToReference(value));
        } else if (name.equals(SP_STATUS)) {
            this.status = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("statusDate")) {
            this.statusDate = TypeConvertor.castToDateTime(value);
        } else if (name.equals("containedItemQuantity")) {
            this.getContainedItemQuantity().add(TypeConvertor.castToQuantity(value));
        } else if (name.equals("description")) {
            this.description = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("legalStatusOfSupply")) {
            this.legalStatusOfSupply = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("marketingStatus")) {
            this.getMarketingStatus().add(TypeConvertor.castToMarketingStatus(value));
        } else if (name.equals("characteristic")) {
            this.getCharacteristic().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("copackagedIndicator")) {
            this.copackagedIndicator = TypeConvertor.castToBoolean(value);
        } else if (name.equals("marketingAuthorization")) {
            this.marketingAuthorization = TypeConvertor.castToReference(value);
        } else if (name.equals("manufacturer")) {
            this.getManufacturer().add(TypeConvertor.castToReference(value));
        } else if (name.equals("attachedDocument")) {
            this.getAttachedDocument().add(TypeConvertor.castToReference(value));
        } else if (name.equals(SP_PACKAGE)) {
            this.package_ = (PackagedProductDefinitionPackageComponent)value;
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case 3575610: {
                return this.getType();
            }
            case -1867885268: {
                return this.addSubject();
            }
            case -892481550: {
                return this.getStatus();
            }
            case 247524032: {
                return this.getStatusDateElement();
            }
            case -1686893359: {
                return this.addContainedItemQuantity();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case -844874031: {
                return this.getLegalStatusOfSupply();
            }
            case 70767032: {
                return this.addMarketingStatus();
            }
            case 366313883: {
                return this.addCharacteristic();
            }
            case -1638663195: {
                return this.getCopackagedIndicatorElement();
            }
            case 571831283: {
                return this.getMarketingAuthorization();
            }
            case -1969347631: {
                return this.addManufacturer();
            }
            case -513945889: {
                return this.addAttachedDocument();
            }
            case -807062458: {
                return this.getPackage();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case 3575610: {
                return new String[]{"CodeableConcept"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case -892481550: {
                return new String[]{"CodeableConcept"};
            }
            case 247524032: {
                return new String[]{"dateTime"};
            }
            case -1686893359: {
                return new String[]{"Quantity"};
            }
            case -1724546052: {
                return new String[]{"markdown"};
            }
            case -844874031: {
                return new String[]{"CodeableConcept"};
            }
            case 70767032: {
                return new String[]{"MarketingStatus"};
            }
            case 366313883: {
                return new String[]{"CodeableConcept"};
            }
            case -1638663195: {
                return new String[]{"boolean"};
            }
            case 571831283: {
                return new String[]{"Reference"};
            }
            case -1969347631: {
                return new String[]{"Reference"};
            }
            case -513945889: {
                return new String[]{"Reference"};
            }
            case -807062458: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a primitive type PackagedProductDefinition.name");
        }
        if (name.equals("type")) {
            this.type = new CodeableConcept();
            return this.type;
        }
        if (name.equals(SP_SUBJECT)) {
            return this.addSubject();
        }
        if (name.equals(SP_STATUS)) {
            this.status = new CodeableConcept();
            return this.status;
        }
        if (name.equals("statusDate")) {
            throw new FHIRException("Cannot call addChild on a primitive type PackagedProductDefinition.statusDate");
        }
        if (name.equals("containedItemQuantity")) {
            return this.addContainedItemQuantity();
        }
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on a primitive type PackagedProductDefinition.description");
        }
        if (name.equals("legalStatusOfSupply")) {
            this.legalStatusOfSupply = new CodeableConcept();
            return this.legalStatusOfSupply;
        }
        if (name.equals("marketingStatus")) {
            return this.addMarketingStatus();
        }
        if (name.equals("characteristic")) {
            return this.addCharacteristic();
        }
        if (name.equals("copackagedIndicator")) {
            throw new FHIRException("Cannot call addChild on a primitive type PackagedProductDefinition.copackagedIndicator");
        }
        if (name.equals("marketingAuthorization")) {
            this.marketingAuthorization = new Reference();
            return this.marketingAuthorization;
        }
        if (name.equals("manufacturer")) {
            return this.addManufacturer();
        }
        if (name.equals("attachedDocument")) {
            return this.addAttachedDocument();
        }
        if (name.equals(SP_PACKAGE)) {
            this.package_ = new PackagedProductDefinitionPackageComponent();
            return this.package_;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "PackagedProductDefinition";
    }

    @Override
    public PackagedProductDefinition copy() {
        PackagedProductDefinition dst = new PackagedProductDefinition();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(PackagedProductDefinition dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.name = this.name == null ? null : this.name.copy();
        CodeableConcept codeableConcept = dst.type = this.type == null ? null : this.type.copy();
        if (this.subject != null) {
            dst.subject = new ArrayList<Reference>();
            for (Reference reference : this.subject) {
                dst.subject.add(reference.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        DateTimeType dateTimeType = dst.statusDate = this.statusDate == null ? null : this.statusDate.copy();
        if (this.containedItemQuantity != null) {
            dst.containedItemQuantity = new ArrayList<Quantity>();
            for (Quantity quantity : this.containedItemQuantity) {
                dst.containedItemQuantity.add(quantity.copy());
            }
        }
        dst.description = this.description == null ? null : this.description.copy();
        CodeableConcept codeableConcept2 = dst.legalStatusOfSupply = this.legalStatusOfSupply == null ? null : this.legalStatusOfSupply.copy();
        if (this.marketingStatus != null) {
            dst.marketingStatus = new ArrayList<MarketingStatus>();
            for (MarketingStatus marketingStatus : this.marketingStatus) {
                dst.marketingStatus.add(marketingStatus.copy());
            }
        }
        if (this.characteristic != null) {
            dst.characteristic = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept3 : this.characteristic) {
                dst.characteristic.add(codeableConcept3.copy());
            }
        }
        dst.copackagedIndicator = this.copackagedIndicator == null ? null : this.copackagedIndicator.copy();
        Reference reference = dst.marketingAuthorization = this.marketingAuthorization == null ? null : this.marketingAuthorization.copy();
        if (this.manufacturer != null) {
            dst.manufacturer = new ArrayList<Reference>();
            for (Reference reference2 : this.manufacturer) {
                dst.manufacturer.add(reference2.copy());
            }
        }
        if (this.attachedDocument != null) {
            dst.attachedDocument = new ArrayList<Reference>();
            for (Reference reference3 : this.attachedDocument) {
                dst.attachedDocument.add(reference3.copy());
            }
        }
        dst.package_ = this.package_ == null ? null : this.package_.copy();
    }

    protected PackagedProductDefinition typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof PackagedProductDefinition)) {
            return false;
        }
        PackagedProductDefinition o = (PackagedProductDefinition)other_;
        return PackagedProductDefinition.compareDeep(this.identifier, o.identifier, true) && PackagedProductDefinition.compareDeep(this.name, o.name, true) && PackagedProductDefinition.compareDeep(this.type, o.type, true) && PackagedProductDefinition.compareDeep(this.subject, o.subject, true) && PackagedProductDefinition.compareDeep(this.status, o.status, true) && PackagedProductDefinition.compareDeep(this.statusDate, o.statusDate, true) && PackagedProductDefinition.compareDeep(this.containedItemQuantity, o.containedItemQuantity, true) && PackagedProductDefinition.compareDeep(this.description, o.description, true) && PackagedProductDefinition.compareDeep(this.legalStatusOfSupply, o.legalStatusOfSupply, true) && PackagedProductDefinition.compareDeep(this.marketingStatus, o.marketingStatus, true) && PackagedProductDefinition.compareDeep(this.characteristic, o.characteristic, true) && PackagedProductDefinition.compareDeep(this.copackagedIndicator, o.copackagedIndicator, true) && PackagedProductDefinition.compareDeep(this.marketingAuthorization, o.marketingAuthorization, true) && PackagedProductDefinition.compareDeep(this.manufacturer, o.manufacturer, true) && PackagedProductDefinition.compareDeep(this.attachedDocument, o.attachedDocument, true) && PackagedProductDefinition.compareDeep(this.package_, o.package_, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof PackagedProductDefinition)) {
            return false;
        }
        PackagedProductDefinition o = (PackagedProductDefinition)other_;
        return PackagedProductDefinition.compareValues(this.name, o.name, true) && PackagedProductDefinition.compareValues(this.statusDate, o.statusDate, true) && PackagedProductDefinition.compareValues(this.description, o.description, true) && PackagedProductDefinition.compareValues(this.copackagedIndicator, o.copackagedIndicator, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty(this.identifier, this.name, this.type, this.subject, this.status, this.statusDate, this.containedItemQuantity, this.description, this.legalStatusOfSupply, this.marketingStatus, this.characteristic, this.copackagedIndicator, this.marketingAuthorization, this.manufacturer, this.attachedDocument, this.package_);
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.PackagedProductDefinition;
    }

    @Block
    public static class PackagedProductDefinitionPackageContainedItemComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="item", type={CodeableReference.class}, order=1, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="The actual item(s) of medication, as manufactured, or a device (typically, but not necessarily, a co-packaged one), or other medically related item (such as food, biologicals, raw materials, medical fluids, gases etc.), as contained in the package. This also allows another packaged product to be included, which is solely for the case where a package of other entire packages is wanted - such as a wholesale or distribution pack", formalDefinition="The actual item(s) of medication, as manufactured, or a device (typically, but not necessarily, a co-packaged one), or other medically related item (such as food, biologicals, raw materials, medical fluids, gases etc.), as contained in the package. This also allows another packaged product to be included, which is solely for the case where a package of other entire packages is wanted - such as a wholesale or distribution pack.")
        protected List<CodeableReference> item;
        @Child(name="amount", type={Quantity.class, IntegerType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The number of this type of item within this packaging", formalDefinition="The number of this type of item within this packaging.")
        protected DataType amount;
        private static final long serialVersionUID = -293288479L;

        public List<CodeableReference> getItem() {
            if (this.item == null) {
                this.item = new ArrayList<CodeableReference>();
            }
            return this.item;
        }

        public PackagedProductDefinitionPackageContainedItemComponent setItem(List<CodeableReference> theItem) {
            this.item = theItem;
            return this;
        }

        public boolean hasItem() {
            if (this.item == null) {
                return false;
            }
            for (CodeableReference item : this.item) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableReference addItem() {
            CodeableReference t = new CodeableReference();
            if (this.item == null) {
                this.item = new ArrayList<CodeableReference>();
            }
            this.item.add(t);
            return t;
        }

        public PackagedProductDefinitionPackageContainedItemComponent addItem(CodeableReference t) {
            if (t == null) {
                return this;
            }
            if (this.item == null) {
                this.item = new ArrayList<CodeableReference>();
            }
            this.item.add(t);
            return this;
        }

        public CodeableReference getItemFirstRep() {
            if (this.getItem().isEmpty()) {
                this.addItem();
            }
            return this.getItem().get(0);
        }

        public DataType getAmount() {
            return this.amount;
        }

        public Quantity getAmountQuantity() throws FHIRException {
            if (this.amount == null) {
                this.amount = new Quantity();
            }
            if (!(this.amount instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.amount.getClass().getName() + " was encountered");
            }
            return (Quantity)this.amount;
        }

        public boolean hasAmountQuantity() {
            return this != null && this.amount instanceof Quantity;
        }

        public IntegerType getAmountIntegerType() throws FHIRException {
            if (this.amount == null) {
                this.amount = new IntegerType();
            }
            if (!(this.amount instanceof IntegerType)) {
                throw new FHIRException("Type mismatch: the type IntegerType was expected, but " + this.amount.getClass().getName() + " was encountered");
            }
            return (IntegerType)this.amount;
        }

        public boolean hasAmountIntegerType() {
            return this != null && this.amount instanceof IntegerType;
        }

        public boolean hasAmount() {
            return this.amount != null && !this.amount.isEmpty();
        }

        public PackagedProductDefinitionPackageContainedItemComponent setAmount(DataType value) {
            if (value != null && !(value instanceof Quantity) && !(value instanceof IntegerType)) {
                throw new Error("Not the right type for PackagedProductDefinition.package.containedItem.amount[x]: " + value.fhirType());
            }
            this.amount = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("item", "CodeableReference(ManufacturedItemDefinition|DeviceDefinition|PackagedProductDefinition|BiologicallyDerivedProduct|NutritionProduct)", "The actual item(s) of medication, as manufactured, or a device (typically, but not necessarily, a co-packaged one), or other medically related item (such as food, biologicals, raw materials, medical fluids, gases etc.), as contained in the package. This also allows another packaged product to be included, which is solely for the case where a package of other entire packages is wanted - such as a wholesale or distribution pack.", 0, Integer.MAX_VALUE, this.item));
            children.add(new Property("amount[x]", "Quantity|integer", "The number of this type of item within this packaging.", 0, 1, this.amount));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3242771: {
                    return new Property("item", "CodeableReference(ManufacturedItemDefinition|DeviceDefinition|PackagedProductDefinition|BiologicallyDerivedProduct|NutritionProduct)", "The actual item(s) of medication, as manufactured, or a device (typically, but not necessarily, a co-packaged one), or other medically related item (such as food, biologicals, raw materials, medical fluids, gases etc.), as contained in the package. This also allows another packaged product to be included, which is solely for the case where a package of other entire packages is wanted - such as a wholesale or distribution pack.", 0, Integer.MAX_VALUE, this.item);
                }
                case 646780200: {
                    return new Property("amount[x]", "Quantity|integer", "The number of this type of item within this packaging.", 0, 1, this.amount);
                }
                case -1413853096: {
                    return new Property("amount[x]", "Quantity|integer", "The number of this type of item within this packaging.", 0, 1, this.amount);
                }
                case 1664303363: {
                    return new Property("amount[x]", "Quantity", "The number of this type of item within this packaging.", 0, 1, this.amount);
                }
                case 2053191110: {
                    return new Property("amount[x]", "integer", "The number of this type of item within this packaging.", 0, 1, this.amount);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3242771: {
                    return this.item == null ? new Base[]{} : this.item.toArray(new Base[this.item.size()]);
                }
                case -1413853096: {
                    Base[] baseArray;
                    if (this.amount == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.amount;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3242771: {
                    this.getItem().add(TypeConvertor.castToCodeableReference(value));
                    return value;
                }
                case -1413853096: {
                    this.amount = TypeConvertor.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("item")) {
                this.getItem().add(TypeConvertor.castToCodeableReference(value));
            } else if (name.equals("amount[x]")) {
                this.amount = TypeConvertor.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3242771: {
                    return this.addItem();
                }
                case 646780200: {
                    return this.getAmount();
                }
                case -1413853096: {
                    return this.getAmount();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3242771: {
                    return new String[]{"CodeableReference"};
                }
                case -1413853096: {
                    return new String[]{"Quantity", "integer"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("item")) {
                return this.addItem();
            }
            if (name.equals("amountQuantity")) {
                this.amount = new Quantity();
                return this.amount;
            }
            if (name.equals("amountInteger")) {
                this.amount = new IntegerType();
                return this.amount;
            }
            return super.addChild(name);
        }

        @Override
        public PackagedProductDefinitionPackageContainedItemComponent copy() {
            PackagedProductDefinitionPackageContainedItemComponent dst = new PackagedProductDefinitionPackageContainedItemComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(PackagedProductDefinitionPackageContainedItemComponent dst) {
            super.copyValues(dst);
            if (this.item != null) {
                dst.item = new ArrayList<CodeableReference>();
                for (CodeableReference i2 : this.item) {
                    dst.item.add(i2.copy());
                }
            }
            dst.amount = this.amount == null ? null : this.amount.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof PackagedProductDefinitionPackageContainedItemComponent)) {
                return false;
            }
            PackagedProductDefinitionPackageContainedItemComponent o = (PackagedProductDefinitionPackageContainedItemComponent)other_;
            return PackagedProductDefinitionPackageContainedItemComponent.compareDeep(this.item, o.item, true) && PackagedProductDefinitionPackageContainedItemComponent.compareDeep(this.amount, o.amount, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof PackagedProductDefinitionPackageContainedItemComponent)) {
                return false;
            }
            PackagedProductDefinitionPackageContainedItemComponent o = (PackagedProductDefinitionPackageContainedItemComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.item, this.amount);
        }

        @Override
        public String fhirType() {
            return "PackagedProductDefinition.package.containedItem";
        }
    }

    @Block
    public static class PackagedProductDefinitionPackagePropertyComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A code expressing the type of characteristic", formalDefinition="A code expressing the type of characteristic.")
        protected CodeableConcept type;
        @Child(name="value", type={CodeableConcept.class, Quantity.class, DateType.class, BooleanType.class, Attachment.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A value for the characteristic", formalDefinition="A value for the characteristic.")
        protected DataType value;
        private static final long serialVersionUID = -1659186716L;

        public PackagedProductDefinitionPackagePropertyComponent() {
        }

        public PackagedProductDefinitionPackagePropertyComponent(CodeableConcept type) {
            this.setType(type);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PackagedProductDefinitionPackagePropertyComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public PackagedProductDefinitionPackagePropertyComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public DataType getValue() {
            return this.value;
        }

        public CodeableConcept getValueCodeableConcept() throws FHIRException {
            if (this.value == null) {
                this.value = new CodeableConcept();
            }
            if (!(this.value instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.value;
        }

        public boolean hasValueCodeableConcept() {
            return this != null && this.value instanceof CodeableConcept;
        }

        public Quantity getValueQuantity() throws FHIRException {
            if (this.value == null) {
                this.value = new Quantity();
            }
            if (!(this.value instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Quantity)this.value;
        }

        public boolean hasValueQuantity() {
            return this != null && this.value instanceof Quantity;
        }

        public DateType getValueDateType() throws FHIRException {
            if (this.value == null) {
                this.value = new DateType();
            }
            if (!(this.value instanceof DateType)) {
                throw new FHIRException("Type mismatch: the type DateType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (DateType)this.value;
        }

        public boolean hasValueDateType() {
            return this != null && this.value instanceof DateType;
        }

        public BooleanType getValueBooleanType() throws FHIRException {
            if (this.value == null) {
                this.value = new BooleanType();
            }
            if (!(this.value instanceof BooleanType)) {
                throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (BooleanType)this.value;
        }

        public boolean hasValueBooleanType() {
            return this != null && this.value instanceof BooleanType;
        }

        public Attachment getValueAttachment() throws FHIRException {
            if (this.value == null) {
                this.value = new Attachment();
            }
            if (!(this.value instanceof Attachment)) {
                throw new FHIRException("Type mismatch: the type Attachment was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Attachment)this.value;
        }

        public boolean hasValueAttachment() {
            return this != null && this.value instanceof Attachment;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public PackagedProductDefinitionPackagePropertyComponent setValue(DataType value) {
            if (!(value == null || value instanceof CodeableConcept || value instanceof Quantity || value instanceof DateType || value instanceof BooleanType || value instanceof Attachment)) {
                throw new Error("Not the right type for PackagedProductDefinition.package.property.value[x]: " + value.fhirType());
            }
            this.value = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "A code expressing the type of characteristic.", 0, 1, this.type));
            children.add(new Property("value[x]", "CodeableConcept|Quantity|date|boolean|Attachment", "A value for the characteristic.", 0, 1, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "A code expressing the type of characteristic.", 0, 1, this.type);
                }
                case -1410166417: {
                    return new Property("value[x]", "CodeableConcept|Quantity|date|boolean|Attachment", "A value for the characteristic.", 0, 1, this.value);
                }
                case 111972721: {
                    return new Property("value[x]", "CodeableConcept|Quantity|date|boolean|Attachment", "A value for the characteristic.", 0, 1, this.value);
                }
                case 924902896: {
                    return new Property("value[x]", "CodeableConcept", "A value for the characteristic.", 0, 1, this.value);
                }
                case -2029823716: {
                    return new Property("value[x]", "Quantity", "A value for the characteristic.", 0, 1, this.value);
                }
                case -766192449: {
                    return new Property("value[x]", "date", "A value for the characteristic.", 0, 1, this.value);
                }
                case 733421943: {
                    return new Property("value[x]", "boolean", "A value for the characteristic.", 0, 1, this.value);
                }
                case -475566732: {
                    return new Property("value[x]", "Attachment", "A value for the characteristic.", 0, 1, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 111972721: {
                    this.value = TypeConvertor.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("value[x]")) {
                this.value = TypeConvertor.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -1410166417: {
                    return this.getValue();
                }
                case 111972721: {
                    return this.getValue();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 111972721: {
                    return new String[]{"CodeableConcept", "Quantity", "date", "boolean", "Attachment"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("valueCodeableConcept")) {
                this.value = new CodeableConcept();
                return this.value;
            }
            if (name.equals("valueQuantity")) {
                this.value = new Quantity();
                return this.value;
            }
            if (name.equals("valueDate")) {
                this.value = new DateType();
                return this.value;
            }
            if (name.equals("valueBoolean")) {
                this.value = new BooleanType();
                return this.value;
            }
            if (name.equals("valueAttachment")) {
                this.value = new Attachment();
                return this.value;
            }
            return super.addChild(name);
        }

        @Override
        public PackagedProductDefinitionPackagePropertyComponent copy() {
            PackagedProductDefinitionPackagePropertyComponent dst = new PackagedProductDefinitionPackagePropertyComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(PackagedProductDefinitionPackagePropertyComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.value = this.value == null ? null : this.value.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof PackagedProductDefinitionPackagePropertyComponent)) {
                return false;
            }
            PackagedProductDefinitionPackagePropertyComponent o = (PackagedProductDefinitionPackagePropertyComponent)other_;
            return PackagedProductDefinitionPackagePropertyComponent.compareDeep(this.type, o.type, true) && PackagedProductDefinitionPackagePropertyComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof PackagedProductDefinitionPackagePropertyComponent)) {
                return false;
            }
            PackagedProductDefinitionPackagePropertyComponent o = (PackagedProductDefinitionPackagePropertyComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.type, this.value);
        }

        @Override
        public String fhirType() {
            return "PackagedProductDefinition.package.property";
        }
    }

    @Block
    public static class PackagedProductDefinitionPackageComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Including possibly Data Carrier Identifier", formalDefinition="Including possibly Data Carrier Identifier.")
        protected List<Identifier> identifier;
        @Child(name="type", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The physical type of the container of the items", formalDefinition="The physical type of the container of the items.")
        protected CodeableConcept type;
        @Child(name="quantity", type={IntegerType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The quantity of this level of packaging in the package that contains it. If specified, the outermost level is always 1", formalDefinition="The quantity of this level of packaging in the package that contains it. If specified, the outermost level is always 1.")
        protected IntegerType quantity;
        @Child(name="material", type={CodeableConcept.class}, order=4, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Material type of the package item", formalDefinition="Material type of the package item.")
        protected List<CodeableConcept> material;
        @Child(name="alternateMaterial", type={CodeableConcept.class}, order=5, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="A possible alternate material for the packaging", formalDefinition="A possible alternate material for the packaging.")
        protected List<CodeableConcept> alternateMaterial;
        @Child(name="shelfLifeStorage", type={ProductShelfLife.class}, order=6, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Shelf Life and storage information", formalDefinition="Shelf Life and storage information.")
        protected List<ProductShelfLife> shelfLifeStorage;
        @Child(name="manufacturer", type={Organization.class}, order=7, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Manufacturer of this package Item. When there are multiple it means these are all possible manufacturers", formalDefinition="Manufacturer of this package Item. When there are multiple it means these are all possible manufacturers.")
        protected List<Reference> manufacturer;
        @Child(name="property", type={}, order=8, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="General characteristics of this item", formalDefinition="General characteristics of this item.")
        protected List<PackagedProductDefinitionPackagePropertyComponent> property;
        @Child(name="containedItem", type={}, order=9, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="The item(s) within the packaging", formalDefinition="The item(s) within the packaging.")
        protected List<PackagedProductDefinitionPackageContainedItemComponent> containedItem;
        @Child(name="package", type={PackagedProductDefinitionPackageComponent.class}, order=10, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Allows containers within containers", formalDefinition="Allows containers within containers.")
        protected List<PackagedProductDefinitionPackageComponent> package_;
        private static final long serialVersionUID = 387482302L;

        public List<Identifier> getIdentifier() {
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            return this.identifier;
        }

        public PackagedProductDefinitionPackageComponent setIdentifier(List<Identifier> theIdentifier) {
            this.identifier = theIdentifier;
            return this;
        }

        public boolean hasIdentifier() {
            if (this.identifier == null) {
                return false;
            }
            for (Identifier item : this.identifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Identifier addIdentifier() {
            Identifier t = new Identifier();
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            this.identifier.add(t);
            return t;
        }

        public PackagedProductDefinitionPackageComponent addIdentifier(Identifier t) {
            if (t == null) {
                return this;
            }
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            this.identifier.add(t);
            return this;
        }

        public Identifier getIdentifierFirstRep() {
            if (this.getIdentifier().isEmpty()) {
                this.addIdentifier();
            }
            return this.getIdentifier().get(0);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PackagedProductDefinitionPackageComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public PackagedProductDefinitionPackageComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public IntegerType getQuantityElement() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PackagedProductDefinitionPackageComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new IntegerType();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantityElement() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public PackagedProductDefinitionPackageComponent setQuantityElement(IntegerType value) {
            this.quantity = value;
            return this;
        }

        public int getQuantity() {
            return this.quantity == null || this.quantity.isEmpty() ? 0 : (Integer)this.quantity.getValue();
        }

        public PackagedProductDefinitionPackageComponent setQuantity(int value) {
            if (this.quantity == null) {
                this.quantity = new IntegerType();
            }
            this.quantity.setValue((Object)value);
            return this;
        }

        public List<CodeableConcept> getMaterial() {
            if (this.material == null) {
                this.material = new ArrayList<CodeableConcept>();
            }
            return this.material;
        }

        public PackagedProductDefinitionPackageComponent setMaterial(List<CodeableConcept> theMaterial) {
            this.material = theMaterial;
            return this;
        }

        public boolean hasMaterial() {
            if (this.material == null) {
                return false;
            }
            for (CodeableConcept item : this.material) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addMaterial() {
            CodeableConcept t = new CodeableConcept();
            if (this.material == null) {
                this.material = new ArrayList<CodeableConcept>();
            }
            this.material.add(t);
            return t;
        }

        public PackagedProductDefinitionPackageComponent addMaterial(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.material == null) {
                this.material = new ArrayList<CodeableConcept>();
            }
            this.material.add(t);
            return this;
        }

        public CodeableConcept getMaterialFirstRep() {
            if (this.getMaterial().isEmpty()) {
                this.addMaterial();
            }
            return this.getMaterial().get(0);
        }

        public List<CodeableConcept> getAlternateMaterial() {
            if (this.alternateMaterial == null) {
                this.alternateMaterial = new ArrayList<CodeableConcept>();
            }
            return this.alternateMaterial;
        }

        public PackagedProductDefinitionPackageComponent setAlternateMaterial(List<CodeableConcept> theAlternateMaterial) {
            this.alternateMaterial = theAlternateMaterial;
            return this;
        }

        public boolean hasAlternateMaterial() {
            if (this.alternateMaterial == null) {
                return false;
            }
            for (CodeableConcept item : this.alternateMaterial) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addAlternateMaterial() {
            CodeableConcept t = new CodeableConcept();
            if (this.alternateMaterial == null) {
                this.alternateMaterial = new ArrayList<CodeableConcept>();
            }
            this.alternateMaterial.add(t);
            return t;
        }

        public PackagedProductDefinitionPackageComponent addAlternateMaterial(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.alternateMaterial == null) {
                this.alternateMaterial = new ArrayList<CodeableConcept>();
            }
            this.alternateMaterial.add(t);
            return this;
        }

        public CodeableConcept getAlternateMaterialFirstRep() {
            if (this.getAlternateMaterial().isEmpty()) {
                this.addAlternateMaterial();
            }
            return this.getAlternateMaterial().get(0);
        }

        public List<ProductShelfLife> getShelfLifeStorage() {
            if (this.shelfLifeStorage == null) {
                this.shelfLifeStorage = new ArrayList<ProductShelfLife>();
            }
            return this.shelfLifeStorage;
        }

        public PackagedProductDefinitionPackageComponent setShelfLifeStorage(List<ProductShelfLife> theShelfLifeStorage) {
            this.shelfLifeStorage = theShelfLifeStorage;
            return this;
        }

        public boolean hasShelfLifeStorage() {
            if (this.shelfLifeStorage == null) {
                return false;
            }
            for (ProductShelfLife item : this.shelfLifeStorage) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ProductShelfLife addShelfLifeStorage() {
            ProductShelfLife t = new ProductShelfLife();
            if (this.shelfLifeStorage == null) {
                this.shelfLifeStorage = new ArrayList<ProductShelfLife>();
            }
            this.shelfLifeStorage.add(t);
            return t;
        }

        public PackagedProductDefinitionPackageComponent addShelfLifeStorage(ProductShelfLife t) {
            if (t == null) {
                return this;
            }
            if (this.shelfLifeStorage == null) {
                this.shelfLifeStorage = new ArrayList<ProductShelfLife>();
            }
            this.shelfLifeStorage.add(t);
            return this;
        }

        public ProductShelfLife getShelfLifeStorageFirstRep() {
            if (this.getShelfLifeStorage().isEmpty()) {
                this.addShelfLifeStorage();
            }
            return this.getShelfLifeStorage().get(0);
        }

        public List<Reference> getManufacturer() {
            if (this.manufacturer == null) {
                this.manufacturer = new ArrayList<Reference>();
            }
            return this.manufacturer;
        }

        public PackagedProductDefinitionPackageComponent setManufacturer(List<Reference> theManufacturer) {
            this.manufacturer = theManufacturer;
            return this;
        }

        public boolean hasManufacturer() {
            if (this.manufacturer == null) {
                return false;
            }
            for (Reference item : this.manufacturer) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addManufacturer() {
            Reference t = new Reference();
            if (this.manufacturer == null) {
                this.manufacturer = new ArrayList<Reference>();
            }
            this.manufacturer.add(t);
            return t;
        }

        public PackagedProductDefinitionPackageComponent addManufacturer(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.manufacturer == null) {
                this.manufacturer = new ArrayList<Reference>();
            }
            this.manufacturer.add(t);
            return this;
        }

        public Reference getManufacturerFirstRep() {
            if (this.getManufacturer().isEmpty()) {
                this.addManufacturer();
            }
            return this.getManufacturer().get(0);
        }

        public List<PackagedProductDefinitionPackagePropertyComponent> getProperty() {
            if (this.property == null) {
                this.property = new ArrayList<PackagedProductDefinitionPackagePropertyComponent>();
            }
            return this.property;
        }

        public PackagedProductDefinitionPackageComponent setProperty(List<PackagedProductDefinitionPackagePropertyComponent> theProperty) {
            this.property = theProperty;
            return this;
        }

        public boolean hasProperty() {
            if (this.property == null) {
                return false;
            }
            for (PackagedProductDefinitionPackagePropertyComponent item : this.property) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PackagedProductDefinitionPackagePropertyComponent addProperty() {
            PackagedProductDefinitionPackagePropertyComponent t = new PackagedProductDefinitionPackagePropertyComponent();
            if (this.property == null) {
                this.property = new ArrayList<PackagedProductDefinitionPackagePropertyComponent>();
            }
            this.property.add(t);
            return t;
        }

        public PackagedProductDefinitionPackageComponent addProperty(PackagedProductDefinitionPackagePropertyComponent t) {
            if (t == null) {
                return this;
            }
            if (this.property == null) {
                this.property = new ArrayList<PackagedProductDefinitionPackagePropertyComponent>();
            }
            this.property.add(t);
            return this;
        }

        public PackagedProductDefinitionPackagePropertyComponent getPropertyFirstRep() {
            if (this.getProperty().isEmpty()) {
                this.addProperty();
            }
            return this.getProperty().get(0);
        }

        public List<PackagedProductDefinitionPackageContainedItemComponent> getContainedItem() {
            if (this.containedItem == null) {
                this.containedItem = new ArrayList<PackagedProductDefinitionPackageContainedItemComponent>();
            }
            return this.containedItem;
        }

        public PackagedProductDefinitionPackageComponent setContainedItem(List<PackagedProductDefinitionPackageContainedItemComponent> theContainedItem) {
            this.containedItem = theContainedItem;
            return this;
        }

        public boolean hasContainedItem() {
            if (this.containedItem == null) {
                return false;
            }
            for (PackagedProductDefinitionPackageContainedItemComponent item : this.containedItem) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PackagedProductDefinitionPackageContainedItemComponent addContainedItem() {
            PackagedProductDefinitionPackageContainedItemComponent t = new PackagedProductDefinitionPackageContainedItemComponent();
            if (this.containedItem == null) {
                this.containedItem = new ArrayList<PackagedProductDefinitionPackageContainedItemComponent>();
            }
            this.containedItem.add(t);
            return t;
        }

        public PackagedProductDefinitionPackageComponent addContainedItem(PackagedProductDefinitionPackageContainedItemComponent t) {
            if (t == null) {
                return this;
            }
            if (this.containedItem == null) {
                this.containedItem = new ArrayList<PackagedProductDefinitionPackageContainedItemComponent>();
            }
            this.containedItem.add(t);
            return this;
        }

        public PackagedProductDefinitionPackageContainedItemComponent getContainedItemFirstRep() {
            if (this.getContainedItem().isEmpty()) {
                this.addContainedItem();
            }
            return this.getContainedItem().get(0);
        }

        public List<PackagedProductDefinitionPackageComponent> getPackage() {
            if (this.package_ == null) {
                this.package_ = new ArrayList<PackagedProductDefinitionPackageComponent>();
            }
            return this.package_;
        }

        public PackagedProductDefinitionPackageComponent setPackage(List<PackagedProductDefinitionPackageComponent> thePackage) {
            this.package_ = thePackage;
            return this;
        }

        public boolean hasPackage() {
            if (this.package_ == null) {
                return false;
            }
            for (PackagedProductDefinitionPackageComponent item : this.package_) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PackagedProductDefinitionPackageComponent addPackage() {
            PackagedProductDefinitionPackageComponent t = new PackagedProductDefinitionPackageComponent();
            if (this.package_ == null) {
                this.package_ = new ArrayList<PackagedProductDefinitionPackageComponent>();
            }
            this.package_.add(t);
            return t;
        }

        public PackagedProductDefinitionPackageComponent addPackage(PackagedProductDefinitionPackageComponent t) {
            if (t == null) {
                return this;
            }
            if (this.package_ == null) {
                this.package_ = new ArrayList<PackagedProductDefinitionPackageComponent>();
            }
            this.package_.add(t);
            return this;
        }

        public PackagedProductDefinitionPackageComponent getPackageFirstRep() {
            if (this.getPackage().isEmpty()) {
                this.addPackage();
            }
            return this.getPackage().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(PackagedProductDefinition.SP_IDENTIFIER, "Identifier", "Including possibly Data Carrier Identifier.", 0, Integer.MAX_VALUE, this.identifier));
            children.add(new Property("type", "CodeableConcept", "The physical type of the container of the items.", 0, 1, this.type));
            children.add(new Property("quantity", "integer", "The quantity of this level of packaging in the package that contains it. If specified, the outermost level is always 1.", 0, 1, this.quantity));
            children.add(new Property("material", "CodeableConcept", "Material type of the package item.", 0, Integer.MAX_VALUE, this.material));
            children.add(new Property("alternateMaterial", "CodeableConcept", "A possible alternate material for the packaging.", 0, Integer.MAX_VALUE, this.alternateMaterial));
            children.add(new Property("shelfLifeStorage", "ProductShelfLife", "Shelf Life and storage information.", 0, Integer.MAX_VALUE, this.shelfLifeStorage));
            children.add(new Property("manufacturer", "Reference(Organization)", "Manufacturer of this package Item. When there are multiple it means these are all possible manufacturers.", 0, Integer.MAX_VALUE, this.manufacturer));
            children.add(new Property("property", "", "General characteristics of this item.", 0, Integer.MAX_VALUE, this.property));
            children.add(new Property("containedItem", "", "The item(s) within the packaging.", 0, Integer.MAX_VALUE, this.containedItem));
            children.add(new Property(PackagedProductDefinition.SP_PACKAGE, "@PackagedProductDefinition.package", "Allows containers within containers.", 0, Integer.MAX_VALUE, this.package_));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1618432855: {
                    return new Property(PackagedProductDefinition.SP_IDENTIFIER, "Identifier", "Including possibly Data Carrier Identifier.", 0, Integer.MAX_VALUE, this.identifier);
                }
                case 3575610: {
                    return new Property("type", "CodeableConcept", "The physical type of the container of the items.", 0, 1, this.type);
                }
                case -1285004149: {
                    return new Property("quantity", "integer", "The quantity of this level of packaging in the package that contains it. If specified, the outermost level is always 1.", 0, 1, this.quantity);
                }
                case 299066663: {
                    return new Property("material", "CodeableConcept", "Material type of the package item.", 0, Integer.MAX_VALUE, this.material);
                }
                case -1021448255: {
                    return new Property("alternateMaterial", "CodeableConcept", "A possible alternate material for the packaging.", 0, Integer.MAX_VALUE, this.alternateMaterial);
                }
                case 172049237: {
                    return new Property("shelfLifeStorage", "ProductShelfLife", "Shelf Life and storage information.", 0, Integer.MAX_VALUE, this.shelfLifeStorage);
                }
                case -1969347631: {
                    return new Property("manufacturer", "Reference(Organization)", "Manufacturer of this package Item. When there are multiple it means these are all possible manufacturers.", 0, Integer.MAX_VALUE, this.manufacturer);
                }
                case -993141291: {
                    return new Property("property", "", "General characteristics of this item.", 0, Integer.MAX_VALUE, this.property);
                }
                case 1953679910: {
                    return new Property("containedItem", "", "The item(s) within the packaging.", 0, Integer.MAX_VALUE, this.containedItem);
                }
                case -807062458: {
                    return new Property(PackagedProductDefinition.SP_PACKAGE, "@PackagedProductDefinition.package", "Allows containers within containers.", 0, Integer.MAX_VALUE, this.package_);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -1285004149: {
                    Base[] baseArray;
                    if (this.quantity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.quantity;
                    }
                    return baseArray;
                }
                case 299066663: {
                    return this.material == null ? new Base[]{} : this.material.toArray(new Base[this.material.size()]);
                }
                case -1021448255: {
                    return this.alternateMaterial == null ? new Base[]{} : this.alternateMaterial.toArray(new Base[this.alternateMaterial.size()]);
                }
                case 172049237: {
                    return this.shelfLifeStorage == null ? new Base[]{} : this.shelfLifeStorage.toArray(new Base[this.shelfLifeStorage.size()]);
                }
                case -1969347631: {
                    return this.manufacturer == null ? new Base[]{} : this.manufacturer.toArray(new Base[this.manufacturer.size()]);
                }
                case -993141291: {
                    return this.property == null ? new Base[]{} : this.property.toArray(new Base[this.property.size()]);
                }
                case 1953679910: {
                    return this.containedItem == null ? new Base[]{} : this.containedItem.toArray(new Base[this.containedItem.size()]);
                }
                case -807062458: {
                    return this.package_ == null ? new Base[]{} : this.package_.toArray(new Base[this.package_.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                    return value;
                }
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1285004149: {
                    this.quantity = TypeConvertor.castToInteger(value);
                    return value;
                }
                case 299066663: {
                    this.getMaterial().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case -1021448255: {
                    this.getAlternateMaterial().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case 172049237: {
                    this.getShelfLifeStorage().add(TypeConvertor.castToProductShelfLife(value));
                    return value;
                }
                case -1969347631: {
                    this.getManufacturer().add(TypeConvertor.castToReference(value));
                    return value;
                }
                case -993141291: {
                    this.getProperty().add((PackagedProductDefinitionPackagePropertyComponent)value);
                    return value;
                }
                case 1953679910: {
                    this.getContainedItem().add((PackagedProductDefinitionPackageContainedItemComponent)value);
                    return value;
                }
                case -807062458: {
                    this.getPackage().add((PackagedProductDefinitionPackageComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(PackagedProductDefinition.SP_IDENTIFIER)) {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
            } else if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("quantity")) {
                this.quantity = TypeConvertor.castToInteger(value);
            } else if (name.equals("material")) {
                this.getMaterial().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("alternateMaterial")) {
                this.getAlternateMaterial().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("shelfLifeStorage")) {
                this.getShelfLifeStorage().add(TypeConvertor.castToProductShelfLife(value));
            } else if (name.equals("manufacturer")) {
                this.getManufacturer().add(TypeConvertor.castToReference(value));
            } else if (name.equals("property")) {
                this.getProperty().add((PackagedProductDefinitionPackagePropertyComponent)value);
            } else if (name.equals("containedItem")) {
                this.getContainedItem().add((PackagedProductDefinitionPackageContainedItemComponent)value);
            } else if (name.equals(PackagedProductDefinition.SP_PACKAGE)) {
                this.getPackage().add((PackagedProductDefinitionPackageComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return this.addIdentifier();
                }
                case 3575610: {
                    return this.getType();
                }
                case -1285004149: {
                    return this.getQuantityElement();
                }
                case 299066663: {
                    return this.addMaterial();
                }
                case -1021448255: {
                    return this.addAlternateMaterial();
                }
                case 172049237: {
                    return this.addShelfLifeStorage();
                }
                case -1969347631: {
                    return this.addManufacturer();
                }
                case -993141291: {
                    return this.addProperty();
                }
                case 1953679910: {
                    return this.addContainedItem();
                }
                case -807062458: {
                    return this.addPackage();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return new String[]{"Identifier"};
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -1285004149: {
                    return new String[]{"integer"};
                }
                case 299066663: {
                    return new String[]{"CodeableConcept"};
                }
                case -1021448255: {
                    return new String[]{"CodeableConcept"};
                }
                case 172049237: {
                    return new String[]{"ProductShelfLife"};
                }
                case -1969347631: {
                    return new String[]{"Reference"};
                }
                case -993141291: {
                    return new String[0];
                }
                case 1953679910: {
                    return new String[0];
                }
                case -807062458: {
                    return new String[]{"@PackagedProductDefinition.package"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(PackagedProductDefinition.SP_IDENTIFIER)) {
                return this.addIdentifier();
            }
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("quantity")) {
                throw new FHIRException("Cannot call addChild on a primitive type PackagedProductDefinition.package.quantity");
            }
            if (name.equals("material")) {
                return this.addMaterial();
            }
            if (name.equals("alternateMaterial")) {
                return this.addAlternateMaterial();
            }
            if (name.equals("shelfLifeStorage")) {
                return this.addShelfLifeStorage();
            }
            if (name.equals("manufacturer")) {
                return this.addManufacturer();
            }
            if (name.equals("property")) {
                return this.addProperty();
            }
            if (name.equals("containedItem")) {
                return this.addContainedItem();
            }
            if (name.equals(PackagedProductDefinition.SP_PACKAGE)) {
                return this.addPackage();
            }
            return super.addChild(name);
        }

        @Override
        public PackagedProductDefinitionPackageComponent copy() {
            PackagedProductDefinitionPackageComponent dst = new PackagedProductDefinitionPackageComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(PackagedProductDefinitionPackageComponent dst) {
            super.copyValues(dst);
            if (this.identifier != null) {
                dst.identifier = new ArrayList<Identifier>();
                for (Identifier identifier : this.identifier) {
                    dst.identifier.add(identifier.copy());
                }
            }
            dst.type = this.type == null ? null : this.type.copy();
            IntegerType integerType = dst.quantity = this.quantity == null ? null : this.quantity.copy();
            if (this.material != null) {
                dst.material = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.material) {
                    dst.material.add(codeableConcept.copy());
                }
            }
            if (this.alternateMaterial != null) {
                dst.alternateMaterial = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.alternateMaterial) {
                    dst.alternateMaterial.add(codeableConcept.copy());
                }
            }
            if (this.shelfLifeStorage != null) {
                dst.shelfLifeStorage = new ArrayList<ProductShelfLife>();
                for (ProductShelfLife productShelfLife : this.shelfLifeStorage) {
                    dst.shelfLifeStorage.add(productShelfLife.copy());
                }
            }
            if (this.manufacturer != null) {
                dst.manufacturer = new ArrayList<Reference>();
                for (Reference reference : this.manufacturer) {
                    dst.manufacturer.add(reference.copy());
                }
            }
            if (this.property != null) {
                dst.property = new ArrayList<PackagedProductDefinitionPackagePropertyComponent>();
                for (PackagedProductDefinitionPackagePropertyComponent packagedProductDefinitionPackagePropertyComponent : this.property) {
                    dst.property.add(packagedProductDefinitionPackagePropertyComponent.copy());
                }
            }
            if (this.containedItem != null) {
                dst.containedItem = new ArrayList<PackagedProductDefinitionPackageContainedItemComponent>();
                for (PackagedProductDefinitionPackageContainedItemComponent packagedProductDefinitionPackageContainedItemComponent : this.containedItem) {
                    dst.containedItem.add(packagedProductDefinitionPackageContainedItemComponent.copy());
                }
            }
            if (this.package_ != null) {
                dst.package_ = new ArrayList<PackagedProductDefinitionPackageComponent>();
                for (PackagedProductDefinitionPackageComponent packagedProductDefinitionPackageComponent : this.package_) {
                    dst.package_.add(packagedProductDefinitionPackageComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof PackagedProductDefinitionPackageComponent)) {
                return false;
            }
            PackagedProductDefinitionPackageComponent o = (PackagedProductDefinitionPackageComponent)other_;
            return PackagedProductDefinitionPackageComponent.compareDeep(this.identifier, o.identifier, true) && PackagedProductDefinitionPackageComponent.compareDeep(this.type, o.type, true) && PackagedProductDefinitionPackageComponent.compareDeep(this.quantity, o.quantity, true) && PackagedProductDefinitionPackageComponent.compareDeep(this.material, o.material, true) && PackagedProductDefinitionPackageComponent.compareDeep(this.alternateMaterial, o.alternateMaterial, true) && PackagedProductDefinitionPackageComponent.compareDeep(this.shelfLifeStorage, o.shelfLifeStorage, true) && PackagedProductDefinitionPackageComponent.compareDeep(this.manufacturer, o.manufacturer, true) && PackagedProductDefinitionPackageComponent.compareDeep(this.property, o.property, true) && PackagedProductDefinitionPackageComponent.compareDeep(this.containedItem, o.containedItem, true) && PackagedProductDefinitionPackageComponent.compareDeep(this.package_, o.package_, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof PackagedProductDefinitionPackageComponent)) {
                return false;
            }
            PackagedProductDefinitionPackageComponent o = (PackagedProductDefinitionPackageComponent)other_;
            return PackagedProductDefinitionPackageComponent.compareValues(this.quantity, o.quantity, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.identifier, this.type, this.quantity, this.material, this.alternateMaterial, this.shelfLifeStorage, this.manufacturer, this.property, this.containedItem, this.package_);
        }

        @Override
        public String fhirType() {
            return "PackagedProductDefinition.package";
        }
    }
}

