/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.CompositeClientParam;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.QuantityClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DecimalType;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.UnsignedIntType;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.UsageContext;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="CodeSystem", profile="http://hl7.org/fhir/StructureDefinition/CodeSystem")
public class CodeSystem
extends CanonicalResource {
    @Child(name="url", type={UriType.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Canonical identifier for this code system, represented as a URI (globally unique) (Coding.system)", formalDefinition="An absolute URI that is used to identify this code system when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this code system is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the code system is stored on different servers. This is used in [Coding](datatypes.html#Coding).system.")
    protected UriType url;
    @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Additional identifier for the code system (business identifier)", formalDefinition="A formal identifier that is used to identify this code system when it is represented in other formats, or referenced in a specification, model, design or an instance.")
    protected List<Identifier> identifier;
    @Child(name="version", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Business version of the code system (Coding.version)", formalDefinition="The identifier that is used to identify this version of the code system when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the code system author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence. This is used in [Coding](datatypes.html#Coding).version.")
    protected StringType version;
    @Child(name="name", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name for this code system (computer friendly)", formalDefinition="A natural language name identifying the code system. This name should be usable as an identifier for the module by machine processing applications such as code generation.")
    protected StringType name;
    @Child(name="title", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name for this code system (human friendly)", formalDefinition="A short, descriptive, user-friendly title for the code system.")
    protected StringType title;
    @Child(name="status", type={CodeType.class}, order=5, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | active | retired | unknown", formalDefinition="The date (and optionally time) when the code system resource was created or revised.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/publication-status")
    protected Enumeration<Enumerations.PublicationStatus> status;
    @Child(name="experimental", type={BooleanType.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="For testing purposes, not real usage", formalDefinition="A Boolean value to indicate that this code system is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.")
    protected BooleanType experimental;
    @Child(name="date", type={DateTimeType.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date last changed", formalDefinition="The date  (and optionally time) when the code system was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the code system changes.")
    protected DateTimeType date;
    @Child(name="publisher", type={StringType.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name of the publisher (organization or individual)", formalDefinition="The name of the organization or individual that published the code system.")
    protected StringType publisher;
    @Child(name="contact", type={ContactDetail.class}, order=9, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Contact details for the publisher", formalDefinition="Contact details to assist a user in finding and communicating with the publisher.")
    protected List<ContactDetail> contact;
    @Child(name="description", type={MarkdownType.class}, order=10, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Natural language description of the code system", formalDefinition="A free text natural language description of the code system from a consumer's perspective.")
    protected MarkdownType description;
    @Child(name="useContext", type={UsageContext.class}, order=11, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The context that the content is intended to support", formalDefinition="The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate code system instances.")
    protected List<UsageContext> useContext;
    @Child(name="jurisdiction", type={CodeableConcept.class}, order=12, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Intended jurisdiction for code system (if applicable)", formalDefinition="A legal or geographic region in which the code system is intended to be used.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/jurisdiction")
    protected List<CodeableConcept> jurisdiction;
    @Child(name="purpose", type={MarkdownType.class}, order=13, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Why this code system is defined", formalDefinition="Explanation of why this code system is needed and why it has been designed as it has.")
    protected MarkdownType purpose;
    @Child(name="copyright", type={MarkdownType.class}, order=14, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Use and/or publishing restrictions", formalDefinition="A copyright statement relating to the code system and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the code system.")
    protected MarkdownType copyright;
    @Child(name="caseSensitive", type={BooleanType.class}, order=15, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="If code comparison is case sensitive", formalDefinition="If code comparison is case sensitive when codes within this system are compared to each other.")
    protected BooleanType caseSensitive;
    @Child(name="valueSet", type={CanonicalType.class}, order=16, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Canonical reference to the value set with entire code system", formalDefinition="Canonical reference to the value set that contains the entire code system.")
    protected CanonicalType valueSet;
    @Child(name="hierarchyMeaning", type={CodeType.class}, order=17, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="grouped-by | is-a | part-of | classified-with", formalDefinition="The meaning of the hierarchy of concepts as represented in this resource.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/codesystem-hierarchy-meaning")
    protected Enumeration<CodeSystemHierarchyMeaning> hierarchyMeaning;
    @Child(name="compositional", type={BooleanType.class}, order=18, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="If code system defines a compositional grammar", formalDefinition="The code system defines a compositional (post-coordination) grammar.")
    protected BooleanType compositional;
    @Child(name="versionNeeded", type={BooleanType.class}, order=19, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="If definitions are not stable", formalDefinition="This flag is used to signify that the code system does not commit to concept permanence across versions. If true, a version must be specified when referencing this code system.")
    protected BooleanType versionNeeded;
    @Child(name="content", type={CodeType.class}, order=20, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="not-present | example | fragment | complete | supplement", formalDefinition="The extent of the content of the code system (the concepts and codes it defines) are represented in this resource instance.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/codesystem-content-mode")
    protected Enumeration<CodeSystemContentMode> content;
    @Child(name="supplements", type={CanonicalType.class}, order=21, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Canonical URL of Code System this adds designations and properties to", formalDefinition="The canonical URL of the code system that this code system supplement is adding designations and properties to.")
    protected CanonicalType supplements;
    @Child(name="count", type={UnsignedIntType.class}, order=22, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Total concepts in the code system", formalDefinition="The total number of concepts defined by the code system. Where the code system has a compositional grammar, the basis of this count is defined by the system steward.")
    protected UnsignedIntType count;
    @Child(name="filter", type={}, order=23, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Filter that can be used in a value set", formalDefinition="A filter that can be used in a value set compose statement when selecting concepts using a filter.")
    protected List<CodeSystemFilterComponent> filter;
    @Child(name="property", type={}, order=24, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Additional information supplied about each concept", formalDefinition="A property defines an additional slot through which additional information can be provided about a concept.")
    protected List<PropertyComponent> property;
    @Child(name="concept", type={}, order=25, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Concepts in the code system", formalDefinition="Concepts that are in the code system. The concept definitions are inherently hierarchical, but the definitions must be consulted to determine what the meanings of the hierarchical relationships are.")
    protected List<ConceptDefinitionComponent> concept;
    private static final long serialVersionUID = -499428696L;
    @SearchParamDefinition(name="context", path="(CapabilityStatement.useContext.value as CodeableConcept) | (CodeSystem.useContext.value as CodeableConcept) | (CompartmentDefinition.useContext.value as CodeableConcept) | (ConceptMap.useContext.value as CodeableConcept) | (GraphDefinition.useContext.value as CodeableConcept) | (ImplementationGuide.useContext.value as CodeableConcept) | (MessageDefinition.useContext.value as CodeableConcept) | (NamingSystem.useContext.value as CodeableConcept) | (OperationDefinition.useContext.value as CodeableConcept) | (SearchParameter.useContext.value as CodeableConcept) | (StructureDefinition.useContext.value as CodeableConcept) | (StructureMap.useContext.value as CodeableConcept) | (TerminologyCapabilities.useContext.value as CodeableConcept) | (ValueSet.useContext.value as CodeableConcept)", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): A use context assigned to the capability statement\r\n* [CodeSystem](codesystem.html): A use context assigned to the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): A use context assigned to the compartment definition\r\n* [ConceptMap](conceptmap.html): A use context assigned to the concept map\r\n* [GraphDefinition](graphdefinition.html): A use context assigned to the graph definition\r\n* [ImplementationGuide](implementationguide.html): A use context assigned to the implementation guide\r\n* [MessageDefinition](messagedefinition.html): A use context assigned to the message definition\r\n* [NamingSystem](namingsystem.html): A use context assigned to the naming system\r\n* [OperationDefinition](operationdefinition.html): A use context assigned to the operation definition\r\n* [SearchParameter](searchparameter.html): A use context assigned to the search parameter\r\n* [StructureDefinition](structuredefinition.html): A use context assigned to the structure definition\r\n* [StructureMap](structuremap.html): A use context assigned to the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): A use context assigned to the terminology capabilities\r\n* [ValueSet](valueset.html): A use context assigned to the value set\r\n", type="token")
    public static final String SP_CONTEXT = "context";
    public static final TokenClientParam CONTEXT = new TokenClientParam("context");
    @SearchParamDefinition(name="context-quantity", path="(CapabilityStatement.useContext.value as Quantity) | (CapabilityStatement.useContext.value as Range) | (CodeSystem.useContext.value as Quantity) | (CodeSystem.useContext.value as Range) | (CompartmentDefinition.useContext.value as Quantity) | (CompartmentDefinition.useContext.value as Range) | (ConceptMap.useContext.value as Quantity) | (ConceptMap.useContext.value as Range) | (GraphDefinition.useContext.value as Quantity) | (GraphDefinition.useContext.value as Range) | (ImplementationGuide.useContext.value as Quantity) | (ImplementationGuide.useContext.value as Range) | (MessageDefinition.useContext.value as Quantity) | (MessageDefinition.useContext.value as Range) | (NamingSystem.useContext.value as Quantity) | (NamingSystem.useContext.value as Range) | (OperationDefinition.useContext.value as Quantity) | (OperationDefinition.useContext.value as Range) | (SearchParameter.useContext.value as Quantity) | (SearchParameter.useContext.value as Range) | (StructureDefinition.useContext.value as Quantity) | (StructureDefinition.useContext.value as Range) | (StructureMap.useContext.value as Quantity) | (StructureMap.useContext.value as Range) | (TerminologyCapabilities.useContext.value as Quantity) | (TerminologyCapabilities.useContext.value as Range) | (ValueSet.useContext.value as Quantity) | (ValueSet.useContext.value as Range)", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): A quantity- or range-valued use context assigned to the capability statement\r\n* [CodeSystem](codesystem.html): A quantity- or range-valued use context assigned to the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): A quantity- or range-valued use context assigned to the compartment definition\r\n* [ConceptMap](conceptmap.html): A quantity- or range-valued use context assigned to the concept map\r\n* [GraphDefinition](graphdefinition.html): A quantity- or range-valued use context assigned to the graph definition\r\n* [ImplementationGuide](implementationguide.html): A quantity- or range-valued use context assigned to the implementation guide\r\n* [MessageDefinition](messagedefinition.html): A quantity- or range-valued use context assigned to the message definition\r\n* [NamingSystem](namingsystem.html): A quantity- or range-valued use context assigned to the naming system\r\n* [OperationDefinition](operationdefinition.html): A quantity- or range-valued use context assigned to the operation definition\r\n* [SearchParameter](searchparameter.html): A quantity- or range-valued use context assigned to the search parameter\r\n* [StructureDefinition](structuredefinition.html): A quantity- or range-valued use context assigned to the structure definition\r\n* [StructureMap](structuremap.html): A quantity- or range-valued use context assigned to the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): A quantity- or range-valued use context assigned to the terminology capabilities\r\n* [ValueSet](valueset.html): A quantity- or range-valued use context assigned to the value set\r\n", type="quantity")
    public static final String SP_CONTEXT_QUANTITY = "context-quantity";
    public static final QuantityClientParam CONTEXT_QUANTITY = new QuantityClientParam("context-quantity");
    @SearchParamDefinition(name="context-type", path="CapabilityStatement.useContext.code | CodeSystem.useContext.code | CompartmentDefinition.useContext.code | ConceptMap.useContext.code | GraphDefinition.useContext.code | ImplementationGuide.useContext.code | MessageDefinition.useContext.code | NamingSystem.useContext.code | OperationDefinition.useContext.code | SearchParameter.useContext.code | StructureDefinition.useContext.code | StructureMap.useContext.code | TerminologyCapabilities.useContext.code | ValueSet.useContext.code", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): A type of use context assigned to the capability statement\r\n* [CodeSystem](codesystem.html): A type of use context assigned to the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): A type of use context assigned to the compartment definition\r\n* [ConceptMap](conceptmap.html): A type of use context assigned to the concept map\r\n* [GraphDefinition](graphdefinition.html): A type of use context assigned to the graph definition\r\n* [ImplementationGuide](implementationguide.html): A type of use context assigned to the implementation guide\r\n* [MessageDefinition](messagedefinition.html): A type of use context assigned to the message definition\r\n* [NamingSystem](namingsystem.html): A type of use context assigned to the naming system\r\n* [OperationDefinition](operationdefinition.html): A type of use context assigned to the operation definition\r\n* [SearchParameter](searchparameter.html): A type of use context assigned to the search parameter\r\n* [StructureDefinition](structuredefinition.html): A type of use context assigned to the structure definition\r\n* [StructureMap](structuremap.html): A type of use context assigned to the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): A type of use context assigned to the terminology capabilities\r\n* [ValueSet](valueset.html): A type of use context assigned to the value set\r\n", type="token")
    public static final String SP_CONTEXT_TYPE = "context-type";
    public static final TokenClientParam CONTEXT_TYPE = new TokenClientParam("context-type");
    @SearchParamDefinition(name="date", path="CapabilityStatement.date | CodeSystem.date | CompartmentDefinition.date | ConceptMap.date | GraphDefinition.date | ImplementationGuide.date | MessageDefinition.date | NamingSystem.date | OperationDefinition.date | SearchParameter.date | StructureDefinition.date | StructureMap.date | TerminologyCapabilities.date | ValueSet.date", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): The capability statement publication date\r\n* [CodeSystem](codesystem.html): The code system publication date\r\n* [CompartmentDefinition](compartmentdefinition.html): The compartment definition publication date\r\n* [ConceptMap](conceptmap.html): The concept map publication date\r\n* [GraphDefinition](graphdefinition.html): The graph definition publication date\r\n* [ImplementationGuide](implementationguide.html): The implementation guide publication date\r\n* [MessageDefinition](messagedefinition.html): The message definition publication date\r\n* [NamingSystem](namingsystem.html): The naming system publication date\r\n* [OperationDefinition](operationdefinition.html): The operation definition publication date\r\n* [SearchParameter](searchparameter.html): The search parameter publication date\r\n* [StructureDefinition](structuredefinition.html): The structure definition publication date\r\n* [StructureMap](structuremap.html): The structure map publication date\r\n* [TerminologyCapabilities](terminologycapabilities.html): The terminology capabilities publication date\r\n* [ValueSet](valueset.html): The value set publication date\r\n", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="description", path="CapabilityStatement.description | CodeSystem.description | CompartmentDefinition.description | ConceptMap.description | GraphDefinition.description | ImplementationGuide.description | MessageDefinition.description | NamingSystem.description | OperationDefinition.description | SearchParameter.description | StructureDefinition.description | StructureMap.description | TerminologyCapabilities.description | ValueSet.description", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): The description of the capability statement\r\n* [CodeSystem](codesystem.html): The description of the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): The description of the compartment definition\r\n* [ConceptMap](conceptmap.html): The description of the concept map\r\n* [GraphDefinition](graphdefinition.html): The description of the graph definition\r\n* [ImplementationGuide](implementationguide.html): The description of the implementation guide\r\n* [MessageDefinition](messagedefinition.html): The description of the message definition\r\n* [NamingSystem](namingsystem.html): The description of the naming system\r\n* [OperationDefinition](operationdefinition.html): The description of the operation definition\r\n* [SearchParameter](searchparameter.html): The description of the search parameter\r\n* [StructureDefinition](structuredefinition.html): The description of the structure definition\r\n* [StructureMap](structuremap.html): The description of the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): The description of the terminology capabilities\r\n* [ValueSet](valueset.html): The description of the value set\r\n", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="jurisdiction", path="CapabilityStatement.jurisdiction | CodeSystem.jurisdiction | ConceptMap.jurisdiction | GraphDefinition.jurisdiction | ImplementationGuide.jurisdiction | MessageDefinition.jurisdiction | NamingSystem.jurisdiction | OperationDefinition.jurisdiction | SearchParameter.jurisdiction | StructureDefinition.jurisdiction | StructureMap.jurisdiction | TerminologyCapabilities.jurisdiction | ValueSet.jurisdiction", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): Intended jurisdiction for the capability statement\r\n* [CodeSystem](codesystem.html): Intended jurisdiction for the code system\r\n* [ConceptMap](conceptmap.html): Intended jurisdiction for the concept map\r\n* [GraphDefinition](graphdefinition.html): Intended jurisdiction for the graph definition\r\n* [ImplementationGuide](implementationguide.html): Intended jurisdiction for the implementation guide\r\n* [MessageDefinition](messagedefinition.html): Intended jurisdiction for the message definition\r\n* [NamingSystem](namingsystem.html): Intended jurisdiction for the naming system\r\n* [OperationDefinition](operationdefinition.html): Intended jurisdiction for the operation definition\r\n* [SearchParameter](searchparameter.html): Intended jurisdiction for the search parameter\r\n* [StructureDefinition](structuredefinition.html): Intended jurisdiction for the structure definition\r\n* [StructureMap](structuremap.html): Intended jurisdiction for the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): Intended jurisdiction for the terminology capabilities\r\n* [ValueSet](valueset.html): Intended jurisdiction for the value set\r\n", type="token")
    public static final String SP_JURISDICTION = "jurisdiction";
    public static final TokenClientParam JURISDICTION = new TokenClientParam("jurisdiction");
    @SearchParamDefinition(name="name", path="CapabilityStatement.name | CodeSystem.name | CompartmentDefinition.name | ConceptMap.name | GraphDefinition.name | ImplementationGuide.name | MessageDefinition.name | NamingSystem.name | OperationDefinition.name | SearchParameter.name | StructureDefinition.name | StructureMap.name | TerminologyCapabilities.name | ValueSet.name", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): Computationally friendly name of the capability statement\r\n* [CodeSystem](codesystem.html): Computationally friendly name of the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): Computationally friendly name of the compartment definition\r\n* [ConceptMap](conceptmap.html): Computationally friendly name of the concept map\r\n* [GraphDefinition](graphdefinition.html): Computationally friendly name of the graph definition\r\n* [ImplementationGuide](implementationguide.html): Computationally friendly name of the implementation guide\r\n* [MessageDefinition](messagedefinition.html): Computationally friendly name of the message definition\r\n* [NamingSystem](namingsystem.html): Computationally friendly name of the naming system\r\n* [OperationDefinition](operationdefinition.html): Computationally friendly name of the operation definition\r\n* [SearchParameter](searchparameter.html): Computationally friendly name of the search parameter\r\n* [StructureDefinition](structuredefinition.html): Computationally friendly name of the structure definition\r\n* [StructureMap](structuremap.html): Computationally friendly name of the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): Computationally friendly name of the terminology capabilities\r\n* [ValueSet](valueset.html): Computationally friendly name of the value set\r\n", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="publisher", path="CapabilityStatement.publisher | CodeSystem.publisher | CompartmentDefinition.publisher | ConceptMap.publisher | GraphDefinition.publisher | ImplementationGuide.publisher | MessageDefinition.publisher | NamingSystem.publisher | OperationDefinition.publisher | SearchParameter.publisher | StructureDefinition.publisher | StructureMap.publisher | TerminologyCapabilities.publisher | ValueSet.publisher", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): Name of the publisher of the capability statement\r\n* [CodeSystem](codesystem.html): Name of the publisher of the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): Name of the publisher of the compartment definition\r\n* [ConceptMap](conceptmap.html): Name of the publisher of the concept map\r\n* [GraphDefinition](graphdefinition.html): Name of the publisher of the graph definition\r\n* [ImplementationGuide](implementationguide.html): Name of the publisher of the implementation guide\r\n* [MessageDefinition](messagedefinition.html): Name of the publisher of the message definition\r\n* [NamingSystem](namingsystem.html): Name of the publisher of the naming system\r\n* [OperationDefinition](operationdefinition.html): Name of the publisher of the operation definition\r\n* [SearchParameter](searchparameter.html): Name of the publisher of the search parameter\r\n* [StructureDefinition](structuredefinition.html): Name of the publisher of the structure definition\r\n* [StructureMap](structuremap.html): Name of the publisher of the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): Name of the publisher of the terminology capabilities\r\n* [ValueSet](valueset.html): Name of the publisher of the value set\r\n", type="string")
    public static final String SP_PUBLISHER = "publisher";
    public static final StringClientParam PUBLISHER = new StringClientParam("publisher");
    @SearchParamDefinition(name="status", path="CapabilityStatement.status | CodeSystem.status | CompartmentDefinition.status | ConceptMap.status | GraphDefinition.status | ImplementationGuide.status | MessageDefinition.status | NamingSystem.status | OperationDefinition.status | SearchParameter.status | StructureDefinition.status | StructureMap.status | TerminologyCapabilities.status | ValueSet.status", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): The current status of the capability statement\r\n* [CodeSystem](codesystem.html): The current status of the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): The current status of the compartment definition\r\n* [ConceptMap](conceptmap.html): The current status of the concept map\r\n* [GraphDefinition](graphdefinition.html): The current status of the graph definition\r\n* [ImplementationGuide](implementationguide.html): The current status of the implementation guide\r\n* [MessageDefinition](messagedefinition.html): The current status of the message definition\r\n* [NamingSystem](namingsystem.html): The current status of the naming system\r\n* [OperationDefinition](operationdefinition.html): The current status of the operation definition\r\n* [SearchParameter](searchparameter.html): The current status of the search parameter\r\n* [StructureDefinition](structuredefinition.html): The current status of the structure definition\r\n* [StructureMap](structuremap.html): The current status of the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): The current status of the terminology capabilities\r\n* [ValueSet](valueset.html): The current status of the value set\r\n", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="title", path="CapabilityStatement.title | CodeSystem.title | ConceptMap.title | ImplementationGuide.title | MessageDefinition.title | OperationDefinition.title | StructureDefinition.title | StructureMap.title | TerminologyCapabilities.title | ValueSet.title", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): The human-friendly name of the capability statement\r\n* [CodeSystem](codesystem.html): The human-friendly name of the code system\r\n* [ConceptMap](conceptmap.html): The human-friendly name of the concept map\r\n* [ImplementationGuide](implementationguide.html): The human-friendly name of the implementation guide\r\n* [MessageDefinition](messagedefinition.html): The human-friendly name of the message definition\r\n* [OperationDefinition](operationdefinition.html): The human-friendly name of the operation definition\r\n* [StructureDefinition](structuredefinition.html): The human-friendly name of the structure definition\r\n* [StructureMap](structuremap.html): The human-friendly name of the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): The human-friendly name of the terminology capabilities\r\n* [ValueSet](valueset.html): The human-friendly name of the value set\r\n", type="string")
    public static final String SP_TITLE = "title";
    public static final StringClientParam TITLE = new StringClientParam("title");
    @SearchParamDefinition(name="url", path="CapabilityStatement.url | CodeSystem.url | CompartmentDefinition.url | ConceptMap.url | GraphDefinition.url | ImplementationGuide.url | MessageDefinition.url | NamingSystem.url | OperationDefinition.url | SearchParameter.url | StructureDefinition.url | StructureMap.url | TerminologyCapabilities.url | ValueSet.url", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): The uri that identifies the capability statement\r\n* [CodeSystem](codesystem.html): The uri that identifies the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): The uri that identifies the compartment definition\r\n* [ConceptMap](conceptmap.html): The uri that identifies the concept map\r\n* [GraphDefinition](graphdefinition.html): The uri that identifies the graph definition\r\n* [ImplementationGuide](implementationguide.html): The uri that identifies the implementation guide\r\n* [MessageDefinition](messagedefinition.html): The uri that identifies the message definition\r\n* [NamingSystem](namingsystem.html): The uri that identifies the naming system\r\n* [OperationDefinition](operationdefinition.html): The uri that identifies the operation definition\r\n* [SearchParameter](searchparameter.html): The uri that identifies the search parameter\r\n* [StructureDefinition](structuredefinition.html): The uri that identifies the structure definition\r\n* [StructureMap](structuremap.html): The uri that identifies the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): The uri that identifies the terminology capabilities\r\n* [ValueSet](valueset.html): The uri that identifies the value set\r\n", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="version", path="CapabilityStatement.version | CodeSystem.version | CompartmentDefinition.version | ConceptMap.version | GraphDefinition.version | ImplementationGuide.version | MessageDefinition.version | NamingSystem.version | OperationDefinition.version | SearchParameter.version | StructureDefinition.version | StructureMap.version | TerminologyCapabilities.version | ValueSet.version", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): The business version of the capability statement\r\n* [CodeSystem](codesystem.html): The business version of the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): The business version of the compartment definition\r\n* [ConceptMap](conceptmap.html): The business version of the concept map\r\n* [GraphDefinition](graphdefinition.html): The business version of the graph definition\r\n* [ImplementationGuide](implementationguide.html): The business version of the implementation guide\r\n* [MessageDefinition](messagedefinition.html): The business version of the message definition\r\n* [NamingSystem](namingsystem.html): The business version of the naming system\r\n* [OperationDefinition](operationdefinition.html): The business version of the operation definition\r\n* [SearchParameter](searchparameter.html): The business version of the search parameter\r\n* [StructureDefinition](structuredefinition.html): The business version of the structure definition\r\n* [StructureMap](structuremap.html): The business version of the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): The business version of the terminology capabilities\r\n* [ValueSet](valueset.html): The business version of the value set\r\n", type="token")
    public static final String SP_VERSION = "version";
    public static final TokenClientParam VERSION = new TokenClientParam("version");
    @SearchParamDefinition(name="context-type-quantity", path="CapabilityStatement.useContext | CodeSystem.useContext | CompartmentDefinition.useContext | ConceptMap.useContext | GraphDefinition.useContext | ImplementationGuide.useContext | MessageDefinition.useContext | NamingSystem.useContext | OperationDefinition.useContext | SearchParameter.useContext | StructureDefinition.useContext | StructureMap.useContext | TerminologyCapabilities.useContext | ValueSet.useContext", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): A use context type and quantity- or range-based value assigned to the capability statement\r\n* [CodeSystem](codesystem.html): A use context type and quantity- or range-based value assigned to the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): A use context type and quantity- or range-based value assigned to the compartment definition\r\n* [ConceptMap](conceptmap.html): A use context type and quantity- or range-based value assigned to the concept map\r\n* [GraphDefinition](graphdefinition.html): A use context type and quantity- or range-based value assigned to the graph definition\r\n* [ImplementationGuide](implementationguide.html): A use context type and quantity- or range-based value assigned to the implementation guide\r\n* [MessageDefinition](messagedefinition.html): A use context type and quantity- or range-based value assigned to the message definition\r\n* [NamingSystem](namingsystem.html): A use context type and quantity- or range-based value assigned to the naming system\r\n* [OperationDefinition](operationdefinition.html): A use context type and quantity- or range-based value assigned to the operation definition\r\n* [SearchParameter](searchparameter.html): A use context type and quantity- or range-based value assigned to the search parameter\r\n* [StructureDefinition](structuredefinition.html): A use context type and quantity- or range-based value assigned to the structure definition\r\n* [StructureMap](structuremap.html): A use context type and quantity- or range-based value assigned to the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): A use context type and quantity- or range-based value assigned to the terminology capabilities\r\n* [ValueSet](valueset.html): A use context type and quantity- or range-based value assigned to the value set\r\n", type="composite", compositeOf={"context-type", "context-quantity"})
    public static final String SP_CONTEXT_TYPE_QUANTITY = "context-type-quantity";
    public static final CompositeClientParam<TokenClientParam, QuantityClientParam> CONTEXT_TYPE_QUANTITY = new CompositeClientParam("context-type-quantity");
    @SearchParamDefinition(name="context-type-value", path="CapabilityStatement.useContext | CodeSystem.useContext | CompartmentDefinition.useContext | ConceptMap.useContext | GraphDefinition.useContext | ImplementationGuide.useContext | MessageDefinition.useContext | NamingSystem.useContext | OperationDefinition.useContext | SearchParameter.useContext | StructureDefinition.useContext | StructureMap.useContext | TerminologyCapabilities.useContext | ValueSet.useContext", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): A use context type and value assigned to the capability statement\r\n* [CodeSystem](codesystem.html): A use context type and value assigned to the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): A use context type and value assigned to the compartment definition\r\n* [ConceptMap](conceptmap.html): A use context type and value assigned to the concept map\r\n* [GraphDefinition](graphdefinition.html): A use context type and value assigned to the graph definition\r\n* [ImplementationGuide](implementationguide.html): A use context type and value assigned to the implementation guide\r\n* [MessageDefinition](messagedefinition.html): A use context type and value assigned to the message definition\r\n* [NamingSystem](namingsystem.html): A use context type and value assigned to the naming system\r\n* [OperationDefinition](operationdefinition.html): A use context type and value assigned to the operation definition\r\n* [SearchParameter](searchparameter.html): A use context type and value assigned to the search parameter\r\n* [StructureDefinition](structuredefinition.html): A use context type and value assigned to the structure definition\r\n* [StructureMap](structuremap.html): A use context type and value assigned to the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): A use context type and value assigned to the terminology capabilities\r\n* [ValueSet](valueset.html): A use context type and value assigned to the value set\r\n", type="composite", compositeOf={"context-type", "context"})
    public static final String SP_CONTEXT_TYPE_VALUE = "context-type-value";
    public static final CompositeClientParam<TokenClientParam, TokenClientParam> CONTEXT_TYPE_VALUE = new CompositeClientParam("context-type-value");
    @SearchParamDefinition(name="code", path="CodeSystem.concept.code", description="A code defined in the code system", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="content-mode", path="CodeSystem.content", description="not-present | example | fragment | complete | supplement", type="token")
    public static final String SP_CONTENT_MODE = "content-mode";
    public static final TokenClientParam CONTENT_MODE = new TokenClientParam("content-mode");
    @SearchParamDefinition(name="identifier", path="CodeSystem.identifier | ConceptMap.identifier | MessageDefinition.identifier | StructureDefinition.identifier | StructureMap.identifier | TerminologyCapabilities.identifier | ValueSet.identifier", description="Multiple Resources: \r\n\r\n* [CodeSystem](codesystem.html): External identifier for the code system\r\n* [ConceptMap](conceptmap.html): External identifier for the concept map\r\n* [MessageDefinition](messagedefinition.html): External identifier for the message definition\r\n* [StructureDefinition](structuredefinition.html): External identifier for the structure definition\r\n* [StructureMap](structuremap.html): External identifier for the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): External identifier for the terminology capabilities\r\n* [ValueSet](valueset.html): External identifier for the value set\r\n", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="language", path="CodeSystem.concept.designation.language", description="A language in which a designation is provided", type="token")
    public static final String SP_LANGUAGE = "language";
    public static final TokenClientParam LANGUAGE = new TokenClientParam("language");
    @SearchParamDefinition(name="supplements", path="CodeSystem.supplements", description="Find code system supplements for the referenced code system", type="reference", target={CodeSystem.class})
    public static final String SP_SUPPLEMENTS = "supplements";
    public static final ReferenceClientParam SUPPLEMENTS = new ReferenceClientParam("supplements");
    public static final Include INCLUDE_SUPPLEMENTS = new Include("CodeSystem:supplements").toLocked();
    @SearchParamDefinition(name="system", path="CodeSystem.url", description="The system for any codes defined by this code system (same as 'url')", type="uri")
    public static final String SP_SYSTEM = "system";
    public static final UriClientParam SYSTEM = new UriClientParam("system");

    public CodeSystem() {
    }

    public CodeSystem(Enumerations.PublicationStatus status, CodeSystemContentMode content) {
        this.setStatus(status);
        this.setContent(content);
    }

    @Override
    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CodeSystem.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    @Override
    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public CodeSystem setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    @Override
    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    @Override
    public CodeSystem setUrl(String value) {
        if (Utilities.noString(value)) {
            this.url = null;
        } else {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
        }
        return this;
    }

    @Override
    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    @Override
    public CodeSystem setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    @Override
    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    @Override
    public CodeSystem addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    @Override
    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    @Override
    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CodeSystem.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    @Override
    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public CodeSystem setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    @Override
    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    @Override
    public CodeSystem setVersion(String value) {
        if (Utilities.noString(value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CodeSystem.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    @Override
    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public CodeSystem setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    @Override
    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    @Override
    public CodeSystem setName(String value) {
        if (Utilities.noString(value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getTitleElement() {
        if (this.title == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CodeSystem.title");
            }
            if (Configuration.doAutoCreate()) {
                this.title = new StringType();
            }
        }
        return this.title;
    }

    @Override
    public boolean hasTitleElement() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public boolean hasTitle() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public CodeSystem setTitleElement(StringType value) {
        this.title = value;
        return this;
    }

    @Override
    public String getTitle() {
        return this.title == null ? null : (String)this.title.getValue();
    }

    @Override
    public CodeSystem setTitle(String value) {
        if (Utilities.noString(value)) {
            this.title = null;
        } else {
            if (this.title == null) {
                this.title = new StringType();
            }
            this.title.setValue(value);
        }
        return this;
    }

    @Override
    public Enumeration<Enumerations.PublicationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CodeSystem.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
            }
        }
        return this.status;
    }

    @Override
    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public CodeSystem setStatusElement(Enumeration<Enumerations.PublicationStatus> value) {
        this.status = value;
        return this;
    }

    @Override
    public Enumerations.PublicationStatus getStatus() {
        return this.status == null ? null : (Enumerations.PublicationStatus)((Object)this.status.getValue());
    }

    @Override
    public CodeSystem setStatus(Enumerations.PublicationStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    @Override
    public BooleanType getExperimentalElement() {
        if (this.experimental == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CodeSystem.experimental");
            }
            if (Configuration.doAutoCreate()) {
                this.experimental = new BooleanType();
            }
        }
        return this.experimental;
    }

    @Override
    public boolean hasExperimentalElement() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public boolean hasExperimental() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public CodeSystem setExperimentalElement(BooleanType value) {
        this.experimental = value;
        return this;
    }

    @Override
    public boolean getExperimental() {
        return this.experimental == null || this.experimental.isEmpty() ? false : (Boolean)this.experimental.getValue();
    }

    @Override
    public CodeSystem setExperimental(boolean value) {
        if (this.experimental == null) {
            this.experimental = new BooleanType();
        }
        this.experimental.setValue((Object)value);
        return this;
    }

    @Override
    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CodeSystem.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    @Override
    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public CodeSystem setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    @Override
    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    @Override
    public CodeSystem setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getPublisherElement() {
        if (this.publisher == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CodeSystem.publisher");
            }
            if (Configuration.doAutoCreate()) {
                this.publisher = new StringType();
            }
        }
        return this.publisher;
    }

    @Override
    public boolean hasPublisherElement() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public boolean hasPublisher() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public CodeSystem setPublisherElement(StringType value) {
        this.publisher = value;
        return this;
    }

    @Override
    public String getPublisher() {
        return this.publisher == null ? null : (String)this.publisher.getValue();
    }

    @Override
    public CodeSystem setPublisher(String value) {
        if (Utilities.noString(value)) {
            this.publisher = null;
        } else {
            if (this.publisher == null) {
                this.publisher = new StringType();
            }
            this.publisher.setValue(value);
        }
        return this;
    }

    @Override
    public List<ContactDetail> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        return this.contact;
    }

    @Override
    public CodeSystem setContact(List<ContactDetail> theContact) {
        this.contact = theContact;
        return this;
    }

    @Override
    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ContactDetail item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addContact() {
        ContactDetail t = new ContactDetail();
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        this.contact.add(t);
        return t;
    }

    @Override
    public CodeSystem addContact(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        this.contact.add(t);
        return this;
    }

    @Override
    public ContactDetail getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    @Override
    public MarkdownType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CodeSystem.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new MarkdownType();
            }
        }
        return this.description;
    }

    @Override
    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public CodeSystem setDescriptionElement(MarkdownType value) {
        this.description = value;
        return this;
    }

    @Override
    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    @Override
    public CodeSystem setDescription(String value) {
        if (value == null) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new MarkdownType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    @Override
    public List<UsageContext> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        return this.useContext;
    }

    @Override
    public CodeSystem setUseContext(List<UsageContext> theUseContext) {
        this.useContext = theUseContext;
        return this;
    }

    @Override
    public boolean hasUseContext() {
        if (this.useContext == null) {
            return false;
        }
        for (UsageContext item : this.useContext) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public UsageContext addUseContext() {
        UsageContext t = new UsageContext();
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        this.useContext.add(t);
        return t;
    }

    @Override
    public CodeSystem addUseContext(UsageContext t) {
        if (t == null) {
            return this;
        }
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        this.useContext.add(t);
        return this;
    }

    @Override
    public UsageContext getUseContextFirstRep() {
        if (this.getUseContext().isEmpty()) {
            this.addUseContext();
        }
        return this.getUseContext().get(0);
    }

    @Override
    public List<CodeableConcept> getJurisdiction() {
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        return this.jurisdiction;
    }

    @Override
    public CodeSystem setJurisdiction(List<CodeableConcept> theJurisdiction) {
        this.jurisdiction = theJurisdiction;
        return this;
    }

    @Override
    public boolean hasJurisdiction() {
        if (this.jurisdiction == null) {
            return false;
        }
        for (CodeableConcept item : this.jurisdiction) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public CodeableConcept addJurisdiction() {
        CodeableConcept t = new CodeableConcept();
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        this.jurisdiction.add(t);
        return t;
    }

    @Override
    public CodeSystem addJurisdiction(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        this.jurisdiction.add(t);
        return this;
    }

    @Override
    public CodeableConcept getJurisdictionFirstRep() {
        if (this.getJurisdiction().isEmpty()) {
            this.addJurisdiction();
        }
        return this.getJurisdiction().get(0);
    }

    @Override
    public MarkdownType getPurposeElement() {
        if (this.purpose == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CodeSystem.purpose");
            }
            if (Configuration.doAutoCreate()) {
                this.purpose = new MarkdownType();
            }
        }
        return this.purpose;
    }

    @Override
    public boolean hasPurposeElement() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    @Override
    public boolean hasPurpose() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    @Override
    public CodeSystem setPurposeElement(MarkdownType value) {
        this.purpose = value;
        return this;
    }

    @Override
    public String getPurpose() {
        return this.purpose == null ? null : (String)this.purpose.getValue();
    }

    @Override
    public CodeSystem setPurpose(String value) {
        if (value == null) {
            this.purpose = null;
        } else {
            if (this.purpose == null) {
                this.purpose = new MarkdownType();
            }
            this.purpose.setValue(value);
        }
        return this;
    }

    @Override
    public MarkdownType getCopyrightElement() {
        if (this.copyright == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CodeSystem.copyright");
            }
            if (Configuration.doAutoCreate()) {
                this.copyright = new MarkdownType();
            }
        }
        return this.copyright;
    }

    @Override
    public boolean hasCopyrightElement() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    @Override
    public boolean hasCopyright() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    @Override
    public CodeSystem setCopyrightElement(MarkdownType value) {
        this.copyright = value;
        return this;
    }

    @Override
    public String getCopyright() {
        return this.copyright == null ? null : (String)this.copyright.getValue();
    }

    @Override
    public CodeSystem setCopyright(String value) {
        if (value == null) {
            this.copyright = null;
        } else {
            if (this.copyright == null) {
                this.copyright = new MarkdownType();
            }
            this.copyright.setValue(value);
        }
        return this;
    }

    public BooleanType getCaseSensitiveElement() {
        if (this.caseSensitive == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CodeSystem.caseSensitive");
            }
            if (Configuration.doAutoCreate()) {
                this.caseSensitive = new BooleanType();
            }
        }
        return this.caseSensitive;
    }

    public boolean hasCaseSensitiveElement() {
        return this.caseSensitive != null && !this.caseSensitive.isEmpty();
    }

    public boolean hasCaseSensitive() {
        return this.caseSensitive != null && !this.caseSensitive.isEmpty();
    }

    public CodeSystem setCaseSensitiveElement(BooleanType value) {
        this.caseSensitive = value;
        return this;
    }

    public boolean getCaseSensitive() {
        return this.caseSensitive == null || this.caseSensitive.isEmpty() ? false : (Boolean)this.caseSensitive.getValue();
    }

    public CodeSystem setCaseSensitive(boolean value) {
        if (this.caseSensitive == null) {
            this.caseSensitive = new BooleanType();
        }
        this.caseSensitive.setValue((Object)value);
        return this;
    }

    public CanonicalType getValueSetElement() {
        if (this.valueSet == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CodeSystem.valueSet");
            }
            if (Configuration.doAutoCreate()) {
                this.valueSet = new CanonicalType();
            }
        }
        return this.valueSet;
    }

    public boolean hasValueSetElement() {
        return this.valueSet != null && !this.valueSet.isEmpty();
    }

    public boolean hasValueSet() {
        return this.valueSet != null && !this.valueSet.isEmpty();
    }

    public CodeSystem setValueSetElement(CanonicalType value) {
        this.valueSet = value;
        return this;
    }

    public String getValueSet() {
        return this.valueSet == null ? null : (String)this.valueSet.getValue();
    }

    public CodeSystem setValueSet(String value) {
        if (Utilities.noString(value)) {
            this.valueSet = null;
        } else {
            if (this.valueSet == null) {
                this.valueSet = new CanonicalType();
            }
            this.valueSet.setValue(value);
        }
        return this;
    }

    public Enumeration<CodeSystemHierarchyMeaning> getHierarchyMeaningElement() {
        if (this.hierarchyMeaning == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CodeSystem.hierarchyMeaning");
            }
            if (Configuration.doAutoCreate()) {
                this.hierarchyMeaning = new Enumeration<CodeSystemHierarchyMeaning>(new CodeSystemHierarchyMeaningEnumFactory());
            }
        }
        return this.hierarchyMeaning;
    }

    public boolean hasHierarchyMeaningElement() {
        return this.hierarchyMeaning != null && !this.hierarchyMeaning.isEmpty();
    }

    public boolean hasHierarchyMeaning() {
        return this.hierarchyMeaning != null && !this.hierarchyMeaning.isEmpty();
    }

    public CodeSystem setHierarchyMeaningElement(Enumeration<CodeSystemHierarchyMeaning> value) {
        this.hierarchyMeaning = value;
        return this;
    }

    public CodeSystemHierarchyMeaning getHierarchyMeaning() {
        return this.hierarchyMeaning == null ? null : (CodeSystemHierarchyMeaning)((Object)this.hierarchyMeaning.getValue());
    }

    public CodeSystem setHierarchyMeaning(CodeSystemHierarchyMeaning value) {
        if (value == null) {
            this.hierarchyMeaning = null;
        } else {
            if (this.hierarchyMeaning == null) {
                this.hierarchyMeaning = new Enumeration<CodeSystemHierarchyMeaning>(new CodeSystemHierarchyMeaningEnumFactory());
            }
            this.hierarchyMeaning.setValue((Object)value);
        }
        return this;
    }

    public BooleanType getCompositionalElement() {
        if (this.compositional == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CodeSystem.compositional");
            }
            if (Configuration.doAutoCreate()) {
                this.compositional = new BooleanType();
            }
        }
        return this.compositional;
    }

    public boolean hasCompositionalElement() {
        return this.compositional != null && !this.compositional.isEmpty();
    }

    public boolean hasCompositional() {
        return this.compositional != null && !this.compositional.isEmpty();
    }

    public CodeSystem setCompositionalElement(BooleanType value) {
        this.compositional = value;
        return this;
    }

    public boolean getCompositional() {
        return this.compositional == null || this.compositional.isEmpty() ? false : (Boolean)this.compositional.getValue();
    }

    public CodeSystem setCompositional(boolean value) {
        if (this.compositional == null) {
            this.compositional = new BooleanType();
        }
        this.compositional.setValue((Object)value);
        return this;
    }

    public BooleanType getVersionNeededElement() {
        if (this.versionNeeded == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CodeSystem.versionNeeded");
            }
            if (Configuration.doAutoCreate()) {
                this.versionNeeded = new BooleanType();
            }
        }
        return this.versionNeeded;
    }

    public boolean hasVersionNeededElement() {
        return this.versionNeeded != null && !this.versionNeeded.isEmpty();
    }

    public boolean hasVersionNeeded() {
        return this.versionNeeded != null && !this.versionNeeded.isEmpty();
    }

    public CodeSystem setVersionNeededElement(BooleanType value) {
        this.versionNeeded = value;
        return this;
    }

    public boolean getVersionNeeded() {
        return this.versionNeeded == null || this.versionNeeded.isEmpty() ? false : (Boolean)this.versionNeeded.getValue();
    }

    public CodeSystem setVersionNeeded(boolean value) {
        if (this.versionNeeded == null) {
            this.versionNeeded = new BooleanType();
        }
        this.versionNeeded.setValue((Object)value);
        return this;
    }

    public Enumeration<CodeSystemContentMode> getContentElement() {
        if (this.content == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CodeSystem.content");
            }
            if (Configuration.doAutoCreate()) {
                this.content = new Enumeration<CodeSystemContentMode>(new CodeSystemContentModeEnumFactory());
            }
        }
        return this.content;
    }

    public boolean hasContentElement() {
        return this.content != null && !this.content.isEmpty();
    }

    public boolean hasContent() {
        return this.content != null && !this.content.isEmpty();
    }

    public CodeSystem setContentElement(Enumeration<CodeSystemContentMode> value) {
        this.content = value;
        return this;
    }

    public CodeSystemContentMode getContent() {
        return this.content == null ? null : (CodeSystemContentMode)((Object)this.content.getValue());
    }

    public CodeSystem setContent(CodeSystemContentMode value) {
        if (this.content == null) {
            this.content = new Enumeration<CodeSystemContentMode>(new CodeSystemContentModeEnumFactory());
        }
        this.content.setValue((Object)value);
        return this;
    }

    public CanonicalType getSupplementsElement() {
        if (this.supplements == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CodeSystem.supplements");
            }
            if (Configuration.doAutoCreate()) {
                this.supplements = new CanonicalType();
            }
        }
        return this.supplements;
    }

    public boolean hasSupplementsElement() {
        return this.supplements != null && !this.supplements.isEmpty();
    }

    public boolean hasSupplements() {
        return this.supplements != null && !this.supplements.isEmpty();
    }

    public CodeSystem setSupplementsElement(CanonicalType value) {
        this.supplements = value;
        return this;
    }

    public String getSupplements() {
        return this.supplements == null ? null : (String)this.supplements.getValue();
    }

    public CodeSystem setSupplements(String value) {
        if (Utilities.noString(value)) {
            this.supplements = null;
        } else {
            if (this.supplements == null) {
                this.supplements = new CanonicalType();
            }
            this.supplements.setValue(value);
        }
        return this;
    }

    public UnsignedIntType getCountElement() {
        if (this.count == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CodeSystem.count");
            }
            if (Configuration.doAutoCreate()) {
                this.count = new UnsignedIntType();
            }
        }
        return this.count;
    }

    public boolean hasCountElement() {
        return this.count != null && !this.count.isEmpty();
    }

    public boolean hasCount() {
        return this.count != null && !this.count.isEmpty();
    }

    public CodeSystem setCountElement(UnsignedIntType value) {
        this.count = value;
        return this;
    }

    public int getCount() {
        return this.count == null || this.count.isEmpty() ? 0 : (Integer)this.count.getValue();
    }

    public CodeSystem setCount(int value) {
        if (this.count == null) {
            this.count = new UnsignedIntType();
        }
        this.count.setValue((Object)value);
        return this;
    }

    public List<CodeSystemFilterComponent> getFilter() {
        if (this.filter == null) {
            this.filter = new ArrayList<CodeSystemFilterComponent>();
        }
        return this.filter;
    }

    public CodeSystem setFilter(List<CodeSystemFilterComponent> theFilter) {
        this.filter = theFilter;
        return this;
    }

    public boolean hasFilter() {
        if (this.filter == null) {
            return false;
        }
        for (CodeSystemFilterComponent item : this.filter) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeSystemFilterComponent addFilter() {
        CodeSystemFilterComponent t = new CodeSystemFilterComponent();
        if (this.filter == null) {
            this.filter = new ArrayList<CodeSystemFilterComponent>();
        }
        this.filter.add(t);
        return t;
    }

    public CodeSystem addFilter(CodeSystemFilterComponent t) {
        if (t == null) {
            return this;
        }
        if (this.filter == null) {
            this.filter = new ArrayList<CodeSystemFilterComponent>();
        }
        this.filter.add(t);
        return this;
    }

    public CodeSystemFilterComponent getFilterFirstRep() {
        if (this.getFilter().isEmpty()) {
            this.addFilter();
        }
        return this.getFilter().get(0);
    }

    public List<PropertyComponent> getProperty() {
        if (this.property == null) {
            this.property = new ArrayList<PropertyComponent>();
        }
        return this.property;
    }

    public CodeSystem setProperty(List<PropertyComponent> theProperty) {
        this.property = theProperty;
        return this;
    }

    public boolean hasProperty() {
        if (this.property == null) {
            return false;
        }
        for (PropertyComponent item : this.property) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public PropertyComponent addProperty() {
        PropertyComponent t = new PropertyComponent();
        if (this.property == null) {
            this.property = new ArrayList<PropertyComponent>();
        }
        this.property.add(t);
        return t;
    }

    public CodeSystem addProperty(PropertyComponent t) {
        if (t == null) {
            return this;
        }
        if (this.property == null) {
            this.property = new ArrayList<PropertyComponent>();
        }
        this.property.add(t);
        return this;
    }

    public PropertyComponent getPropertyFirstRep() {
        if (this.getProperty().isEmpty()) {
            this.addProperty();
        }
        return this.getProperty().get(0);
    }

    public List<ConceptDefinitionComponent> getConcept() {
        if (this.concept == null) {
            this.concept = new ArrayList<ConceptDefinitionComponent>();
        }
        return this.concept;
    }

    public CodeSystem setConcept(List<ConceptDefinitionComponent> theConcept) {
        this.concept = theConcept;
        return this;
    }

    public boolean hasConcept() {
        if (this.concept == null) {
            return false;
        }
        for (ConceptDefinitionComponent item : this.concept) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ConceptDefinitionComponent addConcept() {
        ConceptDefinitionComponent t = new ConceptDefinitionComponent();
        if (this.concept == null) {
            this.concept = new ArrayList<ConceptDefinitionComponent>();
        }
        this.concept.add(t);
        return t;
    }

    public CodeSystem addConcept(ConceptDefinitionComponent t) {
        if (t == null) {
            return this;
        }
        if (this.concept == null) {
            this.concept = new ArrayList<ConceptDefinitionComponent>();
        }
        this.concept.add(t);
        return this;
    }

    public ConceptDefinitionComponent getConceptFirstRep() {
        if (this.getConcept().isEmpty()) {
            this.addConcept();
        }
        return this.getConcept().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_URL, "uri", "An absolute URI that is used to identify this code system when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this code system is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the code system is stored on different servers. This is used in [Coding](datatypes.html#Coding).system.", 0, 1, this.url));
        children.add(new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this code system when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the code system when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the code system author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence. This is used in [Coding](datatypes.html#Coding).version.", 0, 1, this.version));
        children.add(new Property(SP_NAME, "string", "A natural language name identifying the code system. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name));
        children.add(new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the code system.", 0, 1, this.title));
        children.add(new Property(SP_STATUS, SP_CODE, "The date (and optionally time) when the code system resource was created or revised.", 0, 1, this.status));
        children.add(new Property("experimental", "boolean", "A Boolean value to indicate that this code system is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.", 0, 1, this.experimental));
        children.add(new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the code system was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the code system changes.", 0, 1, this.date));
        children.add(new Property(SP_PUBLISHER, "string", "The name of the organization or individual that published the code system.", 0, 1, this.publisher));
        children.add(new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact));
        children.add(new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the code system from a consumer's perspective.", 0, 1, this.description));
        children.add(new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate code system instances.", 0, Integer.MAX_VALUE, this.useContext));
        children.add(new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the code system is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction));
        children.add(new Property("purpose", "markdown", "Explanation of why this code system is needed and why it has been designed as it has.", 0, 1, this.purpose));
        children.add(new Property("copyright", "markdown", "A copyright statement relating to the code system and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the code system.", 0, 1, this.copyright));
        children.add(new Property("caseSensitive", "boolean", "If code comparison is case sensitive when codes within this system are compared to each other.", 0, 1, this.caseSensitive));
        children.add(new Property("valueSet", "canonical(ValueSet)", "Canonical reference to the value set that contains the entire code system.", 0, 1, this.valueSet));
        children.add(new Property("hierarchyMeaning", SP_CODE, "The meaning of the hierarchy of concepts as represented in this resource.", 0, 1, this.hierarchyMeaning));
        children.add(new Property("compositional", "boolean", "The code system defines a compositional (post-coordination) grammar.", 0, 1, this.compositional));
        children.add(new Property("versionNeeded", "boolean", "This flag is used to signify that the code system does not commit to concept permanence across versions. If true, a version must be specified when referencing this code system.", 0, 1, this.versionNeeded));
        children.add(new Property("content", SP_CODE, "The extent of the content of the code system (the concepts and codes it defines) are represented in this resource instance.", 0, 1, this.content));
        children.add(new Property(SP_SUPPLEMENTS, "canonical(CodeSystem)", "The canonical URL of the code system that this code system supplement is adding designations and properties to.", 0, 1, this.supplements));
        children.add(new Property("count", "unsignedInt", "The total number of concepts defined by the code system. Where the code system has a compositional grammar, the basis of this count is defined by the system steward.", 0, 1, this.count));
        children.add(new Property("filter", "", "A filter that can be used in a value set compose statement when selecting concepts using a filter.", 0, Integer.MAX_VALUE, this.filter));
        children.add(new Property("property", "", "A property defines an additional slot through which additional information can be provided about a concept.", 0, Integer.MAX_VALUE, this.property));
        children.add(new Property("concept", "", "Concepts that are in the code system. The concept definitions are inherently hierarchical, but the definitions must be consulted to determine what the meanings of the hierarchical relationships are.", 0, Integer.MAX_VALUE, this.concept));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 116079: {
                return new Property(SP_URL, "uri", "An absolute URI that is used to identify this code system when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this code system is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the code system is stored on different servers. This is used in [Coding](datatypes.html#Coding).system.", 0, 1, this.url);
            }
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this code system when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 351608024: {
                return new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the code system when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the code system author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence. This is used in [Coding](datatypes.html#Coding).version.", 0, 1, this.version);
            }
            case 3373707: {
                return new Property(SP_NAME, "string", "A natural language name identifying the code system. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name);
            }
            case 110371416: {
                return new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the code system.", 0, 1, this.title);
            }
            case -892481550: {
                return new Property(SP_STATUS, SP_CODE, "The date (and optionally time) when the code system resource was created or revised.", 0, 1, this.status);
            }
            case -404562712: {
                return new Property("experimental", "boolean", "A Boolean value to indicate that this code system is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.", 0, 1, this.experimental);
            }
            case 3076014: {
                return new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the code system was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the code system changes.", 0, 1, this.date);
            }
            case 1447404028: {
                return new Property(SP_PUBLISHER, "string", "The name of the organization or individual that published the code system.", 0, 1, this.publisher);
            }
            case 951526432: {
                return new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact);
            }
            case -1724546052: {
                return new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the code system from a consumer's perspective.", 0, 1, this.description);
            }
            case -669707736: {
                return new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate code system instances.", 0, Integer.MAX_VALUE, this.useContext);
            }
            case -507075711: {
                return new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the code system is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction);
            }
            case -220463842: {
                return new Property("purpose", "markdown", "Explanation of why this code system is needed and why it has been designed as it has.", 0, 1, this.purpose);
            }
            case 1522889671: {
                return new Property("copyright", "markdown", "A copyright statement relating to the code system and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the code system.", 0, 1, this.copyright);
            }
            case -35616442: {
                return new Property("caseSensitive", "boolean", "If code comparison is case sensitive when codes within this system are compared to each other.", 0, 1, this.caseSensitive);
            }
            case -1410174671: {
                return new Property("valueSet", "canonical(ValueSet)", "Canonical reference to the value set that contains the entire code system.", 0, 1, this.valueSet);
            }
            case 1913078280: {
                return new Property("hierarchyMeaning", SP_CODE, "The meaning of the hierarchy of concepts as represented in this resource.", 0, 1, this.hierarchyMeaning);
            }
            case 1248023381: {
                return new Property("compositional", "boolean", "The code system defines a compositional (post-coordination) grammar.", 0, 1, this.compositional);
            }
            case 617270957: {
                return new Property("versionNeeded", "boolean", "This flag is used to signify that the code system does not commit to concept permanence across versions. If true, a version must be specified when referencing this code system.", 0, 1, this.versionNeeded);
            }
            case 951530617: {
                return new Property("content", SP_CODE, "The extent of the content of the code system (the concepts and codes it defines) are represented in this resource instance.", 0, 1, this.content);
            }
            case -596951334: {
                return new Property(SP_SUPPLEMENTS, "canonical(CodeSystem)", "The canonical URL of the code system that this code system supplement is adding designations and properties to.", 0, 1, this.supplements);
            }
            case 94851343: {
                return new Property("count", "unsignedInt", "The total number of concepts defined by the code system. Where the code system has a compositional grammar, the basis of this count is defined by the system steward.", 0, 1, this.count);
            }
            case -1274492040: {
                return new Property("filter", "", "A filter that can be used in a value set compose statement when selecting concepts using a filter.", 0, Integer.MAX_VALUE, this.filter);
            }
            case -993141291: {
                return new Property("property", "", "A property defines an additional slot through which additional information can be provided about a concept.", 0, Integer.MAX_VALUE, this.property);
            }
            case 951024232: {
                return new Property("concept", "", "Concepts that are in the code system. The concept definitions are inherently hierarchical, but the definitions must be consulted to determine what the meanings of the hierarchical relationships are.", 0, Integer.MAX_VALUE, this.concept);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.url;
                }
                return baseArray;
            }
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.version;
                }
                return baseArray;
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.name;
                }
                return baseArray;
            }
            case 110371416: {
                Base[] baseArray;
                if (this.title == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.title;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.status;
                }
                return baseArray;
            }
            case -404562712: {
                Base[] baseArray;
                if (this.experimental == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.experimental;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.date;
                }
                return baseArray;
            }
            case 1447404028: {
                Base[] baseArray;
                if (this.publisher == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.publisher;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.description;
                }
                return baseArray;
            }
            case -669707736: {
                return this.useContext == null ? new Base[]{} : this.useContext.toArray(new Base[this.useContext.size()]);
            }
            case -507075711: {
                return this.jurisdiction == null ? new Base[]{} : this.jurisdiction.toArray(new Base[this.jurisdiction.size()]);
            }
            case -220463842: {
                Base[] baseArray;
                if (this.purpose == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.purpose;
                }
                return baseArray;
            }
            case 1522889671: {
                Base[] baseArray;
                if (this.copyright == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.copyright;
                }
                return baseArray;
            }
            case -35616442: {
                Base[] baseArray;
                if (this.caseSensitive == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.caseSensitive;
                }
                return baseArray;
            }
            case -1410174671: {
                Base[] baseArray;
                if (this.valueSet == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.valueSet;
                }
                return baseArray;
            }
            case 1913078280: {
                Base[] baseArray;
                if (this.hierarchyMeaning == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.hierarchyMeaning;
                }
                return baseArray;
            }
            case 1248023381: {
                Base[] baseArray;
                if (this.compositional == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray16 = new Base[1];
                    baseArray = baseArray16;
                    baseArray16[0] = this.compositional;
                }
                return baseArray;
            }
            case 617270957: {
                Base[] baseArray;
                if (this.versionNeeded == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray17 = new Base[1];
                    baseArray = baseArray17;
                    baseArray17[0] = this.versionNeeded;
                }
                return baseArray;
            }
            case 951530617: {
                Base[] baseArray;
                if (this.content == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray18 = new Base[1];
                    baseArray = baseArray18;
                    baseArray18[0] = this.content;
                }
                return baseArray;
            }
            case -596951334: {
                Base[] baseArray;
                if (this.supplements == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray19 = new Base[1];
                    baseArray = baseArray19;
                    baseArray19[0] = this.supplements;
                }
                return baseArray;
            }
            case 94851343: {
                Base[] baseArray;
                if (this.count == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray20 = new Base[1];
                    baseArray = baseArray20;
                    baseArray20[0] = this.count;
                }
                return baseArray;
            }
            case -1274492040: {
                return this.filter == null ? new Base[]{} : this.filter.toArray(new Base[this.filter.size()]);
            }
            case -993141291: {
                return this.property == null ? new Base[]{} : this.property.toArray(new Base[this.property.size()]);
            }
            case 951024232: {
                return this.concept == null ? new Base[]{} : this.concept.toArray(new Base[this.concept.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116079: {
                this.url = TypeConvertor.castToUri(value);
                return value;
            }
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case 351608024: {
                this.version = TypeConvertor.castToString(value);
                return value;
            }
            case 3373707: {
                this.name = TypeConvertor.castToString(value);
                return value;
            }
            case 110371416: {
                this.title = TypeConvertor.castToString(value);
                return value;
            }
            case -892481550: {
                value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case -404562712: {
                this.experimental = TypeConvertor.castToBoolean(value);
                return value;
            }
            case 3076014: {
                this.date = TypeConvertor.castToDateTime(value);
                return value;
            }
            case 1447404028: {
                this.publisher = TypeConvertor.castToString(value);
                return value;
            }
            case 951526432: {
                this.getContact().add(TypeConvertor.castToContactDetail(value));
                return value;
            }
            case -1724546052: {
                this.description = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case -669707736: {
                this.getUseContext().add(TypeConvertor.castToUsageContext(value));
                return value;
            }
            case -507075711: {
                this.getJurisdiction().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -220463842: {
                this.purpose = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case 1522889671: {
                this.copyright = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case -35616442: {
                this.caseSensitive = TypeConvertor.castToBoolean(value);
                return value;
            }
            case -1410174671: {
                this.valueSet = TypeConvertor.castToCanonical(value);
                return value;
            }
            case 1913078280: {
                value = new CodeSystemHierarchyMeaningEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.hierarchyMeaning = value;
                return value;
            }
            case 1248023381: {
                this.compositional = TypeConvertor.castToBoolean(value);
                return value;
            }
            case 617270957: {
                this.versionNeeded = TypeConvertor.castToBoolean(value);
                return value;
            }
            case 951530617: {
                value = new CodeSystemContentModeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.content = value;
                return value;
            }
            case -596951334: {
                this.supplements = TypeConvertor.castToCanonical(value);
                return value;
            }
            case 94851343: {
                this.count = TypeConvertor.castToUnsignedInt(value);
                return value;
            }
            case -1274492040: {
                this.getFilter().add((CodeSystemFilterComponent)((Object)value));
                return value;
            }
            case -993141291: {
                this.getProperty().add((PropertyComponent)((Object)value));
                return value;
            }
            case 951024232: {
                this.getConcept().add((ConceptDefinitionComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = TypeConvertor.castToUri(value);
        } else if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_VERSION)) {
            this.version = TypeConvertor.castToString(value);
        } else if (name.equals(SP_NAME)) {
            this.name = TypeConvertor.castToString(value);
        } else if (name.equals(SP_TITLE)) {
            this.title = TypeConvertor.castToString(value);
        } else if (name.equals(SP_STATUS)) {
            value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("experimental")) {
            this.experimental = TypeConvertor.castToBoolean(value);
        } else if (name.equals(SP_DATE)) {
            this.date = TypeConvertor.castToDateTime(value);
        } else if (name.equals(SP_PUBLISHER)) {
            this.publisher = TypeConvertor.castToString(value);
        } else if (name.equals("contact")) {
            this.getContact().add(TypeConvertor.castToContactDetail(value));
        } else if (name.equals(SP_DESCRIPTION)) {
            this.description = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("useContext")) {
            this.getUseContext().add(TypeConvertor.castToUsageContext(value));
        } else if (name.equals(SP_JURISDICTION)) {
            this.getJurisdiction().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("purpose")) {
            this.purpose = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("copyright")) {
            this.copyright = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("caseSensitive")) {
            this.caseSensitive = TypeConvertor.castToBoolean(value);
        } else if (name.equals("valueSet")) {
            this.valueSet = TypeConvertor.castToCanonical(value);
        } else if (name.equals("hierarchyMeaning")) {
            value = new CodeSystemHierarchyMeaningEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.hierarchyMeaning = value;
        } else if (name.equals("compositional")) {
            this.compositional = TypeConvertor.castToBoolean(value);
        } else if (name.equals("versionNeeded")) {
            this.versionNeeded = TypeConvertor.castToBoolean(value);
        } else if (name.equals("content")) {
            value = new CodeSystemContentModeEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.content = value;
        } else if (name.equals(SP_SUPPLEMENTS)) {
            this.supplements = TypeConvertor.castToCanonical(value);
        } else if (name.equals("count")) {
            this.count = TypeConvertor.castToUnsignedInt(value);
        } else if (name.equals("filter")) {
            this.getFilter().add((CodeSystemFilterComponent)((Object)value));
        } else if (name.equals("property")) {
            this.getProperty().add((PropertyComponent)((Object)value));
        } else if (name.equals("concept")) {
            this.getConcept().add((ConceptDefinitionComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return this.getUrlElement();
            }
            case -1618432855: {
                return this.addIdentifier();
            }
            case 351608024: {
                return this.getVersionElement();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case 110371416: {
                return this.getTitleElement();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -404562712: {
                return this.getExperimentalElement();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case 1447404028: {
                return this.getPublisherElement();
            }
            case 951526432: {
                return this.addContact();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case -669707736: {
                return this.addUseContext();
            }
            case -507075711: {
                return this.addJurisdiction();
            }
            case -220463842: {
                return this.getPurposeElement();
            }
            case 1522889671: {
                return this.getCopyrightElement();
            }
            case -35616442: {
                return this.getCaseSensitiveElement();
            }
            case -1410174671: {
                return this.getValueSetElement();
            }
            case 1913078280: {
                return this.getHierarchyMeaningElement();
            }
            case 1248023381: {
                return this.getCompositionalElement();
            }
            case 617270957: {
                return this.getVersionNeededElement();
            }
            case 951530617: {
                return this.getContentElement();
            }
            case -596951334: {
                return this.getSupplementsElement();
            }
            case 94851343: {
                return this.getCountElement();
            }
            case -1274492040: {
                return this.addFilter();
            }
            case -993141291: {
                return this.addProperty();
            }
            case 951024232: {
                return this.addConcept();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return new String[]{"uri"};
            }
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 351608024: {
                return new String[]{"string"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case 110371416: {
                return new String[]{"string"};
            }
            case -892481550: {
                return new String[]{SP_CODE};
            }
            case -404562712: {
                return new String[]{"boolean"};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case 1447404028: {
                return new String[]{"string"};
            }
            case 951526432: {
                return new String[]{"ContactDetail"};
            }
            case -1724546052: {
                return new String[]{"markdown"};
            }
            case -669707736: {
                return new String[]{"UsageContext"};
            }
            case -507075711: {
                return new String[]{"CodeableConcept"};
            }
            case -220463842: {
                return new String[]{"markdown"};
            }
            case 1522889671: {
                return new String[]{"markdown"};
            }
            case -35616442: {
                return new String[]{"boolean"};
            }
            case -1410174671: {
                return new String[]{"canonical"};
            }
            case 1913078280: {
                return new String[]{SP_CODE};
            }
            case 1248023381: {
                return new String[]{"boolean"};
            }
            case 617270957: {
                return new String[]{"boolean"};
            }
            case 951530617: {
                return new String[]{SP_CODE};
            }
            case -596951334: {
                return new String[]{"canonical"};
            }
            case 94851343: {
                return new String[]{"unsignedInt"};
            }
            case -1274492040: {
                return new String[0];
            }
            case -993141291: {
                return new String[0];
            }
            case 951024232: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a primitive type CodeSystem.url");
        }
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_VERSION)) {
            throw new FHIRException("Cannot call addChild on a primitive type CodeSystem.version");
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a primitive type CodeSystem.name");
        }
        if (name.equals(SP_TITLE)) {
            throw new FHIRException("Cannot call addChild on a primitive type CodeSystem.title");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type CodeSystem.status");
        }
        if (name.equals("experimental")) {
            throw new FHIRException("Cannot call addChild on a primitive type CodeSystem.experimental");
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a primitive type CodeSystem.date");
        }
        if (name.equals(SP_PUBLISHER)) {
            throw new FHIRException("Cannot call addChild on a primitive type CodeSystem.publisher");
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals(SP_DESCRIPTION)) {
            throw new FHIRException("Cannot call addChild on a primitive type CodeSystem.description");
        }
        if (name.equals("useContext")) {
            return this.addUseContext();
        }
        if (name.equals(SP_JURISDICTION)) {
            return this.addJurisdiction();
        }
        if (name.equals("purpose")) {
            throw new FHIRException("Cannot call addChild on a primitive type CodeSystem.purpose");
        }
        if (name.equals("copyright")) {
            throw new FHIRException("Cannot call addChild on a primitive type CodeSystem.copyright");
        }
        if (name.equals("caseSensitive")) {
            throw new FHIRException("Cannot call addChild on a primitive type CodeSystem.caseSensitive");
        }
        if (name.equals("valueSet")) {
            throw new FHIRException("Cannot call addChild on a primitive type CodeSystem.valueSet");
        }
        if (name.equals("hierarchyMeaning")) {
            throw new FHIRException("Cannot call addChild on a primitive type CodeSystem.hierarchyMeaning");
        }
        if (name.equals("compositional")) {
            throw new FHIRException("Cannot call addChild on a primitive type CodeSystem.compositional");
        }
        if (name.equals("versionNeeded")) {
            throw new FHIRException("Cannot call addChild on a primitive type CodeSystem.versionNeeded");
        }
        if (name.equals("content")) {
            throw new FHIRException("Cannot call addChild on a primitive type CodeSystem.content");
        }
        if (name.equals(SP_SUPPLEMENTS)) {
            throw new FHIRException("Cannot call addChild on a primitive type CodeSystem.supplements");
        }
        if (name.equals("count")) {
            throw new FHIRException("Cannot call addChild on a primitive type CodeSystem.count");
        }
        if (name.equals("filter")) {
            return this.addFilter();
        }
        if (name.equals("property")) {
            return this.addProperty();
        }
        if (name.equals("concept")) {
            return this.addConcept();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "CodeSystem";
    }

    @Override
    public CodeSystem copy() {
        CodeSystem dst = new CodeSystem();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(CodeSystem dst) {
        super.copyValues(dst);
        UriType uriType = dst.url = this.url == null ? null : this.url.copy();
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.version = this.version == null ? null : this.version.copy();
        dst.name = this.name == null ? null : this.name.copy();
        dst.title = this.title == null ? null : this.title.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.experimental = this.experimental == null ? null : this.experimental.copy();
        dst.date = this.date == null ? null : this.date.copy();
        StringType stringType = dst.publisher = this.publisher == null ? null : this.publisher.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.contact) {
                dst.contact.add(contactDetail.copy());
            }
        }
        MarkdownType markdownType = dst.description = this.description == null ? null : this.description.copy();
        if (this.useContext != null) {
            dst.useContext = new ArrayList<UsageContext>();
            for (UsageContext usageContext : this.useContext) {
                dst.useContext.add(usageContext.copy());
            }
        }
        if (this.jurisdiction != null) {
            dst.jurisdiction = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.jurisdiction) {
                dst.jurisdiction.add(codeableConcept.copy());
            }
        }
        dst.purpose = this.purpose == null ? null : this.purpose.copy();
        dst.copyright = this.copyright == null ? null : this.copyright.copy();
        dst.caseSensitive = this.caseSensitive == null ? null : this.caseSensitive.copy();
        dst.valueSet = this.valueSet == null ? null : this.valueSet.copy();
        dst.hierarchyMeaning = this.hierarchyMeaning == null ? null : this.hierarchyMeaning.copy();
        dst.compositional = this.compositional == null ? null : this.compositional.copy();
        dst.versionNeeded = this.versionNeeded == null ? null : this.versionNeeded.copy();
        dst.content = this.content == null ? null : this.content.copy();
        dst.supplements = this.supplements == null ? null : this.supplements.copy();
        UnsignedIntType unsignedIntType = dst.count = this.count == null ? null : this.count.copy();
        if (this.filter != null) {
            dst.filter = new ArrayList<CodeSystemFilterComponent>();
            for (CodeSystemFilterComponent codeSystemFilterComponent : this.filter) {
                dst.filter.add(codeSystemFilterComponent.copy());
            }
        }
        if (this.property != null) {
            dst.property = new ArrayList<PropertyComponent>();
            for (PropertyComponent propertyComponent : this.property) {
                dst.property.add(propertyComponent.copy());
            }
        }
        if (this.concept != null) {
            dst.concept = new ArrayList<ConceptDefinitionComponent>();
            for (ConceptDefinitionComponent conceptDefinitionComponent : this.concept) {
                dst.concept.add(conceptDefinitionComponent.copy());
            }
        }
    }

    protected CodeSystem typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof CodeSystem)) {
            return false;
        }
        CodeSystem o = (CodeSystem)other_;
        return CodeSystem.compareDeep(this.url, o.url, true) && CodeSystem.compareDeep(this.identifier, o.identifier, true) && CodeSystem.compareDeep(this.version, o.version, true) && CodeSystem.compareDeep(this.name, o.name, true) && CodeSystem.compareDeep(this.title, o.title, true) && CodeSystem.compareDeep(this.status, o.status, true) && CodeSystem.compareDeep(this.experimental, o.experimental, true) && CodeSystem.compareDeep(this.date, o.date, true) && CodeSystem.compareDeep(this.publisher, o.publisher, true) && CodeSystem.compareDeep(this.contact, o.contact, true) && CodeSystem.compareDeep(this.description, o.description, true) && CodeSystem.compareDeep(this.useContext, o.useContext, true) && CodeSystem.compareDeep(this.jurisdiction, o.jurisdiction, true) && CodeSystem.compareDeep(this.purpose, o.purpose, true) && CodeSystem.compareDeep(this.copyright, o.copyright, true) && CodeSystem.compareDeep(this.caseSensitive, o.caseSensitive, true) && CodeSystem.compareDeep(this.valueSet, o.valueSet, true) && CodeSystem.compareDeep(this.hierarchyMeaning, o.hierarchyMeaning, true) && CodeSystem.compareDeep(this.compositional, o.compositional, true) && CodeSystem.compareDeep(this.versionNeeded, o.versionNeeded, true) && CodeSystem.compareDeep(this.content, o.content, true) && CodeSystem.compareDeep(this.supplements, o.supplements, true) && CodeSystem.compareDeep(this.count, o.count, true) && CodeSystem.compareDeep(this.filter, o.filter, true) && CodeSystem.compareDeep(this.property, o.property, true) && CodeSystem.compareDeep(this.concept, o.concept, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof CodeSystem)) {
            return false;
        }
        CodeSystem o = (CodeSystem)other_;
        return CodeSystem.compareValues(this.url, o.url, true) && CodeSystem.compareValues(this.version, o.version, true) && CodeSystem.compareValues(this.name, o.name, true) && CodeSystem.compareValues(this.title, o.title, true) && CodeSystem.compareValues(this.status, o.status, true) && CodeSystem.compareValues(this.experimental, o.experimental, true) && CodeSystem.compareValues(this.date, o.date, true) && CodeSystem.compareValues(this.publisher, o.publisher, true) && CodeSystem.compareValues(this.description, o.description, true) && CodeSystem.compareValues(this.purpose, o.purpose, true) && CodeSystem.compareValues(this.copyright, o.copyright, true) && CodeSystem.compareValues(this.caseSensitive, o.caseSensitive, true) && CodeSystem.compareValues(this.valueSet, o.valueSet, true) && CodeSystem.compareValues(this.hierarchyMeaning, o.hierarchyMeaning, true) && CodeSystem.compareValues(this.compositional, o.compositional, true) && CodeSystem.compareValues(this.versionNeeded, o.versionNeeded, true) && CodeSystem.compareValues(this.content, o.content, true) && CodeSystem.compareValues(this.supplements, o.supplements, true) && CodeSystem.compareValues(this.count, o.count, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty(this.url, this.identifier, this.version, this.name, this.title, this.status, this.experimental, this.date, this.publisher, this.contact, this.description, this.useContext, this.jurisdiction, this.purpose, this.copyright, this.caseSensitive, this.valueSet, this.hierarchyMeaning, this.compositional, this.versionNeeded, this.content, this.supplements, this.count, this.filter, this.property, this.concept);
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.CodeSystem;
    }

    public PropertyComponent getProperty(String code) {
        for (PropertyComponent pd : this.getProperty()) {
            if (!pd.getCode().equalsIgnoreCase(code)) continue;
            return pd;
        }
        return null;
    }

    public ConceptDefinitionComponent getDefinitionByCode(String code) {
        return this.getDefinitionByCode(this.getConcept(), code);
    }

    private ConceptDefinitionComponent getDefinitionByCode(List<ConceptDefinitionComponent> list, String code) {
        for (ConceptDefinitionComponent t : list) {
            if (code.equals(t.getCode())) {
                return t;
            }
            ConceptDefinitionComponent cc = this.getDefinitionByCode(t.getConcept(), code);
            if (cc == null) continue;
            return cc;
        }
        return null;
    }

    @Block
    public static class ConceptPropertyComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Reference to CodeSystem.property.code", formalDefinition="A code that is a reference to CodeSystem.property.code.")
        protected CodeType code;
        @Child(name="value", type={CodeType.class, Coding.class, StringType.class, IntegerType.class, BooleanType.class, DateTimeType.class, DecimalType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Value of the property for this concept", formalDefinition="The value of this property.")
        protected DataType value;
        private static final long serialVersionUID = -422546419L;

        public ConceptPropertyComponent() {
        }

        public ConceptPropertyComponent(String code, DataType value) {
            this.setCode(code);
            this.setValue(value);
        }

        public CodeType getCodeElement() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptPropertyComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeType();
                }
            }
            return this.code;
        }

        public boolean hasCodeElement() {
            return this.code != null && !this.code.isEmpty();
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public ConceptPropertyComponent setCodeElement(CodeType value) {
            this.code = value;
            return this;
        }

        public String getCode() {
            return this.code == null ? null : (String)this.code.getValue();
        }

        public ConceptPropertyComponent setCode(String value) {
            if (this.code == null) {
                this.code = new CodeType();
            }
            this.code.setValue(value);
            return this;
        }

        public DataType getValue() {
            return this.value;
        }

        public CodeType getValueCodeType() throws FHIRException {
            if (this.value == null) {
                this.value = new CodeType();
            }
            if (!(this.value instanceof CodeType)) {
                throw new FHIRException("Type mismatch: the type CodeType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (CodeType)this.value;
        }

        public boolean hasValueCodeType() {
            return this != null && this.value instanceof CodeType;
        }

        public Coding getValueCoding() throws FHIRException {
            if (this.value == null) {
                this.value = new Coding();
            }
            if (!(this.value instanceof Coding)) {
                throw new FHIRException("Type mismatch: the type Coding was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Coding)this.value;
        }

        public boolean hasValueCoding() {
            return this != null && this.value instanceof Coding;
        }

        public StringType getValueStringType() throws FHIRException {
            if (this.value == null) {
                this.value = new StringType();
            }
            if (!(this.value instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (StringType)this.value;
        }

        public boolean hasValueStringType() {
            return this != null && this.value instanceof StringType;
        }

        public IntegerType getValueIntegerType() throws FHIRException {
            if (this.value == null) {
                this.value = new IntegerType();
            }
            if (!(this.value instanceof IntegerType)) {
                throw new FHIRException("Type mismatch: the type IntegerType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (IntegerType)this.value;
        }

        public boolean hasValueIntegerType() {
            return this != null && this.value instanceof IntegerType;
        }

        public BooleanType getValueBooleanType() throws FHIRException {
            if (this.value == null) {
                this.value = new BooleanType();
            }
            if (!(this.value instanceof BooleanType)) {
                throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (BooleanType)this.value;
        }

        public boolean hasValueBooleanType() {
            return this != null && this.value instanceof BooleanType;
        }

        public DateTimeType getValueDateTimeType() throws FHIRException {
            if (this.value == null) {
                this.value = new DateTimeType();
            }
            if (!(this.value instanceof DateTimeType)) {
                throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (DateTimeType)this.value;
        }

        public boolean hasValueDateTimeType() {
            return this != null && this.value instanceof DateTimeType;
        }

        public DecimalType getValueDecimalType() throws FHIRException {
            if (this.value == null) {
                this.value = new DecimalType();
            }
            if (!(this.value instanceof DecimalType)) {
                throw new FHIRException("Type mismatch: the type DecimalType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (DecimalType)this.value;
        }

        public boolean hasValueDecimalType() {
            return this != null && this.value instanceof DecimalType;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public ConceptPropertyComponent setValue(DataType value) {
            if (!(value == null || value instanceof CodeType || value instanceof Coding || value instanceof StringType || value instanceof IntegerType || value instanceof BooleanType || value instanceof DateTimeType || value instanceof DecimalType)) {
                throw new Error("Not the right type for CodeSystem.concept.property.value[x]: " + value.fhirType());
            }
            this.value = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(CodeSystem.SP_CODE, CodeSystem.SP_CODE, "A code that is a reference to CodeSystem.property.code.", 0, 1, this.code));
            children.add(new Property("value[x]", "code|Coding|string|integer|boolean|dateTime|decimal", "The value of this property.", 0, 1, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property(CodeSystem.SP_CODE, CodeSystem.SP_CODE, "A code that is a reference to CodeSystem.property.code.", 0, 1, this.code);
                }
                case -1410166417: {
                    return new Property("value[x]", "code|Coding|string|integer|boolean|dateTime|decimal", "The value of this property.", 0, 1, this.value);
                }
                case 111972721: {
                    return new Property("value[x]", "code|Coding|string|integer|boolean|dateTime|decimal", "The value of this property.", 0, 1, this.value);
                }
                case -766209282: {
                    return new Property("value[x]", CodeSystem.SP_CODE, "The value of this property.", 0, 1, this.value);
                }
                case -1887705029: {
                    return new Property("value[x]", "Coding", "The value of this property.", 0, 1, this.value);
                }
                case -1424603934: {
                    return new Property("value[x]", "string", "The value of this property.", 0, 1, this.value);
                }
                case -1668204915: {
                    return new Property("value[x]", "integer", "The value of this property.", 0, 1, this.value);
                }
                case 733421943: {
                    return new Property("value[x]", "boolean", "The value of this property.", 0, 1, this.value);
                }
                case 1047929900: {
                    return new Property("value[x]", "dateTime", "The value of this property.", 0, 1, this.value);
                }
                case -2083993440: {
                    return new Property("value[x]", "decimal", "The value of this property.", 0, 1, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = TypeConvertor.castToCode(value);
                    return value;
                }
                case 111972721: {
                    this.value = TypeConvertor.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(CodeSystem.SP_CODE)) {
                this.code = TypeConvertor.castToCode(value);
            } else if (name.equals("value[x]")) {
                this.value = TypeConvertor.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCodeElement();
                }
                case -1410166417: {
                    return this.getValue();
                }
                case 111972721: {
                    return this.getValue();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{CodeSystem.SP_CODE};
                }
                case 111972721: {
                    return new String[]{CodeSystem.SP_CODE, "Coding", "string", "integer", "boolean", "dateTime", "decimal"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(CodeSystem.SP_CODE)) {
                throw new FHIRException("Cannot call addChild on a primitive type CodeSystem.concept.property.code");
            }
            if (name.equals("valueCode")) {
                this.value = new CodeType();
                return this.value;
            }
            if (name.equals("valueCoding")) {
                this.value = new Coding();
                return this.value;
            }
            if (name.equals("valueString")) {
                this.value = new StringType();
                return this.value;
            }
            if (name.equals("valueInteger")) {
                this.value = new IntegerType();
                return this.value;
            }
            if (name.equals("valueBoolean")) {
                this.value = new BooleanType();
                return this.value;
            }
            if (name.equals("valueDateTime")) {
                this.value = new DateTimeType();
                return this.value;
            }
            if (name.equals("valueDecimal")) {
                this.value = new DecimalType();
                return this.value;
            }
            return super.addChild(name);
        }

        @Override
        public ConceptPropertyComponent copy() {
            ConceptPropertyComponent dst = new ConceptPropertyComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ConceptPropertyComponent dst) {
            super.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.value = this.value == null ? null : this.value.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ConceptPropertyComponent)) {
                return false;
            }
            ConceptPropertyComponent o = (ConceptPropertyComponent)other_;
            return ConceptPropertyComponent.compareDeep(this.code, o.code, true) && ConceptPropertyComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ConceptPropertyComponent)) {
                return false;
            }
            ConceptPropertyComponent o = (ConceptPropertyComponent)other_;
            return ConceptPropertyComponent.compareValues(this.code, o.code, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.code, this.value);
        }

        @Override
        public String fhirType() {
            return "CodeSystem.concept.property";
        }
    }

    @Block
    public static class ConceptDefinitionDesignationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="language", type={CodeType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Human language of the designation", formalDefinition="The language this designation is defined for.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/languages")
        protected CodeType language;
        @Child(name="use", type={Coding.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Details how this designation would be used", formalDefinition="A code that details how this designation would be used.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/designation-use")
        protected Coding use;
        @Child(name="value", type={StringType.class}, order=3, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The text value for this designation", formalDefinition="The text value for this designation.")
        protected StringType value;
        private static final long serialVersionUID = 1515662414L;

        public ConceptDefinitionDesignationComponent() {
        }

        public ConceptDefinitionDesignationComponent(String value) {
            this.setValue(value);
        }

        public CodeType getLanguageElement() {
            if (this.language == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptDefinitionDesignationComponent.language");
                }
                if (Configuration.doAutoCreate()) {
                    this.language = new CodeType();
                }
            }
            return this.language;
        }

        public boolean hasLanguageElement() {
            return this.language != null && !this.language.isEmpty();
        }

        public boolean hasLanguage() {
            return this.language != null && !this.language.isEmpty();
        }

        public ConceptDefinitionDesignationComponent setLanguageElement(CodeType value) {
            this.language = value;
            return this;
        }

        public String getLanguage() {
            return this.language == null ? null : (String)this.language.getValue();
        }

        public ConceptDefinitionDesignationComponent setLanguage(String value) {
            if (Utilities.noString(value)) {
                this.language = null;
            } else {
                if (this.language == null) {
                    this.language = new CodeType();
                }
                this.language.setValue(value);
            }
            return this;
        }

        public Coding getUse() {
            if (this.use == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptDefinitionDesignationComponent.use");
                }
                if (Configuration.doAutoCreate()) {
                    this.use = new Coding();
                }
            }
            return this.use;
        }

        public boolean hasUse() {
            return this.use != null && !this.use.isEmpty();
        }

        public ConceptDefinitionDesignationComponent setUse(Coding value) {
            this.use = value;
            return this;
        }

        public StringType getValueElement() {
            if (this.value == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptDefinitionDesignationComponent.value");
                }
                if (Configuration.doAutoCreate()) {
                    this.value = new StringType();
                }
            }
            return this.value;
        }

        public boolean hasValueElement() {
            return this.value != null && !this.value.isEmpty();
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public ConceptDefinitionDesignationComponent setValueElement(StringType value) {
            this.value = value;
            return this;
        }

        public String getValue() {
            return this.value == null ? null : (String)this.value.getValue();
        }

        public ConceptDefinitionDesignationComponent setValue(String value) {
            if (this.value == null) {
                this.value = new StringType();
            }
            this.value.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(CodeSystem.SP_LANGUAGE, CodeSystem.SP_CODE, "The language this designation is defined for.", 0, 1, this.language));
            children.add(new Property("use", "Coding", "A code that details how this designation would be used.", 0, 1, this.use));
            children.add(new Property("value", "string", "The text value for this designation.", 0, 1, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1613589672: {
                    return new Property(CodeSystem.SP_LANGUAGE, CodeSystem.SP_CODE, "The language this designation is defined for.", 0, 1, this.language);
                }
                case 116103: {
                    return new Property("use", "Coding", "A code that details how this designation would be used.", 0, 1, this.use);
                }
                case 111972721: {
                    return new Property("value", "string", "The text value for this designation.", 0, 1, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1613589672: {
                    Base[] baseArray;
                    if (this.language == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.language;
                    }
                    return baseArray;
                }
                case 116103: {
                    Base[] baseArray;
                    if (this.use == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.use;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1613589672: {
                    this.language = TypeConvertor.castToCode(value);
                    return value;
                }
                case 116103: {
                    this.use = TypeConvertor.castToCoding(value);
                    return value;
                }
                case 111972721: {
                    this.value = TypeConvertor.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(CodeSystem.SP_LANGUAGE)) {
                this.language = TypeConvertor.castToCode(value);
            } else if (name.equals("use")) {
                this.use = TypeConvertor.castToCoding(value);
            } else if (name.equals("value")) {
                this.value = TypeConvertor.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1613589672: {
                    return this.getLanguageElement();
                }
                case 116103: {
                    return this.getUse();
                }
                case 111972721: {
                    return this.getValueElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1613589672: {
                    return new String[]{CodeSystem.SP_CODE};
                }
                case 116103: {
                    return new String[]{"Coding"};
                }
                case 111972721: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(CodeSystem.SP_LANGUAGE)) {
                throw new FHIRException("Cannot call addChild on a primitive type CodeSystem.concept.designation.language");
            }
            if (name.equals("use")) {
                this.use = new Coding();
                return this.use;
            }
            if (name.equals("value")) {
                throw new FHIRException("Cannot call addChild on a primitive type CodeSystem.concept.designation.value");
            }
            return super.addChild(name);
        }

        @Override
        public ConceptDefinitionDesignationComponent copy() {
            ConceptDefinitionDesignationComponent dst = new ConceptDefinitionDesignationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ConceptDefinitionDesignationComponent dst) {
            super.copyValues(dst);
            dst.language = this.language == null ? null : this.language.copy();
            dst.use = this.use == null ? null : this.use.copy();
            dst.value = this.value == null ? null : this.value.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ConceptDefinitionDesignationComponent)) {
                return false;
            }
            ConceptDefinitionDesignationComponent o = (ConceptDefinitionDesignationComponent)other_;
            return ConceptDefinitionDesignationComponent.compareDeep(this.language, o.language, true) && ConceptDefinitionDesignationComponent.compareDeep(this.use, o.use, true) && ConceptDefinitionDesignationComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ConceptDefinitionDesignationComponent)) {
                return false;
            }
            ConceptDefinitionDesignationComponent o = (ConceptDefinitionDesignationComponent)other_;
            return ConceptDefinitionDesignationComponent.compareValues(this.language, o.language, true) && ConceptDefinitionDesignationComponent.compareValues(this.value, o.value, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.language, this.use, this.value);
        }

        @Override
        public String fhirType() {
            return "CodeSystem.concept.designation";
        }
    }

    @Block
    public static class ConceptDefinitionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Code that identifies concept", formalDefinition="A code - a text symbol - that uniquely identifies the concept within the code system.")
        protected CodeType code;
        @Child(name="display", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Text to display to the user", formalDefinition="A human readable string that is the recommended default way to present this concept to a user.")
        protected StringType display;
        @Child(name="definition", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Formal definition", formalDefinition="The formal definition of the concept. The code system resource does not make formal definitions required, because of the prevalence of legacy systems. However, they are highly recommended, as without them there is no formal meaning associated with the concept.")
        protected StringType definition;
        @Child(name="designation", type={}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Additional representations for the concept", formalDefinition="Additional representations for the concept - other languages, aliases, specialized purposes, used for particular purposes, etc.")
        protected List<ConceptDefinitionDesignationComponent> designation;
        @Child(name="property", type={}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Property value for the concept", formalDefinition="A property value for this concept.")
        protected List<ConceptPropertyComponent> property;
        @Child(name="concept", type={ConceptDefinitionComponent.class}, order=6, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Child Concepts (is-a/contains/categorizes)", formalDefinition="Defines children of a concept to produce a hierarchy of concepts. The nature of the relationships is variable (is-a/contains/categorizes) - see hierarchyMeaning.")
        protected List<ConceptDefinitionComponent> concept;
        private static final long serialVersionUID = 878320988L;

        public ConceptDefinitionComponent() {
        }

        public ConceptDefinitionComponent(String code) {
            this.setCode(code);
        }

        public CodeType getCodeElement() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptDefinitionComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeType();
                }
            }
            return this.code;
        }

        public boolean hasCodeElement() {
            return this.code != null && !this.code.isEmpty();
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public ConceptDefinitionComponent setCodeElement(CodeType value) {
            this.code = value;
            return this;
        }

        public String getCode() {
            return this.code == null ? null : (String)this.code.getValue();
        }

        public ConceptDefinitionComponent setCode(String value) {
            if (this.code == null) {
                this.code = new CodeType();
            }
            this.code.setValue(value);
            return this;
        }

        public StringType getDisplayElement() {
            if (this.display == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptDefinitionComponent.display");
                }
                if (Configuration.doAutoCreate()) {
                    this.display = new StringType();
                }
            }
            return this.display;
        }

        public boolean hasDisplayElement() {
            return this.display != null && !this.display.isEmpty();
        }

        public boolean hasDisplay() {
            return this.display != null && !this.display.isEmpty();
        }

        public ConceptDefinitionComponent setDisplayElement(StringType value) {
            this.display = value;
            return this;
        }

        public String getDisplay() {
            return this.display == null ? null : (String)this.display.getValue();
        }

        public ConceptDefinitionComponent setDisplay(String value) {
            if (Utilities.noString(value)) {
                this.display = null;
            } else {
                if (this.display == null) {
                    this.display = new StringType();
                }
                this.display.setValue(value);
            }
            return this;
        }

        public StringType getDefinitionElement() {
            if (this.definition == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptDefinitionComponent.definition");
                }
                if (Configuration.doAutoCreate()) {
                    this.definition = new StringType();
                }
            }
            return this.definition;
        }

        public boolean hasDefinitionElement() {
            return this.definition != null && !this.definition.isEmpty();
        }

        public boolean hasDefinition() {
            return this.definition != null && !this.definition.isEmpty();
        }

        public ConceptDefinitionComponent setDefinitionElement(StringType value) {
            this.definition = value;
            return this;
        }

        public String getDefinition() {
            return this.definition == null ? null : (String)this.definition.getValue();
        }

        public ConceptDefinitionComponent setDefinition(String value) {
            if (Utilities.noString(value)) {
                this.definition = null;
            } else {
                if (this.definition == null) {
                    this.definition = new StringType();
                }
                this.definition.setValue(value);
            }
            return this;
        }

        public List<ConceptDefinitionDesignationComponent> getDesignation() {
            if (this.designation == null) {
                this.designation = new ArrayList<ConceptDefinitionDesignationComponent>();
            }
            return this.designation;
        }

        public ConceptDefinitionComponent setDesignation(List<ConceptDefinitionDesignationComponent> theDesignation) {
            this.designation = theDesignation;
            return this;
        }

        public boolean hasDesignation() {
            if (this.designation == null) {
                return false;
            }
            for (ConceptDefinitionDesignationComponent item : this.designation) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ConceptDefinitionDesignationComponent addDesignation() {
            ConceptDefinitionDesignationComponent t = new ConceptDefinitionDesignationComponent();
            if (this.designation == null) {
                this.designation = new ArrayList<ConceptDefinitionDesignationComponent>();
            }
            this.designation.add(t);
            return t;
        }

        public ConceptDefinitionComponent addDesignation(ConceptDefinitionDesignationComponent t) {
            if (t == null) {
                return this;
            }
            if (this.designation == null) {
                this.designation = new ArrayList<ConceptDefinitionDesignationComponent>();
            }
            this.designation.add(t);
            return this;
        }

        public ConceptDefinitionDesignationComponent getDesignationFirstRep() {
            if (this.getDesignation().isEmpty()) {
                this.addDesignation();
            }
            return this.getDesignation().get(0);
        }

        public List<ConceptPropertyComponent> getProperty() {
            if (this.property == null) {
                this.property = new ArrayList<ConceptPropertyComponent>();
            }
            return this.property;
        }

        public ConceptDefinitionComponent setProperty(List<ConceptPropertyComponent> theProperty) {
            this.property = theProperty;
            return this;
        }

        public boolean hasProperty() {
            if (this.property == null) {
                return false;
            }
            for (ConceptPropertyComponent item : this.property) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ConceptPropertyComponent addProperty() {
            ConceptPropertyComponent t = new ConceptPropertyComponent();
            if (this.property == null) {
                this.property = new ArrayList<ConceptPropertyComponent>();
            }
            this.property.add(t);
            return t;
        }

        public ConceptDefinitionComponent addProperty(ConceptPropertyComponent t) {
            if (t == null) {
                return this;
            }
            if (this.property == null) {
                this.property = new ArrayList<ConceptPropertyComponent>();
            }
            this.property.add(t);
            return this;
        }

        public ConceptPropertyComponent getPropertyFirstRep() {
            if (this.getProperty().isEmpty()) {
                this.addProperty();
            }
            return this.getProperty().get(0);
        }

        public List<ConceptDefinitionComponent> getConcept() {
            if (this.concept == null) {
                this.concept = new ArrayList<ConceptDefinitionComponent>();
            }
            return this.concept;
        }

        public ConceptDefinitionComponent setConcept(List<ConceptDefinitionComponent> theConcept) {
            this.concept = theConcept;
            return this;
        }

        public boolean hasConcept() {
            if (this.concept == null) {
                return false;
            }
            for (ConceptDefinitionComponent item : this.concept) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ConceptDefinitionComponent addConcept() {
            ConceptDefinitionComponent t = new ConceptDefinitionComponent();
            if (this.concept == null) {
                this.concept = new ArrayList<ConceptDefinitionComponent>();
            }
            this.concept.add(t);
            return t;
        }

        public ConceptDefinitionComponent addConcept(ConceptDefinitionComponent t) {
            if (t == null) {
                return this;
            }
            if (this.concept == null) {
                this.concept = new ArrayList<ConceptDefinitionComponent>();
            }
            this.concept.add(t);
            return this;
        }

        public ConceptDefinitionComponent getConceptFirstRep() {
            if (this.getConcept().isEmpty()) {
                this.addConcept();
            }
            return this.getConcept().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(CodeSystem.SP_CODE, CodeSystem.SP_CODE, "A code - a text symbol - that uniquely identifies the concept within the code system.", 0, 1, this.code));
            children.add(new Property("display", "string", "A human readable string that is the recommended default way to present this concept to a user.", 0, 1, this.display));
            children.add(new Property("definition", "string", "The formal definition of the concept. The code system resource does not make formal definitions required, because of the prevalence of legacy systems. However, they are highly recommended, as without them there is no formal meaning associated with the concept.", 0, 1, this.definition));
            children.add(new Property("designation", "", "Additional representations for the concept - other languages, aliases, specialized purposes, used for particular purposes, etc.", 0, Integer.MAX_VALUE, this.designation));
            children.add(new Property("property", "", "A property value for this concept.", 0, Integer.MAX_VALUE, this.property));
            children.add(new Property("concept", "@CodeSystem.concept", "Defines children of a concept to produce a hierarchy of concepts. The nature of the relationships is variable (is-a/contains/categorizes) - see hierarchyMeaning.", 0, Integer.MAX_VALUE, this.concept));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property(CodeSystem.SP_CODE, CodeSystem.SP_CODE, "A code - a text symbol - that uniquely identifies the concept within the code system.", 0, 1, this.code);
                }
                case 1671764162: {
                    return new Property("display", "string", "A human readable string that is the recommended default way to present this concept to a user.", 0, 1, this.display);
                }
                case -1014418093: {
                    return new Property("definition", "string", "The formal definition of the concept. The code system resource does not make formal definitions required, because of the prevalence of legacy systems. However, they are highly recommended, as without them there is no formal meaning associated with the concept.", 0, 1, this.definition);
                }
                case -900931593: {
                    return new Property("designation", "", "Additional representations for the concept - other languages, aliases, specialized purposes, used for particular purposes, etc.", 0, Integer.MAX_VALUE, this.designation);
                }
                case -993141291: {
                    return new Property("property", "", "A property value for this concept.", 0, Integer.MAX_VALUE, this.property);
                }
                case 951024232: {
                    return new Property("concept", "@CodeSystem.concept", "Defines children of a concept to produce a hierarchy of concepts. The nature of the relationships is variable (is-a/contains/categorizes) - see hierarchyMeaning.", 0, Integer.MAX_VALUE, this.concept);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case 1671764162: {
                    Base[] baseArray;
                    if (this.display == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.display;
                    }
                    return baseArray;
                }
                case -1014418093: {
                    Base[] baseArray;
                    if (this.definition == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.definition;
                    }
                    return baseArray;
                }
                case -900931593: {
                    return this.designation == null ? new Base[]{} : this.designation.toArray(new Base[this.designation.size()]);
                }
                case -993141291: {
                    return this.property == null ? new Base[]{} : this.property.toArray(new Base[this.property.size()]);
                }
                case 951024232: {
                    return this.concept == null ? new Base[]{} : this.concept.toArray(new Base[this.concept.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = TypeConvertor.castToCode(value);
                    return value;
                }
                case 1671764162: {
                    this.display = TypeConvertor.castToString(value);
                    return value;
                }
                case -1014418093: {
                    this.definition = TypeConvertor.castToString(value);
                    return value;
                }
                case -900931593: {
                    this.getDesignation().add((ConceptDefinitionDesignationComponent)value);
                    return value;
                }
                case -993141291: {
                    this.getProperty().add((ConceptPropertyComponent)value);
                    return value;
                }
                case 951024232: {
                    this.getConcept().add((ConceptDefinitionComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(CodeSystem.SP_CODE)) {
                this.code = TypeConvertor.castToCode(value);
            } else if (name.equals("display")) {
                this.display = TypeConvertor.castToString(value);
            } else if (name.equals("definition")) {
                this.definition = TypeConvertor.castToString(value);
            } else if (name.equals("designation")) {
                this.getDesignation().add((ConceptDefinitionDesignationComponent)value);
            } else if (name.equals("property")) {
                this.getProperty().add((ConceptPropertyComponent)value);
            } else if (name.equals("concept")) {
                this.getConcept().add((ConceptDefinitionComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCodeElement();
                }
                case 1671764162: {
                    return this.getDisplayElement();
                }
                case -1014418093: {
                    return this.getDefinitionElement();
                }
                case -900931593: {
                    return this.addDesignation();
                }
                case -993141291: {
                    return this.addProperty();
                }
                case 951024232: {
                    return this.addConcept();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{CodeSystem.SP_CODE};
                }
                case 1671764162: {
                    return new String[]{"string"};
                }
                case -1014418093: {
                    return new String[]{"string"};
                }
                case -900931593: {
                    return new String[0];
                }
                case -993141291: {
                    return new String[0];
                }
                case 951024232: {
                    return new String[]{"@CodeSystem.concept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(CodeSystem.SP_CODE)) {
                throw new FHIRException("Cannot call addChild on a primitive type CodeSystem.concept.code");
            }
            if (name.equals("display")) {
                throw new FHIRException("Cannot call addChild on a primitive type CodeSystem.concept.display");
            }
            if (name.equals("definition")) {
                throw new FHIRException("Cannot call addChild on a primitive type CodeSystem.concept.definition");
            }
            if (name.equals("designation")) {
                return this.addDesignation();
            }
            if (name.equals("property")) {
                return this.addProperty();
            }
            if (name.equals("concept")) {
                return this.addConcept();
            }
            return super.addChild(name);
        }

        @Override
        public ConceptDefinitionComponent copy() {
            ConceptDefinitionComponent dst = new ConceptDefinitionComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ConceptDefinitionComponent dst) {
            super.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.display = this.display == null ? null : this.display.copy();
            StringType stringType = dst.definition = this.definition == null ? null : this.definition.copy();
            if (this.designation != null) {
                dst.designation = new ArrayList<ConceptDefinitionDesignationComponent>();
                for (ConceptDefinitionDesignationComponent conceptDefinitionDesignationComponent : this.designation) {
                    dst.designation.add(conceptDefinitionDesignationComponent.copy());
                }
            }
            if (this.property != null) {
                dst.property = new ArrayList<ConceptPropertyComponent>();
                for (ConceptPropertyComponent conceptPropertyComponent : this.property) {
                    dst.property.add(conceptPropertyComponent.copy());
                }
            }
            if (this.concept != null) {
                dst.concept = new ArrayList<ConceptDefinitionComponent>();
                for (ConceptDefinitionComponent conceptDefinitionComponent : this.concept) {
                    dst.concept.add(conceptDefinitionComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ConceptDefinitionComponent)) {
                return false;
            }
            ConceptDefinitionComponent o = (ConceptDefinitionComponent)other_;
            return ConceptDefinitionComponent.compareDeep(this.code, o.code, true) && ConceptDefinitionComponent.compareDeep(this.display, o.display, true) && ConceptDefinitionComponent.compareDeep(this.definition, o.definition, true) && ConceptDefinitionComponent.compareDeep(this.designation, o.designation, true) && ConceptDefinitionComponent.compareDeep(this.property, o.property, true) && ConceptDefinitionComponent.compareDeep(this.concept, o.concept, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ConceptDefinitionComponent)) {
                return false;
            }
            ConceptDefinitionComponent o = (ConceptDefinitionComponent)other_;
            return ConceptDefinitionComponent.compareValues(this.code, o.code, true) && ConceptDefinitionComponent.compareValues(this.display, o.display, true) && ConceptDefinitionComponent.compareValues(this.definition, o.definition, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.code, this.display, this.definition, this.designation, this.property, this.concept);
        }

        @Override
        public String fhirType() {
            return "CodeSystem.concept";
        }

        public String toString() {
            return this.getCode() + ": " + this.getDisplay();
        }
    }

    @Block
    public static class PropertyComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Identifies the property on the concepts, and when referred to in operations", formalDefinition="A code that is used to identify the property. The code is used internally (in CodeSystem.concept.property.code) and also externally, such as in property filters.")
        protected CodeType code;
        @Child(name="uri", type={UriType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Formal identifier for the property", formalDefinition="Reference to the formal meaning of the property. One possible source of meaning is the [Concept Properties](codesystem-concept-properties.html) code system.")
        protected UriType uri;
        @Child(name="description", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Why the property is defined, and/or what it conveys", formalDefinition="A description of the property- why it is defined, and how its value might be used.")
        protected StringType description;
        @Child(name="type", type={CodeType.class}, order=4, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="code | Coding | string | integer | boolean | dateTime | decimal", formalDefinition="The type of the property value. Properties of type \"code\" contain a code defined by the code system (e.g. a reference to another defined concept).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/concept-property-type")
        protected Enumeration<PropertyType> type;
        private static final long serialVersionUID = -1810713373L;

        public PropertyComponent() {
        }

        public PropertyComponent(String code, PropertyType type) {
            this.setCode(code);
            this.setType(type);
        }

        public CodeType getCodeElement() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PropertyComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeType();
                }
            }
            return this.code;
        }

        public boolean hasCodeElement() {
            return this.code != null && !this.code.isEmpty();
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public PropertyComponent setCodeElement(CodeType value) {
            this.code = value;
            return this;
        }

        public String getCode() {
            return this.code == null ? null : (String)this.code.getValue();
        }

        public PropertyComponent setCode(String value) {
            if (this.code == null) {
                this.code = new CodeType();
            }
            this.code.setValue(value);
            return this;
        }

        public UriType getUriElement() {
            if (this.uri == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PropertyComponent.uri");
                }
                if (Configuration.doAutoCreate()) {
                    this.uri = new UriType();
                }
            }
            return this.uri;
        }

        public boolean hasUriElement() {
            return this.uri != null && !this.uri.isEmpty();
        }

        public boolean hasUri() {
            return this.uri != null && !this.uri.isEmpty();
        }

        public PropertyComponent setUriElement(UriType value) {
            this.uri = value;
            return this;
        }

        public String getUri() {
            return this.uri == null ? null : (String)this.uri.getValue();
        }

        public PropertyComponent setUri(String value) {
            if (Utilities.noString(value)) {
                this.uri = null;
            } else {
                if (this.uri == null) {
                    this.uri = new UriType();
                }
                this.uri.setValue(value);
            }
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PropertyComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public PropertyComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public PropertyComponent setDescription(String value) {
            if (Utilities.noString(value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public Enumeration<PropertyType> getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PropertyComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Enumeration<PropertyType>(new PropertyTypeEnumFactory());
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public PropertyComponent setTypeElement(Enumeration<PropertyType> value) {
            this.type = value;
            return this;
        }

        public PropertyType getType() {
            return this.type == null ? null : (PropertyType)((Object)this.type.getValue());
        }

        public PropertyComponent setType(PropertyType value) {
            if (this.type == null) {
                this.type = new Enumeration<PropertyType>(new PropertyTypeEnumFactory());
            }
            this.type.setValue((Object)value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(CodeSystem.SP_CODE, CodeSystem.SP_CODE, "A code that is used to identify the property. The code is used internally (in CodeSystem.concept.property.code) and also externally, such as in property filters.", 0, 1, this.code));
            children.add(new Property("uri", "uri", "Reference to the formal meaning of the property. One possible source of meaning is the [Concept Properties](codesystem-concept-properties.html) code system.", 0, 1, this.uri));
            children.add(new Property(CodeSystem.SP_DESCRIPTION, "string", "A description of the property- why it is defined, and how its value might be used.", 0, 1, this.description));
            children.add(new Property("type", CodeSystem.SP_CODE, "The type of the property value. Properties of type \"code\" contain a code defined by the code system (e.g. a reference to another defined concept).", 0, 1, this.type));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property(CodeSystem.SP_CODE, CodeSystem.SP_CODE, "A code that is used to identify the property. The code is used internally (in CodeSystem.concept.property.code) and also externally, such as in property filters.", 0, 1, this.code);
                }
                case 116076: {
                    return new Property("uri", "uri", "Reference to the formal meaning of the property. One possible source of meaning is the [Concept Properties](codesystem-concept-properties.html) code system.", 0, 1, this.uri);
                }
                case -1724546052: {
                    return new Property(CodeSystem.SP_DESCRIPTION, "string", "A description of the property- why it is defined, and how its value might be used.", 0, 1, this.description);
                }
                case 3575610: {
                    return new Property("type", CodeSystem.SP_CODE, "The type of the property value. Properties of type \"code\" contain a code defined by the code system (e.g. a reference to another defined concept).", 0, 1, this.type);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case 116076: {
                    Base[] baseArray;
                    if (this.uri == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.uri;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.description;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.type;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = TypeConvertor.castToCode(value);
                    return value;
                }
                case 116076: {
                    this.uri = TypeConvertor.castToUri(value);
                    return value;
                }
                case -1724546052: {
                    this.description = TypeConvertor.castToString(value);
                    return value;
                }
                case 3575610: {
                    value = new PropertyTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.type = value;
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(CodeSystem.SP_CODE)) {
                this.code = TypeConvertor.castToCode(value);
            } else if (name.equals("uri")) {
                this.uri = TypeConvertor.castToUri(value);
            } else if (name.equals(CodeSystem.SP_DESCRIPTION)) {
                this.description = TypeConvertor.castToString(value);
            } else if (name.equals("type")) {
                value = new PropertyTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.type = value;
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCodeElement();
                }
                case 116076: {
                    return this.getUriElement();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case 3575610: {
                    return this.getTypeElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{CodeSystem.SP_CODE};
                }
                case 116076: {
                    return new String[]{"uri"};
                }
                case -1724546052: {
                    return new String[]{"string"};
                }
                case 3575610: {
                    return new String[]{CodeSystem.SP_CODE};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(CodeSystem.SP_CODE)) {
                throw new FHIRException("Cannot call addChild on a primitive type CodeSystem.property.code");
            }
            if (name.equals("uri")) {
                throw new FHIRException("Cannot call addChild on a primitive type CodeSystem.property.uri");
            }
            if (name.equals(CodeSystem.SP_DESCRIPTION)) {
                throw new FHIRException("Cannot call addChild on a primitive type CodeSystem.property.description");
            }
            if (name.equals("type")) {
                throw new FHIRException("Cannot call addChild on a primitive type CodeSystem.property.type");
            }
            return super.addChild(name);
        }

        @Override
        public PropertyComponent copy() {
            PropertyComponent dst = new PropertyComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(PropertyComponent dst) {
            super.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.uri = this.uri == null ? null : this.uri.copy();
            dst.description = this.description == null ? null : this.description.copy();
            dst.type = this.type == null ? null : this.type.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof PropertyComponent)) {
                return false;
            }
            PropertyComponent o = (PropertyComponent)other_;
            return PropertyComponent.compareDeep(this.code, o.code, true) && PropertyComponent.compareDeep(this.uri, o.uri, true) && PropertyComponent.compareDeep(this.description, o.description, true) && PropertyComponent.compareDeep(this.type, o.type, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof PropertyComponent)) {
                return false;
            }
            PropertyComponent o = (PropertyComponent)other_;
            return PropertyComponent.compareValues(this.code, o.code, true) && PropertyComponent.compareValues(this.uri, o.uri, true) && PropertyComponent.compareValues(this.description, o.description, true) && PropertyComponent.compareValues(this.type, o.type, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.code, this.uri, this.description, this.type);
        }

        @Override
        public String fhirType() {
            return "CodeSystem.property";
        }
    }

    @Block
    public static class CodeSystemFilterComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Code that identifies the filter", formalDefinition="The code that identifies this filter when it is used as a filter in [ValueSet](valueset.html#).compose.include.filter.")
        protected CodeType code;
        @Child(name="description", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="How or why the filter is used", formalDefinition="A description of how or why the filter is used.")
        protected StringType description;
        @Child(name="operator", type={CodeType.class}, order=3, min=1, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="= | is-a | descendent-of | is-not-a | regex | in | not-in | generalizes | child-of | descendent-leaf | exists", formalDefinition="A list of operators that can be used with the filter.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/filter-operator")
        protected List<Enumeration<Enumerations.FilterOperator>> operator;
        @Child(name="value", type={StringType.class}, order=4, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="What to use for the value", formalDefinition="A description of what the value for the filter should be.")
        protected StringType value;
        private static final long serialVersionUID = -1087409836L;

        public CodeSystemFilterComponent() {
        }

        public CodeSystemFilterComponent(String code, Enumerations.FilterOperator operator, String value) {
            this.setCode(code);
            this.addOperator(operator);
            this.setValue(value);
        }

        public CodeType getCodeElement() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CodeSystemFilterComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeType();
                }
            }
            return this.code;
        }

        public boolean hasCodeElement() {
            return this.code != null && !this.code.isEmpty();
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public CodeSystemFilterComponent setCodeElement(CodeType value) {
            this.code = value;
            return this;
        }

        public String getCode() {
            return this.code == null ? null : (String)this.code.getValue();
        }

        public CodeSystemFilterComponent setCode(String value) {
            if (this.code == null) {
                this.code = new CodeType();
            }
            this.code.setValue(value);
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CodeSystemFilterComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public CodeSystemFilterComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public CodeSystemFilterComponent setDescription(String value) {
            if (Utilities.noString(value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public List<Enumeration<Enumerations.FilterOperator>> getOperator() {
            if (this.operator == null) {
                this.operator = new ArrayList<Enumeration<Enumerations.FilterOperator>>();
            }
            return this.operator;
        }

        public CodeSystemFilterComponent setOperator(List<Enumeration<Enumerations.FilterOperator>> theOperator) {
            this.operator = theOperator;
            return this;
        }

        public boolean hasOperator() {
            if (this.operator == null) {
                return false;
            }
            for (Enumeration<Enumerations.FilterOperator> item : this.operator) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Enumeration<Enumerations.FilterOperator> addOperatorElement() {
            Enumeration<Enumerations.FilterOperator> t = new Enumeration<Enumerations.FilterOperator>(new Enumerations.FilterOperatorEnumFactory());
            if (this.operator == null) {
                this.operator = new ArrayList<Enumeration<Enumerations.FilterOperator>>();
            }
            this.operator.add(t);
            return t;
        }

        public CodeSystemFilterComponent addOperator(Enumerations.FilterOperator value) {
            Enumeration<Enumerations.FilterOperator> t = new Enumeration<Enumerations.FilterOperator>(new Enumerations.FilterOperatorEnumFactory());
            t.setValue((Object)value);
            if (this.operator == null) {
                this.operator = new ArrayList<Enumeration<Enumerations.FilterOperator>>();
            }
            this.operator.add(t);
            return this;
        }

        public boolean hasOperator(Enumerations.FilterOperator value) {
            if (this.operator == null) {
                return false;
            }
            for (Enumeration<Enumerations.FilterOperator> v : this.operator) {
                if (!((Enumerations.FilterOperator)((Object)v.getValue())).equals((Object)value)) continue;
                return true;
            }
            return false;
        }

        public StringType getValueElement() {
            if (this.value == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CodeSystemFilterComponent.value");
                }
                if (Configuration.doAutoCreate()) {
                    this.value = new StringType();
                }
            }
            return this.value;
        }

        public boolean hasValueElement() {
            return this.value != null && !this.value.isEmpty();
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public CodeSystemFilterComponent setValueElement(StringType value) {
            this.value = value;
            return this;
        }

        public String getValue() {
            return this.value == null ? null : (String)this.value.getValue();
        }

        public CodeSystemFilterComponent setValue(String value) {
            if (this.value == null) {
                this.value = new StringType();
            }
            this.value.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(CodeSystem.SP_CODE, CodeSystem.SP_CODE, "The code that identifies this filter when it is used as a filter in [ValueSet](valueset.html#).compose.include.filter.", 0, 1, this.code));
            children.add(new Property(CodeSystem.SP_DESCRIPTION, "string", "A description of how or why the filter is used.", 0, 1, this.description));
            children.add(new Property("operator", CodeSystem.SP_CODE, "A list of operators that can be used with the filter.", 0, Integer.MAX_VALUE, this.operator));
            children.add(new Property("value", "string", "A description of what the value for the filter should be.", 0, 1, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property(CodeSystem.SP_CODE, CodeSystem.SP_CODE, "The code that identifies this filter when it is used as a filter in [ValueSet](valueset.html#).compose.include.filter.", 0, 1, this.code);
                }
                case -1724546052: {
                    return new Property(CodeSystem.SP_DESCRIPTION, "string", "A description of how or why the filter is used.", 0, 1, this.description);
                }
                case -500553564: {
                    return new Property("operator", CodeSystem.SP_CODE, "A list of operators that can be used with the filter.", 0, Integer.MAX_VALUE, this.operator);
                }
                case 111972721: {
                    return new Property("value", "string", "A description of what the value for the filter should be.", 0, 1, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.description;
                    }
                    return baseArray;
                }
                case -500553564: {
                    return this.operator == null ? new Base[]{} : this.operator.toArray(new Base[this.operator.size()]);
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = TypeConvertor.castToCode(value);
                    return value;
                }
                case -1724546052: {
                    this.description = TypeConvertor.castToString(value);
                    return value;
                }
                case -500553564: {
                    value = new Enumerations.FilterOperatorEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.getOperator().add(value);
                    return value;
                }
                case 111972721: {
                    this.value = TypeConvertor.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(CodeSystem.SP_CODE)) {
                this.code = TypeConvertor.castToCode(value);
            } else if (name.equals(CodeSystem.SP_DESCRIPTION)) {
                this.description = TypeConvertor.castToString(value);
            } else if (name.equals("operator")) {
                value = new Enumerations.FilterOperatorEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.getOperator().add(value);
            } else if (name.equals("value")) {
                this.value = TypeConvertor.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCodeElement();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case -500553564: {
                    return this.addOperatorElement();
                }
                case 111972721: {
                    return this.getValueElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{CodeSystem.SP_CODE};
                }
                case -1724546052: {
                    return new String[]{"string"};
                }
                case -500553564: {
                    return new String[]{CodeSystem.SP_CODE};
                }
                case 111972721: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(CodeSystem.SP_CODE)) {
                throw new FHIRException("Cannot call addChild on a primitive type CodeSystem.filter.code");
            }
            if (name.equals(CodeSystem.SP_DESCRIPTION)) {
                throw new FHIRException("Cannot call addChild on a primitive type CodeSystem.filter.description");
            }
            if (name.equals("operator")) {
                throw new FHIRException("Cannot call addChild on a primitive type CodeSystem.filter.operator");
            }
            if (name.equals("value")) {
                throw new FHIRException("Cannot call addChild on a primitive type CodeSystem.filter.value");
            }
            return super.addChild(name);
        }

        @Override
        public CodeSystemFilterComponent copy() {
            CodeSystemFilterComponent dst = new CodeSystemFilterComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CodeSystemFilterComponent dst) {
            super.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            StringType stringType = dst.description = this.description == null ? null : this.description.copy();
            if (this.operator != null) {
                dst.operator = new ArrayList<Enumeration<Enumerations.FilterOperator>>();
                for (Enumeration<Enumerations.FilterOperator> i2 : this.operator) {
                    dst.operator.add((Enumeration<Enumerations.FilterOperator>)i2.copy());
                }
            }
            dst.value = this.value == null ? null : this.value.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CodeSystemFilterComponent)) {
                return false;
            }
            CodeSystemFilterComponent o = (CodeSystemFilterComponent)other_;
            return CodeSystemFilterComponent.compareDeep(this.code, o.code, true) && CodeSystemFilterComponent.compareDeep(this.description, o.description, true) && CodeSystemFilterComponent.compareDeep(this.operator, o.operator, true) && CodeSystemFilterComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CodeSystemFilterComponent)) {
                return false;
            }
            CodeSystemFilterComponent o = (CodeSystemFilterComponent)other_;
            return CodeSystemFilterComponent.compareValues(this.code, o.code, true) && CodeSystemFilterComponent.compareValues(this.description, o.description, true) && CodeSystemFilterComponent.compareValues(this.operator, o.operator, true) && CodeSystemFilterComponent.compareValues(this.value, o.value, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.code, this.description, this.operator, this.value);
        }

        @Override
        public String fhirType() {
            return "CodeSystem.filter";
        }
    }

    public static class PropertyTypeEnumFactory
    implements EnumFactory<PropertyType> {
        @Override
        public PropertyType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if (CodeSystem.SP_CODE.equals(codeString)) {
                return PropertyType.CODE;
            }
            if ("Coding".equals(codeString)) {
                return PropertyType.CODING;
            }
            if ("string".equals(codeString)) {
                return PropertyType.STRING;
            }
            if ("integer".equals(codeString)) {
                return PropertyType.INTEGER;
            }
            if ("boolean".equals(codeString)) {
                return PropertyType.BOOLEAN;
            }
            if ("dateTime".equals(codeString)) {
                return PropertyType.DATETIME;
            }
            if ("decimal".equals(codeString)) {
                return PropertyType.DECIMAL;
            }
            throw new IllegalArgumentException("Unknown PropertyType code '" + codeString + "'");
        }

        public Enumeration<PropertyType> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<PropertyType>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if (CodeSystem.SP_CODE.equals(codeString)) {
                return new Enumeration<PropertyType>(this, PropertyType.CODE);
            }
            if ("Coding".equals(codeString)) {
                return new Enumeration<PropertyType>(this, PropertyType.CODING);
            }
            if ("string".equals(codeString)) {
                return new Enumeration<PropertyType>(this, PropertyType.STRING);
            }
            if ("integer".equals(codeString)) {
                return new Enumeration<PropertyType>(this, PropertyType.INTEGER);
            }
            if ("boolean".equals(codeString)) {
                return new Enumeration<PropertyType>(this, PropertyType.BOOLEAN);
            }
            if ("dateTime".equals(codeString)) {
                return new Enumeration<PropertyType>(this, PropertyType.DATETIME);
            }
            if ("decimal".equals(codeString)) {
                return new Enumeration<PropertyType>(this, PropertyType.DECIMAL);
            }
            throw new FHIRException("Unknown PropertyType code '" + codeString + "'");
        }

        @Override
        public String toCode(PropertyType code) {
            if (code == PropertyType.CODE) {
                return CodeSystem.SP_CODE;
            }
            if (code == PropertyType.CODING) {
                return "Coding";
            }
            if (code == PropertyType.STRING) {
                return "string";
            }
            if (code == PropertyType.INTEGER) {
                return "integer";
            }
            if (code == PropertyType.BOOLEAN) {
                return "boolean";
            }
            if (code == PropertyType.DATETIME) {
                return "dateTime";
            }
            if (code == PropertyType.DECIMAL) {
                return "decimal";
            }
            return "?";
        }

        @Override
        public String toSystem(PropertyType code) {
            return code.getSystem();
        }
    }

    public static enum PropertyType {
        CODE,
        CODING,
        STRING,
        INTEGER,
        BOOLEAN,
        DATETIME,
        DECIMAL,
        NULL;


        public static PropertyType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if (CodeSystem.SP_CODE.equals(codeString)) {
                return CODE;
            }
            if ("Coding".equals(codeString)) {
                return CODING;
            }
            if ("string".equals(codeString)) {
                return STRING;
            }
            if ("integer".equals(codeString)) {
                return INTEGER;
            }
            if ("boolean".equals(codeString)) {
                return BOOLEAN;
            }
            if ("dateTime".equals(codeString)) {
                return DATETIME;
            }
            if ("decimal".equals(codeString)) {
                return DECIMAL;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown PropertyType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case CODE: {
                    return CodeSystem.SP_CODE;
                }
                case CODING: {
                    return "Coding";
                }
                case STRING: {
                    return "string";
                }
                case INTEGER: {
                    return "integer";
                }
                case BOOLEAN: {
                    return "boolean";
                }
                case DATETIME: {
                    return "dateTime";
                }
                case DECIMAL: {
                    return "decimal";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case CODE: {
                    return "http://hl7.org/fhir/concept-property-type";
                }
                case CODING: {
                    return "http://hl7.org/fhir/concept-property-type";
                }
                case STRING: {
                    return "http://hl7.org/fhir/concept-property-type";
                }
                case INTEGER: {
                    return "http://hl7.org/fhir/concept-property-type";
                }
                case BOOLEAN: {
                    return "http://hl7.org/fhir/concept-property-type";
                }
                case DATETIME: {
                    return "http://hl7.org/fhir/concept-property-type";
                }
                case DECIMAL: {
                    return "http://hl7.org/fhir/concept-property-type";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case CODE: {
                    return "The property value is a code that identifies a concept defined in the code system.";
                }
                case CODING: {
                    return "The property  value is a code defined in an external code system. This may be used for translations, but is not the intent.";
                }
                case STRING: {
                    return "The property value is a string.";
                }
                case INTEGER: {
                    return "The property value is a string (often used to assign ranking values to concepts for supporting score assessments).";
                }
                case BOOLEAN: {
                    return "The property value is a boolean true | false.";
                }
                case DATETIME: {
                    return "The property is a date or a date + time.";
                }
                case DECIMAL: {
                    return "The property value is a decimal number.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case CODE: {
                    return "code (internal reference)";
                }
                case CODING: {
                    return "Coding (external reference)";
                }
                case STRING: {
                    return "string";
                }
                case INTEGER: {
                    return "integer";
                }
                case BOOLEAN: {
                    return "boolean";
                }
                case DATETIME: {
                    return "dateTime";
                }
                case DECIMAL: {
                    return "decimal";
                }
            }
            return "?";
        }
    }

    public static class CodeSystemHierarchyMeaningEnumFactory
    implements EnumFactory<CodeSystemHierarchyMeaning> {
        @Override
        public CodeSystemHierarchyMeaning fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("grouped-by".equals(codeString)) {
                return CodeSystemHierarchyMeaning.GROUPEDBY;
            }
            if ("is-a".equals(codeString)) {
                return CodeSystemHierarchyMeaning.ISA;
            }
            if ("part-of".equals(codeString)) {
                return CodeSystemHierarchyMeaning.PARTOF;
            }
            if ("classified-with".equals(codeString)) {
                return CodeSystemHierarchyMeaning.CLASSIFIEDWITH;
            }
            throw new IllegalArgumentException("Unknown CodeSystemHierarchyMeaning code '" + codeString + "'");
        }

        public Enumeration<CodeSystemHierarchyMeaning> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<CodeSystemHierarchyMeaning>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("grouped-by".equals(codeString)) {
                return new Enumeration<CodeSystemHierarchyMeaning>(this, CodeSystemHierarchyMeaning.GROUPEDBY);
            }
            if ("is-a".equals(codeString)) {
                return new Enumeration<CodeSystemHierarchyMeaning>(this, CodeSystemHierarchyMeaning.ISA);
            }
            if ("part-of".equals(codeString)) {
                return new Enumeration<CodeSystemHierarchyMeaning>(this, CodeSystemHierarchyMeaning.PARTOF);
            }
            if ("classified-with".equals(codeString)) {
                return new Enumeration<CodeSystemHierarchyMeaning>(this, CodeSystemHierarchyMeaning.CLASSIFIEDWITH);
            }
            throw new FHIRException("Unknown CodeSystemHierarchyMeaning code '" + codeString + "'");
        }

        @Override
        public String toCode(CodeSystemHierarchyMeaning code) {
            if (code == CodeSystemHierarchyMeaning.GROUPEDBY) {
                return "grouped-by";
            }
            if (code == CodeSystemHierarchyMeaning.ISA) {
                return "is-a";
            }
            if (code == CodeSystemHierarchyMeaning.PARTOF) {
                return "part-of";
            }
            if (code == CodeSystemHierarchyMeaning.CLASSIFIEDWITH) {
                return "classified-with";
            }
            return "?";
        }

        @Override
        public String toSystem(CodeSystemHierarchyMeaning code) {
            return code.getSystem();
        }
    }

    public static enum CodeSystemHierarchyMeaning {
        GROUPEDBY,
        ISA,
        PARTOF,
        CLASSIFIEDWITH,
        NULL;


        public static CodeSystemHierarchyMeaning fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("grouped-by".equals(codeString)) {
                return GROUPEDBY;
            }
            if ("is-a".equals(codeString)) {
                return ISA;
            }
            if ("part-of".equals(codeString)) {
                return PARTOF;
            }
            if ("classified-with".equals(codeString)) {
                return CLASSIFIEDWITH;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown CodeSystemHierarchyMeaning code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case GROUPEDBY: {
                    return "grouped-by";
                }
                case ISA: {
                    return "is-a";
                }
                case PARTOF: {
                    return "part-of";
                }
                case CLASSIFIEDWITH: {
                    return "classified-with";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case GROUPEDBY: {
                    return "http://hl7.org/fhir/codesystem-hierarchy-meaning";
                }
                case ISA: {
                    return "http://hl7.org/fhir/codesystem-hierarchy-meaning";
                }
                case PARTOF: {
                    return "http://hl7.org/fhir/codesystem-hierarchy-meaning";
                }
                case CLASSIFIEDWITH: {
                    return "http://hl7.org/fhir/codesystem-hierarchy-meaning";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case GROUPEDBY: {
                    return "No particular relationship between the concepts can be assumed, except what can be determined by inspection of the definitions of the elements (possible reasons to use this: importing from a source where this is not defined, or where various parts of the hierarchy have different meanings).";
                }
                case ISA: {
                    return "A hierarchy where the child concepts have an IS-A relationship with the parents - that is, all the properties of the parent are also true for its child concepts. Not that is-a is a property of the concepts, so additional subsumption relationships may be defined using properties or the [subsumes](extension-codesystem-subsumes.html) extension.";
                }
                case PARTOF: {
                    return "Child elements list the individual parts of a composite whole (e.g. body site).";
                }
                case CLASSIFIEDWITH: {
                    return "Child concepts in the hierarchy may have only one parent, and there is a presumption that the code system is a \"closed world\" meaning all things must be in the hierarchy. This results in concepts such as \"not otherwise classified.\".";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case GROUPEDBY: {
                    return "Grouped By";
                }
                case ISA: {
                    return "Is-A";
                }
                case PARTOF: {
                    return "Part Of";
                }
                case CLASSIFIEDWITH: {
                    return "Classified With";
                }
            }
            return "?";
        }
    }

    public static class CodeSystemContentModeEnumFactory
    implements EnumFactory<CodeSystemContentMode> {
        @Override
        public CodeSystemContentMode fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("not-present".equals(codeString)) {
                return CodeSystemContentMode.NOTPRESENT;
            }
            if ("example".equals(codeString)) {
                return CodeSystemContentMode.EXAMPLE;
            }
            if ("fragment".equals(codeString)) {
                return CodeSystemContentMode.FRAGMENT;
            }
            if ("complete".equals(codeString)) {
                return CodeSystemContentMode.COMPLETE;
            }
            if ("supplement".equals(codeString)) {
                return CodeSystemContentMode.SUPPLEMENT;
            }
            throw new IllegalArgumentException("Unknown CodeSystemContentMode code '" + codeString + "'");
        }

        public Enumeration<CodeSystemContentMode> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<CodeSystemContentMode>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("not-present".equals(codeString)) {
                return new Enumeration<CodeSystemContentMode>(this, CodeSystemContentMode.NOTPRESENT);
            }
            if ("example".equals(codeString)) {
                return new Enumeration<CodeSystemContentMode>(this, CodeSystemContentMode.EXAMPLE);
            }
            if ("fragment".equals(codeString)) {
                return new Enumeration<CodeSystemContentMode>(this, CodeSystemContentMode.FRAGMENT);
            }
            if ("complete".equals(codeString)) {
                return new Enumeration<CodeSystemContentMode>(this, CodeSystemContentMode.COMPLETE);
            }
            if ("supplement".equals(codeString)) {
                return new Enumeration<CodeSystemContentMode>(this, CodeSystemContentMode.SUPPLEMENT);
            }
            throw new FHIRException("Unknown CodeSystemContentMode code '" + codeString + "'");
        }

        @Override
        public String toCode(CodeSystemContentMode code) {
            if (code == CodeSystemContentMode.NOTPRESENT) {
                return "not-present";
            }
            if (code == CodeSystemContentMode.EXAMPLE) {
                return "example";
            }
            if (code == CodeSystemContentMode.FRAGMENT) {
                return "fragment";
            }
            if (code == CodeSystemContentMode.COMPLETE) {
                return "complete";
            }
            if (code == CodeSystemContentMode.SUPPLEMENT) {
                return "supplement";
            }
            return "?";
        }

        @Override
        public String toSystem(CodeSystemContentMode code) {
            return code.getSystem();
        }
    }

    public static enum CodeSystemContentMode {
        NOTPRESENT,
        EXAMPLE,
        FRAGMENT,
        COMPLETE,
        SUPPLEMENT,
        NULL;


        public static CodeSystemContentMode fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("not-present".equals(codeString)) {
                return NOTPRESENT;
            }
            if ("example".equals(codeString)) {
                return EXAMPLE;
            }
            if ("fragment".equals(codeString)) {
                return FRAGMENT;
            }
            if ("complete".equals(codeString)) {
                return COMPLETE;
            }
            if ("supplement".equals(codeString)) {
                return SUPPLEMENT;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown CodeSystemContentMode code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case NOTPRESENT: {
                    return "not-present";
                }
                case EXAMPLE: {
                    return "example";
                }
                case FRAGMENT: {
                    return "fragment";
                }
                case COMPLETE: {
                    return "complete";
                }
                case SUPPLEMENT: {
                    return "supplement";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case NOTPRESENT: {
                    return "http://hl7.org/fhir/codesystem-content-mode";
                }
                case EXAMPLE: {
                    return "http://hl7.org/fhir/codesystem-content-mode";
                }
                case FRAGMENT: {
                    return "http://hl7.org/fhir/codesystem-content-mode";
                }
                case COMPLETE: {
                    return "http://hl7.org/fhir/codesystem-content-mode";
                }
                case SUPPLEMENT: {
                    return "http://hl7.org/fhir/codesystem-content-mode";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case NOTPRESENT: {
                    return "None of the concepts defined by the code system are included in the code system resource.";
                }
                case EXAMPLE: {
                    return "A few representative concepts are included in the code system resource. There is no useful intent in the subset choice and there's no process to make it workable: it's not intended to be workable.";
                }
                case FRAGMENT: {
                    return "A subset of the code system concepts are included in the code system resource. This is a curated subset released for a specific purpose under the governance of the code system steward, and that the intent, bounds and consequences of the fragmentation are clearly defined in the fragment or the code system documentation. Fragments are also known as partitions.";
                }
                case COMPLETE: {
                    return "All the concepts defined by the code system are included in the code system resource.";
                }
                case SUPPLEMENT: {
                    return "The resource doesn't define any new concepts; it just provides additional designations and properties to another code system.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case NOTPRESENT: {
                    return "Not Present";
                }
                case EXAMPLE: {
                    return "Example";
                }
                case FRAGMENT: {
                    return "Fragment";
                }
                case COMPLETE: {
                    return "Complete";
                }
                case SUPPLEMENT: {
                    return "Supplement";
                }
            }
            return "?";
        }
    }
}

