/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ConsentPerformer {
    CONSENTER,
    GRANTEE,
    GRANTOR,
    DELEGATEE,
    DELEGATOR,
    NULL;


    public static ConsentPerformer fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("consenter".equals(codeString)) {
            return CONSENTER;
        }
        if ("grantee".equals(codeString)) {
            return GRANTEE;
        }
        if ("grantor".equals(codeString)) {
            return GRANTOR;
        }
        if ("delegatee".equals(codeString)) {
            return DELEGATEE;
        }
        if ("delegator".equals(codeString)) {
            return DELEGATOR;
        }
        throw new FHIRException("Unknown ConsentPerformer code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case CONSENTER: {
                return "consenter";
            }
            case GRANTEE: {
                return "grantee";
            }
            case GRANTOR: {
                return "grantor";
            }
            case DELEGATEE: {
                return "delegatee";
            }
            case DELEGATOR: {
                return "delegator";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/consentperformer";
    }

    public String getDefinition() {
        switch (this) {
            case CONSENTER: {
                return "An entity or an entity's delegatee who is the grantee in an agreement such as a consent for services, advanced directive, or a privacy consent directive in accordance with jurisdictional, organizational, or patient policy.";
            }
            case GRANTEE: {
                return "An entity which accepts certain rights or authority from a grantor.";
            }
            case GRANTOR: {
                return "An entity which agrees to confer certain rights or authority to a grantee.";
            }
            case DELEGATEE: {
                return "A party to whom some right or authority is granted by a delegator.";
            }
            case DELEGATOR: {
                return "A party that grants all or some portion its right or authority to another party.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case CONSENTER: {
                return "Consenter";
            }
            case GRANTEE: {
                return "Grantee";
            }
            case GRANTOR: {
                return "Grantor";
            }
            case DELEGATEE: {
                return "Delegatee";
            }
            case DELEGATOR: {
                return "Delegator";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

