/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum AuditEventType {
    REST,
    NULL;


    public static AuditEventType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("rest".equals(codeString)) {
            return REST;
        }
        throw new FHIRException("Unknown AuditEventType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case REST: {
                return "rest";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/audit-event-type";
    }

    public String getDefinition() {
        switch (this) {
            case REST: {
                return "Audit Event: Execution of a RESTful operation as defined by FHIR.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case REST: {
                return "RESTful Operation";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

