/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.hapi.fluentpath;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.fhirpath.FhirPathExecutionException;
import ca.uhn.fhir.fhirpath.IFhirPath;
import java.util.List;
import java.util.Optional;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.r4.hapi.ctx.HapiWorkerContext;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.utils.FHIRPathEngine;

public class FhirPathR4
implements IFhirPath {
    private FHIRPathEngine myEngine;

    public FhirPathR4(FhirContext theCtx) {
        IValidationSupport validationSupport = theCtx.getValidationSupport();
        this.myEngine = new FHIRPathEngine(new HapiWorkerContext(theCtx, validationSupport));
    }

    @Override
    public <T extends IBase> List<T> evaluate(IBase theInput, String thePath, Class<T> theReturnType) {
        List<Base> result;
        try {
            result = this.myEngine.evaluate((Base)theInput, thePath);
        }
        catch (FHIRException e) {
            throw new FhirPathExecutionException(e);
        }
        for (Base next : result) {
            if (theReturnType.isAssignableFrom(next.getClass())) continue;
            throw new FhirPathExecutionException("FluentPath expression \"" + thePath + "\" returned unexpected type " + next.getClass().getSimpleName() + " - Expected " + theReturnType.getName());
        }
        return result;
    }

    @Override
    public <T extends IBase> Optional<T> evaluateFirst(IBase theInput, String thePath, Class<T> theReturnType) {
        return this.evaluate(theInput, thePath, theReturnType).stream().findFirst();
    }

    @Override
    public void parse(String theExpression) {
        this.myEngine.parse(theExpression);
    }
}

