/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.hapi.ctx;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.fhirpath.IFhirPath;
import ca.uhn.fhir.model.api.IFhirVersion;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.api.IVersionSpecificBundleFactory;
import ca.uhn.fhir.util.ReflectionUtil;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseCoding;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.hapi.fluentpath.FhirPathR4;
import org.hl7.fhir.r4.hapi.rest.server.R4BundleFactory;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.StructureDefinition;

public class FhirR4
implements IFhirVersion {
    private String myId;

    @Override
    public IFhirPath createFhirPathExecutor(FhirContext theFhirContext) {
        return new FhirPathR4(theFhirContext);
    }

    @Override
    public IBaseResource generateProfile(RuntimeResourceDefinition theRuntimeResourceDefinition, String theServerBase) {
        StructureDefinition retVal = new StructureDefinition();
        RuntimeResourceDefinition def = theRuntimeResourceDefinition;
        this.myId = def.getId();
        if (StringUtils.isBlank((CharSequence)this.myId)) {
            this.myId = theRuntimeResourceDefinition.getName().toLowerCase();
        }
        retVal.setId(new IdDt(this.myId));
        return retVal;
    }

    public Class<List> getContainedType() {
        return List.class;
    }

    @Override
    public InputStream getFhirVersionPropertiesFile() {
        String path = "org/hl7/fhir/r4/model/fhirversion.properties";
        InputStream str = FhirR4.class.getResourceAsStream("/" + path);
        if (str == null) {
            str = FhirR4.class.getResourceAsStream(path);
        }
        if (str == null) {
            throw new ConfigurationException("Can not find model property file on classpath: " + path);
        }
        return str;
    }

    @Override
    public IPrimitiveType<Date> getLastUpdated(IBaseResource theResource) {
        return ((Resource)theResource).getMeta().getLastUpdatedElement();
    }

    @Override
    public String getPathToSchemaDefinitions() {
        return "/org/hl7/fhir/r4/model/schema";
    }

    public Class<? extends IBaseReference> getResourceReferenceType() {
        return Reference.class;
    }

    @Override
    public Object getServerVersion() {
        return ReflectionUtil.newInstanceOfFhirServerType("org.hl7.fhir.r4.hapi.ctx.FhirServerR4");
    }

    @Override
    public FhirVersionEnum getVersion() {
        return FhirVersionEnum.R4;
    }

    @Override
    public IVersionSpecificBundleFactory newBundleFactory(FhirContext theContext) {
        return new R4BundleFactory(theContext);
    }

    @Override
    public IBaseCoding newCodingDt() {
        return new Coding();
    }

    @Override
    public IIdType newIdType() {
        return new IdType();
    }
}

