/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum LocationPhysicalType {
    SI,
    BU,
    WI,
    WA,
    LVL,
    CO,
    RO,
    BD,
    VE,
    HO,
    CA,
    RD,
    AREA,
    JDN,
    NULL;


    public static LocationPhysicalType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("si".equals(codeString)) {
            return SI;
        }
        if ("bu".equals(codeString)) {
            return BU;
        }
        if ("wi".equals(codeString)) {
            return WI;
        }
        if ("wa".equals(codeString)) {
            return WA;
        }
        if ("lvl".equals(codeString)) {
            return LVL;
        }
        if ("co".equals(codeString)) {
            return CO;
        }
        if ("ro".equals(codeString)) {
            return RO;
        }
        if ("bd".equals(codeString)) {
            return BD;
        }
        if ("ve".equals(codeString)) {
            return VE;
        }
        if ("ho".equals(codeString)) {
            return HO;
        }
        if ("ca".equals(codeString)) {
            return CA;
        }
        if ("rd".equals(codeString)) {
            return RD;
        }
        if ("area".equals(codeString)) {
            return AREA;
        }
        if ("jdn".equals(codeString)) {
            return JDN;
        }
        throw new FHIRException("Unknown LocationPhysicalType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case SI: {
                return "si";
            }
            case BU: {
                return "bu";
            }
            case WI: {
                return "wi";
            }
            case WA: {
                return "wa";
            }
            case LVL: {
                return "lvl";
            }
            case CO: {
                return "co";
            }
            case RO: {
                return "ro";
            }
            case BD: {
                return "bd";
            }
            case VE: {
                return "ve";
            }
            case HO: {
                return "ho";
            }
            case CA: {
                return "ca";
            }
            case RD: {
                return "rd";
            }
            case AREA: {
                return "area";
            }
            case JDN: {
                return "jdn";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/location-physical-type";
    }

    public String getDefinition() {
        switch (this) {
            case SI: {
                return "A collection of buildings or other locations such as a site or a campus.";
            }
            case BU: {
                return "Any Building or structure. This may contain rooms, corridors, wings, etc. It may not have walls, or a roof, but is considered a defined/allocated space.";
            }
            case WI: {
                return "A Wing within a Building, this often contains levels, rooms and corridors.";
            }
            case WA: {
                return "A Ward is a section of a medical facility that may contain rooms and other types of location.";
            }
            case LVL: {
                return "A Level in a multi-level Building/Structure.";
            }
            case CO: {
                return "Any corridor within a Building, that may connect rooms.";
            }
            case RO: {
                return "A space that is allocated as a room, it may have walls/roof etc., but does not require these.";
            }
            case BD: {
                return "A space that is allocated for sleeping/laying on. This is not the physical bed/trolley that may be moved about, but the space it may occupy.";
            }
            case VE: {
                return "A means of transportation.";
            }
            case HO: {
                return "A residential dwelling. Usually used to reference a location that a person/patient may reside.";
            }
            case CA: {
                return "A container that can store goods, equipment, medications or other items.";
            }
            case RD: {
                return "A defined path to travel between 2 points that has a known name.";
            }
            case AREA: {
                return "A defined physical boundary of something, such as a flood risk zone, region, postcode";
            }
            case JDN: {
                return "A wide scope that covers a conceptual domain, such as a Nation (Country wide community or Federal Government - e.g. Ministry of Health),  Province or State (community or Government), Business (throughout the enterprise), Nation with a business scope of an agency (e.g. CDC, FDA etc.) or a Business segment (UK Pharmacy), not just an physical boundry";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case SI: {
                return "Site";
            }
            case BU: {
                return "Building";
            }
            case WI: {
                return "Wing";
            }
            case WA: {
                return "Ward";
            }
            case LVL: {
                return "Level";
            }
            case CO: {
                return "Corridor";
            }
            case RO: {
                return "Room";
            }
            case BD: {
                return "Bed";
            }
            case VE: {
                return "Vehicle";
            }
            case HO: {
                return "House";
            }
            case CA: {
                return "Cabinet";
            }
            case RD: {
                return "Road";
            }
            case AREA: {
                return "Area";
            }
            case JDN: {
                return "Jurisdiction";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

