/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model;

import org.hl7.fhir.exceptions.FHIRException;

public enum ResourceType {
    Account,
    ActivityDefinition,
    AdverseEvent,
    AllergyIntolerance,
    Appointment,
    AppointmentResponse,
    AuditEvent,
    Basic,
    Binary,
    BodySite,
    Bundle,
    CapabilityStatement,
    CarePlan,
    CareTeam,
    ChargeItem,
    Claim,
    ClaimResponse,
    ClinicalImpression,
    CodeSystem,
    Communication,
    CommunicationRequest,
    CompartmentDefinition,
    Composition,
    ConceptMap,
    Condition,
    Consent,
    Contract,
    Coverage,
    DataElement,
    DetectedIssue,
    Device,
    DeviceComponent,
    DeviceMetric,
    DeviceRequest,
    DeviceUseStatement,
    DiagnosticReport,
    DocumentManifest,
    DocumentReference,
    EligibilityRequest,
    EligibilityResponse,
    Encounter,
    Endpoint,
    EnrollmentRequest,
    EnrollmentResponse,
    EpisodeOfCare,
    ExpansionProfile,
    ExplanationOfBenefit,
    FamilyMemberHistory,
    Flag,
    Goal,
    GraphDefinition,
    Group,
    GuidanceResponse,
    HealthcareService,
    ImagingManifest,
    ImagingStudy,
    Immunization,
    ImmunizationRecommendation,
    ImplementationGuide,
    Library,
    Linkage,
    List,
    Location,
    Measure,
    MeasureReport,
    Media,
    Medication,
    MedicationAdministration,
    MedicationDispense,
    MedicationRequest,
    MedicationStatement,
    MessageDefinition,
    MessageHeader,
    NamingSystem,
    NutritionOrder,
    Observation,
    OperationDefinition,
    OperationOutcome,
    Organization,
    Parameters,
    Patient,
    PaymentNotice,
    PaymentReconciliation,
    Person,
    PlanDefinition,
    Practitioner,
    PractitionerRole,
    Procedure,
    ProcedureRequest,
    ProcessRequest,
    ProcessResponse,
    Provenance,
    Questionnaire,
    QuestionnaireResponse,
    ReferralRequest,
    RelatedPerson,
    RequestGroup,
    ResearchStudy,
    ResearchSubject,
    RiskAssessment,
    Schedule,
    SearchParameter,
    Sequence,
    ServiceDefinition,
    Slot,
    Specimen,
    StructureDefinition,
    StructureMap,
    Subscription,
    Substance,
    SupplyDelivery,
    SupplyRequest,
    Task,
    TestReport,
    TestScript,
    ValueSet,
    VisionPrescription;


    public String getPath() {
        switch (this) {
            case Account: {
                return "account";
            }
            case ActivityDefinition: {
                return "activitydefinition";
            }
            case AdverseEvent: {
                return "adverseevent";
            }
            case AllergyIntolerance: {
                return "allergyintolerance";
            }
            case Appointment: {
                return "appointment";
            }
            case AppointmentResponse: {
                return "appointmentresponse";
            }
            case AuditEvent: {
                return "auditevent";
            }
            case Basic: {
                return "basic";
            }
            case Binary: {
                return "binary";
            }
            case BodySite: {
                return "bodysite";
            }
            case Bundle: {
                return "bundle";
            }
            case CapabilityStatement: {
                return "capabilitystatement";
            }
            case CarePlan: {
                return "careplan";
            }
            case CareTeam: {
                return "careteam";
            }
            case ChargeItem: {
                return "chargeitem";
            }
            case Claim: {
                return "claim";
            }
            case ClaimResponse: {
                return "claimresponse";
            }
            case ClinicalImpression: {
                return "clinicalimpression";
            }
            case CodeSystem: {
                return "codesystem";
            }
            case Communication: {
                return "communication";
            }
            case CommunicationRequest: {
                return "communicationrequest";
            }
            case CompartmentDefinition: {
                return "compartmentdefinition";
            }
            case Composition: {
                return "composition";
            }
            case ConceptMap: {
                return "conceptmap";
            }
            case Condition: {
                return "condition";
            }
            case Consent: {
                return "consent";
            }
            case Contract: {
                return "contract";
            }
            case Coverage: {
                return "coverage";
            }
            case DataElement: {
                return "dataelement";
            }
            case DetectedIssue: {
                return "detectedissue";
            }
            case Device: {
                return "device";
            }
            case DeviceComponent: {
                return "devicecomponent";
            }
            case DeviceMetric: {
                return "devicemetric";
            }
            case DeviceRequest: {
                return "devicerequest";
            }
            case DeviceUseStatement: {
                return "deviceusestatement";
            }
            case DiagnosticReport: {
                return "diagnosticreport";
            }
            case DocumentManifest: {
                return "documentmanifest";
            }
            case DocumentReference: {
                return "documentreference";
            }
            case EligibilityRequest: {
                return "eligibilityrequest";
            }
            case EligibilityResponse: {
                return "eligibilityresponse";
            }
            case Encounter: {
                return "encounter";
            }
            case Endpoint: {
                return "endpoint";
            }
            case EnrollmentRequest: {
                return "enrollmentrequest";
            }
            case EnrollmentResponse: {
                return "enrollmentresponse";
            }
            case EpisodeOfCare: {
                return "episodeofcare";
            }
            case ExpansionProfile: {
                return "expansionprofile";
            }
            case ExplanationOfBenefit: {
                return "explanationofbenefit";
            }
            case FamilyMemberHistory: {
                return "familymemberhistory";
            }
            case Flag: {
                return "flag";
            }
            case Goal: {
                return "goal";
            }
            case GraphDefinition: {
                return "graphdefinition";
            }
            case Group: {
                return "group";
            }
            case GuidanceResponse: {
                return "guidanceresponse";
            }
            case HealthcareService: {
                return "healthcareservice";
            }
            case ImagingManifest: {
                return "imagingmanifest";
            }
            case ImagingStudy: {
                return "imagingstudy";
            }
            case Immunization: {
                return "immunization";
            }
            case ImmunizationRecommendation: {
                return "immunizationrecommendation";
            }
            case ImplementationGuide: {
                return "implementationguide";
            }
            case Library: {
                return "library";
            }
            case Linkage: {
                return "linkage";
            }
            case List: {
                return "list";
            }
            case Location: {
                return "location";
            }
            case Measure: {
                return "measure";
            }
            case MeasureReport: {
                return "measurereport";
            }
            case Media: {
                return "media";
            }
            case Medication: {
                return "medication";
            }
            case MedicationAdministration: {
                return "medicationadministration";
            }
            case MedicationDispense: {
                return "medicationdispense";
            }
            case MedicationRequest: {
                return "medicationrequest";
            }
            case MedicationStatement: {
                return "medicationstatement";
            }
            case MessageDefinition: {
                return "messagedefinition";
            }
            case MessageHeader: {
                return "messageheader";
            }
            case NamingSystem: {
                return "namingsystem";
            }
            case NutritionOrder: {
                return "nutritionorder";
            }
            case Observation: {
                return "observation";
            }
            case OperationDefinition: {
                return "operationdefinition";
            }
            case OperationOutcome: {
                return "operationoutcome";
            }
            case Organization: {
                return "organization";
            }
            case Parameters: {
                return "parameters";
            }
            case Patient: {
                return "patient";
            }
            case PaymentNotice: {
                return "paymentnotice";
            }
            case PaymentReconciliation: {
                return "paymentreconciliation";
            }
            case Person: {
                return "person";
            }
            case PlanDefinition: {
                return "plandefinition";
            }
            case Practitioner: {
                return "practitioner";
            }
            case PractitionerRole: {
                return "practitionerrole";
            }
            case Procedure: {
                return "procedure";
            }
            case ProcedureRequest: {
                return "procedurerequest";
            }
            case ProcessRequest: {
                return "processrequest";
            }
            case ProcessResponse: {
                return "processresponse";
            }
            case Provenance: {
                return "provenance";
            }
            case Questionnaire: {
                return "questionnaire";
            }
            case QuestionnaireResponse: {
                return "questionnaireresponse";
            }
            case ReferralRequest: {
                return "referralrequest";
            }
            case RelatedPerson: {
                return "relatedperson";
            }
            case RequestGroup: {
                return "requestgroup";
            }
            case ResearchStudy: {
                return "researchstudy";
            }
            case ResearchSubject: {
                return "researchsubject";
            }
            case RiskAssessment: {
                return "riskassessment";
            }
            case Schedule: {
                return "schedule";
            }
            case SearchParameter: {
                return "searchparameter";
            }
            case Sequence: {
                return "sequence";
            }
            case ServiceDefinition: {
                return "servicedefinition";
            }
            case Slot: {
                return "slot";
            }
            case Specimen: {
                return "specimen";
            }
            case StructureDefinition: {
                return "structuredefinition";
            }
            case StructureMap: {
                return "structuremap";
            }
            case Subscription: {
                return "subscription";
            }
            case Substance: {
                return "substance";
            }
            case SupplyDelivery: {
                return "supplydelivery";
            }
            case SupplyRequest: {
                return "supplyrequest";
            }
            case Task: {
                return "task";
            }
            case TestReport: {
                return "testreport";
            }
            case TestScript: {
                return "testscript";
            }
            case ValueSet: {
                return "valueset";
            }
            case VisionPrescription: {
                return "visionprescription";
            }
        }
        return null;
    }

    public static ResourceType fromCode(String code) throws FHIRException {
        if ("Account".equals(code)) {
            return Account;
        }
        if ("ActivityDefinition".equals(code)) {
            return ActivityDefinition;
        }
        if ("AdverseEvent".equals(code)) {
            return AdverseEvent;
        }
        if ("AllergyIntolerance".equals(code)) {
            return AllergyIntolerance;
        }
        if ("Appointment".equals(code)) {
            return Appointment;
        }
        if ("AppointmentResponse".equals(code)) {
            return AppointmentResponse;
        }
        if ("AuditEvent".equals(code)) {
            return AuditEvent;
        }
        if ("Basic".equals(code)) {
            return Basic;
        }
        if ("Binary".equals(code)) {
            return Binary;
        }
        if ("BodySite".equals(code)) {
            return BodySite;
        }
        if ("Bundle".equals(code)) {
            return Bundle;
        }
        if ("CapabilityStatement".equals(code)) {
            return CapabilityStatement;
        }
        if ("CarePlan".equals(code)) {
            return CarePlan;
        }
        if ("CareTeam".equals(code)) {
            return CareTeam;
        }
        if ("ChargeItem".equals(code)) {
            return ChargeItem;
        }
        if ("Claim".equals(code)) {
            return Claim;
        }
        if ("ClaimResponse".equals(code)) {
            return ClaimResponse;
        }
        if ("ClinicalImpression".equals(code)) {
            return ClinicalImpression;
        }
        if ("CodeSystem".equals(code)) {
            return CodeSystem;
        }
        if ("Communication".equals(code)) {
            return Communication;
        }
        if ("CommunicationRequest".equals(code)) {
            return CommunicationRequest;
        }
        if ("CompartmentDefinition".equals(code)) {
            return CompartmentDefinition;
        }
        if ("Composition".equals(code)) {
            return Composition;
        }
        if ("ConceptMap".equals(code)) {
            return ConceptMap;
        }
        if ("Condition".equals(code)) {
            return Condition;
        }
        if ("Consent".equals(code)) {
            return Consent;
        }
        if ("Contract".equals(code)) {
            return Contract;
        }
        if ("Coverage".equals(code)) {
            return Coverage;
        }
        if ("DataElement".equals(code)) {
            return DataElement;
        }
        if ("DetectedIssue".equals(code)) {
            return DetectedIssue;
        }
        if ("Device".equals(code)) {
            return Device;
        }
        if ("DeviceComponent".equals(code)) {
            return DeviceComponent;
        }
        if ("DeviceMetric".equals(code)) {
            return DeviceMetric;
        }
        if ("DeviceRequest".equals(code)) {
            return DeviceRequest;
        }
        if ("DeviceUseStatement".equals(code)) {
            return DeviceUseStatement;
        }
        if ("DiagnosticReport".equals(code)) {
            return DiagnosticReport;
        }
        if ("DocumentManifest".equals(code)) {
            return DocumentManifest;
        }
        if ("DocumentReference".equals(code)) {
            return DocumentReference;
        }
        if ("EligibilityRequest".equals(code)) {
            return EligibilityRequest;
        }
        if ("EligibilityResponse".equals(code)) {
            return EligibilityResponse;
        }
        if ("Encounter".equals(code)) {
            return Encounter;
        }
        if ("Endpoint".equals(code)) {
            return Endpoint;
        }
        if ("EnrollmentRequest".equals(code)) {
            return EnrollmentRequest;
        }
        if ("EnrollmentResponse".equals(code)) {
            return EnrollmentResponse;
        }
        if ("EpisodeOfCare".equals(code)) {
            return EpisodeOfCare;
        }
        if ("ExpansionProfile".equals(code)) {
            return ExpansionProfile;
        }
        if ("ExplanationOfBenefit".equals(code)) {
            return ExplanationOfBenefit;
        }
        if ("FamilyMemberHistory".equals(code)) {
            return FamilyMemberHistory;
        }
        if ("Flag".equals(code)) {
            return Flag;
        }
        if ("Goal".equals(code)) {
            return Goal;
        }
        if ("GraphDefinition".equals(code)) {
            return GraphDefinition;
        }
        if ("Group".equals(code)) {
            return Group;
        }
        if ("GuidanceResponse".equals(code)) {
            return GuidanceResponse;
        }
        if ("HealthcareService".equals(code)) {
            return HealthcareService;
        }
        if ("ImagingManifest".equals(code)) {
            return ImagingManifest;
        }
        if ("ImagingStudy".equals(code)) {
            return ImagingStudy;
        }
        if ("Immunization".equals(code)) {
            return Immunization;
        }
        if ("ImmunizationRecommendation".equals(code)) {
            return ImmunizationRecommendation;
        }
        if ("ImplementationGuide".equals(code)) {
            return ImplementationGuide;
        }
        if ("Library".equals(code)) {
            return Library;
        }
        if ("Linkage".equals(code)) {
            return Linkage;
        }
        if ("List".equals(code)) {
            return List;
        }
        if ("Location".equals(code)) {
            return Location;
        }
        if ("Measure".equals(code)) {
            return Measure;
        }
        if ("MeasureReport".equals(code)) {
            return MeasureReport;
        }
        if ("Media".equals(code)) {
            return Media;
        }
        if ("Medication".equals(code)) {
            return Medication;
        }
        if ("MedicationAdministration".equals(code)) {
            return MedicationAdministration;
        }
        if ("MedicationDispense".equals(code)) {
            return MedicationDispense;
        }
        if ("MedicationRequest".equals(code)) {
            return MedicationRequest;
        }
        if ("MedicationStatement".equals(code)) {
            return MedicationStatement;
        }
        if ("MessageDefinition".equals(code)) {
            return MessageDefinition;
        }
        if ("MessageHeader".equals(code)) {
            return MessageHeader;
        }
        if ("NamingSystem".equals(code)) {
            return NamingSystem;
        }
        if ("NutritionOrder".equals(code)) {
            return NutritionOrder;
        }
        if ("Observation".equals(code)) {
            return Observation;
        }
        if ("OperationDefinition".equals(code)) {
            return OperationDefinition;
        }
        if ("OperationOutcome".equals(code)) {
            return OperationOutcome;
        }
        if ("Organization".equals(code)) {
            return Organization;
        }
        if ("Parameters".equals(code)) {
            return Parameters;
        }
        if ("Patient".equals(code)) {
            return Patient;
        }
        if ("PaymentNotice".equals(code)) {
            return PaymentNotice;
        }
        if ("PaymentReconciliation".equals(code)) {
            return PaymentReconciliation;
        }
        if ("Person".equals(code)) {
            return Person;
        }
        if ("PlanDefinition".equals(code)) {
            return PlanDefinition;
        }
        if ("Practitioner".equals(code)) {
            return Practitioner;
        }
        if ("PractitionerRole".equals(code)) {
            return PractitionerRole;
        }
        if ("Procedure".equals(code)) {
            return Procedure;
        }
        if ("ProcedureRequest".equals(code)) {
            return ProcedureRequest;
        }
        if ("ProcessRequest".equals(code)) {
            return ProcessRequest;
        }
        if ("ProcessResponse".equals(code)) {
            return ProcessResponse;
        }
        if ("Provenance".equals(code)) {
            return Provenance;
        }
        if ("Questionnaire".equals(code)) {
            return Questionnaire;
        }
        if ("QuestionnaireResponse".equals(code)) {
            return QuestionnaireResponse;
        }
        if ("ReferralRequest".equals(code)) {
            return ReferralRequest;
        }
        if ("RelatedPerson".equals(code)) {
            return RelatedPerson;
        }
        if ("RequestGroup".equals(code)) {
            return RequestGroup;
        }
        if ("ResearchStudy".equals(code)) {
            return ResearchStudy;
        }
        if ("ResearchSubject".equals(code)) {
            return ResearchSubject;
        }
        if ("RiskAssessment".equals(code)) {
            return RiskAssessment;
        }
        if ("Schedule".equals(code)) {
            return Schedule;
        }
        if ("SearchParameter".equals(code)) {
            return SearchParameter;
        }
        if ("Sequence".equals(code)) {
            return Sequence;
        }
        if ("ServiceDefinition".equals(code)) {
            return ServiceDefinition;
        }
        if ("Slot".equals(code)) {
            return Slot;
        }
        if ("Specimen".equals(code)) {
            return Specimen;
        }
        if ("StructureDefinition".equals(code)) {
            return StructureDefinition;
        }
        if ("StructureMap".equals(code)) {
            return StructureMap;
        }
        if ("Subscription".equals(code)) {
            return Subscription;
        }
        if ("Substance".equals(code)) {
            return Substance;
        }
        if ("SupplyDelivery".equals(code)) {
            return SupplyDelivery;
        }
        if ("SupplyRequest".equals(code)) {
            return SupplyRequest;
        }
        if ("Task".equals(code)) {
            return Task;
        }
        if ("TestReport".equals(code)) {
            return TestReport;
        }
        if ("TestScript".equals(code)) {
            return TestScript;
        }
        if ("ValueSet".equals(code)) {
            return ValueSet;
        }
        if ("VisionPrescription".equals(code)) {
            return VisionPrescription;
        }
        throw new FHIRException("Unknown resource type" + code);
    }
}

