/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model;

import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu3.model.Address;
import org.hl7.fhir.dstu3.model.Attachment;
import org.hl7.fhir.dstu3.model.BackboneElement;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.BooleanType;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Configuration;
import org.hl7.fhir.dstu3.model.ContactPoint;
import org.hl7.fhir.dstu3.model.DateType;
import org.hl7.fhir.dstu3.model.DomainResource;
import org.hl7.fhir.dstu3.model.Enumeration;
import org.hl7.fhir.dstu3.model.Enumerations;
import org.hl7.fhir.dstu3.model.HumanName;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Organization;
import org.hl7.fhir.dstu3.model.Period;
import org.hl7.fhir.dstu3.model.Property;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.ResourceType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;

@ResourceDef(name="Practitioner", profile="http://hl7.org/fhir/Profile/Practitioner")
public class Practitioner
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="A identifier for the person as this agent", formalDefinition="An identifier that applies to this person in this role.")
    protected List<Identifier> identifier;
    @Child(name="active", type={BooleanType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Whether this practitioner's record is in active use", formalDefinition="Whether this practitioner's record is in active use.")
    protected BooleanType active;
    @Child(name="name", type={HumanName.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The name(s) associated with the practitioner", formalDefinition="The name(s) associated with the practitioner.")
    protected List<HumanName> name;
    @Child(name="telecom", type={ContactPoint.class}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="A contact detail for the practitioner (that apply to all roles)", formalDefinition="A contact detail for the practitioner, e.g. a telephone number or an email address.")
    protected List<ContactPoint> telecom;
    @Child(name="address", type={Address.class}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Address(es) of the practitioner that are not role specific (typically home address)", formalDefinition="Address(es) of the practitioner that are not role specific (typically home address). \rWork addresses are not typically entered in this property as they are usually role dependent.")
    protected List<Address> address;
    @Child(name="gender", type={CodeType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="male | female | other | unknown", formalDefinition="Administrative Gender - the gender that the person is considered to have for administration and record keeping purposes.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/administrative-gender")
    protected Enumeration<Enumerations.AdministrativeGender> gender;
    @Child(name="birthDate", type={DateType.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The date  on which the practitioner was born", formalDefinition="The date of birth for the practitioner.")
    protected DateType birthDate;
    @Child(name="photo", type={Attachment.class}, order=7, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Image of the person", formalDefinition="Image of the person.")
    protected List<Attachment> photo;
    @Child(name="qualification", type={}, order=8, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Qualifications obtained by training and certification", formalDefinition="Qualifications obtained by training and certification.")
    protected List<PractitionerQualificationComponent> qualification;
    @Child(name="communication", type={CodeableConcept.class}, order=9, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="A language the practitioner is able to use in patient communication", formalDefinition="A language the practitioner is able to use in patient communication.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/languages")
    protected List<CodeableConcept> communication;
    private static final long serialVersionUID = 2128349259L;
    @SearchParamDefinition(name="identifier", path="Practitioner.identifier", description="A practitioner's Identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="given", path="Practitioner.name.given", description="A portion of the given name", type="string")
    public static final String SP_GIVEN = "given";
    public static final StringClientParam GIVEN = new StringClientParam("given");
    @SearchParamDefinition(name="address", path="Practitioner.address", description="A server defined search that may match any of the string fields in the Address, including line, city, state, country, postalCode, and/or text", type="string")
    public static final String SP_ADDRESS = "address";
    public static final StringClientParam ADDRESS = new StringClientParam("address");
    @SearchParamDefinition(name="address-state", path="Practitioner.address.state", description="A state specified in an address", type="string")
    public static final String SP_ADDRESS_STATE = "address-state";
    public static final StringClientParam ADDRESS_STATE = new StringClientParam("address-state");
    @SearchParamDefinition(name="gender", path="Practitioner.gender", description="Gender of the practitioner", type="token")
    public static final String SP_GENDER = "gender";
    public static final TokenClientParam GENDER = new TokenClientParam("gender");
    @SearchParamDefinition(name="active", path="Practitioner.active", description="Whether the practitioner record is active", type="token")
    public static final String SP_ACTIVE = "active";
    public static final TokenClientParam ACTIVE = new TokenClientParam("active");
    @SearchParamDefinition(name="address-postalcode", path="Practitioner.address.postalCode", description="A postalCode specified in an address", type="string")
    public static final String SP_ADDRESS_POSTALCODE = "address-postalcode";
    public static final StringClientParam ADDRESS_POSTALCODE = new StringClientParam("address-postalcode");
    @SearchParamDefinition(name="address-country", path="Practitioner.address.country", description="A country specified in an address", type="string")
    public static final String SP_ADDRESS_COUNTRY = "address-country";
    public static final StringClientParam ADDRESS_COUNTRY = new StringClientParam("address-country");
    @SearchParamDefinition(name="phonetic", path="Practitioner.name", description="A portion of either family or given name using some kind of phonetic matching algorithm", type="string")
    public static final String SP_PHONETIC = "phonetic";
    public static final StringClientParam PHONETIC = new StringClientParam("phonetic");
    @SearchParamDefinition(name="phone", path="Practitioner.telecom.where(system='phone')", description="A value in a phone contact", type="token")
    public static final String SP_PHONE = "phone";
    public static final TokenClientParam PHONE = new TokenClientParam("phone");
    @SearchParamDefinition(name="name", path="Practitioner.name", description="A server defined search that may match any of the string fields in the HumanName, including family, give, prefix, suffix, suffix, and/or text", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="address-use", path="Practitioner.address.use", description="A use code specified in an address", type="token")
    public static final String SP_ADDRESS_USE = "address-use";
    public static final TokenClientParam ADDRESS_USE = new TokenClientParam("address-use");
    @SearchParamDefinition(name="telecom", path="Practitioner.telecom", description="The value in any kind of contact", type="token")
    public static final String SP_TELECOM = "telecom";
    public static final TokenClientParam TELECOM = new TokenClientParam("telecom");
    @SearchParamDefinition(name="family", path="Practitioner.name.family", description="A portion of the family name", type="string")
    public static final String SP_FAMILY = "family";
    public static final StringClientParam FAMILY = new StringClientParam("family");
    @SearchParamDefinition(name="address-city", path="Practitioner.address.city", description="A city specified in an address", type="string")
    public static final String SP_ADDRESS_CITY = "address-city";
    public static final StringClientParam ADDRESS_CITY = new StringClientParam("address-city");
    @SearchParamDefinition(name="communication", path="Practitioner.communication", description="One of the languages that the practitioner can communicate with", type="token")
    public static final String SP_COMMUNICATION = "communication";
    public static final TokenClientParam COMMUNICATION = new TokenClientParam("communication");
    @SearchParamDefinition(name="email", path="Practitioner.telecom.where(system='email')", description="A value in an email contact", type="token")
    public static final String SP_EMAIL = "email";
    public static final TokenClientParam EMAIL = new TokenClientParam("email");

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Practitioner setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Practitioner addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public BooleanType getActiveElement() {
        if (this.active == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Practitioner.active");
            }
            if (Configuration.doAutoCreate()) {
                this.active = new BooleanType();
            }
        }
        return this.active;
    }

    public boolean hasActiveElement() {
        return this.active != null && !this.active.isEmpty();
    }

    public boolean hasActive() {
        return this.active != null && !this.active.isEmpty();
    }

    public Practitioner setActiveElement(BooleanType value) {
        this.active = value;
        return this;
    }

    public boolean getActive() {
        return this.active == null || this.active.isEmpty() ? false : (Boolean)this.active.getValue();
    }

    public Practitioner setActive(boolean value) {
        if (this.active == null) {
            this.active = new BooleanType();
        }
        this.active.setValue((Object)value);
        return this;
    }

    public List<HumanName> getName() {
        if (this.name == null) {
            this.name = new ArrayList<HumanName>();
        }
        return this.name;
    }

    public Practitioner setName(List<HumanName> theName) {
        this.name = theName;
        return this;
    }

    public boolean hasName() {
        if (this.name == null) {
            return false;
        }
        for (HumanName item : this.name) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public HumanName addName() {
        HumanName t = new HumanName();
        if (this.name == null) {
            this.name = new ArrayList<HumanName>();
        }
        this.name.add(t);
        return t;
    }

    public Practitioner addName(HumanName t) {
        if (t == null) {
            return this;
        }
        if (this.name == null) {
            this.name = new ArrayList<HumanName>();
        }
        this.name.add(t);
        return this;
    }

    public HumanName getNameFirstRep() {
        if (this.getName().isEmpty()) {
            this.addName();
        }
        return this.getName().get(0);
    }

    public List<ContactPoint> getTelecom() {
        if (this.telecom == null) {
            this.telecom = new ArrayList<ContactPoint>();
        }
        return this.telecom;
    }

    public Practitioner setTelecom(List<ContactPoint> theTelecom) {
        this.telecom = theTelecom;
        return this;
    }

    public boolean hasTelecom() {
        if (this.telecom == null) {
            return false;
        }
        for (ContactPoint item : this.telecom) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ContactPoint addTelecom() {
        ContactPoint t = new ContactPoint();
        if (this.telecom == null) {
            this.telecom = new ArrayList<ContactPoint>();
        }
        this.telecom.add(t);
        return t;
    }

    public Practitioner addTelecom(ContactPoint t) {
        if (t == null) {
            return this;
        }
        if (this.telecom == null) {
            this.telecom = new ArrayList<ContactPoint>();
        }
        this.telecom.add(t);
        return this;
    }

    public ContactPoint getTelecomFirstRep() {
        if (this.getTelecom().isEmpty()) {
            this.addTelecom();
        }
        return this.getTelecom().get(0);
    }

    public List<Address> getAddress() {
        if (this.address == null) {
            this.address = new ArrayList<Address>();
        }
        return this.address;
    }

    public Practitioner setAddress(List<Address> theAddress) {
        this.address = theAddress;
        return this;
    }

    public boolean hasAddress() {
        if (this.address == null) {
            return false;
        }
        for (Address item : this.address) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Address addAddress() {
        Address t = new Address();
        if (this.address == null) {
            this.address = new ArrayList<Address>();
        }
        this.address.add(t);
        return t;
    }

    public Practitioner addAddress(Address t) {
        if (t == null) {
            return this;
        }
        if (this.address == null) {
            this.address = new ArrayList<Address>();
        }
        this.address.add(t);
        return this;
    }

    public Address getAddressFirstRep() {
        if (this.getAddress().isEmpty()) {
            this.addAddress();
        }
        return this.getAddress().get(0);
    }

    public Enumeration<Enumerations.AdministrativeGender> getGenderElement() {
        if (this.gender == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Practitioner.gender");
            }
            if (Configuration.doAutoCreate()) {
                this.gender = new Enumeration<Enumerations.AdministrativeGender>(new Enumerations.AdministrativeGenderEnumFactory());
            }
        }
        return this.gender;
    }

    public boolean hasGenderElement() {
        return this.gender != null && !this.gender.isEmpty();
    }

    public boolean hasGender() {
        return this.gender != null && !this.gender.isEmpty();
    }

    public Practitioner setGenderElement(Enumeration<Enumerations.AdministrativeGender> value) {
        this.gender = value;
        return this;
    }

    public Enumerations.AdministrativeGender getGender() {
        return this.gender == null ? null : (Enumerations.AdministrativeGender)((Object)this.gender.getValue());
    }

    public Practitioner setGender(Enumerations.AdministrativeGender value) {
        if (value == null) {
            this.gender = null;
        } else {
            if (this.gender == null) {
                this.gender = new Enumeration<Enumerations.AdministrativeGender>(new Enumerations.AdministrativeGenderEnumFactory());
            }
            this.gender.setValue((Object)value);
        }
        return this;
    }

    public DateType getBirthDateElement() {
        if (this.birthDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Practitioner.birthDate");
            }
            if (Configuration.doAutoCreate()) {
                this.birthDate = new DateType();
            }
        }
        return this.birthDate;
    }

    public boolean hasBirthDateElement() {
        return this.birthDate != null && !this.birthDate.isEmpty();
    }

    public boolean hasBirthDate() {
        return this.birthDate != null && !this.birthDate.isEmpty();
    }

    public Practitioner setBirthDateElement(DateType value) {
        this.birthDate = value;
        return this;
    }

    public Date getBirthDate() {
        return this.birthDate == null ? null : (Date)this.birthDate.getValue();
    }

    public Practitioner setBirthDate(Date value) {
        if (value == null) {
            this.birthDate = null;
        } else {
            if (this.birthDate == null) {
                this.birthDate = new DateType();
            }
            this.birthDate.setValue(value);
        }
        return this;
    }

    public List<Attachment> getPhoto() {
        if (this.photo == null) {
            this.photo = new ArrayList<Attachment>();
        }
        return this.photo;
    }

    public Practitioner setPhoto(List<Attachment> thePhoto) {
        this.photo = thePhoto;
        return this;
    }

    public boolean hasPhoto() {
        if (this.photo == null) {
            return false;
        }
        for (Attachment item : this.photo) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Attachment addPhoto() {
        Attachment t = new Attachment();
        if (this.photo == null) {
            this.photo = new ArrayList<Attachment>();
        }
        this.photo.add(t);
        return t;
    }

    public Practitioner addPhoto(Attachment t) {
        if (t == null) {
            return this;
        }
        if (this.photo == null) {
            this.photo = new ArrayList<Attachment>();
        }
        this.photo.add(t);
        return this;
    }

    public Attachment getPhotoFirstRep() {
        if (this.getPhoto().isEmpty()) {
            this.addPhoto();
        }
        return this.getPhoto().get(0);
    }

    public List<PractitionerQualificationComponent> getQualification() {
        if (this.qualification == null) {
            this.qualification = new ArrayList<PractitionerQualificationComponent>();
        }
        return this.qualification;
    }

    public Practitioner setQualification(List<PractitionerQualificationComponent> theQualification) {
        this.qualification = theQualification;
        return this;
    }

    public boolean hasQualification() {
        if (this.qualification == null) {
            return false;
        }
        for (PractitionerQualificationComponent item : this.qualification) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public PractitionerQualificationComponent addQualification() {
        PractitionerQualificationComponent t = new PractitionerQualificationComponent();
        if (this.qualification == null) {
            this.qualification = new ArrayList<PractitionerQualificationComponent>();
        }
        this.qualification.add(t);
        return t;
    }

    public Practitioner addQualification(PractitionerQualificationComponent t) {
        if (t == null) {
            return this;
        }
        if (this.qualification == null) {
            this.qualification = new ArrayList<PractitionerQualificationComponent>();
        }
        this.qualification.add(t);
        return this;
    }

    public PractitionerQualificationComponent getQualificationFirstRep() {
        if (this.getQualification().isEmpty()) {
            this.addQualification();
        }
        return this.getQualification().get(0);
    }

    public List<CodeableConcept> getCommunication() {
        if (this.communication == null) {
            this.communication = new ArrayList<CodeableConcept>();
        }
        return this.communication;
    }

    public Practitioner setCommunication(List<CodeableConcept> theCommunication) {
        this.communication = theCommunication;
        return this;
    }

    public boolean hasCommunication() {
        if (this.communication == null) {
            return false;
        }
        for (CodeableConcept item : this.communication) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addCommunication() {
        CodeableConcept t = new CodeableConcept();
        if (this.communication == null) {
            this.communication = new ArrayList<CodeableConcept>();
        }
        this.communication.add(t);
        return t;
    }

    public Practitioner addCommunication(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.communication == null) {
            this.communication = new ArrayList<CodeableConcept>();
        }
        this.communication.add(t);
        return this;
    }

    public CodeableConcept getCommunicationFirstRep() {
        if (this.getCommunication().isEmpty()) {
            this.addCommunication();
        }
        return this.getCommunication().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "An identifier that applies to this person in this role.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_ACTIVE, "boolean", "Whether this practitioner's record is in active use.", 0, 1, this.active));
        children.add(new Property(SP_NAME, "HumanName", "The name(s) associated with the practitioner.", 0, Integer.MAX_VALUE, this.name));
        children.add(new Property(SP_TELECOM, "ContactPoint", "A contact detail for the practitioner, e.g. a telephone number or an email address.", 0, Integer.MAX_VALUE, this.telecom));
        children.add(new Property(SP_ADDRESS, "Address", "Address(es) of the practitioner that are not role specific (typically home address). \rWork addresses are not typically entered in this property as they are usually role dependent.", 0, Integer.MAX_VALUE, this.address));
        children.add(new Property(SP_GENDER, "code", "Administrative Gender - the gender that the person is considered to have for administration and record keeping purposes.", 0, 1, this.gender));
        children.add(new Property("birthDate", "date", "The date of birth for the practitioner.", 0, 1, this.birthDate));
        children.add(new Property("photo", "Attachment", "Image of the person.", 0, Integer.MAX_VALUE, this.photo));
        children.add(new Property("qualification", "", "Qualifications obtained by training and certification.", 0, Integer.MAX_VALUE, this.qualification));
        children.add(new Property(SP_COMMUNICATION, "CodeableConcept", "A language the practitioner is able to use in patient communication.", 0, Integer.MAX_VALUE, this.communication));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "An identifier that applies to this person in this role.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -1422950650: {
                return new Property(SP_ACTIVE, "boolean", "Whether this practitioner's record is in active use.", 0, 1, this.active);
            }
            case 3373707: {
                return new Property(SP_NAME, "HumanName", "The name(s) associated with the practitioner.", 0, Integer.MAX_VALUE, this.name);
            }
            case -1429363305: {
                return new Property(SP_TELECOM, "ContactPoint", "A contact detail for the practitioner, e.g. a telephone number or an email address.", 0, Integer.MAX_VALUE, this.telecom);
            }
            case -1147692044: {
                return new Property(SP_ADDRESS, "Address", "Address(es) of the practitioner that are not role specific (typically home address). \rWork addresses are not typically entered in this property as they are usually role dependent.", 0, Integer.MAX_VALUE, this.address);
            }
            case -1249512767: {
                return new Property(SP_GENDER, "code", "Administrative Gender - the gender that the person is considered to have for administration and record keeping purposes.", 0, 1, this.gender);
            }
            case -1210031859: {
                return new Property("birthDate", "date", "The date of birth for the practitioner.", 0, 1, this.birthDate);
            }
            case 106642994: {
                return new Property("photo", "Attachment", "Image of the person.", 0, Integer.MAX_VALUE, this.photo);
            }
            case -631333393: {
                return new Property("qualification", "", "Qualifications obtained by training and certification.", 0, Integer.MAX_VALUE, this.qualification);
            }
            case -1035284522: {
                return new Property(SP_COMMUNICATION, "CodeableConcept", "A language the practitioner is able to use in patient communication.", 0, Integer.MAX_VALUE, this.communication);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -1422950650: {
                Base[] baseArray;
                if (this.active == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.active;
                }
                return baseArray;
            }
            case 3373707: {
                return this.name == null ? new Base[]{} : this.name.toArray(new Base[this.name.size()]);
            }
            case -1429363305: {
                return this.telecom == null ? new Base[]{} : this.telecom.toArray(new Base[this.telecom.size()]);
            }
            case -1147692044: {
                return this.address == null ? new Base[]{} : this.address.toArray(new Base[this.address.size()]);
            }
            case -1249512767: {
                Base[] baseArray;
                if (this.gender == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.gender;
                }
                return baseArray;
            }
            case -1210031859: {
                Base[] baseArray;
                if (this.birthDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.birthDate;
                }
                return baseArray;
            }
            case 106642994: {
                return this.photo == null ? new Base[]{} : this.photo.toArray(new Base[this.photo.size()]);
            }
            case -631333393: {
                return this.qualification == null ? new Base[]{} : this.qualification.toArray(new Base[this.qualification.size()]);
            }
            case -1035284522: {
                return this.communication == null ? new Base[]{} : this.communication.toArray(new Base[this.communication.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case -1422950650: {
                this.active = this.castToBoolean(value);
                return value;
            }
            case 3373707: {
                this.getName().add(this.castToHumanName(value));
                return value;
            }
            case -1429363305: {
                this.getTelecom().add(this.castToContactPoint(value));
                return value;
            }
            case -1147692044: {
                this.getAddress().add(this.castToAddress(value));
                return value;
            }
            case -1249512767: {
                value = new Enumerations.AdministrativeGenderEnumFactory().fromType(this.castToCode(value));
                this.gender = value;
                return value;
            }
            case -1210031859: {
                this.birthDate = this.castToDate(value);
                return value;
            }
            case 106642994: {
                this.getPhoto().add(this.castToAttachment(value));
                return value;
            }
            case -631333393: {
                this.getQualification().add((PractitionerQualificationComponent)((Object)value));
                return value;
            }
            case -1035284522: {
                this.getCommunication().add(this.castToCodeableConcept(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_ACTIVE)) {
            this.active = this.castToBoolean(value);
        } else if (name.equals(SP_NAME)) {
            this.getName().add(this.castToHumanName(value));
        } else if (name.equals(SP_TELECOM)) {
            this.getTelecom().add(this.castToContactPoint(value));
        } else if (name.equals(SP_ADDRESS)) {
            this.getAddress().add(this.castToAddress(value));
        } else if (name.equals(SP_GENDER)) {
            value = new Enumerations.AdministrativeGenderEnumFactory().fromType(this.castToCode(value));
            this.gender = value;
        } else if (name.equals("birthDate")) {
            this.birthDate = this.castToDate(value);
        } else if (name.equals("photo")) {
            this.getPhoto().add(this.castToAttachment(value));
        } else if (name.equals("qualification")) {
            this.getQualification().add((PractitionerQualificationComponent)((Object)value));
        } else if (name.equals(SP_COMMUNICATION)) {
            this.getCommunication().add(this.castToCodeableConcept(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -1422950650: {
                return this.getActiveElement();
            }
            case 3373707: {
                return this.addName();
            }
            case -1429363305: {
                return this.addTelecom();
            }
            case -1147692044: {
                return this.addAddress();
            }
            case -1249512767: {
                return this.getGenderElement();
            }
            case -1210031859: {
                return this.getBirthDateElement();
            }
            case 106642994: {
                return this.addPhoto();
            }
            case -631333393: {
                return this.addQualification();
            }
            case -1035284522: {
                return this.addCommunication();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -1422950650: {
                return new String[]{"boolean"};
            }
            case 3373707: {
                return new String[]{"HumanName"};
            }
            case -1429363305: {
                return new String[]{"ContactPoint"};
            }
            case -1147692044: {
                return new String[]{"Address"};
            }
            case -1249512767: {
                return new String[]{"code"};
            }
            case -1210031859: {
                return new String[]{"date"};
            }
            case 106642994: {
                return new String[]{"Attachment"};
            }
            case -631333393: {
                return new String[0];
            }
            case -1035284522: {
                return new String[]{"CodeableConcept"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_ACTIVE)) {
            throw new FHIRException("Cannot call addChild on a primitive type Practitioner.active");
        }
        if (name.equals(SP_NAME)) {
            return this.addName();
        }
        if (name.equals(SP_TELECOM)) {
            return this.addTelecom();
        }
        if (name.equals(SP_ADDRESS)) {
            return this.addAddress();
        }
        if (name.equals(SP_GENDER)) {
            throw new FHIRException("Cannot call addChild on a primitive type Practitioner.gender");
        }
        if (name.equals("birthDate")) {
            throw new FHIRException("Cannot call addChild on a primitive type Practitioner.birthDate");
        }
        if (name.equals("photo")) {
            return this.addPhoto();
        }
        if (name.equals("qualification")) {
            return this.addQualification();
        }
        if (name.equals(SP_COMMUNICATION)) {
            return this.addCommunication();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Practitioner";
    }

    @Override
    public Practitioner copy() {
        Practitioner dst = new Practitioner();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        BooleanType booleanType = dst.active = this.active == null ? null : this.active.copy();
        if (this.name != null) {
            dst.name = new ArrayList<HumanName>();
            for (HumanName humanName : this.name) {
                dst.name.add(humanName.copy());
            }
        }
        if (this.telecom != null) {
            dst.telecom = new ArrayList<ContactPoint>();
            for (ContactPoint contactPoint : this.telecom) {
                dst.telecom.add(contactPoint.copy());
            }
        }
        if (this.address != null) {
            dst.address = new ArrayList<Address>();
            for (Address address : this.address) {
                dst.address.add(address.copy());
            }
        }
        dst.gender = this.gender == null ? null : this.gender.copy();
        DateType dateType = dst.birthDate = this.birthDate == null ? null : this.birthDate.copy();
        if (this.photo != null) {
            dst.photo = new ArrayList<Attachment>();
            for (Attachment attachment : this.photo) {
                dst.photo.add(attachment.copy());
            }
        }
        if (this.qualification != null) {
            dst.qualification = new ArrayList<PractitionerQualificationComponent>();
            for (PractitionerQualificationComponent practitionerQualificationComponent : this.qualification) {
                dst.qualification.add(practitionerQualificationComponent.copy());
            }
        }
        if (this.communication != null) {
            dst.communication = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.communication) {
                dst.communication.add(codeableConcept.copy());
            }
        }
        return dst;
    }

    protected Practitioner typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Practitioner)) {
            return false;
        }
        Practitioner o = (Practitioner)other_;
        return Practitioner.compareDeep(this.identifier, o.identifier, true) && Practitioner.compareDeep(this.active, o.active, true) && Practitioner.compareDeep(this.name, o.name, true) && Practitioner.compareDeep(this.telecom, o.telecom, true) && Practitioner.compareDeep(this.address, o.address, true) && Practitioner.compareDeep(this.gender, o.gender, true) && Practitioner.compareDeep(this.birthDate, o.birthDate, true) && Practitioner.compareDeep(this.photo, o.photo, true) && Practitioner.compareDeep(this.qualification, o.qualification, true) && Practitioner.compareDeep(this.communication, o.communication, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Practitioner)) {
            return false;
        }
        Practitioner o = (Practitioner)other_;
        return Practitioner.compareValues(this.active, o.active, true) && Practitioner.compareValues(this.gender, o.gender, true) && Practitioner.compareValues(this.birthDate, o.birthDate, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty(this.identifier, this.active, this.name, this.telecom, this.address, this.gender, this.birthDate, this.photo, this.qualification, this.communication);
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Practitioner;
    }

    @Block
    public static class PractitionerQualificationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="An identifier for this qualification for the practitioner", formalDefinition="An identifier that applies to this person's qualification in this role.")
        protected List<Identifier> identifier;
        @Child(name="code", type={CodeableConcept.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Coded representation of the qualification", formalDefinition="Coded representation of the qualification.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/v2-2.7-0360")
        protected CodeableConcept code;
        @Child(name="period", type={Period.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Period during which the qualification is valid", formalDefinition="Period during which the qualification is valid.")
        protected Period period;
        @Child(name="issuer", type={Organization.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Organization that regulates and issues the qualification", formalDefinition="Organization that regulates and issues the qualification.")
        protected Reference issuer;
        protected Organization issuerTarget;
        private static final long serialVersionUID = 1095219071L;

        public PractitionerQualificationComponent() {
        }

        public PractitionerQualificationComponent(CodeableConcept code) {
            this.code = code;
        }

        public List<Identifier> getIdentifier() {
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            return this.identifier;
        }

        public PractitionerQualificationComponent setIdentifier(List<Identifier> theIdentifier) {
            this.identifier = theIdentifier;
            return this;
        }

        public boolean hasIdentifier() {
            if (this.identifier == null) {
                return false;
            }
            for (Identifier item : this.identifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Identifier addIdentifier() {
            Identifier t = new Identifier();
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            this.identifier.add(t);
            return t;
        }

        public PractitionerQualificationComponent addIdentifier(Identifier t) {
            if (t == null) {
                return this;
            }
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            this.identifier.add(t);
            return this;
        }

        public Identifier getIdentifierFirstRep() {
            if (this.getIdentifier().isEmpty()) {
                this.addIdentifier();
            }
            return this.getIdentifier().get(0);
        }

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PractitionerQualificationComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public PractitionerQualificationComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public Period getPeriod() {
            if (this.period == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PractitionerQualificationComponent.period");
                }
                if (Configuration.doAutoCreate()) {
                    this.period = new Period();
                }
            }
            return this.period;
        }

        public boolean hasPeriod() {
            return this.period != null && !this.period.isEmpty();
        }

        public PractitionerQualificationComponent setPeriod(Period value) {
            this.period = value;
            return this;
        }

        public Reference getIssuer() {
            if (this.issuer == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PractitionerQualificationComponent.issuer");
                }
                if (Configuration.doAutoCreate()) {
                    this.issuer = new Reference();
                }
            }
            return this.issuer;
        }

        public boolean hasIssuer() {
            return this.issuer != null && !this.issuer.isEmpty();
        }

        public PractitionerQualificationComponent setIssuer(Reference value) {
            this.issuer = value;
            return this;
        }

        public Organization getIssuerTarget() {
            if (this.issuerTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PractitionerQualificationComponent.issuer");
                }
                if (Configuration.doAutoCreate()) {
                    this.issuerTarget = new Organization();
                }
            }
            return this.issuerTarget;
        }

        public PractitionerQualificationComponent setIssuerTarget(Organization value) {
            this.issuerTarget = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(Practitioner.SP_IDENTIFIER, "Identifier", "An identifier that applies to this person's qualification in this role.", 0, Integer.MAX_VALUE, this.identifier));
            children.add(new Property("code", "CodeableConcept", "Coded representation of the qualification.", 0, 1, this.code));
            children.add(new Property("period", "Period", "Period during which the qualification is valid.", 0, 1, this.period));
            children.add(new Property("issuer", "Reference(Organization)", "Organization that regulates and issues the qualification.", 0, 1, this.issuer));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1618432855: {
                    return new Property(Practitioner.SP_IDENTIFIER, "Identifier", "An identifier that applies to this person's qualification in this role.", 0, Integer.MAX_VALUE, this.identifier);
                }
                case 3059181: {
                    return new Property("code", "CodeableConcept", "Coded representation of the qualification.", 0, 1, this.code);
                }
                case -991726143: {
                    return new Property("period", "Period", "Period during which the qualification is valid.", 0, 1, this.period);
                }
                case -1179159879: {
                    return new Property("issuer", "Reference(Organization)", "Organization that regulates and issues the qualification.", 0, 1, this.issuer);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
                }
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case -991726143: {
                    Base[] baseArray;
                    if (this.period == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.period;
                    }
                    return baseArray;
                }
                case -1179159879: {
                    Base[] baseArray;
                    if (this.issuer == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.issuer;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    this.getIdentifier().add(this.castToIdentifier(value));
                    return value;
                }
                case 3059181: {
                    this.code = this.castToCodeableConcept(value);
                    return value;
                }
                case -991726143: {
                    this.period = this.castToPeriod(value);
                    return value;
                }
                case -1179159879: {
                    this.issuer = this.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Practitioner.SP_IDENTIFIER)) {
                this.getIdentifier().add(this.castToIdentifier(value));
            } else if (name.equals("code")) {
                this.code = this.castToCodeableConcept(value);
            } else if (name.equals("period")) {
                this.period = this.castToPeriod(value);
            } else if (name.equals("issuer")) {
                this.issuer = this.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return this.addIdentifier();
                }
                case 3059181: {
                    return this.getCode();
                }
                case -991726143: {
                    return this.getPeriod();
                }
                case -1179159879: {
                    return this.getIssuer();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return new String[]{"Identifier"};
                }
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case -991726143: {
                    return new String[]{"Period"};
                }
                case -1179159879: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Practitioner.SP_IDENTIFIER)) {
                return this.addIdentifier();
            }
            if (name.equals("code")) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals("period")) {
                this.period = new Period();
                return this.period;
            }
            if (name.equals("issuer")) {
                this.issuer = new Reference();
                return this.issuer;
            }
            return super.addChild(name);
        }

        @Override
        public PractitionerQualificationComponent copy() {
            PractitionerQualificationComponent dst = new PractitionerQualificationComponent();
            this.copyValues(dst);
            if (this.identifier != null) {
                dst.identifier = new ArrayList<Identifier>();
                for (Identifier i2 : this.identifier) {
                    dst.identifier.add(i2.copy());
                }
            }
            dst.code = this.code == null ? null : this.code.copy();
            dst.period = this.period == null ? null : this.period.copy();
            dst.issuer = this.issuer == null ? null : this.issuer.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof PractitionerQualificationComponent)) {
                return false;
            }
            PractitionerQualificationComponent o = (PractitionerQualificationComponent)other_;
            return PractitionerQualificationComponent.compareDeep(this.identifier, o.identifier, true) && PractitionerQualificationComponent.compareDeep(this.code, o.code, true) && PractitionerQualificationComponent.compareDeep(this.period, o.period, true) && PractitionerQualificationComponent.compareDeep(this.issuer, o.issuer, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof PractitionerQualificationComponent)) {
                return false;
            }
            PractitionerQualificationComponent o = (PractitionerQualificationComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.identifier, this.code, this.period, this.issuer);
        }

        @Override
        public String fhirType() {
            return "Practitioner.qualification";
        }
    }
}

