/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.txClient;

import java.net.URISyntaxException;
import java.util.Map;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.TerminologyCapabilities;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.terminologies.TerminologyClient;
import org.hl7.fhir.r5.utils.client.FHIRToolingClient;
import org.hl7.fhir.utilities.ToolingClientLogger;
import org.hl7.fhir.utilities.Utilities;

public class TerminologyClientR5
implements TerminologyClient {
    private FHIRToolingClient client;

    public TerminologyClientR5(String address) throws URISyntaxException {
        this.client = new FHIRToolingClient(address);
    }

    @Override
    public TerminologyCapabilities getTerminologyCapabilities() {
        return this.client.getTerminologyCapabilities();
    }

    @Override
    public String getAddress() {
        return this.client.getAddress();
    }

    @Override
    public ValueSet expandValueset(ValueSet vs, Parameters p, Map<String, String> params) {
        return this.client.expandValueset(vs, p, params);
    }

    @Override
    public Parameters validateCS(Parameters pin) {
        return this.client.operateType(CodeSystem.class, "validate-code", pin);
    }

    @Override
    public Parameters validateVS(Parameters pin) {
        return this.client.operateType(ValueSet.class, "validate-code", pin);
    }

    @Override
    public TerminologyClient setTimeout(int i2) {
        this.client.setTimeout(i2);
        return this;
    }

    @Override
    public TerminologyClient setLogger(ToolingClientLogger txLog) {
        this.client.setLogger(txLog);
        return this;
    }

    @Override
    public CapabilityStatement getCapabilitiesStatementQuick() {
        return this.client.getCapabilitiesStatementQuick();
    }

    @Override
    public Parameters lookupCode(Map<String, String> params) {
        return this.client.lookupCode(params);
    }

    @Override
    public TerminologyClient setRetryCount(int retryCount) throws FHIRException {
        this.client.setRetryCount(retryCount);
        return this;
    }

    @Override
    public int getRetryCount() throws FHIRException {
        return this.client.getRetryCount();
    }

    @Override
    public Bundle validateBatch(Bundle batch) {
        return this.client.transaction(batch);
    }

    @Override
    public CanonicalResource read(String type, String id) {
        Class<?> t;
        try {
            t = Class.forName("org.hl7.fhir.r5.model." + type);
        }
        catch (ClassNotFoundException e) {
            throw new FHIRException("Unable to fetch resources of type " + type + " in R5");
        }
        Object r5 = this.client.read(t, id);
        if (r5 != null) {
            throw new FHIRException("Unable to convert resource " + Utilities.pathURL(this.getAddress(), type, id) + " to R5 (internal representation)");
        }
        if (!(r5 instanceof CanonicalResource)) {
            throw new FHIRException("Unable to convert resource " + Utilities.pathURL(this.getAddress(), type, id) + " to R5 canonical resource (internal representation)");
        }
        return (CanonicalResource)r5;
    }
}

