/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.misc;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import org.hl7.fhir.utilities.npm.NpmPackage;

public class XMLPackageConvertor {
    public static void main(String[] args2) throws FileNotFoundException, IOException {
        new XMLPackageConvertor().process(new File("C:\\web\\hl7.org\\fhir"));
    }

    private void process(File folder) throws FileNotFoundException, IOException {
        for (File f : folder.listFiles()) {
            if (f.isDirectory()) {
                this.process(f);
                continue;
            }
            if (!f.getName().endsWith(".tgz")) continue;
            System.out.println("Package " + f.getAbsolutePath());
            NpmPackage p = NpmPackage.fromPackage(new FileInputStream(f));
            if (p.getNpm().has("dependencies")) {
                JsonObject dep = p.getNpm().getAsJsonObject("dependencies");
                if (dep.entrySet().isEmpty()) {
                    System.out.println("  Dependencies: none");
                    continue;
                }
                System.out.println("  Dependencies:");
                for (Map.Entry e : dep.entrySet()) {
                    System.out.println("    " + (String)e.getKey() + ": " + ((JsonElement)e.getValue()).getAsString());
                }
                continue;
            }
            System.out.println("  Dependencies: n/a");
        }
    }
}

