/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.misc;

import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.convertors.VersionConvertor_10_50;
import org.hl7.fhir.convertors.VersionConvertor_30_50;
import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.formats.JsonParser;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.formats.XmlParser;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.Provenance;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.utils.ToolingExtensions;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.npm.FilesystemPackageCacheManager;
import org.hl7.fhir.utilities.npm.NpmPackage;

public class UTGVersionSorter {
    private FilesystemPackageCacheManager pcm;
    private Date runTime = new Date();

    public static void main(String[] args2) throws FileNotFoundException, FHIRException, IOException, ParseException, URISyntaxException {
        new UTGVersionSorter().execute("C:\\work\\org.hl7.fhir.igs\\UTG\\input\\sourceOfTruth");
    }

    private void execute(String source) throws IOException {
        ArrayList<CanonicalResourceAnalysis> list = new ArrayList<CanonicalResourceAnalysis>();
        System.out.println("Loading UTG");
        this.loadFromSource(list, new File(source));
        Map<String, CanonicalResource> r2 = this.loadPackageR2("hl7.fhir.r2.core");
        Map<String, CanonicalResource> r3 = this.loadPackageR3("hl7.fhir.r3.core");
        Map<String, CanonicalResource> r4 = this.loadPackageR4("hl7.fhir.r4.core");
        System.out.println("Processing");
        for (CanonicalResourceAnalysis cr : list) {
            cr.analyse(r2, r3, r4);
        }
        Bundle b = (Bundle)new org.hl7.fhir.r5.formats.JsonParser().parse(new FileInputStream("C:\\work\\org.hl7.fhir.igs\\UTG\\input\\sourceOfTruth\\history\\utgrel1hx-1-0-6.json"));
        System.out.println("Summary");
        for (CanonicalResourceAnalysis cr : list) {
            System.out.println(cr.summary());
            Provenance p = new Provenance();
            b.addEntry().setResource(p).setFullUrl("http://terminology.hl7.org/fhir/Provenance/fhir-1.0.51-" + cr.getId());
            p.setId("hx-fhir-1.0.51-" + cr.getId());
            p.addTarget().setReference(cr.fhirType() + "/" + cr.getId());
            p.getOccurredPeriod().setEnd(this.runTime, TemporalPrecisionEnum.DAY);
            p.setRecorded(this.runTime);
            p.addReason().setText("Reset Version after migration to UTG").addCoding("http://terminology.hl7.org/CodeSystem/v3-ActReason", "METAMGT", null);
            p.getActivity().addCoding("http://terminology.hl7.org/CodeSystem/v3-DataOperation", "UPDATE", null);
            Provenance.ProvenanceAgentComponent pa = p.addAgent();
            pa.getType().addCoding("http://terminology.hl7.org/CodeSystem/provenance-participant-type", "author", null);
            pa.getWho().setDisplay("Grahame Grieve");
            pa = p.addAgent();
            pa.getType().addCoding("http://terminology.hl7.org/CodeSystem/provenance-participant-type", "custodian", null);
            pa.getWho().setDisplay("Vocabulary WG");
            CanonicalResource res = cr.resource;
            res.setVersion(cr.recommendation);
            new XmlParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose(new FileOutputStream(cr.filename), res);
        }
        System.out.println();
        new org.hl7.fhir.r5.formats.JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose(new FileOutputStream("C:\\work\\org.hl7.fhir.igs\\UTG\\input\\sourceOfTruth\\history\\utgrel1hx-1-0-6.json"), b);
        System.out.println("Done");
    }

    private Map<String, CanonicalResource> loadPackageR2(String id) throws IOException {
        HashMap<String, CanonicalResource> res = new HashMap<String, CanonicalResource>();
        if (this.pcm == null) {
            this.pcm = new FilesystemPackageCacheManager(true, 3);
        }
        System.out.println("Load " + id);
        NpmPackage npm = this.pcm.loadPackage(id);
        for (NpmPackage.PackageResourceInformation p : npm.listIndexedResources("CodeSystem", "ValueSet")) {
            CanonicalResource r = (CanonicalResource)VersionConvertor_10_50.convertResource(new org.hl7.fhir.dstu2.formats.JsonParser().parse(npm.load(p)));
            res.put(r.getUrl(), r);
        }
        return res;
    }

    private Map<String, CanonicalResource> loadPackageR3(String id) throws IOException {
        HashMap<String, CanonicalResource> res = new HashMap<String, CanonicalResource>();
        if (this.pcm == null) {
            this.pcm = new FilesystemPackageCacheManager(true, 3);
        }
        System.out.println("Load " + id);
        NpmPackage npm = this.pcm.loadPackage(id);
        for (NpmPackage.PackageResourceInformation p : npm.listIndexedResources("CodeSystem", "ValueSet")) {
            CanonicalResource r = (CanonicalResource)VersionConvertor_30_50.convertResource(new org.hl7.fhir.dstu3.formats.JsonParser().parse(npm.load(p)), false);
            res.put(r.getUrl(), r);
        }
        return res;
    }

    private Map<String, CanonicalResource> loadPackageR4(String id) throws IOException {
        HashMap<String, CanonicalResource> res = new HashMap<String, CanonicalResource>();
        if (this.pcm == null) {
            this.pcm = new FilesystemPackageCacheManager(true, 3);
        }
        System.out.println("Load " + id);
        NpmPackage npm = this.pcm.loadPackage(id);
        for (NpmPackage.PackageResourceInformation p : npm.listIndexedResources("CodeSystem", "ValueSet")) {
            CanonicalResource r = (CanonicalResource)VersionConvertor_40_50.convertResource(new JsonParser().parse(npm.load(p)));
            res.put(r.getUrl(), r);
        }
        return res;
    }

    private void loadFromSource(List<CanonicalResourceAnalysis> list, File source) {
        for (File f : source.listFiles()) {
            if (f.isDirectory()) {
                this.loadFromSource(list, f);
                continue;
            }
            if (!f.getName().endsWith(".xml")) continue;
            try {
                Resource r = new XmlParser().parse(new FileInputStream(f));
                if (!(r instanceof CanonicalResource)) continue;
                CanonicalResource cr = (CanonicalResource)r;
                cr.setUserData("path", f.getAbsolutePath());
                if (!cr.hasVersion() || !cr.getVersion().startsWith("4.") || Utilities.existsInList(cr.getId(), "v3-DataOperation", "v3-KnowledgeSubjectObservationValue")) continue;
                list.add(new CanonicalResourceAnalysis(cr, f.getAbsolutePath()));
            }
            catch (Exception e) {
                System.out.println(f.getAbsolutePath() + " not a resource? " + e.getMessage());
            }
        }
    }

    public class CanonicalResourceAnalysis {
        private CanonicalResource resource;
        private CanonicalResource r2;
        private CanonicalResource r3;
        private CanonicalResource r4;
        private String fmm;
        private boolean normative;
        private String recommendation;
        private String filename;

        public CanonicalResourceAnalysis(CanonicalResource cr, String filename) {
            this.resource = cr;
            this.filename = filename;
        }

        public String summary() {
            return this.resource.getUrl() + " ---> " + this.recommendation + "   in " + this.filename;
        }

        public void analyse(Map<String, CanonicalResource> r2l, Map<String, CanonicalResource> r3l, Map<String, CanonicalResource> r4l) {
            this.r2 = this.findMatch(r2l);
            this.r3 = this.findMatch(r3l);
            this.r4 = this.findMatch(r4l);
            this.fmm = this.r4 != null ? ToolingExtensions.readStringExtension(this.r4, "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm") : null;
            boolean bl = this.normative = this.r4 != null && ToolingExtensions.readStringExtension(this.r4, "http://hl7.org/fhir/StructureDefinition/structuredefinition-normative-version") != null;
            if (this.normative) {
                this.recommendation = "1.0.0";
            } else if (Utilities.existsInList(this.fmm, "3", "4", "5")) {
                this.recommendation = "0.5.0";
            } else {
                int i2 = 1;
                if (this.r2 != null && this.r3 != null && !this.match(this.r2, this.r3, r2l, r3l)) {
                    ++i2;
                }
                if (this.r3 != null && this.r4 != null && !this.match(this.r3, this.r4, r3l, r4l)) {
                    ++i2;
                }
                this.recommendation = "0." + i2 + ".0";
            }
        }

        private boolean match(CanonicalResource l, CanonicalResource r, Map<String, CanonicalResource> ll, Map<String, CanonicalResource> rl) {
            if (l instanceof CodeSystem && r instanceof CodeSystem) {
                return this.matchCS((CodeSystem)l, (CodeSystem)r);
            }
            if (l instanceof ValueSet && r instanceof ValueSet) {
                return this.matchVS((ValueSet)l, (ValueSet)r, ll, rl);
            }
            return false;
        }

        private boolean matchVS(ValueSet l, ValueSet r, Map<String, CanonicalResource> ll, Map<String, CanonicalResource> rl) {
            if (l.getCompose().getInclude().size() == 1 && l.getCompose().getExclude().isEmpty() && l.getCompose().getIncludeFirstRep().hasSystem() && !l.getCompose().getIncludeFirstRep().hasConcept() && !l.getCompose().getIncludeFirstRep().hasFilter() && r.getCompose().getInclude().size() == 1 && r.getCompose().getExclude().isEmpty() && r.getCompose().getIncludeFirstRep().hasSystem() && !r.getCompose().getIncludeFirstRep().hasConcept() && !r.getCompose().getIncludeFirstRep().hasFilter()) {
                CodeSystem lc = (CodeSystem)ll.get(l.getCompose().getIncludeFirstRep().getSystem());
                CodeSystem rc = (CodeSystem)rl.get(l.getCompose().getIncludeFirstRep().getSystem());
                if (lc != null && rc != null) {
                    return this.matchCS(lc, rc);
                }
            }
            return false;
        }

        private boolean matchCS(CodeSystem l, CodeSystem r) {
            return Base.compareDeep(l.getConcept(), r.getConcept(), false);
        }

        public CanonicalResource findMatch(Map<String, CanonicalResource> r2) {
            CanonicalResource r = r2.get(this.resource.getUrl());
            if (r == null) {
                r = r2.get(this.resource.getUrl().replaceAll("http://terminology.hl7.org/", "http://hl7.org/fhir/"));
            }
            if (r == null) {
                r = r2.get(this.resource.getUrl().replaceAll("http://terminology.hl7.org/CodeSystem", "http://hl7.org/fhir/"));
            }
            return r;
        }

        public String getId() {
            return this.resource.getId();
        }

        public String fhirType() {
            return this.resource.fhirType();
        }
    }
}

