/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.misc;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.context.SimpleWorkerContext;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.utilities.npm.FilesystemPackageCacheManager;
import org.hl7.fhir.utilities.npm.NpmPackage;

public class OIDBasedValueSetImporter {
    protected IWorkerContext context;

    protected void init() throws FileNotFoundException, FHIRException, IOException {
        FilesystemPackageCacheManager pcm = new FilesystemPackageCacheManager(true, 3);
        NpmPackage npm = pcm.loadPackage("hl7.fhir.r5.core", "current");
        SimpleWorkerContext ctxt = SimpleWorkerContext.fromPackage(npm);
        ctxt.setAllowLoadingDuplicates(true);
        ctxt.loadFromPackage(pcm.loadPackage("hl7.terminology"), null);
        this.context = ctxt;
    }

    protected String fixVersionforSystem(String url, String csver) {
        if ("http://snomed.info/sct".equals(url)) {
            return "http://snomed.info/sct/731000124108/version/" + csver;
        }
        if ("http://loinc.org".equals(url)) {
            return csver;
        }
        if ("http://www.nlm.nih.gov/research/umls/rxnorm".equals(url)) {
            if (csver.length() == 8) {
                return csver.substring(4, 6) + csver.substring(6, 8) + csver.substring(0, 4);
            }
            return csver;
        }
        return csver;
    }

    protected ValueSet.ConceptSetComponent getInclude(ValueSet vs, String url, String csver) {
        for (ValueSet.ConceptSetComponent t : vs.getCompose().getInclude()) {
            if (!(csver == null ? t.getSystem().equals(url) && !t.hasVersion() : t.getSystem().equals(url) && t.hasVersion() && t.getVersion().equals(csver))) continue;
            return t;
        }
        ValueSet.ConceptSetComponent c = vs.getCompose().addInclude();
        c.setSystem(url);
        c.setVersion(csver);
        return c;
    }
}

