/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.misc;

import com.google.common.base.Charsets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.hl7.fhir.convertors.VersionConvertor_10_30;
import org.hl7.fhir.convertors.VersionConvertor_10_40;
import org.hl7.fhir.convertors.VersionConvertor_10_50;
import org.hl7.fhir.convertors.VersionConvertor_14_30;
import org.hl7.fhir.convertors.VersionConvertor_14_40;
import org.hl7.fhir.convertors.VersionConvertor_14_50;
import org.hl7.fhir.convertors.VersionConvertor_30_40;
import org.hl7.fhir.convertors.VersionConvertor_30_50;
import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.convertors.advisors.VersionConvertorAdvisor40;
import org.hl7.fhir.convertors.misc.PR2Handler;
import org.hl7.fhir.r5.formats.JsonParser;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.json.JSONUtil;
import org.hl7.fhir.utilities.json.JsonTrackingParser;
import org.hl7.fhir.utilities.npm.NpmPackageIndexBuilder;

public class NpmPackageVersionConverter {
    private static final int BUFFER_SIZE = 1024;
    private String source;
    private String dest;
    private String version;
    private String currentVersion;
    private String vCode;
    private List<String> errors = new ArrayList<String>();

    public static void main(String[] args2) throws IOException {
        NpmPackageVersionConverter self = new NpmPackageVersionConverter(args2[0], args2[1], args2[2]);
        self.execute();
        System.out.println("Finished");
        for (String s2 : self.errors) {
            System.out.println(s2);
        }
    }

    public NpmPackageVersionConverter(String source, String dest, String version) {
        this.source = source;
        this.dest = dest;
        this.vCode = version;
        this.version = VersionUtilities.versionFromCode(version);
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public void execute() throws IOException {
        GzipCompressorInputStream gzipIn;
        try {
            gzipIn = new GzipCompressorInputStream((InputStream)new FileInputStream(this.source));
        }
        catch (Exception e) {
            throw new IOException("Error reading " + this.source + ": " + e.getMessage(), e);
        }
        HashMap<String, byte[]> content = new HashMap<String, byte[]>();
        TarArchiveInputStream tarIn = new TarArchiveInputStream((InputStream)gzipIn);
        Object object = null;
        try {
            TarArchiveEntry tarArchiveEntry;
            while ((tarArchiveEntry = (TarArchiveEntry)tarIn.getNextEntry()) != null) {
                String n = tarArchiveEntry.getName();
                if (tarArchiveEntry.isDirectory()) continue;
                byte[] data = new byte[1024];
                Iterator fos = new ByteArrayOutputStream();
                try (BufferedOutputStream dest = new BufferedOutputStream((OutputStream)((Object)fos), 1024);){
                    int count;
                    while ((count = tarIn.read(data, 0, 1024)) != -1) {
                        dest.write(data, 0, count);
                    }
                }
                ((ByteArrayOutputStream)((Object)fos)).close();
                content.put(n, ((ByteArrayOutputStream)((Object)fos)).toByteArray());
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (tarIn != null) {
                if (object != null) {
                    try {
                        tarIn.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    tarIn.close();
                }
            }
        }
        HashMap<String, byte[]> output = new HashMap<String, byte[]>();
        output.put("package/package.json", this.convertPackage((byte[])content.get("package/package.json")));
        for (Map.Entry entry : content.entrySet()) {
            if (((String)entry.getKey()).equals("package/package.json")) continue;
            byte[] cnv = (byte[])entry.getValue();
            try {
                JsonObject json = JsonTrackingParser.parseJson((byte[])entry.getValue());
                if (json.has("resourceType")) {
                    cnv = this.convertResource((String)entry.getKey(), (byte[])entry.getValue());
                }
            }
            catch (Exception json) {
                // empty catch block
            }
            if (cnv == null || cnv.length <= 0) continue;
            output.put((String)entry.getKey(), cnv);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(byteArrayOutputStream);
        GzipCompressorOutputStream gzipOutputStream = new GzipCompressorOutputStream((OutputStream)bufferedOutputStream);
        TarArchiveOutputStream tar = new TarArchiveOutputStream((OutputStream)gzipOutputStream);
        HashMap<String, NpmPackageIndexBuilder> indexers = new HashMap<String, NpmPackageIndexBuilder>();
        for (Map.Entry e : output.entrySet()) {
            String n = ((String)e.getKey()).substring(0, ((String)e.getKey()).lastIndexOf("/"));
            String s2 = ((String)e.getKey()).substring(n.length() + 1);
            byte[] b = (byte[])e.getValue();
            NpmPackageIndexBuilder indexer = (NpmPackageIndexBuilder)indexers.get(n);
            if (indexer == null) {
                indexer = new NpmPackageIndexBuilder();
                indexer.start();
                indexers.put(n, indexer);
            }
            indexer.seeFile(s2, b);
            if (s2.equals(".index.json") || s2.equals("package.json")) continue;
            TarArchiveEntry entry = new TarArchiveEntry((String)e.getKey());
            entry.setSize((long)b.length);
            tar.putArchiveEntry((ArchiveEntry)entry);
            tar.write(b);
            tar.closeArchiveEntry();
        }
        for (Map.Entry e : indexers.entrySet()) {
            byte[] cnt = ((NpmPackageIndexBuilder)e.getValue()).build().getBytes(Charset.forName("UTF-8"));
            TarArchiveEntry entry = new TarArchiveEntry((String)e.getKey() + "/.index.json");
            entry.setSize((long)cnt.length);
            tar.putArchiveEntry((ArchiveEntry)entry);
            tar.write(cnt);
            tar.closeArchiveEntry();
        }
        byte[] cnt = (byte[])output.get("package/package.json");
        TarArchiveEntry entry = new TarArchiveEntry("package/package.json");
        entry.setSize((long)cnt.length);
        tar.putArchiveEntry((ArchiveEntry)entry);
        tar.write(cnt);
        tar.closeArchiveEntry();
        tar.finish();
        tar.close();
        gzipOutputStream.close();
        bufferedOutputStream.close();
        byteArrayOutputStream.close();
        byte[] b = byteArrayOutputStream.toByteArray();
        TextFile.bytesToFile(b, this.dest);
    }

    private byte[] convertPackage(byte[] cnt) throws IOException {
        JsonObject json = JsonTrackingParser.parseJson(cnt);
        this.currentVersion = json.getAsJsonArray("fhirVersions").get(0).getAsString();
        String name = JSONUtil.str(json, "name");
        json.remove("name");
        json.addProperty("name", name + "." + this.vCode);
        json.remove("fhirVersions");
        json.remove("dependencies");
        JsonArray fv = new JsonArray();
        json.add("fhirVersions", (JsonElement)fv);
        fv.add(this.version);
        JsonObject dep = new JsonObject();
        json.add("dependencies", (JsonElement)dep);
        dep.addProperty(VersionUtilities.packageForVersion(this.version), this.version);
        return JsonTrackingParser.write(json).getBytes(Charsets.UTF_8);
    }

    private byte[] convertResource(String n, byte[] cnt) {
        try {
            if (VersionUtilities.isR2Ver(this.currentVersion)) {
                org.hl7.fhir.dstu2.model.Resource res = new org.hl7.fhir.dstu2.formats.JsonParser().parse(cnt);
                if (VersionUtilities.isR2Ver(this.version)) {
                    return new org.hl7.fhir.dstu2.formats.JsonParser().composeBytes(res);
                }
                if (VersionUtilities.isR2BVer(this.version)) {
                    return new org.hl7.fhir.dstu2016may.formats.JsonParser().composeBytes(VersionConvertor_14_30.convertResource(VersionConvertor_10_30.convertResource(res)));
                }
                if (VersionUtilities.isR3Ver(this.version)) {
                    return new org.hl7.fhir.dstu3.formats.JsonParser().composeBytes(VersionConvertor_10_30.convertResource(res));
                }
                if (VersionUtilities.isR4Ver(this.version)) {
                    return new org.hl7.fhir.r4.formats.JsonParser().composeBytes(VersionConvertor_10_40.convertResource(res));
                }
                if (VersionUtilities.isR5Ver(this.version)) {
                    return new JsonParser().composeBytes(VersionConvertor_10_50.convertResource(res));
                }
            } else if (VersionUtilities.isR2BVer(this.currentVersion)) {
                org.hl7.fhir.dstu2016may.model.Resource res = new org.hl7.fhir.dstu2016may.formats.JsonParser().parse(cnt);
                if (VersionUtilities.isR2Ver(this.version)) {
                    return new org.hl7.fhir.dstu2.formats.JsonParser().composeBytes(VersionConvertor_10_30.convertResource(VersionConvertor_14_30.convertResource(res)));
                }
                if (VersionUtilities.isR2BVer(this.version)) {
                    return new org.hl7.fhir.dstu2016may.formats.JsonParser().composeBytes(res);
                }
                if (VersionUtilities.isR3Ver(this.version)) {
                    return new org.hl7.fhir.dstu3.formats.JsonParser().composeBytes(VersionConvertor_14_30.convertResource(res));
                }
                if (VersionUtilities.isR4Ver(this.version)) {
                    return new org.hl7.fhir.r4.formats.JsonParser().composeBytes(VersionConvertor_14_40.convertResource(res));
                }
                if (VersionUtilities.isR5Ver(this.version)) {
                    return new JsonParser().composeBytes(VersionConvertor_14_50.convertResource(res));
                }
            } else if (VersionUtilities.isR3Ver(this.currentVersion)) {
                org.hl7.fhir.dstu3.model.Resource res = new org.hl7.fhir.dstu3.formats.JsonParser().parse(cnt);
                if (VersionUtilities.isR2Ver(this.version)) {
                    return new org.hl7.fhir.dstu2.formats.JsonParser().composeBytes(VersionConvertor_10_30.convertResource(res));
                }
                if (VersionUtilities.isR2BVer(this.version)) {
                    return new org.hl7.fhir.dstu2016may.formats.JsonParser().composeBytes(VersionConvertor_14_30.convertResource(res));
                }
                if (VersionUtilities.isR3Ver(this.version)) {
                    return new org.hl7.fhir.dstu3.formats.JsonParser().composeBytes(res);
                }
                if (VersionUtilities.isR4Ver(this.version)) {
                    return new org.hl7.fhir.r4.formats.JsonParser().composeBytes(VersionConvertor_30_40.convertResource(res, false));
                }
                if (VersionUtilities.isR5Ver(this.version)) {
                    return new JsonParser().composeBytes(VersionConvertor_30_50.convertResource(res, false));
                }
            } else if (VersionUtilities.isR4Ver(this.currentVersion)) {
                org.hl7.fhir.r4.model.Resource res = new org.hl7.fhir.r4.formats.JsonParser().parse(cnt);
                if (VersionUtilities.isR2Ver(this.version)) {
                    return new org.hl7.fhir.dstu2.formats.JsonParser().composeBytes(VersionConvertor_10_40.convertResource(res, (VersionConvertorAdvisor40)new PR2Handler()));
                }
                if (VersionUtilities.isR2BVer(this.version)) {
                    return new org.hl7.fhir.dstu2016may.formats.JsonParser().composeBytes(VersionConvertor_14_40.convertResource(res));
                }
                if (VersionUtilities.isR3Ver(this.version)) {
                    return new org.hl7.fhir.dstu3.formats.JsonParser().composeBytes(VersionConvertor_30_40.convertResource(res, true));
                }
                if (VersionUtilities.isR4Ver(this.version)) {
                    return new org.hl7.fhir.r4.formats.JsonParser().composeBytes(res);
                }
                if (VersionUtilities.isR5Ver(this.version)) {
                    return new JsonParser().composeBytes(VersionConvertor_40_50.convertResource(res));
                }
            } else if (VersionUtilities.isR5Ver(this.currentVersion)) {
                Resource res = new JsonParser().parse(cnt);
                if (VersionUtilities.isR2Ver(this.version)) {
                    return new org.hl7.fhir.dstu2.formats.JsonParser().composeBytes(VersionConvertor_10_50.convertResource(res));
                }
                if (VersionUtilities.isR2BVer(this.version)) {
                    return new org.hl7.fhir.dstu2016may.formats.JsonParser().composeBytes(VersionConvertor_14_50.convertResource(res));
                }
                if (VersionUtilities.isR3Ver(this.version)) {
                    return new org.hl7.fhir.dstu3.formats.JsonParser().composeBytes(VersionConvertor_30_50.convertResource(res, true));
                }
                if (VersionUtilities.isR4Ver(this.version)) {
                    return new org.hl7.fhir.r4.formats.JsonParser().composeBytes(VersionConvertor_40_50.convertResource(res));
                }
                if (VersionUtilities.isR5Ver(this.version)) {
                    return new JsonParser().composeBytes(res);
                }
            }
            throw new Error("Unknown version " + this.currentVersion + " -> " + this.version);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.errors.add("Error converting " + n + ": " + ex.getMessage());
            return null;
        }
    }
}

