/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.misc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import org.hl7.fhir.convertors.VersionConvertor_10_30;
import org.hl7.fhir.convertors.advisors.VersionConvertorAdvisor30;
import org.hl7.fhir.dstu2.formats.XmlParser;
import org.hl7.fhir.dstu3.formats.IParser;
import org.hl7.fhir.dstu3.model.Bundle;
import org.hl7.fhir.dstu3.model.CodeSystem;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.dstu3.model.ValueSet;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.FhirPublication;
import org.hl7.fhir.utilities.Utilities;

public class IGPackConverter102
implements VersionConvertorAdvisor30 {
    private Bundle cslist = new Bundle();

    public static void main(String[] args2) throws Exception {
        new IGPackConverter102().process();
    }

    private void process() throws FileNotFoundException, IOException, FHIRException {
        this.initCSList();
        for (String s2 : new File("C:\\temp\\igpack2").list()) {
            if (!s2.endsWith(".xml") || s2.startsWith("z-") || Utilities.existsInList(s2, "expansions.xml", "v3-codesystems.xml", "v2-tables.xml")) continue;
            System.out.println("process " + s2);
            XmlParser xp = new XmlParser();
            org.hl7.fhir.dstu2.model.Resource r10 = xp.parse((InputStream)new FileInputStream("C:\\temp\\igpack2\\" + s2));
            Resource r17 = VersionConvertor_10_30.convertResource(r10, (VersionConvertorAdvisor30)this);
            org.hl7.fhir.dstu3.formats.XmlParser xc = new org.hl7.fhir.dstu3.formats.XmlParser();
            xc.setOutputStyle(IParser.OutputStyle.PRETTY);
            xc.compose(new FileOutputStream("C:\\temp\\igpack2\\" + s2), r17);
        }
        System.out.println("save codesystems");
        org.hl7.fhir.dstu3.formats.XmlParser xc = new org.hl7.fhir.dstu3.formats.XmlParser();
        xc.setOutputStyle(IParser.OutputStyle.PRETTY);
        xc.compose(new FileOutputStream("C:\\temp\\igpack2\\codesystems.xml"), this.cslist);
        System.out.println("done");
    }

    private void initCSList() {
        this.cslist.setId("codesystems");
        this.cslist.setType(Bundle.BundleType.COLLECTION);
        this.cslist.getMeta().setLastUpdated(new Date());
    }

    @Override
    public boolean ignoreEntry(Bundle.BundleEntryComponent src, FhirPublication publication) {
        return false;
    }

    @Override
    public void handleCodeSystem(CodeSystem tgtcs, ValueSet vs) {
        this.cslist.addEntry().setFullUrl(tgtcs.getUrl()).setResource(tgtcs);
    }

    @Override
    public CodeSystem getCodeSystem(ValueSet src) {
        return null;
    }
}

