/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import java.util.stream.Collectors;
import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.convertors.conv40_50.Enumerations40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.StructureMap;
import org.hl7.fhir.r4.model.UsageContext;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.StructureMap;

public class StructureMap40_50
extends VersionConvertor_40_50 {
    public static StructureMap convertStructureMap(org.hl7.fhir.r4.model.StructureMap src) throws FHIRException {
        if (src == null) {
            return null;
        }
        StructureMap tgt = new StructureMap();
        StructureMap40_50.copyDomainResource(src, tgt);
        if (src.hasUrl()) {
            tgt.setUrlElement(StructureMap40_50.convertUri(src.getUrlElement()));
        }
        for (org.hl7.fhir.r4.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(StructureMap40_50.convertIdentifier(identifier));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(StructureMap40_50.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(StructureMap40_50.convertString(src.getNameElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(StructureMap40_50.convertString(src.getTitleElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((org.hl7.fhir.r5.model.Enumeration)Enumerations40_50.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(StructureMap40_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(StructureMap40_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(StructureMap40_50.convertString(src.getPublisherElement()));
        }
        for (org.hl7.fhir.r4.model.ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(StructureMap40_50.convertContactDetail(contactDetail));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(StructureMap40_50.convertMarkdown(src.getDescriptionElement()));
        }
        for (UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(StructureMap40_50.convertUsageContext(usageContext));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(StructureMap40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPurpose()) {
            tgt.setPurposeElement(StructureMap40_50.convertMarkdown(src.getPurposeElement()));
        }
        if (src.hasCopyright()) {
            tgt.setCopyrightElement(StructureMap40_50.convertMarkdown(src.getCopyrightElement()));
        }
        for (StructureMap.StructureMapStructureComponent structureMapStructureComponent : src.getStructure()) {
            tgt.addStructure(StructureMap40_50.convertStructureMapStructureComponent(structureMapStructureComponent));
        }
        for (org.hl7.fhir.r4.model.CanonicalType canonicalType : src.getImport()) {
            tgt.getImport().add(StructureMap40_50.convertCanonical(canonicalType));
        }
        for (StructureMap.StructureMapGroupComponent structureMapGroupComponent : src.getGroup()) {
            tgt.addGroup(StructureMap40_50.convertStructureMapGroupComponent(structureMapGroupComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.StructureMap convertStructureMap(StructureMap src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.StructureMap tgt = new org.hl7.fhir.r4.model.StructureMap();
        StructureMap40_50.copyDomainResource(src, tgt);
        if (src.hasUrl()) {
            tgt.setUrlElement(StructureMap40_50.convertUri(src.getUrlElement()));
        }
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(StructureMap40_50.convertIdentifier(identifier));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(StructureMap40_50.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(StructureMap40_50.convertString(src.getNameElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(StructureMap40_50.convertString(src.getTitleElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((Enumeration)Enumerations40_50.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(StructureMap40_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(StructureMap40_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(StructureMap40_50.convertString(src.getPublisherElement()));
        }
        for (ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(StructureMap40_50.convertContactDetail(contactDetail));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(StructureMap40_50.convertMarkdown(src.getDescriptionElement()));
        }
        for (org.hl7.fhir.r5.model.UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(StructureMap40_50.convertUsageContext(usageContext));
        }
        for (CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(StructureMap40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPurpose()) {
            tgt.setPurposeElement(StructureMap40_50.convertMarkdown(src.getPurposeElement()));
        }
        if (src.hasCopyright()) {
            tgt.setCopyrightElement(StructureMap40_50.convertMarkdown(src.getCopyrightElement()));
        }
        for (StructureMap.StructureMapStructureComponent structureMapStructureComponent : src.getStructure()) {
            tgt.addStructure(StructureMap40_50.convertStructureMapStructureComponent(structureMapStructureComponent));
        }
        for (CanonicalType canonicalType : src.getImport()) {
            tgt.getImport().add(StructureMap40_50.convertCanonical(canonicalType));
        }
        for (StructureMap.StructureMapGroupComponent structureMapGroupComponent : src.getGroup()) {
            tgt.addGroup(StructureMap40_50.convertStructureMapGroupComponent(structureMapGroupComponent));
        }
        return tgt;
    }

    public static StructureMap.StructureMapStructureComponent convertStructureMapStructureComponent(StructureMap.StructureMapStructureComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        StructureMap.StructureMapStructureComponent tgt = new StructureMap.StructureMapStructureComponent();
        StructureMap40_50.copyElement(src, tgt, new String[0]);
        if (src.hasUrl()) {
            tgt.setUrlElement(StructureMap40_50.convertCanonical(src.getUrlElement()));
        }
        if (src.hasMode()) {
            tgt.setModeElement(StructureMap40_50.convertStructureMapModelMode(src.getModeElement()));
        }
        if (src.hasAlias()) {
            tgt.setAliasElement(StructureMap40_50.convertString(src.getAliasElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(StructureMap40_50.convertString(src.getDocumentationElement()));
        }
        return tgt;
    }

    public static StructureMap.StructureMapStructureComponent convertStructureMapStructureComponent(StructureMap.StructureMapStructureComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        StructureMap.StructureMapStructureComponent tgt = new StructureMap.StructureMapStructureComponent();
        StructureMap40_50.copyElement(src, tgt, new String[0]);
        if (src.hasUrl()) {
            tgt.setUrlElement(StructureMap40_50.convertCanonical(src.getUrlElement()));
        }
        if (src.hasMode()) {
            tgt.setModeElement(StructureMap40_50.convertStructureMapModelMode(src.getModeElement()));
        }
        if (src.hasAlias()) {
            tgt.setAliasElement(StructureMap40_50.convertString(src.getAliasElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(StructureMap40_50.convertString(src.getDocumentationElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<StructureMap.StructureMapModelMode> convertStructureMapModelMode(Enumeration<StructureMap.StructureMapModelMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<StructureMap.StructureMapModelMode> tgt = new org.hl7.fhir.r5.model.Enumeration<StructureMap.StructureMapModelMode>(new StructureMap.StructureMapModelModeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((StructureMap.StructureMapModelMode)((Object)src.getValue())) {
            case SOURCE: {
                tgt.setValue((Object)StructureMap.StructureMapModelMode.SOURCE);
                break;
            }
            case QUERIED: {
                tgt.setValue((Object)StructureMap.StructureMapModelMode.QUERIED);
                break;
            }
            case TARGET: {
                tgt.setValue((Object)StructureMap.StructureMapModelMode.TARGET);
                break;
            }
            case PRODUCED: {
                tgt.setValue((Object)StructureMap.StructureMapModelMode.PRODUCED);
                break;
            }
            default: {
                tgt.setValue((Object)StructureMap.StructureMapModelMode.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<StructureMap.StructureMapModelMode> convertStructureMapModelMode(org.hl7.fhir.r5.model.Enumeration<StructureMap.StructureMapModelMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<StructureMap.StructureMapModelMode> tgt = new Enumeration<StructureMap.StructureMapModelMode>(new StructureMap.StructureMapModelModeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((StructureMap.StructureMapModelMode)((Object)src.getValue())) {
            case SOURCE: {
                tgt.setValue((Object)StructureMap.StructureMapModelMode.SOURCE);
                break;
            }
            case QUERIED: {
                tgt.setValue((Object)StructureMap.StructureMapModelMode.QUERIED);
                break;
            }
            case TARGET: {
                tgt.setValue((Object)StructureMap.StructureMapModelMode.TARGET);
                break;
            }
            case PRODUCED: {
                tgt.setValue((Object)StructureMap.StructureMapModelMode.PRODUCED);
                break;
            }
            default: {
                tgt.setValue((Object)StructureMap.StructureMapModelMode.NULL);
            }
        }
        return tgt;
    }

    public static StructureMap.StructureMapGroupComponent convertStructureMapGroupComponent(StructureMap.StructureMapGroupComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        StructureMap.StructureMapGroupComponent tgt = new StructureMap.StructureMapGroupComponent();
        StructureMap40_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(StructureMap40_50.convertId(src.getNameElement()));
        }
        if (src.hasExtends()) {
            tgt.setExtendsElement(StructureMap40_50.convertId(src.getExtendsElement()));
        }
        if (src.hasTypeMode()) {
            tgt.setTypeModeElement(StructureMap40_50.convertStructureMapGroupTypeMode(src.getTypeModeElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(StructureMap40_50.convertString(src.getDocumentationElement()));
        }
        for (StructureMap.StructureMapGroupInputComponent structureMapGroupInputComponent : src.getInput()) {
            tgt.addInput(StructureMap40_50.convertStructureMapGroupInputComponent(structureMapGroupInputComponent));
        }
        for (StructureMap.StructureMapGroupRuleComponent structureMapGroupRuleComponent : src.getRule()) {
            tgt.addRule(StructureMap40_50.convertStructureMapGroupRuleComponent(structureMapGroupRuleComponent));
        }
        return tgt;
    }

    public static StructureMap.StructureMapGroupComponent convertStructureMapGroupComponent(StructureMap.StructureMapGroupComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        StructureMap.StructureMapGroupComponent tgt = new StructureMap.StructureMapGroupComponent();
        StructureMap40_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(StructureMap40_50.convertId(src.getNameElement()));
        }
        if (src.hasExtends()) {
            tgt.setExtendsElement(StructureMap40_50.convertId(src.getExtendsElement()));
        }
        if (src.hasTypeMode()) {
            tgt.setTypeModeElement(StructureMap40_50.convertStructureMapGroupTypeMode(src.getTypeModeElement()));
        } else {
            tgt.setTypeMode(StructureMap.StructureMapGroupTypeMode.NONE);
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(StructureMap40_50.convertString(src.getDocumentationElement()));
        }
        for (StructureMap.StructureMapGroupInputComponent structureMapGroupInputComponent : src.getInput()) {
            tgt.addInput(StructureMap40_50.convertStructureMapGroupInputComponent(structureMapGroupInputComponent));
        }
        for (StructureMap.StructureMapGroupRuleComponent structureMapGroupRuleComponent : src.getRule()) {
            tgt.addRule(StructureMap40_50.convertStructureMapGroupRuleComponent(structureMapGroupRuleComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<StructureMap.StructureMapGroupTypeMode> convertStructureMapGroupTypeMode(Enumeration<StructureMap.StructureMapGroupTypeMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<StructureMap.StructureMapGroupTypeMode> tgt = new org.hl7.fhir.r5.model.Enumeration<StructureMap.StructureMapGroupTypeMode>(new StructureMap.StructureMapGroupTypeModeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((StructureMap.StructureMapGroupTypeMode)((Object)src.getValue())) {
            case NONE: {
                return null;
            }
            case TYPES: {
                tgt.setValue((Object)StructureMap.StructureMapGroupTypeMode.TYPES);
                break;
            }
            case TYPEANDTYPES: {
                tgt.setValue((Object)StructureMap.StructureMapGroupTypeMode.TYPEANDTYPES);
                break;
            }
            default: {
                tgt.setValue((Object)StructureMap.StructureMapGroupTypeMode.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<StructureMap.StructureMapGroupTypeMode> convertStructureMapGroupTypeMode(org.hl7.fhir.r5.model.Enumeration<StructureMap.StructureMapGroupTypeMode> src) throws FHIRException {
        Enumeration<StructureMap.StructureMapGroupTypeMode> tgt = new Enumeration<StructureMap.StructureMapGroupTypeMode>(new StructureMap.StructureMapGroupTypeModeEnumFactory());
        if (src == null || src.isEmpty()) {
            tgt.setValue((Object)StructureMap.StructureMapGroupTypeMode.NONE);
            return tgt;
        }
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((StructureMap.StructureMapGroupTypeMode)((Object)src.getValue())) {
            case TYPES: {
                tgt.setValue((Object)StructureMap.StructureMapGroupTypeMode.TYPES);
                break;
            }
            case TYPEANDTYPES: {
                tgt.setValue((Object)StructureMap.StructureMapGroupTypeMode.TYPEANDTYPES);
                break;
            }
            default: {
                tgt.setValue((Object)StructureMap.StructureMapGroupTypeMode.NULL);
            }
        }
        return tgt;
    }

    public static StructureMap.StructureMapGroupInputComponent convertStructureMapGroupInputComponent(StructureMap.StructureMapGroupInputComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        StructureMap.StructureMapGroupInputComponent tgt = new StructureMap.StructureMapGroupInputComponent();
        StructureMap40_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(StructureMap40_50.convertId(src.getNameElement()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(StructureMap40_50.convertString(src.getTypeElement()));
        }
        if (src.hasMode()) {
            tgt.setModeElement(StructureMap40_50.convertStructureMapInputMode(src.getModeElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(StructureMap40_50.convertString(src.getDocumentationElement()));
        }
        return tgt;
    }

    public static StructureMap.StructureMapGroupInputComponent convertStructureMapGroupInputComponent(StructureMap.StructureMapGroupInputComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        StructureMap.StructureMapGroupInputComponent tgt = new StructureMap.StructureMapGroupInputComponent();
        StructureMap40_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(StructureMap40_50.convertId(src.getNameElement()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(StructureMap40_50.convertString(src.getTypeElement()));
        }
        if (src.hasMode()) {
            tgt.setModeElement(StructureMap40_50.convertStructureMapInputMode(src.getModeElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(StructureMap40_50.convertString(src.getDocumentationElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<StructureMap.StructureMapInputMode> convertStructureMapInputMode(Enumeration<StructureMap.StructureMapInputMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<StructureMap.StructureMapInputMode> tgt = new org.hl7.fhir.r5.model.Enumeration<StructureMap.StructureMapInputMode>(new StructureMap.StructureMapInputModeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((StructureMap.StructureMapInputMode)((Object)src.getValue())) {
            case SOURCE: {
                tgt.setValue((Object)StructureMap.StructureMapInputMode.SOURCE);
                break;
            }
            case TARGET: {
                tgt.setValue((Object)StructureMap.StructureMapInputMode.TARGET);
                break;
            }
            default: {
                tgt.setValue((Object)StructureMap.StructureMapInputMode.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<StructureMap.StructureMapInputMode> convertStructureMapInputMode(org.hl7.fhir.r5.model.Enumeration<StructureMap.StructureMapInputMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<StructureMap.StructureMapInputMode> tgt = new Enumeration<StructureMap.StructureMapInputMode>(new StructureMap.StructureMapInputModeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((StructureMap.StructureMapInputMode)((Object)src.getValue())) {
            case SOURCE: {
                tgt.setValue((Object)StructureMap.StructureMapInputMode.SOURCE);
                break;
            }
            case TARGET: {
                tgt.setValue((Object)StructureMap.StructureMapInputMode.TARGET);
                break;
            }
            default: {
                tgt.setValue((Object)StructureMap.StructureMapInputMode.NULL);
            }
        }
        return tgt;
    }

    public static StructureMap.StructureMapGroupRuleComponent convertStructureMapGroupRuleComponent(StructureMap.StructureMapGroupRuleComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        StructureMap.StructureMapGroupRuleComponent tgt = new StructureMap.StructureMapGroupRuleComponent();
        StructureMap40_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(StructureMap40_50.convertId(src.getNameElement()));
        }
        for (StructureMap.StructureMapGroupRuleSourceComponent structureMapGroupRuleSourceComponent : src.getSource()) {
            tgt.addSource(StructureMap40_50.convertStructureMapGroupRuleSourceComponent(structureMapGroupRuleSourceComponent));
        }
        for (StructureMap.StructureMapGroupRuleTargetComponent structureMapGroupRuleTargetComponent : src.getTarget()) {
            tgt.addTarget(StructureMap40_50.convertStructureMapGroupRuleTargetComponent(structureMapGroupRuleTargetComponent));
        }
        for (StructureMap.StructureMapGroupRuleComponent structureMapGroupRuleComponent : src.getRule()) {
            tgt.addRule(StructureMap40_50.convertStructureMapGroupRuleComponent(structureMapGroupRuleComponent));
        }
        for (StructureMap.StructureMapGroupRuleDependentComponent structureMapGroupRuleDependentComponent : src.getDependent()) {
            tgt.addDependent(StructureMap40_50.convertStructureMapGroupRuleDependentComponent(structureMapGroupRuleDependentComponent));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(StructureMap40_50.convertString(src.getDocumentationElement()));
        }
        return tgt;
    }

    public static StructureMap.StructureMapGroupRuleComponent convertStructureMapGroupRuleComponent(StructureMap.StructureMapGroupRuleComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        StructureMap.StructureMapGroupRuleComponent tgt = new StructureMap.StructureMapGroupRuleComponent();
        StructureMap40_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(StructureMap40_50.convertId(src.getNameElement()));
        }
        for (StructureMap.StructureMapGroupRuleSourceComponent structureMapGroupRuleSourceComponent : src.getSource()) {
            tgt.addSource(StructureMap40_50.convertStructureMapGroupRuleSourceComponent(structureMapGroupRuleSourceComponent));
        }
        for (StructureMap.StructureMapGroupRuleTargetComponent structureMapGroupRuleTargetComponent : src.getTarget()) {
            tgt.addTarget(StructureMap40_50.convertStructureMapGroupRuleTargetComponent(structureMapGroupRuleTargetComponent));
        }
        for (StructureMap.StructureMapGroupRuleComponent structureMapGroupRuleComponent : src.getRule()) {
            tgt.addRule(StructureMap40_50.convertStructureMapGroupRuleComponent(structureMapGroupRuleComponent));
        }
        for (StructureMap.StructureMapGroupRuleDependentComponent structureMapGroupRuleDependentComponent : src.getDependent()) {
            tgt.addDependent(StructureMap40_50.convertStructureMapGroupRuleDependentComponent(structureMapGroupRuleDependentComponent));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(StructureMap40_50.convertString(src.getDocumentationElement()));
        }
        return tgt;
    }

    public static StructureMap.StructureMapGroupRuleSourceComponent convertStructureMapGroupRuleSourceComponent(StructureMap.StructureMapGroupRuleSourceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        StructureMap.StructureMapGroupRuleSourceComponent tgt = new StructureMap.StructureMapGroupRuleSourceComponent();
        StructureMap40_50.copyElement(src, tgt, new String[0]);
        if (src.hasContext()) {
            tgt.setContextElement(StructureMap40_50.convertId(src.getContextElement()));
        }
        if (src.hasMin()) {
            tgt.setMinElement(StructureMap40_50.convertInteger(src.getMinElement()));
        }
        if (src.hasMax()) {
            tgt.setMaxElement(StructureMap40_50.convertString(src.getMaxElement()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(StructureMap40_50.convertString(src.getTypeElement()));
        }
        if (src.hasDefaultValue()) {
            tgt.setDefaultValue(StructureMap40_50.convertType(src.getDefaultValue()));
        }
        if (src.hasElement()) {
            tgt.setElementElement(StructureMap40_50.convertString(src.getElementElement()));
        }
        if (src.hasListMode()) {
            tgt.setListModeElement(StructureMap40_50.convertStructureMapSourceListMode(src.getListModeElement()));
        }
        if (src.hasVariable()) {
            tgt.setVariableElement(StructureMap40_50.convertId(src.getVariableElement()));
        }
        if (src.hasCondition()) {
            tgt.setConditionElement(StructureMap40_50.convertString(src.getConditionElement()));
        }
        if (src.hasCheck()) {
            tgt.setCheckElement(StructureMap40_50.convertString(src.getCheckElement()));
        }
        if (src.hasLogMessage()) {
            tgt.setLogMessageElement(StructureMap40_50.convertString(src.getLogMessageElement()));
        }
        return tgt;
    }

    public static StructureMap.StructureMapGroupRuleSourceComponent convertStructureMapGroupRuleSourceComponent(StructureMap.StructureMapGroupRuleSourceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        StructureMap.StructureMapGroupRuleSourceComponent tgt = new StructureMap.StructureMapGroupRuleSourceComponent();
        StructureMap40_50.copyElement(src, tgt, new String[0]);
        if (src.hasContext()) {
            tgt.setContextElement(StructureMap40_50.convertId(src.getContextElement()));
        }
        if (src.hasMin()) {
            tgt.setMinElement(StructureMap40_50.convertInteger(src.getMinElement()));
        }
        if (src.hasMax()) {
            tgt.setMaxElement(StructureMap40_50.convertString(src.getMaxElement()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(StructureMap40_50.convertString(src.getTypeElement()));
        }
        if (src.hasDefaultValue()) {
            tgt.setDefaultValue(StructureMap40_50.convertType(src.getDefaultValue()));
        }
        if (src.hasElement()) {
            tgt.setElementElement(StructureMap40_50.convertString(src.getElementElement()));
        }
        if (src.hasListMode()) {
            tgt.setListModeElement(StructureMap40_50.convertStructureMapSourceListMode(src.getListModeElement()));
        }
        if (src.hasVariable()) {
            tgt.setVariableElement(StructureMap40_50.convertId(src.getVariableElement()));
        }
        if (src.hasCondition()) {
            tgt.setConditionElement(StructureMap40_50.convertString(src.getConditionElement()));
        }
        if (src.hasCheck()) {
            tgt.setCheckElement(StructureMap40_50.convertString(src.getCheckElement()));
        }
        if (src.hasLogMessage()) {
            tgt.setLogMessageElement(StructureMap40_50.convertString(src.getLogMessageElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<StructureMap.StructureMapSourceListMode> convertStructureMapSourceListMode(Enumeration<StructureMap.StructureMapSourceListMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<StructureMap.StructureMapSourceListMode> tgt = new org.hl7.fhir.r5.model.Enumeration<StructureMap.StructureMapSourceListMode>(new StructureMap.StructureMapSourceListModeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((StructureMap.StructureMapSourceListMode)((Object)src.getValue())) {
            case FIRST: {
                tgt.setValue((Object)StructureMap.StructureMapSourceListMode.FIRST);
                break;
            }
            case NOTFIRST: {
                tgt.setValue((Object)StructureMap.StructureMapSourceListMode.NOTFIRST);
                break;
            }
            case LAST: {
                tgt.setValue((Object)StructureMap.StructureMapSourceListMode.LAST);
                break;
            }
            case NOTLAST: {
                tgt.setValue((Object)StructureMap.StructureMapSourceListMode.NOTLAST);
                break;
            }
            case ONLYONE: {
                tgt.setValue((Object)StructureMap.StructureMapSourceListMode.ONLYONE);
                break;
            }
            default: {
                tgt.setValue((Object)StructureMap.StructureMapSourceListMode.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<StructureMap.StructureMapSourceListMode> convertStructureMapSourceListMode(org.hl7.fhir.r5.model.Enumeration<StructureMap.StructureMapSourceListMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<StructureMap.StructureMapSourceListMode> tgt = new Enumeration<StructureMap.StructureMapSourceListMode>(new StructureMap.StructureMapSourceListModeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((StructureMap.StructureMapSourceListMode)((Object)src.getValue())) {
            case FIRST: {
                tgt.setValue((Object)StructureMap.StructureMapSourceListMode.FIRST);
                break;
            }
            case NOTFIRST: {
                tgt.setValue((Object)StructureMap.StructureMapSourceListMode.NOTFIRST);
                break;
            }
            case LAST: {
                tgt.setValue((Object)StructureMap.StructureMapSourceListMode.LAST);
                break;
            }
            case NOTLAST: {
                tgt.setValue((Object)StructureMap.StructureMapSourceListMode.NOTLAST);
                break;
            }
            case ONLYONE: {
                tgt.setValue((Object)StructureMap.StructureMapSourceListMode.ONLYONE);
                break;
            }
            default: {
                tgt.setValue((Object)StructureMap.StructureMapSourceListMode.NULL);
            }
        }
        return tgt;
    }

    public static StructureMap.StructureMapGroupRuleTargetComponent convertStructureMapGroupRuleTargetComponent(StructureMap.StructureMapGroupRuleTargetComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        StructureMap.StructureMapGroupRuleTargetComponent tgt = new StructureMap.StructureMapGroupRuleTargetComponent();
        StructureMap40_50.copyElement(src, tgt, new String[0]);
        if (src.hasContext()) {
            tgt.setContextElement(StructureMap40_50.convertId(src.getContextElement()));
        }
        if (src.hasContextType() && src.getContextType() != StructureMap.StructureMapContextType.VARIABLE) {
            throw new Error("This conversion is not supported. Consult code maintainers");
        }
        if (src.hasElement()) {
            tgt.setElementElement(StructureMap40_50.convertString(src.getElementElement()));
        }
        if (src.hasVariable()) {
            tgt.setVariableElement(StructureMap40_50.convertId(src.getVariableElement()));
        }
        tgt.setListMode(src.getListMode().stream().map(StructureMap40_50::convertStructureMapTargetListMode).collect(Collectors.toList()));
        if (src.hasListRuleId()) {
            tgt.setListRuleIdElement(StructureMap40_50.convertId(src.getListRuleIdElement()));
        }
        if (src.hasTransform()) {
            tgt.setTransformElement(StructureMap40_50.convertStructureMapTransform(src.getTransformElement()));
        }
        for (StructureMap.StructureMapGroupRuleTargetParameterComponent t : src.getParameter()) {
            tgt.addParameter(StructureMap40_50.convertStructureMapGroupRuleTargetParameterComponent(t));
        }
        return tgt;
    }

    public static StructureMap.StructureMapGroupRuleTargetComponent convertStructureMapGroupRuleTargetComponent(StructureMap.StructureMapGroupRuleTargetComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        StructureMap.StructureMapGroupRuleTargetComponent tgt = new StructureMap.StructureMapGroupRuleTargetComponent();
        StructureMap40_50.copyElement(src, tgt, new String[0]);
        if (src.hasContext()) {
            tgt.setContextElement(StructureMap40_50.convertId(src.getContextElement()));
        }
        tgt.setContextType(StructureMap.StructureMapContextType.VARIABLE);
        if (src.hasElement()) {
            tgt.setElementElement(StructureMap40_50.convertString(src.getElementElement()));
        }
        if (src.hasVariable()) {
            tgt.setVariableElement(StructureMap40_50.convertId(src.getVariableElement()));
        }
        tgt.setListMode(src.getListMode().stream().map(StructureMap40_50::convertStructureMapTargetListMode).collect(Collectors.toList()));
        if (src.hasListRuleId()) {
            tgt.setListRuleIdElement(StructureMap40_50.convertId(src.getListRuleIdElement()));
        }
        if (src.hasTransform()) {
            tgt.setTransformElement(StructureMap40_50.convertStructureMapTransform(src.getTransformElement()));
        }
        for (StructureMap.StructureMapGroupRuleTargetParameterComponent t : src.getParameter()) {
            tgt.addParameter(StructureMap40_50.convertStructureMapGroupRuleTargetParameterComponent(t));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<StructureMap.StructureMapTargetListMode> convertStructureMapTargetListMode(Enumeration<StructureMap.StructureMapTargetListMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<StructureMap.StructureMapTargetListMode> tgt = new org.hl7.fhir.r5.model.Enumeration<StructureMap.StructureMapTargetListMode>(new StructureMap.StructureMapTargetListModeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((StructureMap.StructureMapTargetListMode)((Object)src.getValue())) {
            case FIRST: {
                tgt.setValue((Object)StructureMap.StructureMapTargetListMode.FIRST);
                break;
            }
            case SHARE: {
                tgt.setValue((Object)StructureMap.StructureMapTargetListMode.SHARE);
                break;
            }
            case LAST: {
                tgt.setValue((Object)StructureMap.StructureMapTargetListMode.LAST);
                break;
            }
            case COLLATE: {
                tgt.setValue((Object)StructureMap.StructureMapTargetListMode.COLLATE);
                break;
            }
            default: {
                tgt.setValue((Object)StructureMap.StructureMapTargetListMode.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<StructureMap.StructureMapTargetListMode> convertStructureMapTargetListMode(org.hl7.fhir.r5.model.Enumeration<StructureMap.StructureMapTargetListMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<StructureMap.StructureMapTargetListMode> tgt = new Enumeration<StructureMap.StructureMapTargetListMode>(new StructureMap.StructureMapTargetListModeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((StructureMap.StructureMapTargetListMode)((Object)src.getValue())) {
            case FIRST: {
                tgt.setValue((Object)StructureMap.StructureMapTargetListMode.FIRST);
                break;
            }
            case SHARE: {
                tgt.setValue((Object)StructureMap.StructureMapTargetListMode.SHARE);
                break;
            }
            case LAST: {
                tgt.setValue((Object)StructureMap.StructureMapTargetListMode.LAST);
                break;
            }
            case COLLATE: {
                tgt.setValue((Object)StructureMap.StructureMapTargetListMode.COLLATE);
                break;
            }
            default: {
                tgt.setValue((Object)StructureMap.StructureMapTargetListMode.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<StructureMap.StructureMapTransform> convertStructureMapTransform(Enumeration<StructureMap.StructureMapTransform> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<StructureMap.StructureMapTransform> tgt = new org.hl7.fhir.r5.model.Enumeration<StructureMap.StructureMapTransform>(new StructureMap.StructureMapTransformEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((StructureMap.StructureMapTransform)((Object)src.getValue())) {
            case CREATE: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.CREATE);
                break;
            }
            case COPY: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.COPY);
                break;
            }
            case TRUNCATE: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.TRUNCATE);
                break;
            }
            case ESCAPE: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.ESCAPE);
                break;
            }
            case CAST: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.CAST);
                break;
            }
            case APPEND: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.APPEND);
                break;
            }
            case TRANSLATE: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.TRANSLATE);
                break;
            }
            case REFERENCE: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.REFERENCE);
                break;
            }
            case DATEOP: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.DATEOP);
                break;
            }
            case UUID: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.UUID);
                break;
            }
            case POINTER: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.POINTER);
                break;
            }
            case EVALUATE: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.EVALUATE);
                break;
            }
            case CC: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.CC);
                break;
            }
            case C: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.C);
                break;
            }
            case QTY: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.QTY);
                break;
            }
            case ID: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.ID);
                break;
            }
            case CP: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.CP);
                break;
            }
            default: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<StructureMap.StructureMapTransform> convertStructureMapTransform(org.hl7.fhir.r5.model.Enumeration<StructureMap.StructureMapTransform> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<StructureMap.StructureMapTransform> tgt = new Enumeration<StructureMap.StructureMapTransform>(new StructureMap.StructureMapTransformEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((StructureMap.StructureMapTransform)((Object)src.getValue())) {
            case CREATE: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.CREATE);
                break;
            }
            case COPY: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.COPY);
                break;
            }
            case TRUNCATE: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.TRUNCATE);
                break;
            }
            case ESCAPE: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.ESCAPE);
                break;
            }
            case CAST: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.CAST);
                break;
            }
            case APPEND: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.APPEND);
                break;
            }
            case TRANSLATE: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.TRANSLATE);
                break;
            }
            case REFERENCE: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.REFERENCE);
                break;
            }
            case DATEOP: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.DATEOP);
                break;
            }
            case UUID: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.UUID);
                break;
            }
            case POINTER: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.POINTER);
                break;
            }
            case EVALUATE: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.EVALUATE);
                break;
            }
            case CC: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.CC);
                break;
            }
            case C: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.C);
                break;
            }
            case QTY: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.QTY);
                break;
            }
            case ID: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.ID);
                break;
            }
            case CP: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.CP);
                break;
            }
            default: {
                tgt.setValue((Object)StructureMap.StructureMapTransform.NULL);
            }
        }
        return tgt;
    }

    public static StructureMap.StructureMapGroupRuleTargetParameterComponent convertStructureMapGroupRuleTargetParameterComponent(StructureMap.StructureMapGroupRuleTargetParameterComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        StructureMap.StructureMapGroupRuleTargetParameterComponent tgt = new StructureMap.StructureMapGroupRuleTargetParameterComponent();
        StructureMap40_50.copyElement(src, tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValue(StructureMap40_50.convertType(src.getValue()));
        }
        return tgt;
    }

    public static StructureMap.StructureMapGroupRuleTargetParameterComponent convertStructureMapGroupRuleTargetParameterComponent(StructureMap.StructureMapGroupRuleTargetParameterComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        StructureMap.StructureMapGroupRuleTargetParameterComponent tgt = new StructureMap.StructureMapGroupRuleTargetParameterComponent();
        StructureMap40_50.copyElement(src, tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValue(StructureMap40_50.convertType(src.getValue()));
        }
        return tgt;
    }

    public static StructureMap.StructureMapGroupRuleDependentComponent convertStructureMapGroupRuleDependentComponent(StructureMap.StructureMapGroupRuleDependentComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        StructureMap.StructureMapGroupRuleDependentComponent tgt = new StructureMap.StructureMapGroupRuleDependentComponent();
        StructureMap40_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(StructureMap40_50.convertId(src.getNameElement()));
        }
        for (org.hl7.fhir.r4.model.StringType t : src.getVariable()) {
            tgt.getVariable().add(StructureMap40_50.convertString(t));
        }
        return tgt;
    }

    public static StructureMap.StructureMapGroupRuleDependentComponent convertStructureMapGroupRuleDependentComponent(StructureMap.StructureMapGroupRuleDependentComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        StructureMap.StructureMapGroupRuleDependentComponent tgt = new StructureMap.StructureMapGroupRuleDependentComponent();
        StructureMap40_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(StructureMap40_50.convertId(src.getNameElement()));
        }
        for (StringType t : src.getVariable()) {
            tgt.getVariable().add(StructureMap40_50.convertString(t));
        }
        return tgt;
    }
}

