/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.NutritionOrder;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.NutritionOrder;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.Timing;

public class NutritionOrder40_50
extends VersionConvertor_40_50 {
    public static NutritionOrder convertNutritionOrder(org.hl7.fhir.r4.model.NutritionOrder src) throws FHIRException {
        if (src == null) {
            return null;
        }
        NutritionOrder tgt = new NutritionOrder();
        NutritionOrder40_50.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(NutritionOrder40_50.convertIdentifier(identifier));
        }
        for (CanonicalType canonicalType : src.getInstantiatesCanonical()) {
            tgt.getInstantiatesCanonical().add(NutritionOrder40_50.convertCanonical(canonicalType));
        }
        for (UriType uriType : src.getInstantiatesUri()) {
            tgt.getInstantiatesUri().add(NutritionOrder40_50.convertUri(uriType));
        }
        for (UriType uriType : src.getInstantiates()) {
            tgt.getInstantiates().add(NutritionOrder40_50.convertUri(uriType));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(NutritionOrder40_50.convertNutritionOrderStatus(src.getStatusElement()));
        }
        if (src.hasIntent()) {
            tgt.setIntentElement(NutritionOrder40_50.convertNutritiionOrderIntent(src.getIntentElement()));
        }
        if (src.hasPatient()) {
            tgt.setPatient(NutritionOrder40_50.convertReference(src.getPatient()));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(NutritionOrder40_50.convertReference(src.getEncounter()));
        }
        if (src.hasDateTime()) {
            tgt.setDateTimeElement(NutritionOrder40_50.convertDateTime(src.getDateTimeElement()));
        }
        if (src.hasOrderer()) {
            tgt.setOrderer(NutritionOrder40_50.convertReference(src.getOrderer()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getAllergyIntolerance()) {
            tgt.addAllergyIntolerance(NutritionOrder40_50.convertReference(reference));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getFoodPreferenceModifier()) {
            tgt.addFoodPreferenceModifier(NutritionOrder40_50.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getExcludeFoodModifier()) {
            tgt.addExcludeFoodModifier(NutritionOrder40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasOralDiet()) {
            tgt.setOralDiet(NutritionOrder40_50.convertNutritionOrderOralDietComponent(src.getOralDiet()));
        }
        for (NutritionOrder.NutritionOrderSupplementComponent nutritionOrderSupplementComponent : src.getSupplement()) {
            tgt.addSupplement(NutritionOrder40_50.convertNutritionOrderSupplementComponent(nutritionOrderSupplementComponent));
        }
        if (src.hasEnteralFormula()) {
            tgt.setEnteralFormula(NutritionOrder40_50.convertNutritionOrderEnteralFormulaComponent(src.getEnteralFormula()));
        }
        for (org.hl7.fhir.r4.model.Annotation annotation : src.getNote()) {
            tgt.addNote(NutritionOrder40_50.convertAnnotation(annotation));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.NutritionOrder convertNutritionOrder(NutritionOrder src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.NutritionOrder tgt = new org.hl7.fhir.r4.model.NutritionOrder();
        NutritionOrder40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(NutritionOrder40_50.convertIdentifier(identifier));
        }
        for (org.hl7.fhir.r5.model.CanonicalType canonicalType : src.getInstantiatesCanonical()) {
            tgt.getInstantiatesCanonical().add(NutritionOrder40_50.convertCanonical(canonicalType));
        }
        for (org.hl7.fhir.r5.model.UriType uriType : src.getInstantiatesUri()) {
            tgt.getInstantiatesUri().add(NutritionOrder40_50.convertUri(uriType));
        }
        for (org.hl7.fhir.r5.model.UriType uriType : src.getInstantiates()) {
            tgt.getInstantiates().add(NutritionOrder40_50.convertUri(uriType));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(NutritionOrder40_50.convertNutritionOrderStatus(src.getStatusElement()));
        }
        if (src.hasIntent()) {
            tgt.setIntentElement(NutritionOrder40_50.convertNutritiionOrderIntent(src.getIntentElement()));
        }
        if (src.hasPatient()) {
            tgt.setPatient(NutritionOrder40_50.convertReference(src.getPatient()));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(NutritionOrder40_50.convertReference(src.getEncounter()));
        }
        if (src.hasDateTime()) {
            tgt.setDateTimeElement(NutritionOrder40_50.convertDateTime(src.getDateTimeElement()));
        }
        if (src.hasOrderer()) {
            tgt.setOrderer(NutritionOrder40_50.convertReference(src.getOrderer()));
        }
        for (Reference reference : src.getAllergyIntolerance()) {
            tgt.addAllergyIntolerance(NutritionOrder40_50.convertReference(reference));
        }
        for (CodeableConcept codeableConcept : src.getFoodPreferenceModifier()) {
            tgt.addFoodPreferenceModifier(NutritionOrder40_50.convertCodeableConcept(codeableConcept));
        }
        for (CodeableConcept codeableConcept : src.getExcludeFoodModifier()) {
            tgt.addExcludeFoodModifier(NutritionOrder40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasOralDiet()) {
            tgt.setOralDiet(NutritionOrder40_50.convertNutritionOrderOralDietComponent(src.getOralDiet()));
        }
        for (NutritionOrder.NutritionOrderSupplementComponent nutritionOrderSupplementComponent : src.getSupplement()) {
            tgt.addSupplement(NutritionOrder40_50.convertNutritionOrderSupplementComponent(nutritionOrderSupplementComponent));
        }
        if (src.hasEnteralFormula()) {
            tgt.setEnteralFormula(NutritionOrder40_50.convertNutritionOrderEnteralFormulaComponent(src.getEnteralFormula()));
        }
        for (Annotation annotation : src.getNote()) {
            tgt.addNote(NutritionOrder40_50.convertAnnotation(annotation));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestStatus> convertNutritionOrderStatus(Enumeration<NutritionOrder.NutritionOrderStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestStatus> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestStatus>(new Enumerations.RequestStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((NutritionOrder.NutritionOrderStatus)((Object)src.getValue())) {
            case DRAFT: {
                tgt.setValue((Object)Enumerations.RequestStatus.DRAFT);
                break;
            }
            case ACTIVE: {
                tgt.setValue((Object)Enumerations.RequestStatus.ACTIVE);
                break;
            }
            case ONHOLD: {
                tgt.setValue((Object)Enumerations.RequestStatus.ONHOLD);
                break;
            }
            case REVOKED: {
                tgt.setValue((Object)Enumerations.RequestStatus.REVOKED);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)Enumerations.RequestStatus.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Enumerations.RequestStatus.ENTEREDINERROR);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)Enumerations.RequestStatus.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.RequestStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<NutritionOrder.NutritionOrderStatus> convertNutritionOrderStatus(org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<NutritionOrder.NutritionOrderStatus> tgt = new Enumeration<NutritionOrder.NutritionOrderStatus>(new NutritionOrder.NutritionOrderStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.RequestStatus)((Object)src.getValue())) {
            case DRAFT: {
                tgt.setValue((Object)NutritionOrder.NutritionOrderStatus.DRAFT);
                break;
            }
            case ACTIVE: {
                tgt.setValue((Object)NutritionOrder.NutritionOrderStatus.ACTIVE);
                break;
            }
            case ONHOLD: {
                tgt.setValue((Object)NutritionOrder.NutritionOrderStatus.ONHOLD);
                break;
            }
            case REVOKED: {
                tgt.setValue((Object)NutritionOrder.NutritionOrderStatus.REVOKED);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)NutritionOrder.NutritionOrderStatus.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)NutritionOrder.NutritionOrderStatus.ENTEREDINERROR);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)NutritionOrder.NutritionOrderStatus.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)NutritionOrder.NutritionOrderStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestIntent> convertNutritiionOrderIntent(Enumeration<NutritionOrder.NutritiionOrderIntent> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestIntent> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestIntent>(new Enumerations.RequestIntentEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((NutritionOrder.NutritiionOrderIntent)((Object)src.getValue())) {
            case PROPOSAL: {
                tgt.setValue((Object)Enumerations.RequestIntent.PROPOSAL);
                break;
            }
            case PLAN: {
                tgt.setValue((Object)Enumerations.RequestIntent.PLAN);
                break;
            }
            case DIRECTIVE: {
                tgt.setValue((Object)Enumerations.RequestIntent.DIRECTIVE);
                break;
            }
            case ORDER: {
                tgt.setValue((Object)Enumerations.RequestIntent.ORDER);
                break;
            }
            case ORIGINALORDER: {
                tgt.setValue((Object)Enumerations.RequestIntent.ORIGINALORDER);
                break;
            }
            case REFLEXORDER: {
                tgt.setValue((Object)Enumerations.RequestIntent.REFLEXORDER);
                break;
            }
            case FILLERORDER: {
                tgt.setValue((Object)Enumerations.RequestIntent.FILLERORDER);
                break;
            }
            case INSTANCEORDER: {
                tgt.setValue((Object)Enumerations.RequestIntent.INSTANCEORDER);
                break;
            }
            case OPTION: {
                tgt.setValue((Object)Enumerations.RequestIntent.OPTION);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.RequestIntent.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<NutritionOrder.NutritiionOrderIntent> convertNutritiionOrderIntent(org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestIntent> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<NutritionOrder.NutritiionOrderIntent> tgt = new Enumeration<NutritionOrder.NutritiionOrderIntent>(new NutritionOrder.NutritiionOrderIntentEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.RequestIntent)((Object)src.getValue())) {
            case PROPOSAL: {
                tgt.setValue((Object)NutritionOrder.NutritiionOrderIntent.PROPOSAL);
                break;
            }
            case PLAN: {
                tgt.setValue((Object)NutritionOrder.NutritiionOrderIntent.PLAN);
                break;
            }
            case DIRECTIVE: {
                tgt.setValue((Object)NutritionOrder.NutritiionOrderIntent.DIRECTIVE);
                break;
            }
            case ORDER: {
                tgt.setValue((Object)NutritionOrder.NutritiionOrderIntent.ORDER);
                break;
            }
            case ORIGINALORDER: {
                tgt.setValue((Object)NutritionOrder.NutritiionOrderIntent.ORIGINALORDER);
                break;
            }
            case REFLEXORDER: {
                tgt.setValue((Object)NutritionOrder.NutritiionOrderIntent.REFLEXORDER);
                break;
            }
            case FILLERORDER: {
                tgt.setValue((Object)NutritionOrder.NutritiionOrderIntent.FILLERORDER);
                break;
            }
            case INSTANCEORDER: {
                tgt.setValue((Object)NutritionOrder.NutritiionOrderIntent.INSTANCEORDER);
                break;
            }
            case OPTION: {
                tgt.setValue((Object)NutritionOrder.NutritiionOrderIntent.OPTION);
                break;
            }
            default: {
                tgt.setValue((Object)NutritionOrder.NutritiionOrderIntent.NULL);
            }
        }
        return tgt;
    }

    public static NutritionOrder.NutritionOrderOralDietComponent convertNutritionOrderOralDietComponent(NutritionOrder.NutritionOrderOralDietComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        NutritionOrder.NutritionOrderOralDietComponent tgt = new NutritionOrder.NutritionOrderOralDietComponent();
        NutritionOrder40_50.copyElement(src, tgt, new String[0]);
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getType()) {
            tgt.addType(NutritionOrder40_50.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.Timing timing : src.getSchedule()) {
            tgt.addSchedule(NutritionOrder40_50.convertTiming(timing));
        }
        for (NutritionOrder.NutritionOrderOralDietNutrientComponent nutritionOrderOralDietNutrientComponent : src.getNutrient()) {
            tgt.addNutrient(NutritionOrder40_50.convertNutritionOrderOralDietNutrientComponent(nutritionOrderOralDietNutrientComponent));
        }
        for (NutritionOrder.NutritionOrderOralDietTextureComponent nutritionOrderOralDietTextureComponent : src.getTexture()) {
            tgt.addTexture(NutritionOrder40_50.convertNutritionOrderOralDietTextureComponent(nutritionOrderOralDietTextureComponent));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getFluidConsistencyType()) {
            tgt.addFluidConsistencyType(NutritionOrder40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasInstruction()) {
            tgt.setInstructionElement(NutritionOrder40_50.convertString(src.getInstructionElement()));
        }
        return tgt;
    }

    public static NutritionOrder.NutritionOrderOralDietComponent convertNutritionOrderOralDietComponent(NutritionOrder.NutritionOrderOralDietComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        NutritionOrder.NutritionOrderOralDietComponent tgt = new NutritionOrder.NutritionOrderOralDietComponent();
        NutritionOrder40_50.copyElement(src, tgt, new String[0]);
        for (CodeableConcept codeableConcept : src.getType()) {
            tgt.addType(NutritionOrder40_50.convertCodeableConcept(codeableConcept));
        }
        for (Timing timing : src.getSchedule()) {
            tgt.addSchedule(NutritionOrder40_50.convertTiming(timing));
        }
        for (NutritionOrder.NutritionOrderOralDietNutrientComponent nutritionOrderOralDietNutrientComponent : src.getNutrient()) {
            tgt.addNutrient(NutritionOrder40_50.convertNutritionOrderOralDietNutrientComponent(nutritionOrderOralDietNutrientComponent));
        }
        for (NutritionOrder.NutritionOrderOralDietTextureComponent nutritionOrderOralDietTextureComponent : src.getTexture()) {
            tgt.addTexture(NutritionOrder40_50.convertNutritionOrderOralDietTextureComponent(nutritionOrderOralDietTextureComponent));
        }
        for (CodeableConcept codeableConcept : src.getFluidConsistencyType()) {
            tgt.addFluidConsistencyType(NutritionOrder40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasInstruction()) {
            tgt.setInstructionElement(NutritionOrder40_50.convertString(src.getInstructionElement()));
        }
        return tgt;
    }

    public static NutritionOrder.NutritionOrderOralDietNutrientComponent convertNutritionOrderOralDietNutrientComponent(NutritionOrder.NutritionOrderOralDietNutrientComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        NutritionOrder.NutritionOrderOralDietNutrientComponent tgt = new NutritionOrder.NutritionOrderOralDietNutrientComponent();
        NutritionOrder40_50.copyElement(src, tgt, new String[0]);
        if (src.hasModifier()) {
            tgt.setModifier(NutritionOrder40_50.convertCodeableConcept(src.getModifier()));
        }
        if (src.hasAmount()) {
            tgt.setAmount(NutritionOrder40_50.convertSimpleQuantity(src.getAmount()));
        }
        return tgt;
    }

    public static NutritionOrder.NutritionOrderOralDietNutrientComponent convertNutritionOrderOralDietNutrientComponent(NutritionOrder.NutritionOrderOralDietNutrientComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        NutritionOrder.NutritionOrderOralDietNutrientComponent tgt = new NutritionOrder.NutritionOrderOralDietNutrientComponent();
        NutritionOrder40_50.copyElement(src, tgt, new String[0]);
        if (src.hasModifier()) {
            tgt.setModifier(NutritionOrder40_50.convertCodeableConcept(src.getModifier()));
        }
        if (src.hasAmount()) {
            tgt.setAmount(NutritionOrder40_50.convertSimpleQuantity(src.getAmount()));
        }
        return tgt;
    }

    public static NutritionOrder.NutritionOrderOralDietTextureComponent convertNutritionOrderOralDietTextureComponent(NutritionOrder.NutritionOrderOralDietTextureComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        NutritionOrder.NutritionOrderOralDietTextureComponent tgt = new NutritionOrder.NutritionOrderOralDietTextureComponent();
        NutritionOrder40_50.copyElement(src, tgt, new String[0]);
        if (src.hasModifier()) {
            tgt.setModifier(NutritionOrder40_50.convertCodeableConcept(src.getModifier()));
        }
        if (src.hasFoodType()) {
            tgt.setFoodType(NutritionOrder40_50.convertCodeableConcept(src.getFoodType()));
        }
        return tgt;
    }

    public static NutritionOrder.NutritionOrderOralDietTextureComponent convertNutritionOrderOralDietTextureComponent(NutritionOrder.NutritionOrderOralDietTextureComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        NutritionOrder.NutritionOrderOralDietTextureComponent tgt = new NutritionOrder.NutritionOrderOralDietTextureComponent();
        NutritionOrder40_50.copyElement(src, tgt, new String[0]);
        if (src.hasModifier()) {
            tgt.setModifier(NutritionOrder40_50.convertCodeableConcept(src.getModifier()));
        }
        if (src.hasFoodType()) {
            tgt.setFoodType(NutritionOrder40_50.convertCodeableConcept(src.getFoodType()));
        }
        return tgt;
    }

    public static NutritionOrder.NutritionOrderSupplementComponent convertNutritionOrderSupplementComponent(NutritionOrder.NutritionOrderSupplementComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        NutritionOrder.NutritionOrderSupplementComponent tgt = new NutritionOrder.NutritionOrderSupplementComponent();
        NutritionOrder40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(NutritionOrder40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasProductName()) {
            tgt.setProductNameElement(NutritionOrder40_50.convertString(src.getProductNameElement()));
        }
        for (org.hl7.fhir.r4.model.Timing t : src.getSchedule()) {
            tgt.addSchedule(NutritionOrder40_50.convertTiming(t));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(NutritionOrder40_50.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasInstruction()) {
            tgt.setInstructionElement(NutritionOrder40_50.convertString(src.getInstructionElement()));
        }
        return tgt;
    }

    public static NutritionOrder.NutritionOrderSupplementComponent convertNutritionOrderSupplementComponent(NutritionOrder.NutritionOrderSupplementComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        NutritionOrder.NutritionOrderSupplementComponent tgt = new NutritionOrder.NutritionOrderSupplementComponent();
        NutritionOrder40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(NutritionOrder40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasProductName()) {
            tgt.setProductNameElement(NutritionOrder40_50.convertString(src.getProductNameElement()));
        }
        for (Timing t : src.getSchedule()) {
            tgt.addSchedule(NutritionOrder40_50.convertTiming(t));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(NutritionOrder40_50.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasInstruction()) {
            tgt.setInstructionElement(NutritionOrder40_50.convertString(src.getInstructionElement()));
        }
        return tgt;
    }

    public static NutritionOrder.NutritionOrderEnteralFormulaComponent convertNutritionOrderEnteralFormulaComponent(NutritionOrder.NutritionOrderEnteralFormulaComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        NutritionOrder.NutritionOrderEnteralFormulaComponent tgt = new NutritionOrder.NutritionOrderEnteralFormulaComponent();
        NutritionOrder40_50.copyElement(src, tgt, new String[0]);
        if (src.hasBaseFormulaType()) {
            tgt.setBaseFormulaType(NutritionOrder40_50.convertCodeableConcept(src.getBaseFormulaType()));
        }
        if (src.hasBaseFormulaProductName()) {
            tgt.setBaseFormulaProductNameElement(NutritionOrder40_50.convertString(src.getBaseFormulaProductNameElement()));
        }
        if (src.hasAdditiveType()) {
            tgt.setAdditiveType(NutritionOrder40_50.convertCodeableConcept(src.getAdditiveType()));
        }
        if (src.hasAdditiveProductName()) {
            tgt.setAdditiveProductNameElement(NutritionOrder40_50.convertString(src.getAdditiveProductNameElement()));
        }
        if (src.hasCaloricDensity()) {
            tgt.setCaloricDensity(NutritionOrder40_50.convertSimpleQuantity(src.getCaloricDensity()));
        }
        if (src.hasRouteofAdministration()) {
            tgt.setRouteofAdministration(NutritionOrder40_50.convertCodeableConcept(src.getRouteofAdministration()));
        }
        for (NutritionOrder.NutritionOrderEnteralFormulaAdministrationComponent t : src.getAdministration()) {
            tgt.addAdministration(NutritionOrder40_50.convertNutritionOrderEnteralFormulaAdministrationComponent(t));
        }
        if (src.hasMaxVolumeToDeliver()) {
            tgt.setMaxVolumeToDeliver(NutritionOrder40_50.convertSimpleQuantity(src.getMaxVolumeToDeliver()));
        }
        if (src.hasAdministrationInstruction()) {
            tgt.setAdministrationInstructionElement(NutritionOrder40_50.convertString(src.getAdministrationInstructionElement()));
        }
        return tgt;
    }

    public static NutritionOrder.NutritionOrderEnteralFormulaComponent convertNutritionOrderEnteralFormulaComponent(NutritionOrder.NutritionOrderEnteralFormulaComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        NutritionOrder.NutritionOrderEnteralFormulaComponent tgt = new NutritionOrder.NutritionOrderEnteralFormulaComponent();
        NutritionOrder40_50.copyElement(src, tgt, new String[0]);
        if (src.hasBaseFormulaType()) {
            tgt.setBaseFormulaType(NutritionOrder40_50.convertCodeableConcept(src.getBaseFormulaType()));
        }
        if (src.hasBaseFormulaProductName()) {
            tgt.setBaseFormulaProductNameElement(NutritionOrder40_50.convertString(src.getBaseFormulaProductNameElement()));
        }
        if (src.hasAdditiveType()) {
            tgt.setAdditiveType(NutritionOrder40_50.convertCodeableConcept(src.getAdditiveType()));
        }
        if (src.hasAdditiveProductName()) {
            tgt.setAdditiveProductNameElement(NutritionOrder40_50.convertString(src.getAdditiveProductNameElement()));
        }
        if (src.hasCaloricDensity()) {
            tgt.setCaloricDensity(NutritionOrder40_50.convertSimpleQuantity(src.getCaloricDensity()));
        }
        if (src.hasRouteofAdministration()) {
            tgt.setRouteofAdministration(NutritionOrder40_50.convertCodeableConcept(src.getRouteofAdministration()));
        }
        for (NutritionOrder.NutritionOrderEnteralFormulaAdministrationComponent t : src.getAdministration()) {
            tgt.addAdministration(NutritionOrder40_50.convertNutritionOrderEnteralFormulaAdministrationComponent(t));
        }
        if (src.hasMaxVolumeToDeliver()) {
            tgt.setMaxVolumeToDeliver(NutritionOrder40_50.convertSimpleQuantity(src.getMaxVolumeToDeliver()));
        }
        if (src.hasAdministrationInstruction()) {
            tgt.setAdministrationInstructionElement(NutritionOrder40_50.convertString(src.getAdministrationInstructionElement()));
        }
        return tgt;
    }

    public static NutritionOrder.NutritionOrderEnteralFormulaAdministrationComponent convertNutritionOrderEnteralFormulaAdministrationComponent(NutritionOrder.NutritionOrderEnteralFormulaAdministrationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        NutritionOrder.NutritionOrderEnteralFormulaAdministrationComponent tgt = new NutritionOrder.NutritionOrderEnteralFormulaAdministrationComponent();
        NutritionOrder40_50.copyElement(src, tgt, new String[0]);
        if (src.hasSchedule()) {
            tgt.setSchedule(NutritionOrder40_50.convertTiming(src.getSchedule()));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(NutritionOrder40_50.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasRate()) {
            tgt.setRate(NutritionOrder40_50.convertType(src.getRate()));
        }
        return tgt;
    }

    public static NutritionOrder.NutritionOrderEnteralFormulaAdministrationComponent convertNutritionOrderEnteralFormulaAdministrationComponent(NutritionOrder.NutritionOrderEnteralFormulaAdministrationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        NutritionOrder.NutritionOrderEnteralFormulaAdministrationComponent tgt = new NutritionOrder.NutritionOrderEnteralFormulaAdministrationComponent();
        NutritionOrder40_50.copyElement(src, tgt, new String[0]);
        if (src.hasSchedule()) {
            tgt.setSchedule(NutritionOrder40_50.convertTiming(src.getSchedule()));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(NutritionOrder40_50.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasRate()) {
            tgt.setRate(NutritionOrder40_50.convertType(src.getRate()));
        }
        return tgt;
    }
}

