/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.MolecularSequence;
import org.hl7.fhir.r5.model.DecimalType;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.MolecularSequence;
import org.hl7.fhir.r5.model.Reference;

public class MolecularSequence40_50
extends VersionConvertor_40_50 {
    public static MolecularSequence convertMolecularSequence(org.hl7.fhir.r4.model.MolecularSequence src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MolecularSequence tgt = new MolecularSequence();
        MolecularSequence40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r4.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(MolecularSequence40_50.convertIdentifier(identifier));
        }
        if (src.hasType()) {
            tgt.setTypeElement(MolecularSequence40_50.convertSequenceType(src.getTypeElement()));
        }
        if (src.hasCoordinateSystem()) {
            tgt.setCoordinateSystemElement(MolecularSequence40_50.convertInteger(src.getCoordinateSystemElement()));
        }
        if (src.hasPatient()) {
            tgt.setPatient(MolecularSequence40_50.convertReference(src.getPatient()));
        }
        if (src.hasSpecimen()) {
            tgt.setSpecimen(MolecularSequence40_50.convertReference(src.getSpecimen()));
        }
        if (src.hasDevice()) {
            tgt.setDevice(MolecularSequence40_50.convertReference(src.getDevice()));
        }
        if (src.hasPerformer()) {
            tgt.setPerformer(MolecularSequence40_50.convertReference(src.getPerformer()));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(MolecularSequence40_50.convertQuantity(src.getQuantity()));
        }
        if (src.hasReferenceSeq()) {
            tgt.setReferenceSeq(MolecularSequence40_50.convertMolecularSequenceReferenceSeqComponent(src.getReferenceSeq()));
        }
        for (MolecularSequence.MolecularSequenceVariantComponent molecularSequenceVariantComponent : src.getVariant()) {
            tgt.addVariant(MolecularSequence40_50.convertMolecularSequenceVariantComponent(molecularSequenceVariantComponent));
        }
        if (src.hasObservedSeq()) {
            tgt.setObservedSeqElement(MolecularSequence40_50.convertString(src.getObservedSeqElement()));
        }
        for (MolecularSequence.MolecularSequenceQualityComponent molecularSequenceQualityComponent : src.getQuality()) {
            tgt.addQuality(MolecularSequence40_50.convertMolecularSequenceQualityComponent(molecularSequenceQualityComponent));
        }
        if (src.hasReadCoverage()) {
            tgt.setReadCoverageElement(MolecularSequence40_50.convertInteger(src.getReadCoverageElement()));
        }
        for (MolecularSequence.MolecularSequenceRepositoryComponent molecularSequenceRepositoryComponent : src.getRepository()) {
            tgt.addRepository(MolecularSequence40_50.convertMolecularSequenceRepositoryComponent(molecularSequenceRepositoryComponent));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getPointer()) {
            tgt.addPointer(MolecularSequence40_50.convertReference(reference));
        }
        for (MolecularSequence.MolecularSequenceStructureVariantComponent molecularSequenceStructureVariantComponent : src.getStructureVariant()) {
            tgt.addStructureVariant(MolecularSequence40_50.convertMolecularSequenceStructureVariantComponent(molecularSequenceStructureVariantComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.MolecularSequence convertMolecularSequence(MolecularSequence src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.MolecularSequence tgt = new org.hl7.fhir.r4.model.MolecularSequence();
        MolecularSequence40_50.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(MolecularSequence40_50.convertIdentifier(identifier));
        }
        if (src.hasType()) {
            tgt.setTypeElement(MolecularSequence40_50.convertSequenceType(src.getTypeElement()));
        }
        if (src.hasCoordinateSystem()) {
            tgt.setCoordinateSystemElement(MolecularSequence40_50.convertInteger(src.getCoordinateSystemElement()));
        }
        if (src.hasPatient()) {
            tgt.setPatient(MolecularSequence40_50.convertReference(src.getPatient()));
        }
        if (src.hasSpecimen()) {
            tgt.setSpecimen(MolecularSequence40_50.convertReference(src.getSpecimen()));
        }
        if (src.hasDevice()) {
            tgt.setDevice(MolecularSequence40_50.convertReference(src.getDevice()));
        }
        if (src.hasPerformer()) {
            tgt.setPerformer(MolecularSequence40_50.convertReference(src.getPerformer()));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(MolecularSequence40_50.convertQuantity(src.getQuantity()));
        }
        if (src.hasReferenceSeq()) {
            tgt.setReferenceSeq(MolecularSequence40_50.convertMolecularSequenceReferenceSeqComponent(src.getReferenceSeq()));
        }
        for (MolecularSequence.MolecularSequenceVariantComponent molecularSequenceVariantComponent : src.getVariant()) {
            tgt.addVariant(MolecularSequence40_50.convertMolecularSequenceVariantComponent(molecularSequenceVariantComponent));
        }
        if (src.hasObservedSeq()) {
            tgt.setObservedSeqElement(MolecularSequence40_50.convertString(src.getObservedSeqElement()));
        }
        for (MolecularSequence.MolecularSequenceQualityComponent molecularSequenceQualityComponent : src.getQuality()) {
            tgt.addQuality(MolecularSequence40_50.convertMolecularSequenceQualityComponent(molecularSequenceQualityComponent));
        }
        if (src.hasReadCoverage()) {
            tgt.setReadCoverageElement(MolecularSequence40_50.convertInteger(src.getReadCoverageElement()));
        }
        for (MolecularSequence.MolecularSequenceRepositoryComponent molecularSequenceRepositoryComponent : src.getRepository()) {
            tgt.addRepository(MolecularSequence40_50.convertMolecularSequenceRepositoryComponent(molecularSequenceRepositoryComponent));
        }
        for (Reference reference : src.getPointer()) {
            tgt.addPointer(MolecularSequence40_50.convertReference(reference));
        }
        for (MolecularSequence.MolecularSequenceStructureVariantComponent molecularSequenceStructureVariantComponent : src.getStructureVariant()) {
            tgt.addStructureVariant(MolecularSequence40_50.convertMolecularSequenceStructureVariantComponent(molecularSequenceStructureVariantComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<MolecularSequence.SequenceType> convertSequenceType(Enumeration<MolecularSequence.SequenceType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<MolecularSequence.SequenceType> tgt = new org.hl7.fhir.r5.model.Enumeration<MolecularSequence.SequenceType>(new MolecularSequence.SequenceTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((MolecularSequence.SequenceType)((Object)src.getValue())) {
            case AA: {
                tgt.setValue((Object)MolecularSequence.SequenceType.AA);
                break;
            }
            case DNA: {
                tgt.setValue((Object)MolecularSequence.SequenceType.DNA);
                break;
            }
            case RNA: {
                tgt.setValue((Object)MolecularSequence.SequenceType.RNA);
                break;
            }
            default: {
                tgt.setValue((Object)MolecularSequence.SequenceType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<MolecularSequence.SequenceType> convertSequenceType(org.hl7.fhir.r5.model.Enumeration<MolecularSequence.SequenceType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<MolecularSequence.SequenceType> tgt = new Enumeration<MolecularSequence.SequenceType>(new MolecularSequence.SequenceTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((MolecularSequence.SequenceType)((Object)src.getValue())) {
            case AA: {
                tgt.setValue((Object)MolecularSequence.SequenceType.AA);
                break;
            }
            case DNA: {
                tgt.setValue((Object)MolecularSequence.SequenceType.DNA);
                break;
            }
            case RNA: {
                tgt.setValue((Object)MolecularSequence.SequenceType.RNA);
                break;
            }
            default: {
                tgt.setValue((Object)MolecularSequence.SequenceType.NULL);
            }
        }
        return tgt;
    }

    public static MolecularSequence.MolecularSequenceReferenceSeqComponent convertMolecularSequenceReferenceSeqComponent(MolecularSequence.MolecularSequenceReferenceSeqComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MolecularSequence.MolecularSequenceReferenceSeqComponent tgt = new MolecularSequence.MolecularSequenceReferenceSeqComponent();
        MolecularSequence40_50.copyElement(src, tgt, new String[0]);
        if (src.hasChromosome()) {
            tgt.setChromosome(MolecularSequence40_50.convertCodeableConcept(src.getChromosome()));
        }
        if (src.hasGenomeBuild()) {
            tgt.setGenomeBuildElement(MolecularSequence40_50.convertString(src.getGenomeBuildElement()));
        }
        if (src.hasOrientation()) {
            tgt.setOrientationElement(MolecularSequence40_50.convertOrientationType(src.getOrientationElement()));
        }
        if (src.hasReferenceSeqId()) {
            tgt.setReferenceSeqId(MolecularSequence40_50.convertCodeableConcept(src.getReferenceSeqId()));
        }
        if (src.hasReferenceSeqPointer()) {
            tgt.setReferenceSeqPointer(MolecularSequence40_50.convertReference(src.getReferenceSeqPointer()));
        }
        if (src.hasReferenceSeqString()) {
            tgt.setReferenceSeqStringElement(MolecularSequence40_50.convertString(src.getReferenceSeqStringElement()));
        }
        if (src.hasStrand()) {
            tgt.setStrandElement(MolecularSequence40_50.convertStrandType(src.getStrandElement()));
        }
        if (src.hasWindowStart()) {
            tgt.setWindowStartElement(MolecularSequence40_50.convertInteger(src.getWindowStartElement()));
        }
        if (src.hasWindowEnd()) {
            tgt.setWindowEndElement(MolecularSequence40_50.convertInteger(src.getWindowEndElement()));
        }
        return tgt;
    }

    public static MolecularSequence.MolecularSequenceReferenceSeqComponent convertMolecularSequenceReferenceSeqComponent(MolecularSequence.MolecularSequenceReferenceSeqComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MolecularSequence.MolecularSequenceReferenceSeqComponent tgt = new MolecularSequence.MolecularSequenceReferenceSeqComponent();
        MolecularSequence40_50.copyElement(src, tgt, new String[0]);
        if (src.hasChromosome()) {
            tgt.setChromosome(MolecularSequence40_50.convertCodeableConcept(src.getChromosome()));
        }
        if (src.hasGenomeBuild()) {
            tgt.setGenomeBuildElement(MolecularSequence40_50.convertString(src.getGenomeBuildElement()));
        }
        if (src.hasOrientation()) {
            tgt.setOrientationElement(MolecularSequence40_50.convertOrientationType(src.getOrientationElement()));
        }
        if (src.hasReferenceSeqId()) {
            tgt.setReferenceSeqId(MolecularSequence40_50.convertCodeableConcept(src.getReferenceSeqId()));
        }
        if (src.hasReferenceSeqPointer()) {
            tgt.setReferenceSeqPointer(MolecularSequence40_50.convertReference(src.getReferenceSeqPointer()));
        }
        if (src.hasReferenceSeqString()) {
            tgt.setReferenceSeqStringElement(MolecularSequence40_50.convertString(src.getReferenceSeqStringElement()));
        }
        if (src.hasStrand()) {
            tgt.setStrandElement(MolecularSequence40_50.convertStrandType(src.getStrandElement()));
        }
        if (src.hasWindowStart()) {
            tgt.setWindowStartElement(MolecularSequence40_50.convertInteger(src.getWindowStartElement()));
        }
        if (src.hasWindowEnd()) {
            tgt.setWindowEndElement(MolecularSequence40_50.convertInteger(src.getWindowEndElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<MolecularSequence.OrientationType> convertOrientationType(Enumeration<MolecularSequence.OrientationType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<MolecularSequence.OrientationType> tgt = new org.hl7.fhir.r5.model.Enumeration<MolecularSequence.OrientationType>(new MolecularSequence.OrientationTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((MolecularSequence.OrientationType)((Object)src.getValue())) {
            case SENSE: {
                tgt.setValue((Object)MolecularSequence.OrientationType.SENSE);
                break;
            }
            case ANTISENSE: {
                tgt.setValue((Object)MolecularSequence.OrientationType.ANTISENSE);
                break;
            }
            default: {
                tgt.setValue((Object)MolecularSequence.OrientationType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<MolecularSequence.OrientationType> convertOrientationType(org.hl7.fhir.r5.model.Enumeration<MolecularSequence.OrientationType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<MolecularSequence.OrientationType> tgt = new Enumeration<MolecularSequence.OrientationType>(new MolecularSequence.OrientationTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((MolecularSequence.OrientationType)((Object)src.getValue())) {
            case SENSE: {
                tgt.setValue((Object)MolecularSequence.OrientationType.SENSE);
                break;
            }
            case ANTISENSE: {
                tgt.setValue((Object)MolecularSequence.OrientationType.ANTISENSE);
                break;
            }
            default: {
                tgt.setValue((Object)MolecularSequence.OrientationType.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<MolecularSequence.StrandType> convertStrandType(Enumeration<MolecularSequence.StrandType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<MolecularSequence.StrandType> tgt = new org.hl7.fhir.r5.model.Enumeration<MolecularSequence.StrandType>(new MolecularSequence.StrandTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((MolecularSequence.StrandType)((Object)src.getValue())) {
            case WATSON: {
                tgt.setValue((Object)MolecularSequence.StrandType.WATSON);
                break;
            }
            case CRICK: {
                tgt.setValue((Object)MolecularSequence.StrandType.CRICK);
                break;
            }
            default: {
                tgt.setValue((Object)MolecularSequence.StrandType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<MolecularSequence.StrandType> convertStrandType(org.hl7.fhir.r5.model.Enumeration<MolecularSequence.StrandType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<MolecularSequence.StrandType> tgt = new Enumeration<MolecularSequence.StrandType>(new MolecularSequence.StrandTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((MolecularSequence.StrandType)((Object)src.getValue())) {
            case WATSON: {
                tgt.setValue((Object)MolecularSequence.StrandType.WATSON);
                break;
            }
            case CRICK: {
                tgt.setValue((Object)MolecularSequence.StrandType.CRICK);
                break;
            }
            default: {
                tgt.setValue((Object)MolecularSequence.StrandType.NULL);
            }
        }
        return tgt;
    }

    public static MolecularSequence.MolecularSequenceVariantComponent convertMolecularSequenceVariantComponent(MolecularSequence.MolecularSequenceVariantComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MolecularSequence.MolecularSequenceVariantComponent tgt = new MolecularSequence.MolecularSequenceVariantComponent();
        MolecularSequence40_50.copyElement(src, tgt, new String[0]);
        if (src.hasStart()) {
            tgt.setStartElement(MolecularSequence40_50.convertInteger(src.getStartElement()));
        }
        if (src.hasEnd()) {
            tgt.setEndElement(MolecularSequence40_50.convertInteger(src.getEndElement()));
        }
        if (src.hasObservedAllele()) {
            tgt.setObservedAlleleElement(MolecularSequence40_50.convertString(src.getObservedAlleleElement()));
        }
        if (src.hasReferenceAllele()) {
            tgt.setReferenceAlleleElement(MolecularSequence40_50.convertString(src.getReferenceAlleleElement()));
        }
        if (src.hasCigar()) {
            tgt.setCigarElement(MolecularSequence40_50.convertString(src.getCigarElement()));
        }
        if (src.hasVariantPointer()) {
            tgt.setVariantPointer(MolecularSequence40_50.convertReference(src.getVariantPointer()));
        }
        return tgt;
    }

    public static MolecularSequence.MolecularSequenceVariantComponent convertMolecularSequenceVariantComponent(MolecularSequence.MolecularSequenceVariantComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MolecularSequence.MolecularSequenceVariantComponent tgt = new MolecularSequence.MolecularSequenceVariantComponent();
        MolecularSequence40_50.copyElement(src, tgt, new String[0]);
        if (src.hasStart()) {
            tgt.setStartElement(MolecularSequence40_50.convertInteger(src.getStartElement()));
        }
        if (src.hasEnd()) {
            tgt.setEndElement(MolecularSequence40_50.convertInteger(src.getEndElement()));
        }
        if (src.hasObservedAllele()) {
            tgt.setObservedAlleleElement(MolecularSequence40_50.convertString(src.getObservedAlleleElement()));
        }
        if (src.hasReferenceAllele()) {
            tgt.setReferenceAlleleElement(MolecularSequence40_50.convertString(src.getReferenceAlleleElement()));
        }
        if (src.hasCigar()) {
            tgt.setCigarElement(MolecularSequence40_50.convertString(src.getCigarElement()));
        }
        if (src.hasVariantPointer()) {
            tgt.setVariantPointer(MolecularSequence40_50.convertReference(src.getVariantPointer()));
        }
        return tgt;
    }

    public static MolecularSequence.MolecularSequenceQualityComponent convertMolecularSequenceQualityComponent(MolecularSequence.MolecularSequenceQualityComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MolecularSequence.MolecularSequenceQualityComponent tgt = new MolecularSequence.MolecularSequenceQualityComponent();
        MolecularSequence40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(MolecularSequence40_50.convertQualityType(src.getTypeElement()));
        }
        if (src.hasStandardSequence()) {
            tgt.setStandardSequence(MolecularSequence40_50.convertCodeableConcept(src.getStandardSequence()));
        }
        if (src.hasStart()) {
            tgt.setStartElement(MolecularSequence40_50.convertInteger(src.getStartElement()));
        }
        if (src.hasEnd()) {
            tgt.setEndElement(MolecularSequence40_50.convertInteger(src.getEndElement()));
        }
        if (src.hasScore()) {
            tgt.setScore(MolecularSequence40_50.convertQuantity(src.getScore()));
        }
        if (src.hasMethod()) {
            tgt.setMethod(MolecularSequence40_50.convertCodeableConcept(src.getMethod()));
        }
        if (src.hasTruthTP()) {
            tgt.setTruthTPElement(MolecularSequence40_50.convertDecimal(src.getTruthTPElement()));
        }
        if (src.hasQueryTP()) {
            tgt.setQueryTPElement(MolecularSequence40_50.convertDecimal(src.getQueryTPElement()));
        }
        if (src.hasTruthFN()) {
            tgt.setTruthFNElement(MolecularSequence40_50.convertDecimal(src.getTruthFNElement()));
        }
        if (src.hasQueryFP()) {
            tgt.setQueryFPElement(MolecularSequence40_50.convertDecimal(src.getQueryFPElement()));
        }
        if (src.hasGtFP()) {
            tgt.setGtFPElement(MolecularSequence40_50.convertDecimal(src.getGtFPElement()));
        }
        if (src.hasPrecision()) {
            tgt.setPrecisionElement(MolecularSequence40_50.convertDecimal(src.getPrecisionElement()));
        }
        if (src.hasRecall()) {
            tgt.setRecallElement(MolecularSequence40_50.convertDecimal(src.getRecallElement()));
        }
        if (src.hasFScore()) {
            tgt.setFScoreElement(MolecularSequence40_50.convertDecimal(src.getFScoreElement()));
        }
        if (src.hasRoc()) {
            tgt.setRoc(MolecularSequence40_50.convertMolecularSequenceQualityRocComponent(src.getRoc()));
        }
        return tgt;
    }

    public static MolecularSequence.MolecularSequenceQualityComponent convertMolecularSequenceQualityComponent(MolecularSequence.MolecularSequenceQualityComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MolecularSequence.MolecularSequenceQualityComponent tgt = new MolecularSequence.MolecularSequenceQualityComponent();
        MolecularSequence40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(MolecularSequence40_50.convertQualityType(src.getTypeElement()));
        }
        if (src.hasStandardSequence()) {
            tgt.setStandardSequence(MolecularSequence40_50.convertCodeableConcept(src.getStandardSequence()));
        }
        if (src.hasStart()) {
            tgt.setStartElement(MolecularSequence40_50.convertInteger(src.getStartElement()));
        }
        if (src.hasEnd()) {
            tgt.setEndElement(MolecularSequence40_50.convertInteger(src.getEndElement()));
        }
        if (src.hasScore()) {
            tgt.setScore(MolecularSequence40_50.convertQuantity(src.getScore()));
        }
        if (src.hasMethod()) {
            tgt.setMethod(MolecularSequence40_50.convertCodeableConcept(src.getMethod()));
        }
        if (src.hasTruthTP()) {
            tgt.setTruthTPElement(MolecularSequence40_50.convertDecimal(src.getTruthTPElement()));
        }
        if (src.hasQueryTP()) {
            tgt.setQueryTPElement(MolecularSequence40_50.convertDecimal(src.getQueryTPElement()));
        }
        if (src.hasTruthFN()) {
            tgt.setTruthFNElement(MolecularSequence40_50.convertDecimal(src.getTruthFNElement()));
        }
        if (src.hasQueryFP()) {
            tgt.setQueryFPElement(MolecularSequence40_50.convertDecimal(src.getQueryFPElement()));
        }
        if (src.hasGtFP()) {
            tgt.setGtFPElement(MolecularSequence40_50.convertDecimal(src.getGtFPElement()));
        }
        if (src.hasPrecision()) {
            tgt.setPrecisionElement(MolecularSequence40_50.convertDecimal(src.getPrecisionElement()));
        }
        if (src.hasRecall()) {
            tgt.setRecallElement(MolecularSequence40_50.convertDecimal(src.getRecallElement()));
        }
        if (src.hasFScore()) {
            tgt.setFScoreElement(MolecularSequence40_50.convertDecimal(src.getFScoreElement()));
        }
        if (src.hasRoc()) {
            tgt.setRoc(MolecularSequence40_50.convertMolecularSequenceQualityRocComponent(src.getRoc()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<MolecularSequence.QualityType> convertQualityType(Enumeration<MolecularSequence.QualityType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<MolecularSequence.QualityType> tgt = new org.hl7.fhir.r5.model.Enumeration<MolecularSequence.QualityType>(new MolecularSequence.QualityTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((MolecularSequence.QualityType)((Object)src.getValue())) {
            case INDEL: {
                tgt.setValue((Object)MolecularSequence.QualityType.INDEL);
                break;
            }
            case SNP: {
                tgt.setValue((Object)MolecularSequence.QualityType.SNP);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)MolecularSequence.QualityType.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)MolecularSequence.QualityType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<MolecularSequence.QualityType> convertQualityType(org.hl7.fhir.r5.model.Enumeration<MolecularSequence.QualityType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<MolecularSequence.QualityType> tgt = new Enumeration<MolecularSequence.QualityType>(new MolecularSequence.QualityTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((MolecularSequence.QualityType)((Object)src.getValue())) {
            case INDEL: {
                tgt.setValue((Object)MolecularSequence.QualityType.INDEL);
                break;
            }
            case SNP: {
                tgt.setValue((Object)MolecularSequence.QualityType.SNP);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)MolecularSequence.QualityType.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)MolecularSequence.QualityType.NULL);
            }
        }
        return tgt;
    }

    public static MolecularSequence.MolecularSequenceQualityRocComponent convertMolecularSequenceQualityRocComponent(MolecularSequence.MolecularSequenceQualityRocComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MolecularSequence.MolecularSequenceQualityRocComponent tgt = new MolecularSequence.MolecularSequenceQualityRocComponent();
        MolecularSequence40_50.copyElement(src, tgt, new String[0]);
        for (org.hl7.fhir.r4.model.IntegerType integerType : src.getScore()) {
            tgt.getScore().add(MolecularSequence40_50.convertInteger(integerType));
        }
        for (org.hl7.fhir.r4.model.IntegerType integerType : src.getNumTP()) {
            tgt.getNumTP().add(MolecularSequence40_50.convertInteger(integerType));
        }
        for (org.hl7.fhir.r4.model.IntegerType integerType : src.getNumFP()) {
            tgt.getNumFP().add(MolecularSequence40_50.convertInteger(integerType));
        }
        for (org.hl7.fhir.r4.model.IntegerType integerType : src.getNumFN()) {
            tgt.getNumFN().add(MolecularSequence40_50.convertInteger(integerType));
        }
        for (org.hl7.fhir.r4.model.DecimalType decimalType : src.getPrecision()) {
            tgt.getPrecision().add(MolecularSequence40_50.convertDecimal(decimalType));
        }
        for (org.hl7.fhir.r4.model.DecimalType decimalType : src.getSensitivity()) {
            tgt.getSensitivity().add(MolecularSequence40_50.convertDecimal(decimalType));
        }
        for (org.hl7.fhir.r4.model.DecimalType decimalType : src.getFMeasure()) {
            tgt.getFMeasure().add(MolecularSequence40_50.convertDecimal(decimalType));
        }
        return tgt;
    }

    public static MolecularSequence.MolecularSequenceQualityRocComponent convertMolecularSequenceQualityRocComponent(MolecularSequence.MolecularSequenceQualityRocComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MolecularSequence.MolecularSequenceQualityRocComponent tgt = new MolecularSequence.MolecularSequenceQualityRocComponent();
        MolecularSequence40_50.copyElement(src, tgt, new String[0]);
        for (IntegerType integerType : src.getScore()) {
            tgt.getScore().add(MolecularSequence40_50.convertInteger(integerType));
        }
        for (IntegerType integerType : src.getNumTP()) {
            tgt.getNumTP().add(MolecularSequence40_50.convertInteger(integerType));
        }
        for (IntegerType integerType : src.getNumFP()) {
            tgt.getNumFP().add(MolecularSequence40_50.convertInteger(integerType));
        }
        for (IntegerType integerType : src.getNumFN()) {
            tgt.getNumFN().add(MolecularSequence40_50.convertInteger(integerType));
        }
        for (DecimalType decimalType : src.getPrecision()) {
            tgt.getPrecision().add(MolecularSequence40_50.convertDecimal(decimalType));
        }
        for (DecimalType decimalType : src.getSensitivity()) {
            tgt.getSensitivity().add(MolecularSequence40_50.convertDecimal(decimalType));
        }
        for (DecimalType decimalType : src.getFMeasure()) {
            tgt.getFMeasure().add(MolecularSequence40_50.convertDecimal(decimalType));
        }
        return tgt;
    }

    public static MolecularSequence.MolecularSequenceRepositoryComponent convertMolecularSequenceRepositoryComponent(MolecularSequence.MolecularSequenceRepositoryComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MolecularSequence.MolecularSequenceRepositoryComponent tgt = new MolecularSequence.MolecularSequenceRepositoryComponent();
        MolecularSequence40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(MolecularSequence40_50.convertRepositoryType(src.getTypeElement()));
        }
        if (src.hasUrl()) {
            tgt.setUrlElement(MolecularSequence40_50.convertUri(src.getUrlElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(MolecularSequence40_50.convertString(src.getNameElement()));
        }
        if (src.hasDatasetId()) {
            tgt.setDatasetIdElement(MolecularSequence40_50.convertString(src.getDatasetIdElement()));
        }
        if (src.hasVariantsetId()) {
            tgt.setVariantsetIdElement(MolecularSequence40_50.convertString(src.getVariantsetIdElement()));
        }
        if (src.hasReadsetId()) {
            tgt.setReadsetIdElement(MolecularSequence40_50.convertString(src.getReadsetIdElement()));
        }
        return tgt;
    }

    public static MolecularSequence.MolecularSequenceRepositoryComponent convertMolecularSequenceRepositoryComponent(MolecularSequence.MolecularSequenceRepositoryComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MolecularSequence.MolecularSequenceRepositoryComponent tgt = new MolecularSequence.MolecularSequenceRepositoryComponent();
        MolecularSequence40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(MolecularSequence40_50.convertRepositoryType(src.getTypeElement()));
        }
        if (src.hasUrl()) {
            tgt.setUrlElement(MolecularSequence40_50.convertUri(src.getUrlElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(MolecularSequence40_50.convertString(src.getNameElement()));
        }
        if (src.hasDatasetId()) {
            tgt.setDatasetIdElement(MolecularSequence40_50.convertString(src.getDatasetIdElement()));
        }
        if (src.hasVariantsetId()) {
            tgt.setVariantsetIdElement(MolecularSequence40_50.convertString(src.getVariantsetIdElement()));
        }
        if (src.hasReadsetId()) {
            tgt.setReadsetIdElement(MolecularSequence40_50.convertString(src.getReadsetIdElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<MolecularSequence.RepositoryType> convertRepositoryType(Enumeration<MolecularSequence.RepositoryType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<MolecularSequence.RepositoryType> tgt = new org.hl7.fhir.r5.model.Enumeration<MolecularSequence.RepositoryType>(new MolecularSequence.RepositoryTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((MolecularSequence.RepositoryType)((Object)src.getValue())) {
            case DIRECTLINK: {
                tgt.setValue((Object)MolecularSequence.RepositoryType.DIRECTLINK);
                break;
            }
            case OPENAPI: {
                tgt.setValue((Object)MolecularSequence.RepositoryType.OPENAPI);
                break;
            }
            case LOGIN: {
                tgt.setValue((Object)MolecularSequence.RepositoryType.LOGIN);
                break;
            }
            case OAUTH: {
                tgt.setValue((Object)MolecularSequence.RepositoryType.OAUTH);
                break;
            }
            case OTHER: {
                tgt.setValue((Object)MolecularSequence.RepositoryType.OTHER);
                break;
            }
            default: {
                tgt.setValue((Object)MolecularSequence.RepositoryType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<MolecularSequence.RepositoryType> convertRepositoryType(org.hl7.fhir.r5.model.Enumeration<MolecularSequence.RepositoryType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<MolecularSequence.RepositoryType> tgt = new Enumeration<MolecularSequence.RepositoryType>(new MolecularSequence.RepositoryTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((MolecularSequence.RepositoryType)((Object)src.getValue())) {
            case DIRECTLINK: {
                tgt.setValue((Object)MolecularSequence.RepositoryType.DIRECTLINK);
                break;
            }
            case OPENAPI: {
                tgt.setValue((Object)MolecularSequence.RepositoryType.OPENAPI);
                break;
            }
            case LOGIN: {
                tgt.setValue((Object)MolecularSequence.RepositoryType.LOGIN);
                break;
            }
            case OAUTH: {
                tgt.setValue((Object)MolecularSequence.RepositoryType.OAUTH);
                break;
            }
            case OTHER: {
                tgt.setValue((Object)MolecularSequence.RepositoryType.OTHER);
                break;
            }
            default: {
                tgt.setValue((Object)MolecularSequence.RepositoryType.NULL);
            }
        }
        return tgt;
    }

    public static MolecularSequence.MolecularSequenceStructureVariantComponent convertMolecularSequenceStructureVariantComponent(MolecularSequence.MolecularSequenceStructureVariantComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MolecularSequence.MolecularSequenceStructureVariantComponent tgt = new MolecularSequence.MolecularSequenceStructureVariantComponent();
        MolecularSequence40_50.copyElement(src, tgt, new String[0]);
        if (src.hasVariantType()) {
            tgt.setVariantType(MolecularSequence40_50.convertCodeableConcept(src.getVariantType()));
        }
        if (src.hasExact()) {
            tgt.setExactElement(MolecularSequence40_50.convertBoolean(src.getExactElement()));
        }
        if (src.hasLength()) {
            tgt.setLengthElement(MolecularSequence40_50.convertInteger(src.getLengthElement()));
        }
        if (src.hasOuter()) {
            tgt.setOuter(MolecularSequence40_50.convertMolecularSequenceStructureVariantOuterComponent(src.getOuter()));
        }
        if (src.hasInner()) {
            tgt.setInner(MolecularSequence40_50.convertMolecularSequenceStructureVariantInnerComponent(src.getInner()));
        }
        return tgt;
    }

    public static MolecularSequence.MolecularSequenceStructureVariantComponent convertMolecularSequenceStructureVariantComponent(MolecularSequence.MolecularSequenceStructureVariantComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MolecularSequence.MolecularSequenceStructureVariantComponent tgt = new MolecularSequence.MolecularSequenceStructureVariantComponent();
        MolecularSequence40_50.copyElement(src, tgt, new String[0]);
        if (src.hasVariantType()) {
            tgt.setVariantType(MolecularSequence40_50.convertCodeableConcept(src.getVariantType()));
        }
        if (src.hasExact()) {
            tgt.setExactElement(MolecularSequence40_50.convertBoolean(src.getExactElement()));
        }
        if (src.hasLength()) {
            tgt.setLengthElement(MolecularSequence40_50.convertInteger(src.getLengthElement()));
        }
        if (src.hasOuter()) {
            tgt.setOuter(MolecularSequence40_50.convertMolecularSequenceStructureVariantOuterComponent(src.getOuter()));
        }
        if (src.hasInner()) {
            tgt.setInner(MolecularSequence40_50.convertMolecularSequenceStructureVariantInnerComponent(src.getInner()));
        }
        return tgt;
    }

    public static MolecularSequence.MolecularSequenceStructureVariantOuterComponent convertMolecularSequenceStructureVariantOuterComponent(MolecularSequence.MolecularSequenceStructureVariantOuterComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MolecularSequence.MolecularSequenceStructureVariantOuterComponent tgt = new MolecularSequence.MolecularSequenceStructureVariantOuterComponent();
        MolecularSequence40_50.copyElement(src, tgt, new String[0]);
        if (src.hasStart()) {
            tgt.setStartElement(MolecularSequence40_50.convertInteger(src.getStartElement()));
        }
        if (src.hasEnd()) {
            tgt.setEndElement(MolecularSequence40_50.convertInteger(src.getEndElement()));
        }
        return tgt;
    }

    public static MolecularSequence.MolecularSequenceStructureVariantOuterComponent convertMolecularSequenceStructureVariantOuterComponent(MolecularSequence.MolecularSequenceStructureVariantOuterComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MolecularSequence.MolecularSequenceStructureVariantOuterComponent tgt = new MolecularSequence.MolecularSequenceStructureVariantOuterComponent();
        MolecularSequence40_50.copyElement(src, tgt, new String[0]);
        if (src.hasStart()) {
            tgt.setStartElement(MolecularSequence40_50.convertInteger(src.getStartElement()));
        }
        if (src.hasEnd()) {
            tgt.setEndElement(MolecularSequence40_50.convertInteger(src.getEndElement()));
        }
        return tgt;
    }

    public static MolecularSequence.MolecularSequenceStructureVariantInnerComponent convertMolecularSequenceStructureVariantInnerComponent(MolecularSequence.MolecularSequenceStructureVariantInnerComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MolecularSequence.MolecularSequenceStructureVariantInnerComponent tgt = new MolecularSequence.MolecularSequenceStructureVariantInnerComponent();
        MolecularSequence40_50.copyElement(src, tgt, new String[0]);
        if (src.hasStart()) {
            tgt.setStartElement(MolecularSequence40_50.convertInteger(src.getStartElement()));
        }
        if (src.hasEnd()) {
            tgt.setEndElement(MolecularSequence40_50.convertInteger(src.getEndElement()));
        }
        return tgt;
    }

    public static MolecularSequence.MolecularSequenceStructureVariantInnerComponent convertMolecularSequenceStructureVariantInnerComponent(MolecularSequence.MolecularSequenceStructureVariantInnerComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MolecularSequence.MolecularSequenceStructureVariantInnerComponent tgt = new MolecularSequence.MolecularSequenceStructureVariantInnerComponent();
        MolecularSequence40_50.copyElement(src, tgt, new String[0]);
        if (src.hasStart()) {
            tgt.setStartElement(MolecularSequence40_50.convertInteger(src.getStartElement()));
        }
        if (src.hasEnd()) {
            tgt.setEndElement(MolecularSequence40_50.convertInteger(src.getEndElement()));
        }
        return tgt;
    }
}

