/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Medication;
import org.hl7.fhir.r5.model.Medication;

public class Medication40_50
extends VersionConvertor_40_50 {
    public static Medication convertMedication(org.hl7.fhir.r4.model.Medication src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Medication tgt = new Medication();
        Medication40_50.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(Medication40_50.convertIdentifier(identifier));
        }
        if (src.hasCode()) {
            tgt.setCode(Medication40_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Medication40_50.convertMedicationStatus(src.getStatusElement()));
        }
        if (src.hasManufacturer()) {
            tgt.setSponsor(Medication40_50.convertReference(src.getManufacturer()));
        }
        if (src.hasForm()) {
            tgt.setDoseForm(Medication40_50.convertCodeableConcept(src.getForm()));
        }
        if (src.hasAmount()) {
            tgt.setAmount(Medication40_50.convertRatio(src.getAmount()));
        }
        for (Medication.MedicationIngredientComponent medicationIngredientComponent : src.getIngredient()) {
            tgt.addIngredient(Medication40_50.convertMedicationIngredientComponent(medicationIngredientComponent));
        }
        if (src.hasBatch()) {
            tgt.setBatch(Medication40_50.convertMedicationBatchComponent(src.getBatch()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Medication convertMedication(Medication src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Medication tgt = new org.hl7.fhir.r4.model.Medication();
        Medication40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(Medication40_50.convertIdentifier(identifier));
        }
        if (src.hasCode()) {
            tgt.setCode(Medication40_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Medication40_50.convertMedicationStatus(src.getStatusElement()));
        }
        if (src.hasSponsor()) {
            tgt.setManufacturer(Medication40_50.convertReference(src.getSponsor()));
        }
        if (src.hasDoseForm()) {
            tgt.setForm(Medication40_50.convertCodeableConcept(src.getDoseForm()));
        }
        if (src.hasAmount()) {
            tgt.setAmount(Medication40_50.convertRatio(src.getAmount()));
        }
        for (Medication.MedicationIngredientComponent medicationIngredientComponent : src.getIngredient()) {
            tgt.addIngredient(Medication40_50.convertMedicationIngredientComponent(medicationIngredientComponent));
        }
        if (src.hasBatch()) {
            tgt.setBatch(Medication40_50.convertMedicationBatchComponent(src.getBatch()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Medication.MedicationStatusCodes> convertMedicationStatus(Enumeration<Medication.MedicationStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Medication.MedicationStatusCodes> tgt = new org.hl7.fhir.r5.model.Enumeration<Medication.MedicationStatusCodes>(new Medication.MedicationStatusCodesEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Medication.MedicationStatus)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)Medication.MedicationStatusCodes.ACTIVE);
                break;
            }
            case INACTIVE: {
                tgt.setValue((Object)Medication.MedicationStatusCodes.INACTIVE);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Medication.MedicationStatusCodes.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)Medication.MedicationStatusCodes.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Medication.MedicationStatus> convertMedicationStatus(org.hl7.fhir.r5.model.Enumeration<Medication.MedicationStatusCodes> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Medication.MedicationStatus> tgt = new Enumeration<Medication.MedicationStatus>(new Medication.MedicationStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Medication.MedicationStatusCodes)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)Medication.MedicationStatus.ACTIVE);
                break;
            }
            case INACTIVE: {
                tgt.setValue((Object)Medication.MedicationStatus.INACTIVE);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Medication.MedicationStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)Medication.MedicationStatus.NULL);
            }
        }
        return tgt;
    }

    public static Medication.MedicationIngredientComponent convertMedicationIngredientComponent(Medication.MedicationIngredientComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Medication.MedicationIngredientComponent tgt = new Medication.MedicationIngredientComponent();
        Medication40_50.copyElement(src, tgt, new String[0]);
        if (src.hasItemCodeableConcept()) {
            tgt.getItem().setConcept(Medication40_50.convertCodeableConcept(src.getItemCodeableConcept()));
        }
        if (src.hasItemReference()) {
            tgt.getItem().setReference(Medication40_50.convertReference(src.getItemReference()));
        }
        if (src.hasIsActive()) {
            tgt.setIsActiveElement(Medication40_50.convertBoolean(src.getIsActiveElement()));
        }
        if (src.hasStrength()) {
            tgt.setStrength(Medication40_50.convertRatio(src.getStrength()));
        }
        return tgt;
    }

    public static Medication.MedicationIngredientComponent convertMedicationIngredientComponent(Medication.MedicationIngredientComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Medication.MedicationIngredientComponent tgt = new Medication.MedicationIngredientComponent();
        Medication40_50.copyElement(src, tgt, new String[0]);
        if (src.getItem().hasConcept()) {
            tgt.setItem(Medication40_50.convertType(src.getItem().getConcept()));
        }
        if (src.getItem().hasReference()) {
            tgt.setItem(Medication40_50.convertType(src.getItem().getReference()));
        }
        if (src.hasIsActive()) {
            tgt.setIsActiveElement(Medication40_50.convertBoolean(src.getIsActiveElement()));
        }
        if (src.hasStrengthRatio()) {
            tgt.setStrength(Medication40_50.convertRatio(src.getStrengthRatio()));
        }
        return tgt;
    }

    public static Medication.MedicationBatchComponent convertMedicationBatchComponent(Medication.MedicationBatchComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Medication.MedicationBatchComponent tgt = new Medication.MedicationBatchComponent();
        Medication40_50.copyElement(src, tgt, new String[0]);
        if (src.hasLotNumber()) {
            tgt.setLotNumberElement(Medication40_50.convertString(src.getLotNumberElement()));
        }
        if (src.hasExpirationDate()) {
            tgt.setExpirationDateElement(Medication40_50.convertDateTime(src.getExpirationDateElement()));
        }
        return tgt;
    }

    public static Medication.MedicationBatchComponent convertMedicationBatchComponent(Medication.MedicationBatchComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Medication.MedicationBatchComponent tgt = new Medication.MedicationBatchComponent();
        Medication40_50.copyElement(src, tgt, new String[0]);
        if (src.hasLotNumber()) {
            tgt.setLotNumberElement(Medication40_50.convertString(src.getLotNumberElement()));
        }
        if (src.hasExpirationDate()) {
            tgt.setExpirationDateElement(Medication40_50.convertDateTime(src.getExpirationDateElement()));
        }
        return tgt;
    }
}

