/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.convertors.conv40_50.Enumerations40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Measure;
import org.hl7.fhir.r4.model.UsageContext;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.Measure;
import org.hl7.fhir.r5.model.RelatedArtifact;

public class Measure40_50
extends VersionConvertor_40_50 {
    public static Measure convertMeasure(org.hl7.fhir.r4.model.Measure src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Measure tgt = new Measure();
        Measure40_50.copyDomainResource(src, tgt);
        if (src.hasUrl()) {
            tgt.setUrlElement(Measure40_50.convertUri(src.getUrlElement()));
        }
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(Measure40_50.convertIdentifier(identifier));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(Measure40_50.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(Measure40_50.convertString(src.getNameElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(Measure40_50.convertString(src.getTitleElement()));
        }
        if (src.hasSubtitle()) {
            tgt.setSubtitleElement(Measure40_50.convertString(src.getSubtitleElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((org.hl7.fhir.r5.model.Enumeration)Enumerations40_50.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(Measure40_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(Measure40_50.convertType(src.getSubject()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(Measure40_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(Measure40_50.convertString(src.getPublisherElement()));
        }
        for (org.hl7.fhir.r4.model.ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(Measure40_50.convertContactDetail(contactDetail));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(Measure40_50.convertMarkdown(src.getDescriptionElement()));
        }
        for (UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(Measure40_50.convertUsageContext(usageContext));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(Measure40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPurpose()) {
            tgt.setPurposeElement(Measure40_50.convertMarkdown(src.getPurposeElement()));
        }
        if (src.hasUsage()) {
            tgt.setUsageElement(Measure40_50.convertString(src.getUsageElement()));
        }
        if (src.hasCopyright()) {
            tgt.setCopyrightElement(Measure40_50.convertMarkdown(src.getCopyrightElement()));
        }
        if (src.hasApprovalDate()) {
            tgt.setApprovalDateElement(Measure40_50.convertDate(src.getApprovalDateElement()));
        }
        if (src.hasLastReviewDate()) {
            tgt.setLastReviewDateElement(Measure40_50.convertDate(src.getLastReviewDateElement()));
        }
        if (src.hasEffectivePeriod()) {
            tgt.setEffectivePeriod(Measure40_50.convertPeriod(src.getEffectivePeriod()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getTopic()) {
            tgt.addTopic(Measure40_50.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.ContactDetail contactDetail : src.getAuthor()) {
            tgt.addAuthor(Measure40_50.convertContactDetail(contactDetail));
        }
        for (org.hl7.fhir.r4.model.ContactDetail contactDetail : src.getEditor()) {
            tgt.addEditor(Measure40_50.convertContactDetail(contactDetail));
        }
        for (org.hl7.fhir.r4.model.ContactDetail contactDetail : src.getReviewer()) {
            tgt.addReviewer(Measure40_50.convertContactDetail(contactDetail));
        }
        for (org.hl7.fhir.r4.model.ContactDetail contactDetail : src.getEndorser()) {
            tgt.addEndorser(Measure40_50.convertContactDetail(contactDetail));
        }
        for (org.hl7.fhir.r4.model.RelatedArtifact relatedArtifact : src.getRelatedArtifact()) {
            tgt.addRelatedArtifact(Measure40_50.convertRelatedArtifact(relatedArtifact));
        }
        for (CanonicalType canonicalType : src.getLibrary()) {
            tgt.getLibrary().add(Measure40_50.convertCanonical(canonicalType));
        }
        if (src.hasDisclaimer()) {
            tgt.setDisclaimerElement(Measure40_50.convertMarkdown(src.getDisclaimerElement()));
        }
        if (src.hasScoring()) {
            tgt.setScoring(Measure40_50.convertCodeableConcept(src.getScoring()));
        }
        if (src.hasCompositeScoring()) {
            tgt.setCompositeScoring(Measure40_50.convertCodeableConcept(src.getCompositeScoring()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getType()) {
            tgt.addType(Measure40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasRiskAdjustment()) {
            tgt.setRiskAdjustmentElement(Measure40_50.convertString(src.getRiskAdjustmentElement()));
        }
        if (src.hasRateAggregation()) {
            tgt.setRateAggregationElement(Measure40_50.convertString(src.getRateAggregationElement()));
        }
        if (src.hasRationale()) {
            tgt.setRationaleElement(Measure40_50.convertMarkdown(src.getRationaleElement()));
        }
        if (src.hasClinicalRecommendationStatement()) {
            tgt.setClinicalRecommendationStatementElement(Measure40_50.convertMarkdown(src.getClinicalRecommendationStatementElement()));
        }
        if (src.hasImprovementNotation()) {
            tgt.setImprovementNotation(Measure40_50.convertCodeableConcept(src.getImprovementNotation()));
        }
        for (org.hl7.fhir.r4.model.MarkdownType markdownType : src.getDefinition()) {
            tgt.getDefinition().add(Measure40_50.convertMarkdown(markdownType));
        }
        if (src.hasGuidance()) {
            tgt.setGuidanceElement(Measure40_50.convertMarkdown(src.getGuidanceElement()));
        }
        for (Measure.MeasureGroupComponent measureGroupComponent : src.getGroup()) {
            tgt.addGroup(Measure40_50.convertMeasureGroupComponent(measureGroupComponent));
        }
        for (Measure.MeasureSupplementalDataComponent measureSupplementalDataComponent : src.getSupplementalData()) {
            tgt.addSupplementalData(Measure40_50.convertMeasureSupplementalDataComponent(measureSupplementalDataComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Measure convertMeasure(Measure src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Measure tgt = new org.hl7.fhir.r4.model.Measure();
        Measure40_50.copyDomainResource(src, tgt);
        if (src.hasUrl()) {
            tgt.setUrlElement(Measure40_50.convertUri(src.getUrlElement()));
        }
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(Measure40_50.convertIdentifier(identifier));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(Measure40_50.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(Measure40_50.convertString(src.getNameElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(Measure40_50.convertString(src.getTitleElement()));
        }
        if (src.hasSubtitle()) {
            tgt.setSubtitleElement(Measure40_50.convertString(src.getSubtitleElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((Enumeration)Enumerations40_50.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(Measure40_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(Measure40_50.convertType(src.getSubject()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(Measure40_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(Measure40_50.convertString(src.getPublisherElement()));
        }
        for (ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(Measure40_50.convertContactDetail(contactDetail));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(Measure40_50.convertMarkdown(src.getDescriptionElement()));
        }
        for (org.hl7.fhir.r5.model.UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(Measure40_50.convertUsageContext(usageContext));
        }
        for (CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(Measure40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPurpose()) {
            tgt.setPurposeElement(Measure40_50.convertMarkdown(src.getPurposeElement()));
        }
        if (src.hasUsage()) {
            tgt.setUsageElement(Measure40_50.convertString(src.getUsageElement()));
        }
        if (src.hasCopyright()) {
            tgt.setCopyrightElement(Measure40_50.convertMarkdown(src.getCopyrightElement()));
        }
        if (src.hasApprovalDate()) {
            tgt.setApprovalDateElement(Measure40_50.convertDate(src.getApprovalDateElement()));
        }
        if (src.hasLastReviewDate()) {
            tgt.setLastReviewDateElement(Measure40_50.convertDate(src.getLastReviewDateElement()));
        }
        if (src.hasEffectivePeriod()) {
            tgt.setEffectivePeriod(Measure40_50.convertPeriod(src.getEffectivePeriod()));
        }
        for (CodeableConcept codeableConcept : src.getTopic()) {
            tgt.addTopic(Measure40_50.convertCodeableConcept(codeableConcept));
        }
        for (ContactDetail contactDetail : src.getAuthor()) {
            tgt.addAuthor(Measure40_50.convertContactDetail(contactDetail));
        }
        for (ContactDetail contactDetail : src.getEditor()) {
            tgt.addEditor(Measure40_50.convertContactDetail(contactDetail));
        }
        for (ContactDetail contactDetail : src.getReviewer()) {
            tgt.addReviewer(Measure40_50.convertContactDetail(contactDetail));
        }
        for (ContactDetail contactDetail : src.getEndorser()) {
            tgt.addEndorser(Measure40_50.convertContactDetail(contactDetail));
        }
        for (RelatedArtifact relatedArtifact : src.getRelatedArtifact()) {
            tgt.addRelatedArtifact(Measure40_50.convertRelatedArtifact(relatedArtifact));
        }
        for (org.hl7.fhir.r5.model.CanonicalType canonicalType : src.getLibrary()) {
            tgt.getLibrary().add(Measure40_50.convertCanonical(canonicalType));
        }
        if (src.hasDisclaimer()) {
            tgt.setDisclaimerElement(Measure40_50.convertMarkdown(src.getDisclaimerElement()));
        }
        if (src.hasScoring()) {
            tgt.setScoring(Measure40_50.convertCodeableConcept(src.getScoring()));
        }
        if (src.hasCompositeScoring()) {
            tgt.setCompositeScoring(Measure40_50.convertCodeableConcept(src.getCompositeScoring()));
        }
        for (CodeableConcept codeableConcept : src.getType()) {
            tgt.addType(Measure40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasRiskAdjustment()) {
            tgt.setRiskAdjustmentElement(Measure40_50.convertString(src.getRiskAdjustmentElement()));
        }
        if (src.hasRateAggregation()) {
            tgt.setRateAggregationElement(Measure40_50.convertString(src.getRateAggregationElement()));
        }
        if (src.hasRationale()) {
            tgt.setRationaleElement(Measure40_50.convertMarkdown(src.getRationaleElement()));
        }
        if (src.hasClinicalRecommendationStatement()) {
            tgt.setClinicalRecommendationStatementElement(Measure40_50.convertMarkdown(src.getClinicalRecommendationStatementElement()));
        }
        if (src.hasImprovementNotation()) {
            tgt.setImprovementNotation(Measure40_50.convertCodeableConcept(src.getImprovementNotation()));
        }
        for (MarkdownType markdownType : src.getDefinition()) {
            tgt.getDefinition().add(Measure40_50.convertMarkdown(markdownType));
        }
        if (src.hasGuidance()) {
            tgt.setGuidanceElement(Measure40_50.convertMarkdown(src.getGuidanceElement()));
        }
        for (Measure.MeasureGroupComponent measureGroupComponent : src.getGroup()) {
            tgt.addGroup(Measure40_50.convertMeasureGroupComponent(measureGroupComponent));
        }
        for (Measure.MeasureSupplementalDataComponent measureSupplementalDataComponent : src.getSupplementalData()) {
            tgt.addSupplementalData(Measure40_50.convertMeasureSupplementalDataComponent(measureSupplementalDataComponent));
        }
        return tgt;
    }

    public static Measure.MeasureGroupComponent convertMeasureGroupComponent(Measure.MeasureGroupComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Measure.MeasureGroupComponent tgt = new Measure.MeasureGroupComponent();
        Measure40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCode(Measure40_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(Measure40_50.convertString(src.getDescriptionElement()));
        }
        for (Measure.MeasureGroupPopulationComponent measureGroupPopulationComponent : src.getPopulation()) {
            tgt.addPopulation(Measure40_50.convertMeasureGroupPopulationComponent(measureGroupPopulationComponent));
        }
        for (Measure.MeasureGroupStratifierComponent measureGroupStratifierComponent : src.getStratifier()) {
            tgt.addStratifier(Measure40_50.convertMeasureGroupStratifierComponent(measureGroupStratifierComponent));
        }
        return tgt;
    }

    public static Measure.MeasureGroupComponent convertMeasureGroupComponent(Measure.MeasureGroupComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Measure.MeasureGroupComponent tgt = new Measure.MeasureGroupComponent();
        Measure40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCode(Measure40_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(Measure40_50.convertString(src.getDescriptionElement()));
        }
        for (Measure.MeasureGroupPopulationComponent measureGroupPopulationComponent : src.getPopulation()) {
            tgt.addPopulation(Measure40_50.convertMeasureGroupPopulationComponent(measureGroupPopulationComponent));
        }
        for (Measure.MeasureGroupStratifierComponent measureGroupStratifierComponent : src.getStratifier()) {
            tgt.addStratifier(Measure40_50.convertMeasureGroupStratifierComponent(measureGroupStratifierComponent));
        }
        return tgt;
    }

    public static Measure.MeasureGroupPopulationComponent convertMeasureGroupPopulationComponent(Measure.MeasureGroupPopulationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Measure.MeasureGroupPopulationComponent tgt = new Measure.MeasureGroupPopulationComponent();
        Measure40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCode(Measure40_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(Measure40_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasCriteria()) {
            tgt.setCriteria(Measure40_50.convertExpression(src.getCriteria()));
        }
        return tgt;
    }

    public static Measure.MeasureGroupPopulationComponent convertMeasureGroupPopulationComponent(Measure.MeasureGroupPopulationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Measure.MeasureGroupPopulationComponent tgt = new Measure.MeasureGroupPopulationComponent();
        Measure40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCode(Measure40_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(Measure40_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasCriteria()) {
            tgt.setCriteria(Measure40_50.convertExpression(src.getCriteria()));
        }
        return tgt;
    }

    public static Measure.MeasureGroupStratifierComponent convertMeasureGroupStratifierComponent(Measure.MeasureGroupStratifierComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Measure.MeasureGroupStratifierComponent tgt = new Measure.MeasureGroupStratifierComponent();
        Measure40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCode(Measure40_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(Measure40_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasCriteria()) {
            tgt.setCriteria(Measure40_50.convertExpression(src.getCriteria()));
        }
        for (Measure.MeasureGroupStratifierComponentComponent t : src.getComponent()) {
            tgt.addComponent(Measure40_50.convertMeasureGroupStratifierComponentComponent(t));
        }
        return tgt;
    }

    public static Measure.MeasureGroupStratifierComponent convertMeasureGroupStratifierComponent(Measure.MeasureGroupStratifierComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Measure.MeasureGroupStratifierComponent tgt = new Measure.MeasureGroupStratifierComponent();
        Measure40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCode(Measure40_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(Measure40_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasCriteria()) {
            tgt.setCriteria(Measure40_50.convertExpression(src.getCriteria()));
        }
        for (Measure.MeasureGroupStratifierComponentComponent t : src.getComponent()) {
            tgt.addComponent(Measure40_50.convertMeasureGroupStratifierComponentComponent(t));
        }
        return tgt;
    }

    public static Measure.MeasureGroupStratifierComponentComponent convertMeasureGroupStratifierComponentComponent(Measure.MeasureGroupStratifierComponentComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Measure.MeasureGroupStratifierComponentComponent tgt = new Measure.MeasureGroupStratifierComponentComponent();
        Measure40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCode(Measure40_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(Measure40_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasCriteria()) {
            tgt.setCriteria(Measure40_50.convertExpression(src.getCriteria()));
        }
        return tgt;
    }

    public static Measure.MeasureGroupStratifierComponentComponent convertMeasureGroupStratifierComponentComponent(Measure.MeasureGroupStratifierComponentComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Measure.MeasureGroupStratifierComponentComponent tgt = new Measure.MeasureGroupStratifierComponentComponent();
        Measure40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCode(Measure40_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(Measure40_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasCriteria()) {
            tgt.setCriteria(Measure40_50.convertExpression(src.getCriteria()));
        }
        return tgt;
    }

    public static Measure.MeasureSupplementalDataComponent convertMeasureSupplementalDataComponent(Measure.MeasureSupplementalDataComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Measure.MeasureSupplementalDataComponent tgt = new Measure.MeasureSupplementalDataComponent();
        Measure40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCode(Measure40_50.convertCodeableConcept(src.getCode()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept t : src.getUsage()) {
            tgt.addUsage(Measure40_50.convertCodeableConcept(t));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(Measure40_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasCriteria()) {
            tgt.setCriteria(Measure40_50.convertExpression(src.getCriteria()));
        }
        return tgt;
    }

    public static Measure.MeasureSupplementalDataComponent convertMeasureSupplementalDataComponent(Measure.MeasureSupplementalDataComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Measure.MeasureSupplementalDataComponent tgt = new Measure.MeasureSupplementalDataComponent();
        Measure40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCode(Measure40_50.convertCodeableConcept(src.getCode()));
        }
        for (CodeableConcept t : src.getUsage()) {
            tgt.addUsage(Measure40_50.convertCodeableConcept(t));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(Measure40_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasCriteria()) {
            tgt.setCriteria(Measure40_50.convertExpression(src.getCriteria()));
        }
        return tgt;
    }
}

