/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.convertors.conv40_50.Enumerations40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Library;
import org.hl7.fhir.r4.model.ParameterDefinition;
import org.hl7.fhir.r4.model.UsageContext;
import org.hl7.fhir.r5.model.Attachment;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.DataRequirement;
import org.hl7.fhir.r5.model.RelatedArtifact;

public class Library40_50
extends VersionConvertor_40_50 {
    public static org.hl7.fhir.r5.model.Library convertLibrary(Library src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.Library tgt = new org.hl7.fhir.r5.model.Library();
        Library40_50.copyDomainResource(src, tgt);
        if (src.hasUrl()) {
            tgt.setUrlElement(Library40_50.convertUri(src.getUrlElement()));
        }
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(Library40_50.convertIdentifier(identifier));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(Library40_50.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(Library40_50.convertString(src.getNameElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(Library40_50.convertString(src.getTitleElement()));
        }
        if (src.hasSubtitle()) {
            tgt.setSubtitleElement(Library40_50.convertString(src.getSubtitleElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((org.hl7.fhir.r5.model.Enumeration)Enumerations40_50.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(Library40_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasType()) {
            tgt.setType(Library40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(Library40_50.convertType(src.getSubject()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(Library40_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(Library40_50.convertString(src.getPublisherElement()));
        }
        for (org.hl7.fhir.r4.model.ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(Library40_50.convertContactDetail(contactDetail));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(Library40_50.convertMarkdown(src.getDescriptionElement()));
        }
        for (UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(Library40_50.convertUsageContext(usageContext));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(Library40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPurpose()) {
            tgt.setPurposeElement(Library40_50.convertMarkdown(src.getPurposeElement()));
        }
        if (src.hasUsage()) {
            tgt.setUsageElement(Library40_50.convertString(src.getUsageElement()));
        }
        if (src.hasCopyright()) {
            tgt.setCopyrightElement(Library40_50.convertMarkdown(src.getCopyrightElement()));
        }
        if (src.hasApprovalDate()) {
            tgt.setApprovalDateElement(Library40_50.convertDate(src.getApprovalDateElement()));
        }
        if (src.hasLastReviewDate()) {
            tgt.setLastReviewDateElement(Library40_50.convertDate(src.getLastReviewDateElement()));
        }
        if (src.hasEffectivePeriod()) {
            tgt.setEffectivePeriod(Library40_50.convertPeriod(src.getEffectivePeriod()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getTopic()) {
            tgt.addTopic(Library40_50.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.ContactDetail contactDetail : src.getAuthor()) {
            tgt.addAuthor(Library40_50.convertContactDetail(contactDetail));
        }
        for (org.hl7.fhir.r4.model.ContactDetail contactDetail : src.getEditor()) {
            tgt.addEditor(Library40_50.convertContactDetail(contactDetail));
        }
        for (org.hl7.fhir.r4.model.ContactDetail contactDetail : src.getReviewer()) {
            tgt.addReviewer(Library40_50.convertContactDetail(contactDetail));
        }
        for (org.hl7.fhir.r4.model.ContactDetail contactDetail : src.getEndorser()) {
            tgt.addEndorser(Library40_50.convertContactDetail(contactDetail));
        }
        for (org.hl7.fhir.r4.model.RelatedArtifact relatedArtifact : src.getRelatedArtifact()) {
            tgt.addRelatedArtifact(Library40_50.convertRelatedArtifact(relatedArtifact));
        }
        for (ParameterDefinition parameterDefinition : src.getParameter()) {
            tgt.addParameter(Library40_50.convertParameterDefinition(parameterDefinition));
        }
        for (org.hl7.fhir.r4.model.DataRequirement dataRequirement : src.getDataRequirement()) {
            tgt.addDataRequirement(Library40_50.convertDataRequirement(dataRequirement));
        }
        for (org.hl7.fhir.r4.model.Attachment attachment : src.getContent()) {
            tgt.addContent(Library40_50.convertAttachment(attachment));
        }
        return tgt;
    }

    public static Library convertLibrary(org.hl7.fhir.r5.model.Library src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Library tgt = new Library();
        Library40_50.copyDomainResource(src, tgt);
        if (src.hasUrl()) {
            tgt.setUrlElement(Library40_50.convertUri(src.getUrlElement()));
        }
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(Library40_50.convertIdentifier(identifier));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(Library40_50.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(Library40_50.convertString(src.getNameElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(Library40_50.convertString(src.getTitleElement()));
        }
        if (src.hasSubtitle()) {
            tgt.setSubtitleElement(Library40_50.convertString(src.getSubtitleElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((Enumeration)Enumerations40_50.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(Library40_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasType()) {
            tgt.setType(Library40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(Library40_50.convertType(src.getSubject()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(Library40_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(Library40_50.convertString(src.getPublisherElement()));
        }
        for (ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(Library40_50.convertContactDetail(contactDetail));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(Library40_50.convertMarkdown(src.getDescriptionElement()));
        }
        for (org.hl7.fhir.r5.model.UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(Library40_50.convertUsageContext(usageContext));
        }
        for (CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(Library40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPurpose()) {
            tgt.setPurposeElement(Library40_50.convertMarkdown(src.getPurposeElement()));
        }
        if (src.hasUsage()) {
            tgt.setUsageElement(Library40_50.convertString(src.getUsageElement()));
        }
        if (src.hasCopyright()) {
            tgt.setCopyrightElement(Library40_50.convertMarkdown(src.getCopyrightElement()));
        }
        if (src.hasApprovalDate()) {
            tgt.setApprovalDateElement(Library40_50.convertDate(src.getApprovalDateElement()));
        }
        if (src.hasLastReviewDate()) {
            tgt.setLastReviewDateElement(Library40_50.convertDate(src.getLastReviewDateElement()));
        }
        if (src.hasEffectivePeriod()) {
            tgt.setEffectivePeriod(Library40_50.convertPeriod(src.getEffectivePeriod()));
        }
        for (CodeableConcept codeableConcept : src.getTopic()) {
            tgt.addTopic(Library40_50.convertCodeableConcept(codeableConcept));
        }
        for (ContactDetail contactDetail : src.getAuthor()) {
            tgt.addAuthor(Library40_50.convertContactDetail(contactDetail));
        }
        for (ContactDetail contactDetail : src.getEditor()) {
            tgt.addEditor(Library40_50.convertContactDetail(contactDetail));
        }
        for (ContactDetail contactDetail : src.getReviewer()) {
            tgt.addReviewer(Library40_50.convertContactDetail(contactDetail));
        }
        for (ContactDetail contactDetail : src.getEndorser()) {
            tgt.addEndorser(Library40_50.convertContactDetail(contactDetail));
        }
        for (RelatedArtifact relatedArtifact : src.getRelatedArtifact()) {
            tgt.addRelatedArtifact(Library40_50.convertRelatedArtifact(relatedArtifact));
        }
        for (org.hl7.fhir.r5.model.ParameterDefinition parameterDefinition : src.getParameter()) {
            tgt.addParameter(Library40_50.convertParameterDefinition(parameterDefinition));
        }
        for (DataRequirement dataRequirement : src.getDataRequirement()) {
            tgt.addDataRequirement(Library40_50.convertDataRequirement(dataRequirement));
        }
        for (Attachment attachment : src.getContent()) {
            tgt.addContent(Library40_50.convertAttachment(attachment));
        }
        return tgt;
    }
}

