/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.ImmunizationEvaluation;
import org.hl7.fhir.r5.model.ImmunizationEvaluation;

public class ImmunizationEvaluation40_50
extends VersionConvertor_40_50 {
    public static org.hl7.fhir.r5.model.ImmunizationEvaluation convertImmunizationEvaluation(ImmunizationEvaluation src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.ImmunizationEvaluation tgt = new org.hl7.fhir.r5.model.ImmunizationEvaluation();
        ImmunizationEvaluation40_50.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(ImmunizationEvaluation40_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(ImmunizationEvaluation40_50.convertImmunizationEvaluationStatus(src.getStatusElement()));
        }
        if (src.hasPatient()) {
            tgt.setPatient(ImmunizationEvaluation40_50.convertReference(src.getPatient()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(ImmunizationEvaluation40_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasAuthority()) {
            tgt.setAuthority(ImmunizationEvaluation40_50.convertReference(src.getAuthority()));
        }
        if (src.hasTargetDisease()) {
            tgt.setTargetDisease(ImmunizationEvaluation40_50.convertCodeableConcept(src.getTargetDisease()));
        }
        if (src.hasImmunizationEvent()) {
            tgt.setImmunizationEvent(ImmunizationEvaluation40_50.convertReference(src.getImmunizationEvent()));
        }
        if (src.hasDoseStatus()) {
            tgt.setDoseStatus(ImmunizationEvaluation40_50.convertCodeableConcept(src.getDoseStatus()));
        }
        for (CodeableConcept codeableConcept : src.getDoseStatusReason()) {
            tgt.addDoseStatusReason(ImmunizationEvaluation40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(ImmunizationEvaluation40_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasSeries()) {
            tgt.setSeriesElement(ImmunizationEvaluation40_50.convertString(src.getSeriesElement()));
        }
        if (src.hasDoseNumber()) {
            tgt.setDoseNumber(src.getDoseNumber().primitiveValue());
        }
        if (src.hasSeriesDoses()) {
            tgt.setSeriesDoses(src.getSeriesDoses().primitiveValue());
        }
        return tgt;
    }

    public static ImmunizationEvaluation convertImmunizationEvaluation(org.hl7.fhir.r5.model.ImmunizationEvaluation src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ImmunizationEvaluation tgt = new ImmunizationEvaluation();
        ImmunizationEvaluation40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(ImmunizationEvaluation40_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(ImmunizationEvaluation40_50.convertImmunizationEvaluationStatus(src.getStatusElement()));
        }
        if (src.hasPatient()) {
            tgt.setPatient(ImmunizationEvaluation40_50.convertReference(src.getPatient()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(ImmunizationEvaluation40_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasAuthority()) {
            tgt.setAuthority(ImmunizationEvaluation40_50.convertReference(src.getAuthority()));
        }
        if (src.hasTargetDisease()) {
            tgt.setTargetDisease(ImmunizationEvaluation40_50.convertCodeableConcept(src.getTargetDisease()));
        }
        if (src.hasImmunizationEvent()) {
            tgt.setImmunizationEvent(ImmunizationEvaluation40_50.convertReference(src.getImmunizationEvent()));
        }
        if (src.hasDoseStatus()) {
            tgt.setDoseStatus(ImmunizationEvaluation40_50.convertCodeableConcept(src.getDoseStatus()));
        }
        for (org.hl7.fhir.r5.model.CodeableConcept codeableConcept : src.getDoseStatusReason()) {
            tgt.addDoseStatusReason(ImmunizationEvaluation40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(ImmunizationEvaluation40_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasSeries()) {
            tgt.setSeriesElement(ImmunizationEvaluation40_50.convertString(src.getSeriesElement()));
        }
        if (src.hasDoseNumber()) {
            tgt.setDoseNumber(ImmunizationEvaluation40_50.convertType(src.getDoseNumberElement()));
        }
        if (src.hasSeriesDoses()) {
            tgt.setSeriesDoses(ImmunizationEvaluation40_50.convertType(src.getSeriesDosesElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<ImmunizationEvaluation.ImmunizationEvaluationStatusCodes> convertImmunizationEvaluationStatus(Enumeration<ImmunizationEvaluation.ImmunizationEvaluationStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<ImmunizationEvaluation.ImmunizationEvaluationStatusCodes> tgt = new org.hl7.fhir.r5.model.Enumeration<ImmunizationEvaluation.ImmunizationEvaluationStatusCodes>(new ImmunizationEvaluation.ImmunizationEvaluationStatusCodesEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((ImmunizationEvaluation.ImmunizationEvaluationStatus)((Object)src.getValue())) {
            case COMPLETED: {
                tgt.setValue((Object)ImmunizationEvaluation.ImmunizationEvaluationStatusCodes.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)ImmunizationEvaluation.ImmunizationEvaluationStatusCodes.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)ImmunizationEvaluation.ImmunizationEvaluationStatusCodes.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<ImmunizationEvaluation.ImmunizationEvaluationStatus> convertImmunizationEvaluationStatus(org.hl7.fhir.r5.model.Enumeration<ImmunizationEvaluation.ImmunizationEvaluationStatusCodes> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ImmunizationEvaluation.ImmunizationEvaluationStatus> tgt = new Enumeration<ImmunizationEvaluation.ImmunizationEvaluationStatus>(new ImmunizationEvaluation.ImmunizationEvaluationStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((ImmunizationEvaluation.ImmunizationEvaluationStatusCodes)((Object)src.getValue())) {
            case COMPLETED: {
                tgt.setValue((Object)ImmunizationEvaluation.ImmunizationEvaluationStatus.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)ImmunizationEvaluation.ImmunizationEvaluationStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)ImmunizationEvaluation.ImmunizationEvaluationStatus.NULL);
            }
        }
        return tgt;
    }
}

