/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.FamilyMemberHistory;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.FamilyMemberHistory;

public class FamilyMemberHistory40_50
extends VersionConvertor_40_50 {
    public static org.hl7.fhir.r5.model.FamilyMemberHistory convertFamilyMemberHistory(FamilyMemberHistory src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.FamilyMemberHistory tgt = new org.hl7.fhir.r5.model.FamilyMemberHistory();
        FamilyMemberHistory40_50.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(FamilyMemberHistory40_50.convertIdentifier(identifier));
        }
        for (CanonicalType canonicalType : src.getInstantiatesCanonical()) {
            tgt.getInstantiatesCanonical().add(FamilyMemberHistory40_50.convertCanonical(canonicalType));
        }
        for (UriType uriType : src.getInstantiatesUri()) {
            tgt.getInstantiatesUri().add(FamilyMemberHistory40_50.convertUri(uriType));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(FamilyMemberHistory40_50.convertFamilyHistoryStatus(src.getStatusElement()));
        }
        if (src.hasDataAbsentReason()) {
            tgt.setDataAbsentReason(FamilyMemberHistory40_50.convertCodeableConcept(src.getDataAbsentReason()));
        }
        if (src.hasPatient()) {
            tgt.setPatient(FamilyMemberHistory40_50.convertReference(src.getPatient()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(FamilyMemberHistory40_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(FamilyMemberHistory40_50.convertString(src.getNameElement()));
        }
        if (src.hasRelationship()) {
            tgt.setRelationship(FamilyMemberHistory40_50.convertCodeableConcept(src.getRelationship()));
        }
        if (src.hasSex()) {
            tgt.setSex(FamilyMemberHistory40_50.convertCodeableConcept(src.getSex()));
        }
        if (src.hasBorn()) {
            tgt.setBorn(FamilyMemberHistory40_50.convertType(src.getBorn()));
        }
        if (src.hasAge()) {
            tgt.setAge(FamilyMemberHistory40_50.convertType(src.getAge()));
        }
        if (src.hasEstimatedAge()) {
            tgt.setEstimatedAgeElement(FamilyMemberHistory40_50.convertBoolean(src.getEstimatedAgeElement()));
        }
        if (src.hasDeceased()) {
            tgt.setDeceased(FamilyMemberHistory40_50.convertType(src.getDeceased()));
        }
        for (CodeableConcept codeableConcept : src.getReasonCode()) {
            tgt.addReason(FamilyMemberHistory40_50.convertCodeableConceptToCodeableReference(codeableConcept));
        }
        for (Reference reference : src.getReasonReference()) {
            tgt.addReason(FamilyMemberHistory40_50.convertReferenceToCodeableReference(reference));
        }
        for (org.hl7.fhir.r4.model.Annotation annotation : src.getNote()) {
            tgt.addNote(FamilyMemberHistory40_50.convertAnnotation(annotation));
        }
        for (FamilyMemberHistory.FamilyMemberHistoryConditionComponent familyMemberHistoryConditionComponent : src.getCondition()) {
            tgt.addCondition(FamilyMemberHistory40_50.convertFamilyMemberHistoryConditionComponent(familyMemberHistoryConditionComponent));
        }
        return tgt;
    }

    public static FamilyMemberHistory convertFamilyMemberHistory(org.hl7.fhir.r5.model.FamilyMemberHistory src) throws FHIRException {
        if (src == null) {
            return null;
        }
        FamilyMemberHistory tgt = new FamilyMemberHistory();
        FamilyMemberHistory40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(FamilyMemberHistory40_50.convertIdentifier(identifier));
        }
        for (org.hl7.fhir.r5.model.CanonicalType canonicalType : src.getInstantiatesCanonical()) {
            tgt.getInstantiatesCanonical().add(FamilyMemberHistory40_50.convertCanonical(canonicalType));
        }
        for (org.hl7.fhir.r5.model.UriType uriType : src.getInstantiatesUri()) {
            tgt.getInstantiatesUri().add(FamilyMemberHistory40_50.convertUri(uriType));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(FamilyMemberHistory40_50.convertFamilyHistoryStatus(src.getStatusElement()));
        }
        if (src.hasDataAbsentReason()) {
            tgt.setDataAbsentReason(FamilyMemberHistory40_50.convertCodeableConcept(src.getDataAbsentReason()));
        }
        if (src.hasPatient()) {
            tgt.setPatient(FamilyMemberHistory40_50.convertReference(src.getPatient()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(FamilyMemberHistory40_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(FamilyMemberHistory40_50.convertString(src.getNameElement()));
        }
        if (src.hasRelationship()) {
            tgt.setRelationship(FamilyMemberHistory40_50.convertCodeableConcept(src.getRelationship()));
        }
        if (src.hasSex()) {
            tgt.setSex(FamilyMemberHistory40_50.convertCodeableConcept(src.getSex()));
        }
        if (src.hasBorn()) {
            tgt.setBorn(FamilyMemberHistory40_50.convertType(src.getBorn()));
        }
        if (src.hasAge()) {
            tgt.setAge(FamilyMemberHistory40_50.convertType(src.getAge()));
        }
        if (src.hasEstimatedAge()) {
            tgt.setEstimatedAgeElement(FamilyMemberHistory40_50.convertBoolean(src.getEstimatedAgeElement()));
        }
        if (src.hasDeceased()) {
            tgt.setDeceased(FamilyMemberHistory40_50.convertType(src.getDeceased()));
        }
        for (CodeableReference codeableReference : src.getReason()) {
            if (!codeableReference.hasConcept()) continue;
            tgt.addReasonCode(FamilyMemberHistory40_50.convertCodeableConcept(codeableReference.getConcept()));
        }
        for (CodeableReference codeableReference : src.getReason()) {
            if (!codeableReference.hasReference()) continue;
            tgt.addReasonReference(FamilyMemberHistory40_50.convertReference(codeableReference.getReference()));
        }
        for (Annotation annotation : src.getNote()) {
            tgt.addNote(FamilyMemberHistory40_50.convertAnnotation(annotation));
        }
        for (FamilyMemberHistory.FamilyMemberHistoryConditionComponent familyMemberHistoryConditionComponent : src.getCondition()) {
            tgt.addCondition(FamilyMemberHistory40_50.convertFamilyMemberHistoryConditionComponent(familyMemberHistoryConditionComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<FamilyMemberHistory.FamilyHistoryStatus> convertFamilyHistoryStatus(Enumeration<FamilyMemberHistory.FamilyHistoryStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<FamilyMemberHistory.FamilyHistoryStatus> tgt = new org.hl7.fhir.r5.model.Enumeration<FamilyMemberHistory.FamilyHistoryStatus>(new FamilyMemberHistory.FamilyHistoryStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((FamilyMemberHistory.FamilyHistoryStatus)((Object)src.getValue())) {
            case PARTIAL: {
                tgt.setValue((Object)FamilyMemberHistory.FamilyHistoryStatus.PARTIAL);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)FamilyMemberHistory.FamilyHistoryStatus.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)FamilyMemberHistory.FamilyHistoryStatus.ENTEREDINERROR);
                break;
            }
            case HEALTHUNKNOWN: {
                tgt.setValue((Object)FamilyMemberHistory.FamilyHistoryStatus.HEALTHUNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)FamilyMemberHistory.FamilyHistoryStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<FamilyMemberHistory.FamilyHistoryStatus> convertFamilyHistoryStatus(org.hl7.fhir.r5.model.Enumeration<FamilyMemberHistory.FamilyHistoryStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<FamilyMemberHistory.FamilyHistoryStatus> tgt = new Enumeration<FamilyMemberHistory.FamilyHistoryStatus>(new FamilyMemberHistory.FamilyHistoryStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((FamilyMemberHistory.FamilyHistoryStatus)((Object)src.getValue())) {
            case PARTIAL: {
                tgt.setValue((Object)FamilyMemberHistory.FamilyHistoryStatus.PARTIAL);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)FamilyMemberHistory.FamilyHistoryStatus.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)FamilyMemberHistory.FamilyHistoryStatus.ENTEREDINERROR);
                break;
            }
            case HEALTHUNKNOWN: {
                tgt.setValue((Object)FamilyMemberHistory.FamilyHistoryStatus.HEALTHUNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)FamilyMemberHistory.FamilyHistoryStatus.NULL);
            }
        }
        return tgt;
    }

    public static FamilyMemberHistory.FamilyMemberHistoryConditionComponent convertFamilyMemberHistoryConditionComponent(FamilyMemberHistory.FamilyMemberHistoryConditionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        FamilyMemberHistory.FamilyMemberHistoryConditionComponent tgt = new FamilyMemberHistory.FamilyMemberHistoryConditionComponent();
        FamilyMemberHistory40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCode(FamilyMemberHistory40_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasOutcome()) {
            tgt.setOutcome(FamilyMemberHistory40_50.convertCodeableConcept(src.getOutcome()));
        }
        if (src.hasContributedToDeath()) {
            tgt.setContributedToDeathElement(FamilyMemberHistory40_50.convertBoolean(src.getContributedToDeathElement()));
        }
        if (src.hasOnset()) {
            tgt.setOnset(FamilyMemberHistory40_50.convertType(src.getOnset()));
        }
        for (org.hl7.fhir.r4.model.Annotation t : src.getNote()) {
            tgt.addNote(FamilyMemberHistory40_50.convertAnnotation(t));
        }
        return tgt;
    }

    public static FamilyMemberHistory.FamilyMemberHistoryConditionComponent convertFamilyMemberHistoryConditionComponent(FamilyMemberHistory.FamilyMemberHistoryConditionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        FamilyMemberHistory.FamilyMemberHistoryConditionComponent tgt = new FamilyMemberHistory.FamilyMemberHistoryConditionComponent();
        FamilyMemberHistory40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCode(FamilyMemberHistory40_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasOutcome()) {
            tgt.setOutcome(FamilyMemberHistory40_50.convertCodeableConcept(src.getOutcome()));
        }
        if (src.hasContributedToDeath()) {
            tgt.setContributedToDeathElement(FamilyMemberHistory40_50.convertBoolean(src.getContributedToDeathElement()));
        }
        if (src.hasOnset()) {
            tgt.setOnset(FamilyMemberHistory40_50.convertType(src.getOnset()));
        }
        for (Annotation t : src.getNote()) {
            tgt.addNote(FamilyMemberHistory40_50.convertAnnotation(t));
        }
        return tgt;
    }
}

