/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.convertors.conv40_50.Enumerations40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.ContactDetail;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.TriggerDefinition;
import org.hl7.fhir.r4.model.UsageContext;
import org.hl7.fhir.r5.model.EventDefinition;
import org.hl7.fhir.r5.model.RelatedArtifact;

public class EventDefinition40_50
extends VersionConvertor_40_50 {
    public static EventDefinition convertEventDefinition(org.hl7.fhir.r4.model.EventDefinition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        EventDefinition tgt = new EventDefinition();
        EventDefinition40_50.copyDomainResource(src, tgt);
        if (src.hasUrl()) {
            tgt.setUrlElement(EventDefinition40_50.convertUri(src.getUrlElement()));
        }
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(EventDefinition40_50.convertIdentifier(identifier));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(EventDefinition40_50.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(EventDefinition40_50.convertString(src.getNameElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(EventDefinition40_50.convertString(src.getTitleElement()));
        }
        if (src.hasSubtitle()) {
            tgt.setSubtitleElement(EventDefinition40_50.convertString(src.getSubtitleElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((org.hl7.fhir.r5.model.Enumeration)Enumerations40_50.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(EventDefinition40_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(EventDefinition40_50.convertType(src.getSubject()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(EventDefinition40_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(EventDefinition40_50.convertString(src.getPublisherElement()));
        }
        for (ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(EventDefinition40_50.convertContactDetail(contactDetail));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(EventDefinition40_50.convertMarkdown(src.getDescriptionElement()));
        }
        for (UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(EventDefinition40_50.convertUsageContext(usageContext));
        }
        for (CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(EventDefinition40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPurpose()) {
            tgt.setPurposeElement(EventDefinition40_50.convertMarkdown(src.getPurposeElement()));
        }
        if (src.hasUsage()) {
            tgt.setUsageElement(EventDefinition40_50.convertString(src.getUsageElement()));
        }
        if (src.hasCopyright()) {
            tgt.setCopyrightElement(EventDefinition40_50.convertMarkdown(src.getCopyrightElement()));
        }
        if (src.hasApprovalDate()) {
            tgt.setApprovalDateElement(EventDefinition40_50.convertDate(src.getApprovalDateElement()));
        }
        if (src.hasLastReviewDate()) {
            tgt.setLastReviewDateElement(EventDefinition40_50.convertDate(src.getLastReviewDateElement()));
        }
        if (src.hasEffectivePeriod()) {
            tgt.setEffectivePeriod(EventDefinition40_50.convertPeriod(src.getEffectivePeriod()));
        }
        for (CodeableConcept codeableConcept : src.getTopic()) {
            tgt.addTopic(EventDefinition40_50.convertCodeableConcept(codeableConcept));
        }
        for (ContactDetail contactDetail : src.getAuthor()) {
            tgt.addAuthor(EventDefinition40_50.convertContactDetail(contactDetail));
        }
        for (ContactDetail contactDetail : src.getEditor()) {
            tgt.addEditor(EventDefinition40_50.convertContactDetail(contactDetail));
        }
        for (ContactDetail contactDetail : src.getReviewer()) {
            tgt.addReviewer(EventDefinition40_50.convertContactDetail(contactDetail));
        }
        for (ContactDetail contactDetail : src.getEndorser()) {
            tgt.addEndorser(EventDefinition40_50.convertContactDetail(contactDetail));
        }
        for (org.hl7.fhir.r4.model.RelatedArtifact relatedArtifact : src.getRelatedArtifact()) {
            tgt.addRelatedArtifact(EventDefinition40_50.convertRelatedArtifact(relatedArtifact));
        }
        for (TriggerDefinition triggerDefinition : src.getTrigger()) {
            tgt.addTrigger(EventDefinition40_50.convertTriggerDefinition(triggerDefinition));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.EventDefinition convertEventDefinition(EventDefinition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.EventDefinition tgt = new org.hl7.fhir.r4.model.EventDefinition();
        EventDefinition40_50.copyDomainResource(src, tgt);
        if (src.hasUrl()) {
            tgt.setUrlElement(EventDefinition40_50.convertUri(src.getUrlElement()));
        }
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(EventDefinition40_50.convertIdentifier(identifier));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(EventDefinition40_50.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(EventDefinition40_50.convertString(src.getNameElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(EventDefinition40_50.convertString(src.getTitleElement()));
        }
        if (src.hasSubtitle()) {
            tgt.setSubtitleElement(EventDefinition40_50.convertString(src.getSubtitleElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((Enumeration)Enumerations40_50.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(EventDefinition40_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(EventDefinition40_50.convertType(src.getSubject()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(EventDefinition40_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(EventDefinition40_50.convertString(src.getPublisherElement()));
        }
        for (org.hl7.fhir.r5.model.ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(EventDefinition40_50.convertContactDetail(contactDetail));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(EventDefinition40_50.convertMarkdown(src.getDescriptionElement()));
        }
        for (org.hl7.fhir.r5.model.UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(EventDefinition40_50.convertUsageContext(usageContext));
        }
        for (org.hl7.fhir.r5.model.CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(EventDefinition40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPurpose()) {
            tgt.setPurposeElement(EventDefinition40_50.convertMarkdown(src.getPurposeElement()));
        }
        if (src.hasUsage()) {
            tgt.setUsageElement(EventDefinition40_50.convertString(src.getUsageElement()));
        }
        if (src.hasCopyright()) {
            tgt.setCopyrightElement(EventDefinition40_50.convertMarkdown(src.getCopyrightElement()));
        }
        if (src.hasApprovalDate()) {
            tgt.setApprovalDateElement(EventDefinition40_50.convertDate(src.getApprovalDateElement()));
        }
        if (src.hasLastReviewDate()) {
            tgt.setLastReviewDateElement(EventDefinition40_50.convertDate(src.getLastReviewDateElement()));
        }
        if (src.hasEffectivePeriod()) {
            tgt.setEffectivePeriod(EventDefinition40_50.convertPeriod(src.getEffectivePeriod()));
        }
        for (org.hl7.fhir.r5.model.CodeableConcept codeableConcept : src.getTopic()) {
            tgt.addTopic(EventDefinition40_50.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r5.model.ContactDetail contactDetail : src.getAuthor()) {
            tgt.addAuthor(EventDefinition40_50.convertContactDetail(contactDetail));
        }
        for (org.hl7.fhir.r5.model.ContactDetail contactDetail : src.getEditor()) {
            tgt.addEditor(EventDefinition40_50.convertContactDetail(contactDetail));
        }
        for (org.hl7.fhir.r5.model.ContactDetail contactDetail : src.getReviewer()) {
            tgt.addReviewer(EventDefinition40_50.convertContactDetail(contactDetail));
        }
        for (org.hl7.fhir.r5.model.ContactDetail contactDetail : src.getEndorser()) {
            tgt.addEndorser(EventDefinition40_50.convertContactDetail(contactDetail));
        }
        for (RelatedArtifact relatedArtifact : src.getRelatedArtifact()) {
            tgt.addRelatedArtifact(EventDefinition40_50.convertRelatedArtifact(relatedArtifact));
        }
        for (org.hl7.fhir.r5.model.TriggerDefinition triggerDefinition : src.getTrigger()) {
            tgt.addTrigger(EventDefinition40_50.convertTriggerDefinition(triggerDefinition));
        }
        return tgt;
    }
}

