/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.DiagnosticReport;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r5.model.Attachment;
import org.hl7.fhir.r5.model.DiagnosticReport;

public class DiagnosticReport40_50
extends VersionConvertor_40_50 {
    public static org.hl7.fhir.r5.model.DiagnosticReport convertDiagnosticReport(DiagnosticReport src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.DiagnosticReport tgt = new org.hl7.fhir.r5.model.DiagnosticReport();
        DiagnosticReport40_50.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(DiagnosticReport40_50.convertIdentifier(identifier));
        }
        for (Reference reference : src.getBasedOn()) {
            tgt.addBasedOn(DiagnosticReport40_50.convertReference(reference));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(DiagnosticReport40_50.convertDiagnosticReportStatus(src.getStatusElement()));
        }
        for (CodeableConcept codeableConcept : src.getCategory()) {
            tgt.addCategory(DiagnosticReport40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasCode()) {
            tgt.setCode(DiagnosticReport40_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(DiagnosticReport40_50.convertReference(src.getSubject()));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(DiagnosticReport40_50.convertReference(src.getEncounter()));
        }
        if (src.hasEffective()) {
            tgt.setEffective(DiagnosticReport40_50.convertType(src.getEffective()));
        }
        if (src.hasIssued()) {
            tgt.setIssuedElement(DiagnosticReport40_50.convertInstant(src.getIssuedElement()));
        }
        for (Reference reference : src.getPerformer()) {
            tgt.addPerformer(DiagnosticReport40_50.convertReference(reference));
        }
        for (Reference reference : src.getResultsInterpreter()) {
            tgt.addResultsInterpreter(DiagnosticReport40_50.convertReference(reference));
        }
        for (Reference reference : src.getSpecimen()) {
            tgt.addSpecimen(DiagnosticReport40_50.convertReference(reference));
        }
        for (Reference reference : src.getResult()) {
            tgt.addResult(DiagnosticReport40_50.convertReference(reference));
        }
        for (Reference reference : src.getImagingStudy()) {
            tgt.addImagingStudy(DiagnosticReport40_50.convertReference(reference));
        }
        for (DiagnosticReport.DiagnosticReportMediaComponent diagnosticReportMediaComponent : src.getMedia()) {
            tgt.addMedia(DiagnosticReport40_50.convertDiagnosticReportMediaComponent(diagnosticReportMediaComponent));
        }
        if (src.hasConclusion()) {
            tgt.setConclusionElement(DiagnosticReport40_50.convertString(src.getConclusionElement()));
        }
        for (CodeableConcept codeableConcept : src.getConclusionCode()) {
            tgt.addConclusionCode(DiagnosticReport40_50.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.Attachment attachment : src.getPresentedForm()) {
            tgt.addPresentedForm(DiagnosticReport40_50.convertAttachment(attachment));
        }
        return tgt;
    }

    public static DiagnosticReport convertDiagnosticReport(org.hl7.fhir.r5.model.DiagnosticReport src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DiagnosticReport tgt = new DiagnosticReport();
        DiagnosticReport40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(DiagnosticReport40_50.convertIdentifier(identifier));
        }
        for (org.hl7.fhir.r5.model.Reference reference : src.getBasedOn()) {
            tgt.addBasedOn(DiagnosticReport40_50.convertReference(reference));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(DiagnosticReport40_50.convertDiagnosticReportStatus(src.getStatusElement()));
        }
        for (org.hl7.fhir.r5.model.CodeableConcept codeableConcept : src.getCategory()) {
            tgt.addCategory(DiagnosticReport40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasCode()) {
            tgt.setCode(DiagnosticReport40_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(DiagnosticReport40_50.convertReference(src.getSubject()));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(DiagnosticReport40_50.convertReference(src.getEncounter()));
        }
        if (src.hasEffective()) {
            tgt.setEffective(DiagnosticReport40_50.convertType(src.getEffective()));
        }
        if (src.hasIssued()) {
            tgt.setIssuedElement(DiagnosticReport40_50.convertInstant(src.getIssuedElement()));
        }
        for (org.hl7.fhir.r5.model.Reference reference : src.getPerformer()) {
            tgt.addPerformer(DiagnosticReport40_50.convertReference(reference));
        }
        for (org.hl7.fhir.r5.model.Reference reference : src.getResultsInterpreter()) {
            tgt.addResultsInterpreter(DiagnosticReport40_50.convertReference(reference));
        }
        for (org.hl7.fhir.r5.model.Reference reference : src.getSpecimen()) {
            tgt.addSpecimen(DiagnosticReport40_50.convertReference(reference));
        }
        for (org.hl7.fhir.r5.model.Reference reference : src.getResult()) {
            tgt.addResult(DiagnosticReport40_50.convertReference(reference));
        }
        for (org.hl7.fhir.r5.model.Reference reference : src.getImagingStudy()) {
            tgt.addImagingStudy(DiagnosticReport40_50.convertReference(reference));
        }
        for (DiagnosticReport.DiagnosticReportMediaComponent diagnosticReportMediaComponent : src.getMedia()) {
            tgt.addMedia(DiagnosticReport40_50.convertDiagnosticReportMediaComponent(diagnosticReportMediaComponent));
        }
        if (src.hasConclusion()) {
            tgt.setConclusionElement(DiagnosticReport40_50.convertString(src.getConclusionElement()));
        }
        for (org.hl7.fhir.r5.model.CodeableConcept codeableConcept : src.getConclusionCode()) {
            tgt.addConclusionCode(DiagnosticReport40_50.convertCodeableConcept(codeableConcept));
        }
        for (Attachment attachment : src.getPresentedForm()) {
            tgt.addPresentedForm(DiagnosticReport40_50.convertAttachment(attachment));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<DiagnosticReport.DiagnosticReportStatus> convertDiagnosticReportStatus(Enumeration<DiagnosticReport.DiagnosticReportStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<DiagnosticReport.DiagnosticReportStatus> tgt = new org.hl7.fhir.r5.model.Enumeration<DiagnosticReport.DiagnosticReportStatus>(new DiagnosticReport.DiagnosticReportStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((DiagnosticReport.DiagnosticReportStatus)((Object)src.getValue())) {
            case REGISTERED: {
                tgt.setValue((Object)DiagnosticReport.DiagnosticReportStatus.REGISTERED);
                break;
            }
            case PARTIAL: {
                tgt.setValue((Object)DiagnosticReport.DiagnosticReportStatus.PARTIAL);
                break;
            }
            case PRELIMINARY: {
                tgt.setValue((Object)DiagnosticReport.DiagnosticReportStatus.PRELIMINARY);
                break;
            }
            case FINAL: {
                tgt.setValue((Object)DiagnosticReport.DiagnosticReportStatus.FINAL);
                break;
            }
            case AMENDED: {
                tgt.setValue((Object)DiagnosticReport.DiagnosticReportStatus.AMENDED);
                break;
            }
            case CORRECTED: {
                tgt.setValue((Object)DiagnosticReport.DiagnosticReportStatus.CORRECTED);
                break;
            }
            case APPENDED: {
                tgt.setValue((Object)DiagnosticReport.DiagnosticReportStatus.APPENDED);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)DiagnosticReport.DiagnosticReportStatus.CANCELLED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)DiagnosticReport.DiagnosticReportStatus.ENTEREDINERROR);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)DiagnosticReport.DiagnosticReportStatus.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)DiagnosticReport.DiagnosticReportStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<DiagnosticReport.DiagnosticReportStatus> convertDiagnosticReportStatus(org.hl7.fhir.r5.model.Enumeration<DiagnosticReport.DiagnosticReportStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<DiagnosticReport.DiagnosticReportStatus> tgt = new Enumeration<DiagnosticReport.DiagnosticReportStatus>(new DiagnosticReport.DiagnosticReportStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((DiagnosticReport.DiagnosticReportStatus)((Object)src.getValue())) {
            case REGISTERED: {
                tgt.setValue((Object)DiagnosticReport.DiagnosticReportStatus.REGISTERED);
                break;
            }
            case PARTIAL: {
                tgt.setValue((Object)DiagnosticReport.DiagnosticReportStatus.PARTIAL);
                break;
            }
            case PRELIMINARY: {
                tgt.setValue((Object)DiagnosticReport.DiagnosticReportStatus.PRELIMINARY);
                break;
            }
            case FINAL: {
                tgt.setValue((Object)DiagnosticReport.DiagnosticReportStatus.FINAL);
                break;
            }
            case AMENDED: {
                tgt.setValue((Object)DiagnosticReport.DiagnosticReportStatus.AMENDED);
                break;
            }
            case CORRECTED: {
                tgt.setValue((Object)DiagnosticReport.DiagnosticReportStatus.CORRECTED);
                break;
            }
            case APPENDED: {
                tgt.setValue((Object)DiagnosticReport.DiagnosticReportStatus.APPENDED);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)DiagnosticReport.DiagnosticReportStatus.CANCELLED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)DiagnosticReport.DiagnosticReportStatus.ENTEREDINERROR);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)DiagnosticReport.DiagnosticReportStatus.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)DiagnosticReport.DiagnosticReportStatus.NULL);
            }
        }
        return tgt;
    }

    public static DiagnosticReport.DiagnosticReportMediaComponent convertDiagnosticReportMediaComponent(DiagnosticReport.DiagnosticReportMediaComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DiagnosticReport.DiagnosticReportMediaComponent tgt = new DiagnosticReport.DiagnosticReportMediaComponent();
        DiagnosticReport40_50.copyElement(src, tgt, new String[0]);
        if (src.hasComment()) {
            tgt.setCommentElement(DiagnosticReport40_50.convertString(src.getCommentElement()));
        }
        if (src.hasLink()) {
            tgt.setLink(DiagnosticReport40_50.convertReference(src.getLink()));
        }
        return tgt;
    }

    public static DiagnosticReport.DiagnosticReportMediaComponent convertDiagnosticReportMediaComponent(DiagnosticReport.DiagnosticReportMediaComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DiagnosticReport.DiagnosticReportMediaComponent tgt = new DiagnosticReport.DiagnosticReportMediaComponent();
        DiagnosticReport40_50.copyElement(src, tgt, new String[0]);
        if (src.hasComment()) {
            tgt.setCommentElement(DiagnosticReport40_50.convertString(src.getCommentElement()));
        }
        if (src.hasLink()) {
            tgt.setLink(DiagnosticReport40_50.convertReference(src.getLink()));
        }
        return tgt;
    }
}

