/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.ContactPoint;
import org.hl7.fhir.r4.model.DeviceDefinition;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.ProductShelfLife;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.DeviceDefinition;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Quantity;

public class DeviceDefinition40_50
extends VersionConvertor_40_50 {
    public static DeviceDefinition convertDeviceDefinition(org.hl7.fhir.r4.model.DeviceDefinition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DeviceDefinition tgt = new DeviceDefinition();
        DeviceDefinition40_50.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(DeviceDefinition40_50.convertIdentifier(identifier));
        }
        for (DeviceDefinition.DeviceDefinitionUdiDeviceIdentifierComponent deviceDefinitionUdiDeviceIdentifierComponent : src.getUdiDeviceIdentifier()) {
            tgt.addUdiDeviceIdentifier(DeviceDefinition40_50.convertDeviceDefinitionUdiDeviceIdentifierComponent(deviceDefinitionUdiDeviceIdentifierComponent));
        }
        if (src.hasManufacturer()) {
            tgt.setManufacturer(DeviceDefinition40_50.convertType(src.getManufacturer()));
        }
        for (DeviceDefinition.DeviceDefinitionDeviceNameComponent deviceDefinitionDeviceNameComponent : src.getDeviceName()) {
            tgt.addDeviceName(DeviceDefinition40_50.convertDeviceDefinitionDeviceNameComponent(deviceDefinitionDeviceNameComponent));
        }
        if (src.hasModelNumber()) {
            tgt.setModelNumberElement(DeviceDefinition40_50.convertString(src.getModelNumberElement()));
        }
        if (src.hasType()) {
            tgt.addType(DeviceDefinition40_50.convertCodeableConcept(src.getType()));
        }
        for (DeviceDefinition.DeviceDefinitionSpecializationComponent deviceDefinitionSpecializationComponent : src.getSpecialization()) {
            tgt.addSpecialization(DeviceDefinition40_50.convertDeviceDefinitionSpecializationComponent(deviceDefinitionSpecializationComponent));
        }
        for (StringType stringType : src.getVersion()) {
            tgt.getVersion().add(new DeviceDefinition.DeviceDefinitionVersionComponent().setValueElement(DeviceDefinition40_50.convertString(stringType)));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getSafety()) {
            tgt.addSafety(DeviceDefinition40_50.convertCodeableConcept(codeableConcept));
        }
        for (ProductShelfLife productShelfLife : src.getShelfLifeStorage()) {
            tgt.addShelfLifeStorage(DeviceDefinition40_50.convertProductShelfLife(productShelfLife));
        }
        if (src.hasPhysicalCharacteristics()) {
            tgt.setPhysicalCharacteristics(DeviceDefinition40_50.convertProdCharacteristic(src.getPhysicalCharacteristics()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getLanguageCode()) {
            tgt.addLanguageCode(DeviceDefinition40_50.convertCodeableConcept(codeableConcept));
        }
        for (DeviceDefinition.DeviceDefinitionCapabilityComponent deviceDefinitionCapabilityComponent : src.getCapability()) {
            tgt.addCapability(DeviceDefinition40_50.convertDeviceDefinitionCapabilityComponent(deviceDefinitionCapabilityComponent));
        }
        for (DeviceDefinition.DeviceDefinitionPropertyComponent deviceDefinitionPropertyComponent : src.getProperty()) {
            tgt.addProperty(DeviceDefinition40_50.convertDeviceDefinitionPropertyComponent(deviceDefinitionPropertyComponent));
        }
        if (src.hasOwner()) {
            tgt.setOwner(DeviceDefinition40_50.convertReference(src.getOwner()));
        }
        for (ContactPoint contactPoint : src.getContact()) {
            tgt.addContact(DeviceDefinition40_50.convertContactPoint(contactPoint));
        }
        if (src.hasOnlineInformation()) {
            tgt.setOnlineInformationElement(DeviceDefinition40_50.convertUri(src.getOnlineInformationElement()));
        }
        for (org.hl7.fhir.r4.model.Annotation annotation : src.getNote()) {
            tgt.addNote(DeviceDefinition40_50.convertAnnotation(annotation));
        }
        if (src.hasParentDevice()) {
            tgt.setParentDevice(DeviceDefinition40_50.convertReference(src.getParentDevice()));
        }
        for (DeviceDefinition.DeviceDefinitionMaterialComponent deviceDefinitionMaterialComponent : src.getMaterial()) {
            tgt.addMaterial(DeviceDefinition40_50.convertDeviceDefinitionMaterialComponent(deviceDefinitionMaterialComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.DeviceDefinition convertDeviceDefinition(DeviceDefinition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.DeviceDefinition tgt = new org.hl7.fhir.r4.model.DeviceDefinition();
        DeviceDefinition40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(DeviceDefinition40_50.convertIdentifier(identifier));
        }
        for (DeviceDefinition.DeviceDefinitionUdiDeviceIdentifierComponent deviceDefinitionUdiDeviceIdentifierComponent : src.getUdiDeviceIdentifier()) {
            tgt.addUdiDeviceIdentifier(DeviceDefinition40_50.convertDeviceDefinitionUdiDeviceIdentifierComponent(deviceDefinitionUdiDeviceIdentifierComponent));
        }
        if (src.hasManufacturer()) {
            tgt.setManufacturer(DeviceDefinition40_50.convertType(src.getManufacturer()));
        }
        for (DeviceDefinition.DeviceDefinitionDeviceNameComponent deviceDefinitionDeviceNameComponent : src.getDeviceName()) {
            tgt.addDeviceName(DeviceDefinition40_50.convertDeviceDefinitionDeviceNameComponent(deviceDefinitionDeviceNameComponent));
        }
        if (src.hasModelNumber()) {
            tgt.setModelNumberElement(DeviceDefinition40_50.convertString(src.getModelNumberElement()));
        }
        for (CodeableConcept codeableConcept : src.getType()) {
            tgt.setType(DeviceDefinition40_50.convertCodeableConcept(codeableConcept));
        }
        for (DeviceDefinition.DeviceDefinitionSpecializationComponent deviceDefinitionSpecializationComponent : src.getSpecialization()) {
            tgt.addSpecialization(DeviceDefinition40_50.convertDeviceDefinitionSpecializationComponent(deviceDefinitionSpecializationComponent));
        }
        for (DeviceDefinition.DeviceDefinitionVersionComponent deviceDefinitionVersionComponent : src.getVersion()) {
            tgt.getVersion().add(DeviceDefinition40_50.convertString(deviceDefinitionVersionComponent.getValueElement()));
        }
        for (CodeableConcept codeableConcept : src.getSafety()) {
            tgt.addSafety(DeviceDefinition40_50.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r5.model.ProductShelfLife productShelfLife : src.getShelfLifeStorage()) {
            tgt.addShelfLifeStorage(DeviceDefinition40_50.convertProductShelfLife(productShelfLife));
        }
        if (src.hasPhysicalCharacteristics()) {
            tgt.setPhysicalCharacteristics(DeviceDefinition40_50.convertProdCharacteristic(src.getPhysicalCharacteristics()));
        }
        for (CodeableConcept codeableConcept : src.getLanguageCode()) {
            tgt.addLanguageCode(DeviceDefinition40_50.convertCodeableConcept(codeableConcept));
        }
        for (DeviceDefinition.DeviceDefinitionCapabilityComponent deviceDefinitionCapabilityComponent : src.getCapability()) {
            tgt.addCapability(DeviceDefinition40_50.convertDeviceDefinitionCapabilityComponent(deviceDefinitionCapabilityComponent));
        }
        for (DeviceDefinition.DeviceDefinitionPropertyComponent deviceDefinitionPropertyComponent : src.getProperty()) {
            tgt.addProperty(DeviceDefinition40_50.convertDeviceDefinitionPropertyComponent(deviceDefinitionPropertyComponent));
        }
        if (src.hasOwner()) {
            tgt.setOwner(DeviceDefinition40_50.convertReference(src.getOwner()));
        }
        for (org.hl7.fhir.r5.model.ContactPoint contactPoint : src.getContact()) {
            tgt.addContact(DeviceDefinition40_50.convertContactPoint(contactPoint));
        }
        if (src.hasOnlineInformation()) {
            tgt.setOnlineInformationElement(DeviceDefinition40_50.convertUri(src.getOnlineInformationElement()));
        }
        for (Annotation annotation : src.getNote()) {
            tgt.addNote(DeviceDefinition40_50.convertAnnotation(annotation));
        }
        if (src.hasParentDevice()) {
            tgt.setParentDevice(DeviceDefinition40_50.convertReference(src.getParentDevice()));
        }
        for (DeviceDefinition.DeviceDefinitionMaterialComponent deviceDefinitionMaterialComponent : src.getMaterial()) {
            tgt.addMaterial(DeviceDefinition40_50.convertDeviceDefinitionMaterialComponent(deviceDefinitionMaterialComponent));
        }
        return tgt;
    }

    public static DeviceDefinition.DeviceDefinitionUdiDeviceIdentifierComponent convertDeviceDefinitionUdiDeviceIdentifierComponent(DeviceDefinition.DeviceDefinitionUdiDeviceIdentifierComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DeviceDefinition.DeviceDefinitionUdiDeviceIdentifierComponent tgt = new DeviceDefinition.DeviceDefinitionUdiDeviceIdentifierComponent();
        DeviceDefinition40_50.copyElement(src, tgt, new String[0]);
        if (src.hasDeviceIdentifier()) {
            tgt.setDeviceIdentifierElement(DeviceDefinition40_50.convertString(src.getDeviceIdentifierElement()));
        }
        if (src.hasIssuer()) {
            tgt.setIssuerElement(DeviceDefinition40_50.convertUri(src.getIssuerElement()));
        }
        if (src.hasJurisdiction()) {
            tgt.setJurisdictionElement(DeviceDefinition40_50.convertUri(src.getJurisdictionElement()));
        }
        return tgt;
    }

    public static DeviceDefinition.DeviceDefinitionUdiDeviceIdentifierComponent convertDeviceDefinitionUdiDeviceIdentifierComponent(DeviceDefinition.DeviceDefinitionUdiDeviceIdentifierComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DeviceDefinition.DeviceDefinitionUdiDeviceIdentifierComponent tgt = new DeviceDefinition.DeviceDefinitionUdiDeviceIdentifierComponent();
        DeviceDefinition40_50.copyElement(src, tgt, new String[0]);
        if (src.hasDeviceIdentifier()) {
            tgt.setDeviceIdentifierElement(DeviceDefinition40_50.convertString(src.getDeviceIdentifierElement()));
        }
        if (src.hasIssuer()) {
            tgt.setIssuerElement(DeviceDefinition40_50.convertUri(src.getIssuerElement()));
        }
        if (src.hasJurisdiction()) {
            tgt.setJurisdictionElement(DeviceDefinition40_50.convertUri(src.getJurisdictionElement()));
        }
        return tgt;
    }

    public static DeviceDefinition.DeviceDefinitionDeviceNameComponent convertDeviceDefinitionDeviceNameComponent(DeviceDefinition.DeviceDefinitionDeviceNameComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DeviceDefinition.DeviceDefinitionDeviceNameComponent tgt = new DeviceDefinition.DeviceDefinitionDeviceNameComponent();
        DeviceDefinition40_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(DeviceDefinition40_50.convertString(src.getNameElement()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(DeviceDefinition40_50.convertDeviceNameType(src.getTypeElement()));
        }
        return tgt;
    }

    public static DeviceDefinition.DeviceDefinitionDeviceNameComponent convertDeviceDefinitionDeviceNameComponent(DeviceDefinition.DeviceDefinitionDeviceNameComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DeviceDefinition.DeviceDefinitionDeviceNameComponent tgt = new DeviceDefinition.DeviceDefinitionDeviceNameComponent();
        DeviceDefinition40_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(DeviceDefinition40_50.convertString(src.getNameElement()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(DeviceDefinition40_50.convertDeviceNameType(src.getTypeElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.DeviceNameType> convertDeviceNameType(Enumeration<DeviceDefinition.DeviceNameType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.DeviceNameType> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.DeviceNameType>(new Enumerations.DeviceNameTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((DeviceDefinition.DeviceNameType)((Object)src.getValue())) {
            case UDILABELNAME: {
                tgt.setValue((Object)Enumerations.DeviceNameType.UDILABELNAME);
                break;
            }
            case USERFRIENDLYNAME: {
                tgt.setValue((Object)Enumerations.DeviceNameType.USERFRIENDLYNAME);
                break;
            }
            case PATIENTREPORTEDNAME: {
                tgt.setValue((Object)Enumerations.DeviceNameType.PATIENTREPORTEDNAME);
                break;
            }
            case MANUFACTURERNAME: {
                tgt.setValue((Object)Enumerations.DeviceNameType.MANUFACTURERNAME);
                break;
            }
            case MODELNAME: {
                tgt.setValue((Object)Enumerations.DeviceNameType.MODELNAME);
                break;
            }
            case OTHER: {
                tgt.setValue((Object)Enumerations.DeviceNameType.OTHER);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.DeviceNameType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<DeviceDefinition.DeviceNameType> convertDeviceNameType(org.hl7.fhir.r5.model.Enumeration<Enumerations.DeviceNameType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<DeviceDefinition.DeviceNameType> tgt = new Enumeration<DeviceDefinition.DeviceNameType>(new DeviceDefinition.DeviceNameTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.DeviceNameType)((Object)src.getValue())) {
            case UDILABELNAME: {
                tgt.setValue((Object)DeviceDefinition.DeviceNameType.UDILABELNAME);
                break;
            }
            case USERFRIENDLYNAME: {
                tgt.setValue((Object)DeviceDefinition.DeviceNameType.USERFRIENDLYNAME);
                break;
            }
            case PATIENTREPORTEDNAME: {
                tgt.setValue((Object)DeviceDefinition.DeviceNameType.PATIENTREPORTEDNAME);
                break;
            }
            case MANUFACTURERNAME: {
                tgt.setValue((Object)DeviceDefinition.DeviceNameType.MANUFACTURERNAME);
                break;
            }
            case MODELNAME: {
                tgt.setValue((Object)DeviceDefinition.DeviceNameType.MODELNAME);
                break;
            }
            case OTHER: {
                tgt.setValue((Object)DeviceDefinition.DeviceNameType.OTHER);
                break;
            }
            default: {
                tgt.setValue((Object)DeviceDefinition.DeviceNameType.NULL);
            }
        }
        return tgt;
    }

    public static DeviceDefinition.DeviceDefinitionSpecializationComponent convertDeviceDefinitionSpecializationComponent(DeviceDefinition.DeviceDefinitionSpecializationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DeviceDefinition.DeviceDefinitionSpecializationComponent tgt = new DeviceDefinition.DeviceDefinitionSpecializationComponent();
        DeviceDefinition40_50.copyElement(src, tgt, new String[0]);
        if (src.hasSystemType()) {
            tgt.setSystemTypeElement(DeviceDefinition40_50.convertString(src.getSystemTypeElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(DeviceDefinition40_50.convertString(src.getVersionElement()));
        }
        return tgt;
    }

    public static DeviceDefinition.DeviceDefinitionSpecializationComponent convertDeviceDefinitionSpecializationComponent(DeviceDefinition.DeviceDefinitionSpecializationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DeviceDefinition.DeviceDefinitionSpecializationComponent tgt = new DeviceDefinition.DeviceDefinitionSpecializationComponent();
        DeviceDefinition40_50.copyElement(src, tgt, new String[0]);
        if (src.hasSystemType()) {
            tgt.setSystemTypeElement(DeviceDefinition40_50.convertString(src.getSystemTypeElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(DeviceDefinition40_50.convertString(src.getVersionElement()));
        }
        return tgt;
    }

    public static DeviceDefinition.DeviceDefinitionCapabilityComponent convertDeviceDefinitionCapabilityComponent(DeviceDefinition.DeviceDefinitionCapabilityComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DeviceDefinition.DeviceDefinitionCapabilityComponent tgt = new DeviceDefinition.DeviceDefinitionCapabilityComponent();
        DeviceDefinition40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(DeviceDefinition40_50.convertCodeableConcept(src.getType()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept t : src.getDescription()) {
            tgt.addDescription(DeviceDefinition40_50.convertCodeableConcept(t));
        }
        return tgt;
    }

    public static DeviceDefinition.DeviceDefinitionCapabilityComponent convertDeviceDefinitionCapabilityComponent(DeviceDefinition.DeviceDefinitionCapabilityComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DeviceDefinition.DeviceDefinitionCapabilityComponent tgt = new DeviceDefinition.DeviceDefinitionCapabilityComponent();
        DeviceDefinition40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(DeviceDefinition40_50.convertCodeableConcept(src.getType()));
        }
        for (CodeableConcept t : src.getDescription()) {
            tgt.addDescription(DeviceDefinition40_50.convertCodeableConcept(t));
        }
        return tgt;
    }

    public static DeviceDefinition.DeviceDefinitionPropertyComponent convertDeviceDefinitionPropertyComponent(DeviceDefinition.DeviceDefinitionPropertyComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DeviceDefinition.DeviceDefinitionPropertyComponent tgt = new DeviceDefinition.DeviceDefinitionPropertyComponent();
        DeviceDefinition40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(DeviceDefinition40_50.convertCodeableConcept(src.getType()));
        }
        for (org.hl7.fhir.r4.model.Quantity quantity : src.getValueQuantity()) {
            tgt.addValueQuantity(DeviceDefinition40_50.convertQuantity(quantity));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getValueCode()) {
            tgt.addValueCode(DeviceDefinition40_50.convertCodeableConcept(codeableConcept));
        }
        return tgt;
    }

    public static DeviceDefinition.DeviceDefinitionPropertyComponent convertDeviceDefinitionPropertyComponent(DeviceDefinition.DeviceDefinitionPropertyComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DeviceDefinition.DeviceDefinitionPropertyComponent tgt = new DeviceDefinition.DeviceDefinitionPropertyComponent();
        DeviceDefinition40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(DeviceDefinition40_50.convertCodeableConcept(src.getType()));
        }
        for (Quantity quantity : src.getValueQuantity()) {
            tgt.addValueQuantity(DeviceDefinition40_50.convertQuantity(quantity));
        }
        for (CodeableConcept codeableConcept : src.getValueCode()) {
            tgt.addValueCode(DeviceDefinition40_50.convertCodeableConcept(codeableConcept));
        }
        return tgt;
    }

    public static DeviceDefinition.DeviceDefinitionMaterialComponent convertDeviceDefinitionMaterialComponent(DeviceDefinition.DeviceDefinitionMaterialComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DeviceDefinition.DeviceDefinitionMaterialComponent tgt = new DeviceDefinition.DeviceDefinitionMaterialComponent();
        DeviceDefinition40_50.copyElement(src, tgt, new String[0]);
        if (src.hasSubstance()) {
            tgt.setSubstance(DeviceDefinition40_50.convertCodeableConcept(src.getSubstance()));
        }
        if (src.hasAlternate()) {
            tgt.setAlternateElement(DeviceDefinition40_50.convertBoolean(src.getAlternateElement()));
        }
        if (src.hasAllergenicIndicator()) {
            tgt.setAllergenicIndicatorElement(DeviceDefinition40_50.convertBoolean(src.getAllergenicIndicatorElement()));
        }
        return tgt;
    }

    public static DeviceDefinition.DeviceDefinitionMaterialComponent convertDeviceDefinitionMaterialComponent(DeviceDefinition.DeviceDefinitionMaterialComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DeviceDefinition.DeviceDefinitionMaterialComponent tgt = new DeviceDefinition.DeviceDefinitionMaterialComponent();
        DeviceDefinition40_50.copyElement(src, tgt, new String[0]);
        if (src.hasSubstance()) {
            tgt.setSubstance(DeviceDefinition40_50.convertCodeableConcept(src.getSubstance()));
        }
        if (src.hasAlternate()) {
            tgt.setAlternateElement(DeviceDefinition40_50.convertBoolean(src.getAlternateElement()));
        }
        if (src.hasAllergenicIndicator()) {
            tgt.setAllergenicIndicatorElement(DeviceDefinition40_50.convertBoolean(src.getAllergenicIndicatorElement()));
        }
        return tgt;
    }
}

