/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.ContactPoint;
import org.hl7.fhir.r4.model.Device;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Quantity;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.Enumerations;

public class Device40_50
extends VersionConvertor_40_50 {
    public static org.hl7.fhir.r5.model.Device convertDevice(Device src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.Device tgt = new org.hl7.fhir.r5.model.Device();
        Device40_50.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(Device40_50.convertIdentifier(identifier));
        }
        if (src.hasDefinition()) {
            tgt.setDefinition(Device40_50.convertReference(src.getDefinition()));
        }
        for (Device.DeviceUdiCarrierComponent deviceUdiCarrierComponent : src.getUdiCarrier()) {
            tgt.addUdiCarrier(Device40_50.convertDeviceUdiCarrierComponent(deviceUdiCarrierComponent));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Device40_50.convertFHIRDeviceStatus(src.getStatusElement()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getStatusReason()) {
            tgt.addStatusReason(Device40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasDistinctIdentifier()) {
            tgt.setDistinctIdentifierElement(Device40_50.convertString(src.getDistinctIdentifierElement()));
        }
        if (src.hasManufacturer()) {
            tgt.setManufacturerElement(Device40_50.convertString(src.getManufacturerElement()));
        }
        if (src.hasManufactureDate()) {
            tgt.setManufactureDateElement(Device40_50.convertDateTime(src.getManufactureDateElement()));
        }
        if (src.hasExpirationDate()) {
            tgt.setExpirationDateElement(Device40_50.convertDateTime(src.getExpirationDateElement()));
        }
        if (src.hasLotNumber()) {
            tgt.setLotNumberElement(Device40_50.convertString(src.getLotNumberElement()));
        }
        if (src.hasSerialNumber()) {
            tgt.setSerialNumberElement(Device40_50.convertString(src.getSerialNumberElement()));
        }
        for (Device.DeviceDeviceNameComponent deviceDeviceNameComponent : src.getDeviceName()) {
            tgt.addDeviceName(Device40_50.convertDeviceDeviceNameComponent(deviceDeviceNameComponent));
        }
        if (src.hasModelNumber()) {
            tgt.setModelNumberElement(Device40_50.convertString(src.getModelNumberElement()));
        }
        if (src.hasPartNumber()) {
            tgt.setPartNumberElement(Device40_50.convertString(src.getPartNumberElement()));
        }
        if (src.hasType()) {
            tgt.addType(Device40_50.convertCodeableConcept(src.getType()));
        }
        for (Device.DeviceSpecializationComponent deviceSpecializationComponent : src.getSpecialization()) {
            tgt.addSpecialization(Device40_50.convertDeviceSpecializationComponent(deviceSpecializationComponent));
        }
        for (Device.DeviceVersionComponent deviceVersionComponent : src.getVersion()) {
            tgt.addVersion(Device40_50.convertDeviceVersionComponent(deviceVersionComponent));
        }
        for (Device.DevicePropertyComponent devicePropertyComponent : src.getProperty()) {
            tgt.addProperty(Device40_50.convertDevicePropertyComponent(devicePropertyComponent));
        }
        if (src.hasPatient()) {
            tgt.setPatient(Device40_50.convertReference(src.getPatient()));
        }
        if (src.hasOwner()) {
            tgt.setOwner(Device40_50.convertReference(src.getOwner()));
        }
        for (ContactPoint contactPoint : src.getContact()) {
            tgt.addContact(Device40_50.convertContactPoint(contactPoint));
        }
        if (src.hasLocation()) {
            tgt.setLocation(Device40_50.convertReference(src.getLocation()));
        }
        if (src.hasUrl()) {
            tgt.setUrlElement(Device40_50.convertUri(src.getUrlElement()));
        }
        for (org.hl7.fhir.r4.model.Annotation annotation : src.getNote()) {
            tgt.addNote(Device40_50.convertAnnotation(annotation));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getSafety()) {
            tgt.addSafety(Device40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasParent()) {
            tgt.setParent(Device40_50.convertReference(src.getParent()));
        }
        return tgt;
    }

    public static Device convertDevice(org.hl7.fhir.r5.model.Device src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Device tgt = new Device();
        Device40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(Device40_50.convertIdentifier(identifier));
        }
        if (src.hasDefinition()) {
            tgt.setDefinition(Device40_50.convertReference(src.getDefinition()));
        }
        for (Device.DeviceUdiCarrierComponent deviceUdiCarrierComponent : src.getUdiCarrier()) {
            tgt.addUdiCarrier(Device40_50.convertDeviceUdiCarrierComponent(deviceUdiCarrierComponent));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Device40_50.convertFHIRDeviceStatus(src.getStatusElement()));
        }
        for (CodeableConcept codeableConcept : src.getStatusReason()) {
            tgt.addStatusReason(Device40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasDistinctIdentifier()) {
            tgt.setDistinctIdentifierElement(Device40_50.convertString(src.getDistinctIdentifierElement()));
        }
        if (src.hasManufacturer()) {
            tgt.setManufacturerElement(Device40_50.convertString(src.getManufacturerElement()));
        }
        if (src.hasManufactureDate()) {
            tgt.setManufactureDateElement(Device40_50.convertDateTime(src.getManufactureDateElement()));
        }
        if (src.hasExpirationDate()) {
            tgt.setExpirationDateElement(Device40_50.convertDateTime(src.getExpirationDateElement()));
        }
        if (src.hasLotNumber()) {
            tgt.setLotNumberElement(Device40_50.convertString(src.getLotNumberElement()));
        }
        if (src.hasSerialNumber()) {
            tgt.setSerialNumberElement(Device40_50.convertString(src.getSerialNumberElement()));
        }
        for (Device.DeviceDeviceNameComponent deviceDeviceNameComponent : src.getDeviceName()) {
            tgt.addDeviceName(Device40_50.convertDeviceDeviceNameComponent(deviceDeviceNameComponent));
        }
        if (src.hasModelNumber()) {
            tgt.setModelNumberElement(Device40_50.convertString(src.getModelNumberElement()));
        }
        if (src.hasPartNumber()) {
            tgt.setPartNumberElement(Device40_50.convertString(src.getPartNumberElement()));
        }
        if (src.hasType()) {
            tgt.setType(Device40_50.convertCodeableConcept(src.getTypeFirstRep()));
        }
        for (Device.DeviceSpecializationComponent deviceSpecializationComponent : src.getSpecialization()) {
            tgt.addSpecialization(Device40_50.convertDeviceSpecializationComponent(deviceSpecializationComponent));
        }
        for (Device.DeviceVersionComponent deviceVersionComponent : src.getVersion()) {
            tgt.addVersion(Device40_50.convertDeviceVersionComponent(deviceVersionComponent));
        }
        for (Device.DevicePropertyComponent devicePropertyComponent : src.getProperty()) {
            tgt.addProperty(Device40_50.convertDevicePropertyComponent(devicePropertyComponent));
        }
        if (src.hasPatient()) {
            tgt.setPatient(Device40_50.convertReference(src.getPatient()));
        }
        if (src.hasOwner()) {
            tgt.setOwner(Device40_50.convertReference(src.getOwner()));
        }
        for (org.hl7.fhir.r5.model.ContactPoint contactPoint : src.getContact()) {
            tgt.addContact(Device40_50.convertContactPoint(contactPoint));
        }
        if (src.hasLocation()) {
            tgt.setLocation(Device40_50.convertReference(src.getLocation()));
        }
        if (src.hasUrl()) {
            tgt.setUrlElement(Device40_50.convertUri(src.getUrlElement()));
        }
        for (Annotation annotation : src.getNote()) {
            tgt.addNote(Device40_50.convertAnnotation(annotation));
        }
        for (CodeableConcept codeableConcept : src.getSafety()) {
            tgt.addSafety(Device40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasParent()) {
            tgt.setParent(Device40_50.convertReference(src.getParent()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Device.FHIRDeviceStatus> convertFHIRDeviceStatus(Enumeration<Device.FHIRDeviceStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Device.FHIRDeviceStatus> tgt = new org.hl7.fhir.r5.model.Enumeration<Device.FHIRDeviceStatus>(new Device.FHIRDeviceStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Device.FHIRDeviceStatus)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)Device.FHIRDeviceStatus.ACTIVE);
                break;
            }
            case INACTIVE: {
                tgt.setValue((Object)Device.FHIRDeviceStatus.INACTIVE);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Device.FHIRDeviceStatus.ENTEREDINERROR);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)Device.FHIRDeviceStatus.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)Device.FHIRDeviceStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Device.FHIRDeviceStatus> convertFHIRDeviceStatus(org.hl7.fhir.r5.model.Enumeration<Device.FHIRDeviceStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Device.FHIRDeviceStatus> tgt = new Enumeration<Device.FHIRDeviceStatus>(new Device.FHIRDeviceStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Device.FHIRDeviceStatus)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)Device.FHIRDeviceStatus.ACTIVE);
                break;
            }
            case INACTIVE: {
                tgt.setValue((Object)Device.FHIRDeviceStatus.INACTIVE);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Device.FHIRDeviceStatus.ENTEREDINERROR);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)Device.FHIRDeviceStatus.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)Device.FHIRDeviceStatus.NULL);
            }
        }
        return tgt;
    }

    public static Device.DeviceUdiCarrierComponent convertDeviceUdiCarrierComponent(Device.DeviceUdiCarrierComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Device.DeviceUdiCarrierComponent tgt = new Device.DeviceUdiCarrierComponent();
        Device40_50.copyElement(src, tgt, new String[0]);
        if (src.hasDeviceIdentifier()) {
            tgt.setDeviceIdentifierElement(Device40_50.convertString(src.getDeviceIdentifierElement()));
        }
        if (src.hasIssuer()) {
            tgt.setIssuerElement(Device40_50.convertUri(src.getIssuerElement()));
        }
        if (src.hasJurisdiction()) {
            tgt.setJurisdictionElement(Device40_50.convertUri(src.getJurisdictionElement()));
        }
        if (src.hasCarrierAIDC()) {
            tgt.setCarrierAIDCElement(Device40_50.convertBase64Binary(src.getCarrierAIDCElement()));
        }
        if (src.hasCarrierHRF()) {
            tgt.setCarrierHRFElement(Device40_50.convertString(src.getCarrierHRFElement()));
        }
        if (src.hasEntryType()) {
            tgt.setEntryTypeElement(Device40_50.convertUDIEntryType(src.getEntryTypeElement()));
        }
        return tgt;
    }

    public static Device.DeviceUdiCarrierComponent convertDeviceUdiCarrierComponent(Device.DeviceUdiCarrierComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Device.DeviceUdiCarrierComponent tgt = new Device.DeviceUdiCarrierComponent();
        Device40_50.copyElement(src, tgt, new String[0]);
        if (src.hasDeviceIdentifier()) {
            tgt.setDeviceIdentifierElement(Device40_50.convertString(src.getDeviceIdentifierElement()));
        }
        if (src.hasIssuer()) {
            tgt.setIssuerElement(Device40_50.convertUri(src.getIssuerElement()));
        }
        if (src.hasJurisdiction()) {
            tgt.setJurisdictionElement(Device40_50.convertUri(src.getJurisdictionElement()));
        }
        if (src.hasCarrierAIDC()) {
            tgt.setCarrierAIDCElement(Device40_50.convertBase64Binary(src.getCarrierAIDCElement()));
        }
        if (src.hasCarrierHRF()) {
            tgt.setCarrierHRFElement(Device40_50.convertString(src.getCarrierHRFElement()));
        }
        if (src.hasEntryType()) {
            tgt.setEntryTypeElement(Device40_50.convertUDIEntryType(src.getEntryTypeElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Device.UDIEntryType> convertUDIEntryType(Enumeration<Device.UDIEntryType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Device.UDIEntryType> tgt = new org.hl7.fhir.r5.model.Enumeration<Device.UDIEntryType>(new Device.UDIEntryTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Device.UDIEntryType)((Object)src.getValue())) {
            case BARCODE: {
                tgt.setValue((Object)Device.UDIEntryType.BARCODE);
                break;
            }
            case RFID: {
                tgt.setValue((Object)Device.UDIEntryType.RFID);
                break;
            }
            case MANUAL: {
                tgt.setValue((Object)Device.UDIEntryType.MANUAL);
                break;
            }
            case CARD: {
                tgt.setValue((Object)Device.UDIEntryType.CARD);
                break;
            }
            case SELFREPORTED: {
                tgt.setValue((Object)Device.UDIEntryType.SELFREPORTED);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)Device.UDIEntryType.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)Device.UDIEntryType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Device.UDIEntryType> convertUDIEntryType(org.hl7.fhir.r5.model.Enumeration<Device.UDIEntryType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Device.UDIEntryType> tgt = new Enumeration<Device.UDIEntryType>(new Device.UDIEntryTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Device.UDIEntryType)((Object)src.getValue())) {
            case BARCODE: {
                tgt.setValue((Object)Device.UDIEntryType.BARCODE);
                break;
            }
            case RFID: {
                tgt.setValue((Object)Device.UDIEntryType.RFID);
                break;
            }
            case MANUAL: {
                tgt.setValue((Object)Device.UDIEntryType.MANUAL);
                break;
            }
            case CARD: {
                tgt.setValue((Object)Device.UDIEntryType.CARD);
                break;
            }
            case SELFREPORTED: {
                tgt.setValue((Object)Device.UDIEntryType.SELFREPORTED);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)Device.UDIEntryType.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)Device.UDIEntryType.NULL);
            }
        }
        return tgt;
    }

    public static Device.DeviceDeviceNameComponent convertDeviceDeviceNameComponent(Device.DeviceDeviceNameComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Device.DeviceDeviceNameComponent tgt = new Device.DeviceDeviceNameComponent();
        Device40_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(Device40_50.convertString(src.getNameElement()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(Device40_50.convertDeviceNameType(src.getTypeElement()));
        }
        return tgt;
    }

    public static Device.DeviceDeviceNameComponent convertDeviceDeviceNameComponent(Device.DeviceDeviceNameComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Device.DeviceDeviceNameComponent tgt = new Device.DeviceDeviceNameComponent();
        Device40_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(Device40_50.convertString(src.getNameElement()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(Device40_50.convertDeviceNameType(src.getTypeElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.DeviceNameType> convertDeviceNameType(Enumeration<Device.DeviceNameType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.DeviceNameType> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.DeviceNameType>(new Enumerations.DeviceNameTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Device.DeviceNameType)((Object)src.getValue())) {
            case UDILABELNAME: {
                tgt.setValue((Object)Enumerations.DeviceNameType.UDILABELNAME);
                break;
            }
            case USERFRIENDLYNAME: {
                tgt.setValue((Object)Enumerations.DeviceNameType.USERFRIENDLYNAME);
                break;
            }
            case PATIENTREPORTEDNAME: {
                tgt.setValue((Object)Enumerations.DeviceNameType.PATIENTREPORTEDNAME);
                break;
            }
            case MANUFACTURERNAME: {
                tgt.setValue((Object)Enumerations.DeviceNameType.MANUFACTURERNAME);
                break;
            }
            case MODELNAME: {
                tgt.setValue((Object)Enumerations.DeviceNameType.MODELNAME);
                break;
            }
            case OTHER: {
                tgt.setValue((Object)Enumerations.DeviceNameType.OTHER);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.DeviceNameType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Device.DeviceNameType> convertDeviceNameType(org.hl7.fhir.r5.model.Enumeration<Enumerations.DeviceNameType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Device.DeviceNameType> tgt = new Enumeration<Device.DeviceNameType>(new Device.DeviceNameTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.DeviceNameType)((Object)src.getValue())) {
            case UDILABELNAME: {
                tgt.setValue((Object)Device.DeviceNameType.UDILABELNAME);
                break;
            }
            case USERFRIENDLYNAME: {
                tgt.setValue((Object)Device.DeviceNameType.USERFRIENDLYNAME);
                break;
            }
            case PATIENTREPORTEDNAME: {
                tgt.setValue((Object)Device.DeviceNameType.PATIENTREPORTEDNAME);
                break;
            }
            case MANUFACTURERNAME: {
                tgt.setValue((Object)Device.DeviceNameType.MANUFACTURERNAME);
                break;
            }
            case MODELNAME: {
                tgt.setValue((Object)Device.DeviceNameType.MODELNAME);
                break;
            }
            case OTHER: {
                tgt.setValue((Object)Device.DeviceNameType.OTHER);
                break;
            }
            default: {
                tgt.setValue((Object)Device.DeviceNameType.NULL);
            }
        }
        return tgt;
    }

    public static Device.DeviceSpecializationComponent convertDeviceSpecializationComponent(Device.DeviceSpecializationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Device.DeviceSpecializationComponent tgt = new Device.DeviceSpecializationComponent();
        Device40_50.copyElement(src, tgt, new String[0]);
        if (src.hasSystemType()) {
            tgt.setSystemType(Device40_50.convertCodeableConcept(src.getSystemType()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(Device40_50.convertString(src.getVersionElement()));
        }
        return tgt;
    }

    public static Device.DeviceSpecializationComponent convertDeviceSpecializationComponent(Device.DeviceSpecializationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Device.DeviceSpecializationComponent tgt = new Device.DeviceSpecializationComponent();
        Device40_50.copyElement(src, tgt, new String[0]);
        if (src.hasSystemType()) {
            tgt.setSystemType(Device40_50.convertCodeableConcept(src.getSystemType()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(Device40_50.convertString(src.getVersionElement()));
        }
        return tgt;
    }

    public static Device.DeviceVersionComponent convertDeviceVersionComponent(Device.DeviceVersionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Device.DeviceVersionComponent tgt = new Device.DeviceVersionComponent();
        Device40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(Device40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasComponent()) {
            tgt.setComponent(Device40_50.convertIdentifier(src.getComponent()));
        }
        if (src.hasValue()) {
            tgt.setValueElement(Device40_50.convertString(src.getValueElement()));
        }
        return tgt;
    }

    public static Device.DeviceVersionComponent convertDeviceVersionComponent(Device.DeviceVersionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Device.DeviceVersionComponent tgt = new Device.DeviceVersionComponent();
        Device40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(Device40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasComponent()) {
            tgt.setComponent(Device40_50.convertIdentifier(src.getComponent()));
        }
        if (src.hasValue()) {
            tgt.setValueElement(Device40_50.convertString(src.getValueElement()));
        }
        return tgt;
    }

    public static Device.DevicePropertyComponent convertDevicePropertyComponent(Device.DevicePropertyComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Device.DevicePropertyComponent tgt = new Device.DevicePropertyComponent();
        Device40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(Device40_50.convertCodeableConcept(src.getType()));
        }
        for (Quantity quantity : src.getValueQuantity()) {
            tgt.setValue(Device40_50.convertQuantity(quantity));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getValueCode()) {
            tgt.setValue(Device40_50.convertCodeableConcept(codeableConcept));
        }
        return tgt;
    }

    public static Device.DevicePropertyComponent convertDevicePropertyComponent(Device.DevicePropertyComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Device.DevicePropertyComponent tgt = new Device.DevicePropertyComponent();
        Device40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(Device40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasValueQuantity()) {
            tgt.addValueQuantity(Device40_50.convertQuantity(src.getValueQuantity()));
        }
        if (src.hasValueCodeableConcept()) {
            tgt.addValueCode(Device40_50.convertCodeableConcept(src.getValueCodeableConcept()));
        }
        return tgt;
    }
}

