/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Contract;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Period;
import org.hl7.fhir.r4.model.Signature;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Contract;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.UnsignedIntType;

public class Contract40_50
extends VersionConvertor_40_50 {
    public static Contract convertContract(org.hl7.fhir.r4.model.Contract src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Contract tgt = new Contract();
        Contract40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r4.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(Contract40_50.convertIdentifier(identifier));
        }
        if (src.hasUrl()) {
            tgt.setUrlElement(Contract40_50.convertUri(src.getUrlElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(Contract40_50.convertString(src.getVersionElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Contract40_50.convertContractStatus(src.getStatusElement()));
        }
        if (src.hasLegalState()) {
            tgt.setLegalState(Contract40_50.convertCodeableConcept(src.getLegalState()));
        }
        if (src.hasInstantiatesCanonical()) {
            tgt.setInstantiatesCanonical(Contract40_50.convertReference(src.getInstantiatesCanonical()));
        }
        if (src.hasInstantiatesUri()) {
            tgt.setInstantiatesUriElement(Contract40_50.convertUri(src.getInstantiatesUriElement()));
        }
        if (src.hasContentDerivative()) {
            tgt.setContentDerivative(Contract40_50.convertCodeableConcept(src.getContentDerivative()));
        }
        if (src.hasIssued()) {
            tgt.setIssuedElement(Contract40_50.convertDateTime(src.getIssuedElement()));
        }
        if (src.hasApplies()) {
            tgt.setApplies(Contract40_50.convertPeriod(src.getApplies()));
        }
        if (src.hasExpirationType()) {
            tgt.setExpirationType(Contract40_50.convertCodeableConcept(src.getExpirationType()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getSubject()) {
            tgt.addSubject(Contract40_50.convertReference(reference));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getAuthority()) {
            tgt.addAuthority(Contract40_50.convertReference(reference));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getDomain()) {
            tgt.addDomain(Contract40_50.convertReference(reference));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getSite()) {
            tgt.addSite(Contract40_50.convertReference(reference));
        }
        if (src.hasName()) {
            tgt.setNameElement(Contract40_50.convertString(src.getNameElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(Contract40_50.convertString(src.getTitleElement()));
        }
        if (src.hasSubtitle()) {
            tgt.setSubtitleElement(Contract40_50.convertString(src.getSubtitleElement()));
        }
        for (org.hl7.fhir.r4.model.StringType stringType : src.getAlias()) {
            tgt.getAlias().add(Contract40_50.convertString(stringType));
        }
        if (src.hasAuthor()) {
            tgt.setAuthor(Contract40_50.convertReference(src.getAuthor()));
        }
        if (src.hasScope()) {
            tgt.setScope(Contract40_50.convertCodeableConcept(src.getScope()));
        }
        if (src.hasTopic()) {
            tgt.setTopic(Contract40_50.convertType(src.getTopic()));
        }
        if (src.hasType()) {
            tgt.setType(Contract40_50.convertCodeableConcept(src.getType()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getSubType()) {
            tgt.addSubType(Contract40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasContentDefinition()) {
            tgt.setContentDefinition(Contract40_50.convertContentDefinitionComponent(src.getContentDefinition()));
        }
        for (Contract.TermComponent termComponent : src.getTerm()) {
            tgt.addTerm(Contract40_50.convertTermComponent(termComponent));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getSupportingInfo()) {
            tgt.addSupportingInfo(Contract40_50.convertReference(reference));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getRelevantHistory()) {
            tgt.addRelevantHistory(Contract40_50.convertReference(reference));
        }
        for (Contract.SignatoryComponent signatoryComponent : src.getSigner()) {
            tgt.addSigner(Contract40_50.convertSignatoryComponent(signatoryComponent));
        }
        for (Contract.FriendlyLanguageComponent friendlyLanguageComponent : src.getFriendly()) {
            tgt.addFriendly(Contract40_50.convertFriendlyLanguageComponent(friendlyLanguageComponent));
        }
        for (Contract.LegalLanguageComponent legalLanguageComponent : src.getLegal()) {
            tgt.addLegal(Contract40_50.convertLegalLanguageComponent(legalLanguageComponent));
        }
        for (Contract.ComputableLanguageComponent computableLanguageComponent : src.getRule()) {
            tgt.addRule(Contract40_50.convertComputableLanguageComponent(computableLanguageComponent));
        }
        if (src.hasLegallyBinding()) {
            tgt.setLegallyBinding(Contract40_50.convertType(src.getLegallyBinding()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Contract convertContract(Contract src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Contract tgt = new org.hl7.fhir.r4.model.Contract();
        Contract40_50.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(Contract40_50.convertIdentifier(identifier));
        }
        if (src.hasUrl()) {
            tgt.setUrlElement(Contract40_50.convertUri(src.getUrlElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(Contract40_50.convertString(src.getVersionElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Contract40_50.convertContractStatus(src.getStatusElement()));
        }
        if (src.hasLegalState()) {
            tgt.setLegalState(Contract40_50.convertCodeableConcept(src.getLegalState()));
        }
        if (src.hasInstantiatesCanonical()) {
            tgt.setInstantiatesCanonical(Contract40_50.convertReference(src.getInstantiatesCanonical()));
        }
        if (src.hasInstantiatesUri()) {
            tgt.setInstantiatesUriElement(Contract40_50.convertUri(src.getInstantiatesUriElement()));
        }
        if (src.hasContentDerivative()) {
            tgt.setContentDerivative(Contract40_50.convertCodeableConcept(src.getContentDerivative()));
        }
        if (src.hasIssued()) {
            tgt.setIssuedElement(Contract40_50.convertDateTime(src.getIssuedElement()));
        }
        if (src.hasApplies()) {
            tgt.setApplies(Contract40_50.convertPeriod(src.getApplies()));
        }
        if (src.hasExpirationType()) {
            tgt.setExpirationType(Contract40_50.convertCodeableConcept(src.getExpirationType()));
        }
        for (Reference reference : src.getSubject()) {
            tgt.addSubject(Contract40_50.convertReference(reference));
        }
        for (Reference reference : src.getAuthority()) {
            tgt.addAuthority(Contract40_50.convertReference(reference));
        }
        for (Reference reference : src.getDomain()) {
            tgt.addDomain(Contract40_50.convertReference(reference));
        }
        for (Reference reference : src.getSite()) {
            tgt.addSite(Contract40_50.convertReference(reference));
        }
        if (src.hasName()) {
            tgt.setNameElement(Contract40_50.convertString(src.getNameElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(Contract40_50.convertString(src.getTitleElement()));
        }
        if (src.hasSubtitle()) {
            tgt.setSubtitleElement(Contract40_50.convertString(src.getSubtitleElement()));
        }
        for (StringType stringType : src.getAlias()) {
            tgt.getAlias().add(Contract40_50.convertString(stringType));
        }
        if (src.hasAuthor()) {
            tgt.setAuthor(Contract40_50.convertReference(src.getAuthor()));
        }
        if (src.hasScope()) {
            tgt.setScope(Contract40_50.convertCodeableConcept(src.getScope()));
        }
        if (src.hasTopic()) {
            tgt.setTopic(Contract40_50.convertType(src.getTopic()));
        }
        if (src.hasType()) {
            tgt.setType(Contract40_50.convertCodeableConcept(src.getType()));
        }
        for (CodeableConcept codeableConcept : src.getSubType()) {
            tgt.addSubType(Contract40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasContentDefinition()) {
            tgt.setContentDefinition(Contract40_50.convertContentDefinitionComponent(src.getContentDefinition()));
        }
        for (Contract.TermComponent termComponent : src.getTerm()) {
            tgt.addTerm(Contract40_50.convertTermComponent(termComponent));
        }
        for (Reference reference : src.getSupportingInfo()) {
            tgt.addSupportingInfo(Contract40_50.convertReference(reference));
        }
        for (Reference reference : src.getRelevantHistory()) {
            tgt.addRelevantHistory(Contract40_50.convertReference(reference));
        }
        for (Contract.SignatoryComponent signatoryComponent : src.getSigner()) {
            tgt.addSigner(Contract40_50.convertSignatoryComponent(signatoryComponent));
        }
        for (Contract.FriendlyLanguageComponent friendlyLanguageComponent : src.getFriendly()) {
            tgt.addFriendly(Contract40_50.convertFriendlyLanguageComponent(friendlyLanguageComponent));
        }
        for (Contract.LegalLanguageComponent legalLanguageComponent : src.getLegal()) {
            tgt.addLegal(Contract40_50.convertLegalLanguageComponent(legalLanguageComponent));
        }
        for (Contract.ComputableLanguageComponent computableLanguageComponent : src.getRule()) {
            tgt.addRule(Contract40_50.convertComputableLanguageComponent(computableLanguageComponent));
        }
        if (src.hasLegallyBinding()) {
            tgt.setLegallyBinding(Contract40_50.convertType(src.getLegallyBinding()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Contract.ContractResourceStatusCodes> convertContractStatus(Enumeration<Contract.ContractStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Contract.ContractResourceStatusCodes> tgt = new org.hl7.fhir.r5.model.Enumeration<Contract.ContractResourceStatusCodes>(new Contract.ContractResourceStatusCodesEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Contract.ContractStatus)((Object)src.getValue())) {
            case AMENDED: {
                tgt.setValue((Object)Contract.ContractResourceStatusCodes.AMENDED);
                break;
            }
            case APPENDED: {
                tgt.setValue((Object)Contract.ContractResourceStatusCodes.APPENDED);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)Contract.ContractResourceStatusCodes.CANCELLED);
                break;
            }
            case DISPUTED: {
                tgt.setValue((Object)Contract.ContractResourceStatusCodes.DISPUTED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Contract.ContractResourceStatusCodes.ENTEREDINERROR);
                break;
            }
            case EXECUTABLE: {
                tgt.setValue((Object)Contract.ContractResourceStatusCodes.EXECUTABLE);
                break;
            }
            case EXECUTED: {
                tgt.setValue((Object)Contract.ContractResourceStatusCodes.EXECUTED);
                break;
            }
            case NEGOTIABLE: {
                tgt.setValue((Object)Contract.ContractResourceStatusCodes.NEGOTIABLE);
                break;
            }
            case OFFERED: {
                tgt.setValue((Object)Contract.ContractResourceStatusCodes.OFFERED);
                break;
            }
            case POLICY: {
                tgt.setValue((Object)Contract.ContractResourceStatusCodes.POLICY);
                break;
            }
            case REJECTED: {
                tgt.setValue((Object)Contract.ContractResourceStatusCodes.REJECTED);
                break;
            }
            case RENEWED: {
                tgt.setValue((Object)Contract.ContractResourceStatusCodes.RENEWED);
                break;
            }
            case REVOKED: {
                tgt.setValue((Object)Contract.ContractResourceStatusCodes.REVOKED);
                break;
            }
            case RESOLVED: {
                tgt.setValue((Object)Contract.ContractResourceStatusCodes.RESOLVED);
                break;
            }
            case TERMINATED: {
                tgt.setValue((Object)Contract.ContractResourceStatusCodes.TERMINATED);
                break;
            }
            default: {
                tgt.setValue((Object)Contract.ContractResourceStatusCodes.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Contract.ContractStatus> convertContractStatus(org.hl7.fhir.r5.model.Enumeration<Contract.ContractResourceStatusCodes> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Contract.ContractStatus> tgt = new Enumeration<Contract.ContractStatus>(new Contract.ContractStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Contract.ContractResourceStatusCodes)((Object)src.getValue())) {
            case AMENDED: {
                tgt.setValue((Object)Contract.ContractStatus.AMENDED);
                break;
            }
            case APPENDED: {
                tgt.setValue((Object)Contract.ContractStatus.APPENDED);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)Contract.ContractStatus.CANCELLED);
                break;
            }
            case DISPUTED: {
                tgt.setValue((Object)Contract.ContractStatus.DISPUTED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Contract.ContractStatus.ENTEREDINERROR);
                break;
            }
            case EXECUTABLE: {
                tgt.setValue((Object)Contract.ContractStatus.EXECUTABLE);
                break;
            }
            case EXECUTED: {
                tgt.setValue((Object)Contract.ContractStatus.EXECUTED);
                break;
            }
            case NEGOTIABLE: {
                tgt.setValue((Object)Contract.ContractStatus.NEGOTIABLE);
                break;
            }
            case OFFERED: {
                tgt.setValue((Object)Contract.ContractStatus.OFFERED);
                break;
            }
            case POLICY: {
                tgt.setValue((Object)Contract.ContractStatus.POLICY);
                break;
            }
            case REJECTED: {
                tgt.setValue((Object)Contract.ContractStatus.REJECTED);
                break;
            }
            case RENEWED: {
                tgt.setValue((Object)Contract.ContractStatus.RENEWED);
                break;
            }
            case REVOKED: {
                tgt.setValue((Object)Contract.ContractStatus.REVOKED);
                break;
            }
            case RESOLVED: {
                tgt.setValue((Object)Contract.ContractStatus.RESOLVED);
                break;
            }
            case TERMINATED: {
                tgt.setValue((Object)Contract.ContractStatus.TERMINATED);
                break;
            }
            default: {
                tgt.setValue((Object)Contract.ContractStatus.NULL);
            }
        }
        return tgt;
    }

    public static Contract.ContentDefinitionComponent convertContentDefinitionComponent(Contract.ContentDefinitionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Contract.ContentDefinitionComponent tgt = new Contract.ContentDefinitionComponent();
        Contract40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(Contract40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasSubType()) {
            tgt.setSubType(Contract40_50.convertCodeableConcept(src.getSubType()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisher(Contract40_50.convertReference(src.getPublisher()));
        }
        if (src.hasPublicationDate()) {
            tgt.setPublicationDateElement(Contract40_50.convertDateTime(src.getPublicationDateElement()));
        }
        if (src.hasPublicationStatus()) {
            tgt.setPublicationStatusElement(Contract40_50.convertContractPublicationStatus(src.getPublicationStatusElement()));
        }
        if (src.hasCopyright()) {
            tgt.setCopyrightElement(Contract40_50.convertMarkdown(src.getCopyrightElement()));
        }
        return tgt;
    }

    public static Contract.ContentDefinitionComponent convertContentDefinitionComponent(Contract.ContentDefinitionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Contract.ContentDefinitionComponent tgt = new Contract.ContentDefinitionComponent();
        Contract40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(Contract40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasSubType()) {
            tgt.setSubType(Contract40_50.convertCodeableConcept(src.getSubType()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisher(Contract40_50.convertReference(src.getPublisher()));
        }
        if (src.hasPublicationDate()) {
            tgt.setPublicationDateElement(Contract40_50.convertDateTime(src.getPublicationDateElement()));
        }
        if (src.hasPublicationStatus()) {
            tgt.setPublicationStatusElement(Contract40_50.convertContractPublicationStatus(src.getPublicationStatusElement()));
        }
        if (src.hasCopyright()) {
            tgt.setCopyrightElement(Contract40_50.convertMarkdown(src.getCopyrightElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Contract.ContractResourcePublicationStatusCodes> convertContractPublicationStatus(Enumeration<Contract.ContractPublicationStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Contract.ContractResourcePublicationStatusCodes> tgt = new org.hl7.fhir.r5.model.Enumeration<Contract.ContractResourcePublicationStatusCodes>(new Contract.ContractResourcePublicationStatusCodesEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Contract.ContractPublicationStatus)((Object)src.getValue())) {
            case AMENDED: {
                tgt.setValue((Object)Contract.ContractResourcePublicationStatusCodes.AMENDED);
                break;
            }
            case APPENDED: {
                tgt.setValue((Object)Contract.ContractResourcePublicationStatusCodes.APPENDED);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)Contract.ContractResourcePublicationStatusCodes.CANCELLED);
                break;
            }
            case DISPUTED: {
                tgt.setValue((Object)Contract.ContractResourcePublicationStatusCodes.DISPUTED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Contract.ContractResourcePublicationStatusCodes.ENTEREDINERROR);
                break;
            }
            case EXECUTABLE: {
                tgt.setValue((Object)Contract.ContractResourcePublicationStatusCodes.EXECUTABLE);
                break;
            }
            case EXECUTED: {
                tgt.setValue((Object)Contract.ContractResourcePublicationStatusCodes.EXECUTED);
                break;
            }
            case NEGOTIABLE: {
                tgt.setValue((Object)Contract.ContractResourcePublicationStatusCodes.NEGOTIABLE);
                break;
            }
            case OFFERED: {
                tgt.setValue((Object)Contract.ContractResourcePublicationStatusCodes.OFFERED);
                break;
            }
            case POLICY: {
                tgt.setValue((Object)Contract.ContractResourcePublicationStatusCodes.POLICY);
                break;
            }
            case REJECTED: {
                tgt.setValue((Object)Contract.ContractResourcePublicationStatusCodes.REJECTED);
                break;
            }
            case RENEWED: {
                tgt.setValue((Object)Contract.ContractResourcePublicationStatusCodes.RENEWED);
                break;
            }
            case REVOKED: {
                tgt.setValue((Object)Contract.ContractResourcePublicationStatusCodes.REVOKED);
                break;
            }
            case RESOLVED: {
                tgt.setValue((Object)Contract.ContractResourcePublicationStatusCodes.RESOLVED);
                break;
            }
            case TERMINATED: {
                tgt.setValue((Object)Contract.ContractResourcePublicationStatusCodes.TERMINATED);
                break;
            }
            default: {
                tgt.setValue((Object)Contract.ContractResourcePublicationStatusCodes.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Contract.ContractPublicationStatus> convertContractPublicationStatus(org.hl7.fhir.r5.model.Enumeration<Contract.ContractResourcePublicationStatusCodes> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Contract.ContractPublicationStatus> tgt = new Enumeration<Contract.ContractPublicationStatus>(new Contract.ContractPublicationStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Contract.ContractResourcePublicationStatusCodes)((Object)src.getValue())) {
            case AMENDED: {
                tgt.setValue((Object)Contract.ContractPublicationStatus.AMENDED);
                break;
            }
            case APPENDED: {
                tgt.setValue((Object)Contract.ContractPublicationStatus.APPENDED);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)Contract.ContractPublicationStatus.CANCELLED);
                break;
            }
            case DISPUTED: {
                tgt.setValue((Object)Contract.ContractPublicationStatus.DISPUTED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Contract.ContractPublicationStatus.ENTEREDINERROR);
                break;
            }
            case EXECUTABLE: {
                tgt.setValue((Object)Contract.ContractPublicationStatus.EXECUTABLE);
                break;
            }
            case EXECUTED: {
                tgt.setValue((Object)Contract.ContractPublicationStatus.EXECUTED);
                break;
            }
            case NEGOTIABLE: {
                tgt.setValue((Object)Contract.ContractPublicationStatus.NEGOTIABLE);
                break;
            }
            case OFFERED: {
                tgt.setValue((Object)Contract.ContractPublicationStatus.OFFERED);
                break;
            }
            case POLICY: {
                tgt.setValue((Object)Contract.ContractPublicationStatus.POLICY);
                break;
            }
            case REJECTED: {
                tgt.setValue((Object)Contract.ContractPublicationStatus.REJECTED);
                break;
            }
            case RENEWED: {
                tgt.setValue((Object)Contract.ContractPublicationStatus.RENEWED);
                break;
            }
            case REVOKED: {
                tgt.setValue((Object)Contract.ContractPublicationStatus.REVOKED);
                break;
            }
            case RESOLVED: {
                tgt.setValue((Object)Contract.ContractPublicationStatus.RESOLVED);
                break;
            }
            case TERMINATED: {
                tgt.setValue((Object)Contract.ContractPublicationStatus.TERMINATED);
                break;
            }
            default: {
                tgt.setValue((Object)Contract.ContractPublicationStatus.NULL);
            }
        }
        return tgt;
    }

    public static Contract.TermComponent convertTermComponent(Contract.TermComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Contract.TermComponent tgt = new Contract.TermComponent();
        Contract40_50.copyElement(src, tgt, new String[0]);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(Contract40_50.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasIssued()) {
            tgt.setIssuedElement(Contract40_50.convertDateTime(src.getIssuedElement()));
        }
        if (src.hasApplies()) {
            tgt.setApplies(Contract40_50.convertPeriod(src.getApplies()));
        }
        if (src.hasTopic()) {
            tgt.setTopic(Contract40_50.convertType(src.getTopic()));
        }
        if (src.hasType()) {
            tgt.setType(Contract40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasSubType()) {
            tgt.setSubType(Contract40_50.convertCodeableConcept(src.getSubType()));
        }
        if (src.hasText()) {
            tgt.setTextElement(Contract40_50.convertString(src.getTextElement()));
        }
        for (Contract.SecurityLabelComponent securityLabelComponent : src.getSecurityLabel()) {
            tgt.addSecurityLabel(Contract40_50.convertSecurityLabelComponent(securityLabelComponent));
        }
        if (src.hasOffer()) {
            tgt.setOffer(Contract40_50.convertContractOfferComponent(src.getOffer()));
        }
        for (Contract.ContractAssetComponent contractAssetComponent : src.getAsset()) {
            tgt.addAsset(Contract40_50.convertContractAssetComponent(contractAssetComponent));
        }
        for (Contract.ActionComponent actionComponent : src.getAction()) {
            tgt.addAction(Contract40_50.convertActionComponent(actionComponent));
        }
        for (Contract.TermComponent termComponent : src.getGroup()) {
            tgt.addGroup(Contract40_50.convertTermComponent(termComponent));
        }
        return tgt;
    }

    public static Contract.TermComponent convertTermComponent(Contract.TermComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Contract.TermComponent tgt = new Contract.TermComponent();
        Contract40_50.copyElement(src, tgt, new String[0]);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(Contract40_50.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasIssued()) {
            tgt.setIssuedElement(Contract40_50.convertDateTime(src.getIssuedElement()));
        }
        if (src.hasApplies()) {
            tgt.setApplies(Contract40_50.convertPeriod(src.getApplies()));
        }
        if (src.hasTopic()) {
            tgt.setTopic(Contract40_50.convertType(src.getTopic()));
        }
        if (src.hasType()) {
            tgt.setType(Contract40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasSubType()) {
            tgt.setSubType(Contract40_50.convertCodeableConcept(src.getSubType()));
        }
        if (src.hasText()) {
            tgt.setTextElement(Contract40_50.convertString(src.getTextElement()));
        }
        for (Contract.SecurityLabelComponent securityLabelComponent : src.getSecurityLabel()) {
            tgt.addSecurityLabel(Contract40_50.convertSecurityLabelComponent(securityLabelComponent));
        }
        if (src.hasOffer()) {
            tgt.setOffer(Contract40_50.convertContractOfferComponent(src.getOffer()));
        }
        for (Contract.ContractAssetComponent contractAssetComponent : src.getAsset()) {
            tgt.addAsset(Contract40_50.convertContractAssetComponent(contractAssetComponent));
        }
        for (Contract.ActionComponent actionComponent : src.getAction()) {
            tgt.addAction(Contract40_50.convertActionComponent(actionComponent));
        }
        for (Contract.TermComponent termComponent : src.getGroup()) {
            tgt.addGroup(Contract40_50.convertTermComponent(termComponent));
        }
        return tgt;
    }

    public static Contract.SecurityLabelComponent convertSecurityLabelComponent(Contract.SecurityLabelComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Contract.SecurityLabelComponent tgt = new Contract.SecurityLabelComponent();
        Contract40_50.copyElement(src, tgt, new String[0]);
        for (org.hl7.fhir.r4.model.UnsignedIntType unsignedIntType : src.getNumber()) {
            tgt.getNumber().add(Contract40_50.convertUnsignedInt(unsignedIntType));
        }
        if (src.hasClassification()) {
            tgt.setClassification(Contract40_50.convertCoding(src.getClassification()));
        }
        for (org.hl7.fhir.r4.model.Coding coding : src.getCategory()) {
            tgt.addCategory(Contract40_50.convertCoding(coding));
        }
        for (org.hl7.fhir.r4.model.Coding coding : src.getControl()) {
            tgt.addControl(Contract40_50.convertCoding(coding));
        }
        return tgt;
    }

    public static Contract.SecurityLabelComponent convertSecurityLabelComponent(Contract.SecurityLabelComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Contract.SecurityLabelComponent tgt = new Contract.SecurityLabelComponent();
        Contract40_50.copyElement(src, tgt, new String[0]);
        for (UnsignedIntType unsignedIntType : src.getNumber()) {
            tgt.getNumber().add(Contract40_50.convertUnsignedInt(unsignedIntType));
        }
        if (src.hasClassification()) {
            tgt.setClassification(Contract40_50.convertCoding(src.getClassification()));
        }
        for (Coding coding : src.getCategory()) {
            tgt.addCategory(Contract40_50.convertCoding(coding));
        }
        for (Coding coding : src.getControl()) {
            tgt.addControl(Contract40_50.convertCoding(coding));
        }
        return tgt;
    }

    public static Contract.ContractOfferComponent convertContractOfferComponent(Contract.ContractOfferComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Contract.ContractOfferComponent tgt = new Contract.ContractOfferComponent();
        Contract40_50.copyElement(src, tgt, new String[0]);
        for (org.hl7.fhir.r4.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(Contract40_50.convertIdentifier(identifier));
        }
        for (Contract.ContractPartyComponent contractPartyComponent : src.getParty()) {
            tgt.addParty(Contract40_50.convertContractPartyComponent(contractPartyComponent));
        }
        if (src.hasTopic()) {
            tgt.setTopic(Contract40_50.convertReference(src.getTopic()));
        }
        if (src.hasType()) {
            tgt.setType(Contract40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasDecision()) {
            tgt.setDecision(Contract40_50.convertCodeableConcept(src.getDecision()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getDecisionMode()) {
            tgt.addDecisionMode(Contract40_50.convertCodeableConcept(codeableConcept));
        }
        for (Contract.AnswerComponent answerComponent : src.getAnswer()) {
            tgt.addAnswer(Contract40_50.convertAnswerComponent(answerComponent));
        }
        if (src.hasText()) {
            tgt.setTextElement(Contract40_50.convertString(src.getTextElement()));
        }
        for (org.hl7.fhir.r4.model.StringType stringType : src.getLinkId()) {
            tgt.getLinkId().add(Contract40_50.convertString(stringType));
        }
        for (org.hl7.fhir.r4.model.UnsignedIntType unsignedIntType : src.getSecurityLabelNumber()) {
            tgt.getSecurityLabelNumber().add(Contract40_50.convertUnsignedInt(unsignedIntType));
        }
        return tgt;
    }

    public static Contract.ContractOfferComponent convertContractOfferComponent(Contract.ContractOfferComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Contract.ContractOfferComponent tgt = new Contract.ContractOfferComponent();
        Contract40_50.copyElement(src, tgt, new String[0]);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(Contract40_50.convertIdentifier(identifier));
        }
        for (Contract.ContractPartyComponent contractPartyComponent : src.getParty()) {
            tgt.addParty(Contract40_50.convertContractPartyComponent(contractPartyComponent));
        }
        if (src.hasTopic()) {
            tgt.setTopic(Contract40_50.convertReference(src.getTopic()));
        }
        if (src.hasType()) {
            tgt.setType(Contract40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasDecision()) {
            tgt.setDecision(Contract40_50.convertCodeableConcept(src.getDecision()));
        }
        for (CodeableConcept codeableConcept : src.getDecisionMode()) {
            tgt.addDecisionMode(Contract40_50.convertCodeableConcept(codeableConcept));
        }
        for (Contract.AnswerComponent answerComponent : src.getAnswer()) {
            tgt.addAnswer(Contract40_50.convertAnswerComponent(answerComponent));
        }
        if (src.hasText()) {
            tgt.setTextElement(Contract40_50.convertString(src.getTextElement()));
        }
        for (StringType stringType : src.getLinkId()) {
            tgt.getLinkId().add(Contract40_50.convertString(stringType));
        }
        for (UnsignedIntType unsignedIntType : src.getSecurityLabelNumber()) {
            tgt.getSecurityLabelNumber().add(Contract40_50.convertUnsignedInt(unsignedIntType));
        }
        return tgt;
    }

    public static Contract.ContractPartyComponent convertContractPartyComponent(Contract.ContractPartyComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Contract.ContractPartyComponent tgt = new Contract.ContractPartyComponent();
        Contract40_50.copyElement(src, tgt, new String[0]);
        for (org.hl7.fhir.r4.model.Reference t : src.getReference()) {
            tgt.addReference(Contract40_50.convertReference(t));
        }
        if (src.hasRole()) {
            tgt.setRole(Contract40_50.convertCodeableConcept(src.getRole()));
        }
        return tgt;
    }

    public static Contract.ContractPartyComponent convertContractPartyComponent(Contract.ContractPartyComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Contract.ContractPartyComponent tgt = new Contract.ContractPartyComponent();
        Contract40_50.copyElement(src, tgt, new String[0]);
        for (Reference t : src.getReference()) {
            tgt.addReference(Contract40_50.convertReference(t));
        }
        if (src.hasRole()) {
            tgt.setRole(Contract40_50.convertCodeableConcept(src.getRole()));
        }
        return tgt;
    }

    public static Contract.AnswerComponent convertAnswerComponent(Contract.AnswerComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Contract.AnswerComponent tgt = new Contract.AnswerComponent();
        Contract40_50.copyElement(src, tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValue(Contract40_50.convertType(src.getValue()));
        }
        return tgt;
    }

    public static Contract.AnswerComponent convertAnswerComponent(Contract.AnswerComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Contract.AnswerComponent tgt = new Contract.AnswerComponent();
        Contract40_50.copyElement(src, tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValue(Contract40_50.convertType(src.getValue()));
        }
        return tgt;
    }

    public static Contract.ContractAssetComponent convertContractAssetComponent(Contract.ContractAssetComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Contract.ContractAssetComponent tgt = new Contract.ContractAssetComponent();
        Contract40_50.copyElement(src, tgt, new String[0]);
        if (src.hasScope()) {
            tgt.setScope(Contract40_50.convertCodeableConcept(src.getScope()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getType()) {
            tgt.addType(Contract40_50.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getTypeReference()) {
            tgt.addTypeReference(Contract40_50.convertReference(reference));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getSubtype()) {
            tgt.addSubtype(Contract40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasRelationship()) {
            tgt.setRelationship(Contract40_50.convertCoding(src.getRelationship()));
        }
        for (Contract.AssetContextComponent assetContextComponent : src.getContext()) {
            tgt.addContext(Contract40_50.convertAssetContextComponent(assetContextComponent));
        }
        if (src.hasCondition()) {
            tgt.setConditionElement(Contract40_50.convertString(src.getConditionElement()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getPeriodType()) {
            tgt.addPeriodType(Contract40_50.convertCodeableConcept(codeableConcept));
        }
        for (Period period : src.getPeriod()) {
            tgt.addPeriod(Contract40_50.convertPeriod(period));
        }
        for (Period period : src.getUsePeriod()) {
            tgt.addUsePeriod(Contract40_50.convertPeriod(period));
        }
        if (src.hasText()) {
            tgt.setTextElement(Contract40_50.convertString(src.getTextElement()));
        }
        for (org.hl7.fhir.r4.model.StringType stringType : src.getLinkId()) {
            tgt.getLinkId().add(Contract40_50.convertString(stringType));
        }
        for (Contract.AnswerComponent answerComponent : src.getAnswer()) {
            tgt.addAnswer(Contract40_50.convertAnswerComponent(answerComponent));
        }
        for (org.hl7.fhir.r4.model.UnsignedIntType unsignedIntType : src.getSecurityLabelNumber()) {
            tgt.getSecurityLabelNumber().add(Contract40_50.convertUnsignedInt(unsignedIntType));
        }
        for (Contract.ValuedItemComponent valuedItemComponent : src.getValuedItem()) {
            tgt.addValuedItem(Contract40_50.convertValuedItemComponent(valuedItemComponent));
        }
        return tgt;
    }

    public static Contract.ContractAssetComponent convertContractAssetComponent(Contract.ContractAssetComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Contract.ContractAssetComponent tgt = new Contract.ContractAssetComponent();
        Contract40_50.copyElement(src, tgt, new String[0]);
        if (src.hasScope()) {
            tgt.setScope(Contract40_50.convertCodeableConcept(src.getScope()));
        }
        for (CodeableConcept codeableConcept : src.getType()) {
            tgt.addType(Contract40_50.convertCodeableConcept(codeableConcept));
        }
        for (Reference reference : src.getTypeReference()) {
            tgt.addTypeReference(Contract40_50.convertReference(reference));
        }
        for (CodeableConcept codeableConcept : src.getSubtype()) {
            tgt.addSubtype(Contract40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasRelationship()) {
            tgt.setRelationship(Contract40_50.convertCoding(src.getRelationship()));
        }
        for (Contract.AssetContextComponent assetContextComponent : src.getContext()) {
            tgt.addContext(Contract40_50.convertAssetContextComponent(assetContextComponent));
        }
        if (src.hasCondition()) {
            tgt.setConditionElement(Contract40_50.convertString(src.getConditionElement()));
        }
        for (CodeableConcept codeableConcept : src.getPeriodType()) {
            tgt.addPeriodType(Contract40_50.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r5.model.Period period : src.getPeriod()) {
            tgt.addPeriod(Contract40_50.convertPeriod(period));
        }
        for (org.hl7.fhir.r5.model.Period period : src.getUsePeriod()) {
            tgt.addUsePeriod(Contract40_50.convertPeriod(period));
        }
        if (src.hasText()) {
            tgt.setTextElement(Contract40_50.convertString(src.getTextElement()));
        }
        for (StringType stringType : src.getLinkId()) {
            tgt.getLinkId().add(Contract40_50.convertString(stringType));
        }
        for (Contract.AnswerComponent answerComponent : src.getAnswer()) {
            tgt.addAnswer(Contract40_50.convertAnswerComponent(answerComponent));
        }
        for (UnsignedIntType unsignedIntType : src.getSecurityLabelNumber()) {
            tgt.getSecurityLabelNumber().add(Contract40_50.convertUnsignedInt(unsignedIntType));
        }
        for (Contract.ValuedItemComponent valuedItemComponent : src.getValuedItem()) {
            tgt.addValuedItem(Contract40_50.convertValuedItemComponent(valuedItemComponent));
        }
        return tgt;
    }

    public static Contract.AssetContextComponent convertAssetContextComponent(Contract.AssetContextComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Contract.AssetContextComponent tgt = new Contract.AssetContextComponent();
        Contract40_50.copyElement(src, tgt, new String[0]);
        if (src.hasReference()) {
            tgt.setReference(Contract40_50.convertReference(src.getReference()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept t : src.getCode()) {
            tgt.addCode(Contract40_50.convertCodeableConcept(t));
        }
        if (src.hasText()) {
            tgt.setTextElement(Contract40_50.convertString(src.getTextElement()));
        }
        return tgt;
    }

    public static Contract.AssetContextComponent convertAssetContextComponent(Contract.AssetContextComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Contract.AssetContextComponent tgt = new Contract.AssetContextComponent();
        Contract40_50.copyElement(src, tgt, new String[0]);
        if (src.hasReference()) {
            tgt.setReference(Contract40_50.convertReference(src.getReference()));
        }
        for (CodeableConcept t : src.getCode()) {
            tgt.addCode(Contract40_50.convertCodeableConcept(t));
        }
        if (src.hasText()) {
            tgt.setTextElement(Contract40_50.convertString(src.getTextElement()));
        }
        return tgt;
    }

    public static Contract.ValuedItemComponent convertValuedItemComponent(Contract.ValuedItemComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Contract.ValuedItemComponent tgt = new Contract.ValuedItemComponent();
        Contract40_50.copyElement(src, tgt, new String[0]);
        if (src.hasEntity()) {
            tgt.setEntity(Contract40_50.convertType(src.getEntity()));
        }
        if (src.hasIdentifier()) {
            tgt.setIdentifier(Contract40_50.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasEffectiveTime()) {
            tgt.setEffectiveTimeElement(Contract40_50.convertDateTime(src.getEffectiveTimeElement()));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(Contract40_50.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasUnitPrice()) {
            tgt.setUnitPrice(Contract40_50.convertMoney(src.getUnitPrice()));
        }
        if (src.hasFactor()) {
            tgt.setFactorElement(Contract40_50.convertDecimal(src.getFactorElement()));
        }
        if (src.hasPoints()) {
            tgt.setPointsElement(Contract40_50.convertDecimal(src.getPointsElement()));
        }
        if (src.hasNet()) {
            tgt.setNet(Contract40_50.convertMoney(src.getNet()));
        }
        if (src.hasPayment()) {
            tgt.setPaymentElement(Contract40_50.convertString(src.getPaymentElement()));
        }
        if (src.hasPaymentDate()) {
            tgt.setPaymentDateElement(Contract40_50.convertDateTime(src.getPaymentDateElement()));
        }
        if (src.hasResponsible()) {
            tgt.setResponsible(Contract40_50.convertReference(src.getResponsible()));
        }
        if (src.hasRecipient()) {
            tgt.setRecipient(Contract40_50.convertReference(src.getRecipient()));
        }
        for (org.hl7.fhir.r4.model.StringType stringType : src.getLinkId()) {
            tgt.getLinkId().add(Contract40_50.convertString(stringType));
        }
        for (org.hl7.fhir.r4.model.UnsignedIntType unsignedIntType : src.getSecurityLabelNumber()) {
            tgt.getSecurityLabelNumber().add(Contract40_50.convertUnsignedInt(unsignedIntType));
        }
        return tgt;
    }

    public static Contract.ValuedItemComponent convertValuedItemComponent(Contract.ValuedItemComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Contract.ValuedItemComponent tgt = new Contract.ValuedItemComponent();
        Contract40_50.copyElement(src, tgt, new String[0]);
        if (src.hasEntity()) {
            tgt.setEntity(Contract40_50.convertType(src.getEntity()));
        }
        if (src.hasIdentifier()) {
            tgt.setIdentifier(Contract40_50.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasEffectiveTime()) {
            tgt.setEffectiveTimeElement(Contract40_50.convertDateTime(src.getEffectiveTimeElement()));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(Contract40_50.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasUnitPrice()) {
            tgt.setUnitPrice(Contract40_50.convertMoney(src.getUnitPrice()));
        }
        if (src.hasFactor()) {
            tgt.setFactorElement(Contract40_50.convertDecimal(src.getFactorElement()));
        }
        if (src.hasPoints()) {
            tgt.setPointsElement(Contract40_50.convertDecimal(src.getPointsElement()));
        }
        if (src.hasNet()) {
            tgt.setNet(Contract40_50.convertMoney(src.getNet()));
        }
        if (src.hasPayment()) {
            tgt.setPaymentElement(Contract40_50.convertString(src.getPaymentElement()));
        }
        if (src.hasPaymentDate()) {
            tgt.setPaymentDateElement(Contract40_50.convertDateTime(src.getPaymentDateElement()));
        }
        if (src.hasResponsible()) {
            tgt.setResponsible(Contract40_50.convertReference(src.getResponsible()));
        }
        if (src.hasRecipient()) {
            tgt.setRecipient(Contract40_50.convertReference(src.getRecipient()));
        }
        for (StringType stringType : src.getLinkId()) {
            tgt.getLinkId().add(Contract40_50.convertString(stringType));
        }
        for (UnsignedIntType unsignedIntType : src.getSecurityLabelNumber()) {
            tgt.getSecurityLabelNumber().add(Contract40_50.convertUnsignedInt(unsignedIntType));
        }
        return tgt;
    }

    public static Contract.ActionComponent convertActionComponent(Contract.ActionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Contract.ActionComponent tgt = new Contract.ActionComponent();
        Contract40_50.copyElement(src, tgt, new String[0]);
        if (src.hasDoNotPerform()) {
            tgt.setDoNotPerformElement(Contract40_50.convertBoolean(src.getDoNotPerformElement()));
        }
        if (src.hasType()) {
            tgt.setType(Contract40_50.convertCodeableConcept(src.getType()));
        }
        for (Contract.ActionSubjectComponent actionSubjectComponent : src.getSubject()) {
            tgt.addSubject(Contract40_50.convertActionSubjectComponent(actionSubjectComponent));
        }
        if (src.hasIntent()) {
            tgt.setIntent(Contract40_50.convertCodeableConcept(src.getIntent()));
        }
        for (org.hl7.fhir.r4.model.StringType stringType : src.getLinkId()) {
            tgt.getLinkId().add(Contract40_50.convertString(stringType));
        }
        if (src.hasStatus()) {
            tgt.setStatus(Contract40_50.convertCodeableConcept(src.getStatus()));
        }
        if (src.hasContext()) {
            tgt.setContext(Contract40_50.convertReference(src.getContext()));
        }
        for (org.hl7.fhir.r4.model.StringType stringType : src.getContextLinkId()) {
            tgt.getContextLinkId().add(Contract40_50.convertString(stringType));
        }
        if (src.hasOccurrence()) {
            tgt.setOccurrence(Contract40_50.convertType(src.getOccurrence()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getRequester()) {
            tgt.addRequester(Contract40_50.convertReference(reference));
        }
        for (org.hl7.fhir.r4.model.StringType stringType : src.getRequesterLinkId()) {
            tgt.getRequesterLinkId().add(Contract40_50.convertString(stringType));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getPerformerType()) {
            tgt.addPerformerType(Contract40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPerformerRole()) {
            tgt.setPerformerRole(Contract40_50.convertCodeableConcept(src.getPerformerRole()));
        }
        if (src.hasPerformer()) {
            tgt.setPerformer(Contract40_50.convertReference(src.getPerformer()));
        }
        for (org.hl7.fhir.r4.model.StringType stringType : src.getPerformerLinkId()) {
            tgt.getPerformerLinkId().add(Contract40_50.convertString(stringType));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getReasonCode()) {
            tgt.addReason(Contract40_50.convertCodeableConceptToCodeableReference(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getReasonReference()) {
            tgt.addReason(Contract40_50.convertReferenceToCodeableReference(reference));
        }
        for (org.hl7.fhir.r4.model.StringType stringType : src.getReasonLinkId()) {
            tgt.getReasonLinkId().add(Contract40_50.convertString(stringType));
        }
        for (org.hl7.fhir.r4.model.Annotation annotation : src.getNote()) {
            tgt.addNote(Contract40_50.convertAnnotation(annotation));
        }
        for (org.hl7.fhir.r4.model.UnsignedIntType unsignedIntType : src.getSecurityLabelNumber()) {
            tgt.getSecurityLabelNumber().add(Contract40_50.convertUnsignedInt(unsignedIntType));
        }
        return tgt;
    }

    public static Contract.ActionComponent convertActionComponent(Contract.ActionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Contract.ActionComponent tgt = new Contract.ActionComponent();
        Contract40_50.copyElement(src, tgt, new String[0]);
        if (src.hasDoNotPerform()) {
            tgt.setDoNotPerformElement(Contract40_50.convertBoolean(src.getDoNotPerformElement()));
        }
        if (src.hasType()) {
            tgt.setType(Contract40_50.convertCodeableConcept(src.getType()));
        }
        for (Contract.ActionSubjectComponent actionSubjectComponent : src.getSubject()) {
            tgt.addSubject(Contract40_50.convertActionSubjectComponent(actionSubjectComponent));
        }
        if (src.hasIntent()) {
            tgt.setIntent(Contract40_50.convertCodeableConcept(src.getIntent()));
        }
        for (StringType stringType : src.getLinkId()) {
            tgt.getLinkId().add(Contract40_50.convertString(stringType));
        }
        if (src.hasStatus()) {
            tgt.setStatus(Contract40_50.convertCodeableConcept(src.getStatus()));
        }
        if (src.hasContext()) {
            tgt.setContext(Contract40_50.convertReference(src.getContext()));
        }
        for (StringType stringType : src.getContextLinkId()) {
            tgt.getContextLinkId().add(Contract40_50.convertString(stringType));
        }
        if (src.hasOccurrence()) {
            tgt.setOccurrence(Contract40_50.convertType(src.getOccurrence()));
        }
        for (Reference reference : src.getRequester()) {
            tgt.addRequester(Contract40_50.convertReference(reference));
        }
        for (StringType stringType : src.getRequesterLinkId()) {
            tgt.getRequesterLinkId().add(Contract40_50.convertString(stringType));
        }
        for (CodeableConcept codeableConcept : src.getPerformerType()) {
            tgt.addPerformerType(Contract40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPerformerRole()) {
            tgt.setPerformerRole(Contract40_50.convertCodeableConcept(src.getPerformerRole()));
        }
        if (src.hasPerformer()) {
            tgt.setPerformer(Contract40_50.convertReference(src.getPerformer()));
        }
        for (StringType stringType : src.getPerformerLinkId()) {
            tgt.getPerformerLinkId().add(Contract40_50.convertString(stringType));
        }
        for (CodeableReference codeableReference : src.getReason()) {
            if (!codeableReference.hasConcept()) continue;
            tgt.addReasonCode(Contract40_50.convertCodeableConcept(codeableReference.getConcept()));
        }
        for (CodeableReference codeableReference : src.getReason()) {
            if (!codeableReference.hasReference()) continue;
            tgt.addReasonReference(Contract40_50.convertReference(codeableReference.getReference()));
        }
        for (StringType stringType : src.getReasonLinkId()) {
            tgt.getReason().add(Contract40_50.convertString(stringType));
        }
        for (StringType stringType : src.getReasonLinkId()) {
            tgt.getReasonLinkId().add(Contract40_50.convertString(stringType));
        }
        for (Annotation annotation : src.getNote()) {
            tgt.addNote(Contract40_50.convertAnnotation(annotation));
        }
        for (UnsignedIntType unsignedIntType : src.getSecurityLabelNumber()) {
            tgt.getSecurityLabelNumber().add(Contract40_50.convertUnsignedInt(unsignedIntType));
        }
        return tgt;
    }

    public static Contract.ActionSubjectComponent convertActionSubjectComponent(Contract.ActionSubjectComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Contract.ActionSubjectComponent tgt = new Contract.ActionSubjectComponent();
        Contract40_50.copyElement(src, tgt, new String[0]);
        for (org.hl7.fhir.r4.model.Reference t : src.getReference()) {
            tgt.addReference(Contract40_50.convertReference(t));
        }
        if (src.hasRole()) {
            tgt.setRole(Contract40_50.convertCodeableConcept(src.getRole()));
        }
        return tgt;
    }

    public static Contract.ActionSubjectComponent convertActionSubjectComponent(Contract.ActionSubjectComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Contract.ActionSubjectComponent tgt = new Contract.ActionSubjectComponent();
        Contract40_50.copyElement(src, tgt, new String[0]);
        for (Reference t : src.getReference()) {
            tgt.addReference(Contract40_50.convertReference(t));
        }
        if (src.hasRole()) {
            tgt.setRole(Contract40_50.convertCodeableConcept(src.getRole()));
        }
        return tgt;
    }

    public static Contract.SignatoryComponent convertSignatoryComponent(Contract.SignatoryComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Contract.SignatoryComponent tgt = new Contract.SignatoryComponent();
        Contract40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(Contract40_50.convertCoding(src.getType()));
        }
        if (src.hasParty()) {
            tgt.setParty(Contract40_50.convertReference(src.getParty()));
        }
        for (Signature t : src.getSignature()) {
            tgt.addSignature(Contract40_50.convertSignature(t));
        }
        return tgt;
    }

    public static Contract.SignatoryComponent convertSignatoryComponent(Contract.SignatoryComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Contract.SignatoryComponent tgt = new Contract.SignatoryComponent();
        Contract40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(Contract40_50.convertCoding(src.getType()));
        }
        if (src.hasParty()) {
            tgt.setParty(Contract40_50.convertReference(src.getParty()));
        }
        for (org.hl7.fhir.r5.model.Signature t : src.getSignature()) {
            tgt.addSignature(Contract40_50.convertSignature(t));
        }
        return tgt;
    }

    public static Contract.FriendlyLanguageComponent convertFriendlyLanguageComponent(Contract.FriendlyLanguageComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Contract.FriendlyLanguageComponent tgt = new Contract.FriendlyLanguageComponent();
        Contract40_50.copyElement(src, tgt, new String[0]);
        if (src.hasContent()) {
            tgt.setContent(Contract40_50.convertType(src.getContent()));
        }
        return tgt;
    }

    public static Contract.FriendlyLanguageComponent convertFriendlyLanguageComponent(Contract.FriendlyLanguageComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Contract.FriendlyLanguageComponent tgt = new Contract.FriendlyLanguageComponent();
        Contract40_50.copyElement(src, tgt, new String[0]);
        if (src.hasContent()) {
            tgt.setContent(Contract40_50.convertType(src.getContent()));
        }
        return tgt;
    }

    public static Contract.LegalLanguageComponent convertLegalLanguageComponent(Contract.LegalLanguageComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Contract.LegalLanguageComponent tgt = new Contract.LegalLanguageComponent();
        Contract40_50.copyElement(src, tgt, new String[0]);
        if (src.hasContent()) {
            tgt.setContent(Contract40_50.convertType(src.getContent()));
        }
        return tgt;
    }

    public static Contract.LegalLanguageComponent convertLegalLanguageComponent(Contract.LegalLanguageComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Contract.LegalLanguageComponent tgt = new Contract.LegalLanguageComponent();
        Contract40_50.copyElement(src, tgt, new String[0]);
        if (src.hasContent()) {
            tgt.setContent(Contract40_50.convertType(src.getContent()));
        }
        return tgt;
    }

    public static Contract.ComputableLanguageComponent convertComputableLanguageComponent(Contract.ComputableLanguageComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Contract.ComputableLanguageComponent tgt = new Contract.ComputableLanguageComponent();
        Contract40_50.copyElement(src, tgt, new String[0]);
        if (src.hasContent()) {
            tgt.setContent(Contract40_50.convertType(src.getContent()));
        }
        return tgt;
    }

    public static Contract.ComputableLanguageComponent convertComputableLanguageComponent(Contract.ComputableLanguageComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Contract.ComputableLanguageComponent tgt = new Contract.ComputableLanguageComponent();
        Contract40_50.copyElement(src, tgt, new String[0]);
        if (src.hasContent()) {
            tgt.setContent(Contract40_50.convertType(src.getContent()));
        }
        return tgt;
    }
}

